/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AbstractFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureAdapter;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Layouter;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.util.ReversedList;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompositeFigure
extends AbstractFigure
implements CompositeFigure {
    private LinkedList<Figure> children = new LinkedList();
    private Rectangle2D.Double cachedDrawingArea;
    private Rectangle2D.Double cachedBounds;
    private Layouter layouter;
    private ChildHandler childHandler = new ChildHandler(this);

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            TransformHandleKit.addScaleMoveTransformHandles(this, handles);
        }
        return handles;
    }

    @Override
    public void add(Figure figure) {
        this.add(this.getChildCount(), figure);
    }

    @Override
    public void add(int index, Figure figure) {
        this.basicAdd(index, figure);
        if (this.getDrawing() != null) {
            figure.addNotify(this.getDrawing());
        }
        this.invalidate();
    }

    public void addAll(Collection<Figure> newFigures) {
        for (Figure f : newFigures) {
            this.basicAdd(this.getChildCount(), f);
            if (this.getDrawing() == null) continue;
            f.addNotify(this.getDrawing());
        }
        this.invalidate();
    }

    @Override
    public void basicAdd(Figure figure) {
        this.basicAdd(this.getChildCount(), figure);
    }

    @Override
    public void basicAdd(int index, Figure figure) {
        this.children.add(index, figure);
        figure.addFigureListener(this.childHandler);
    }

    public void basicAddAll(Collection<Figure> newFigures) {
        for (Figure f : newFigures) {
            this.basicAdd(this.getChildCount(), f);
        }
    }

    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        for (Figure child : this.children) {
            child.addNotify(drawing);
        }
    }

    @Override
    public void removeNotify(Drawing drawing) {
        super.removeNotify(drawing);
        for (Figure child : new LinkedList<Figure>(this.children)) {
            child.removeNotify(drawing);
        }
    }

    @Override
    public boolean remove(Figure figure) {
        int index = this.children.indexOf(figure);
        if (index == -1) {
            return false;
        }
        this.basicRemoveChild(index);
        if (this.getDrawing() != null) {
            figure.removeNotify(this.getDrawing());
        }
        return true;
    }

    @Override
    public Figure removeChild(int index) {
        Figure removed = this.basicRemoveChild(index);
        if (this.getDrawing() != null) {
            removed.removeNotify(this.getDrawing());
        }
        return removed;
    }

    @Override
    public boolean basicRemove(Figure figure) {
        int index = this.children.indexOf(figure);
        if (index == -1) {
            return false;
        }
        this.basicRemoveChild(index);
        this.invalidate();
        return true;
    }

    @Override
    public Figure basicRemoveChild(int index) {
        Figure figure = this.children.remove(index);
        figure.removeFigureListener(this.childHandler);
        this.invalidate();
        return figure;
    }

    @Override
    public void removeAllChildren() {
        this.willChange();
        while (this.children.size() > 0) {
            Figure f = this.basicRemoveChild(this.children.size() - 1);
            if (this.getDrawing() == null) continue;
            f.addNotify(this.getDrawing());
        }
        this.changed();
    }

    @Override
    public void basicRemoveAllChildren() {
        while (this.children.size() > 0) {
            Figure figure = this.basicRemoveChild(this.children.size() - 1);
        }
    }

    public synchronized void sendToBack(Figure figure) {
        if (this.children.remove(figure)) {
            this.children.add(0, figure);
            figure.invalidate();
        }
    }

    public synchronized void sendToFront(Figure figure) {
        if (this.children.remove(figure)) {
            this.children.add(figure);
            figure.invalidate();
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        for (Figure f : this.children) {
            f.transform(tx);
        }
        this.invalidateBounds();
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        Rectangle2D.Double oldBounds = this.getBounds();
        Rectangle2D.Double newBounds = new Rectangle2D.Double(Math.min(anchor.x, lead.x), Math.min(anchor.y, lead.y), Math.abs(anchor.x - lead.x), Math.abs(anchor.y - lead.y));
        double sx = newBounds.width / oldBounds.width;
        double sy = newBounds.height / oldBounds.height;
        AffineTransform tx = new AffineTransform();
        tx.translate(-oldBounds.x, -oldBounds.y);
        if (!(Double.isNaN(sx) || Double.isNaN(sy) || sx == 1.0 && sy == 1.0 || sx < 1.0E-4 || sy < 1.0E-4)) {
            this.transform(tx);
            tx.setToIdentity();
            tx.scale(sx, sy);
            this.transform(tx);
            tx.setToIdentity();
        }
        tx.translate(newBounds.x, newBounds.y);
        this.transform(tx);
    }

    @Override
    public List<Figure> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public Figure getChild(int index) {
        return this.children.get(index);
    }

    public List<Figure> getChildrenFrontToBack() {
        return this.children == null ? new LinkedList() : new ReversedList<Figure>(this.children);
    }

    @Override
    public void setAttribute(AttributeKey key, Object value) {
        for (Figure child : this.children) {
            child.setAttribute(key, value);
        }
        this.invalidate();
    }

    @Override
    public Object getAttribute(AttributeKey name) {
        return null;
    }

    @Override
    public Map<AttributeKey, Object> getAttributes() {
        return new HashMap<AttributeKey, Object>();
    }

    @Override
    public Object getAttributesRestoreData() {
        LinkedList<Object> data = new LinkedList<Object>();
        for (Figure child : this.children) {
            data.add(child.getAttributesRestoreData());
        }
        return data;
    }

    @Override
    public void restoreAttributesTo(Object newData) {
        Iterator data = ((LinkedList)newData).iterator();
        for (Figure child : this.children) {
            child.restoreAttributesTo(data.next());
        }
    }

    @Override
    public boolean contains(Point2D.Double p) {
        if (AttributeKeys.TRANSFORM.get(this) != null) {
            try {
                p = (Point2D.Double)AttributeKeys.TRANSFORM.get(this).inverseTransform(p, new Point2D.Double());
            }
            catch (NoninvertibleTransformException ex) {
                InternalError error = new InternalError(ex.getMessage());
                error.initCause(ex);
                throw error;
            }
        }
        if (this.getDrawingArea().contains(p)) {
            for (Figure child : this.getChildrenFrontToBack()) {
                if (!child.isVisible() || !child.contains(p)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Figure findFigureInside(Point2D.Double p) {
        if (this.getDrawingArea().contains(p)) {
            Figure found = null;
            for (Figure child : this.getChildrenFrontToBack()) {
                if (!child.isVisible() || (found = child.findFigureInside(p)) == null) continue;
                return found;
            }
        }
        return null;
    }

    public Figure findChild(Point2D.Double p) {
        if (this.getBounds().contains(p)) {
            Object found = null;
            for (Figure child : this.getChildrenFrontToBack()) {
                if (!child.isVisible() || !child.contains(p)) continue;
                return child;
            }
        }
        return null;
    }

    public int findChildIndex(Point2D.Double p) {
        Figure child = this.findChild(p);
        return child == null ? -1 : this.children.indexOf(child);
    }

    @Override
    public Layouter getLayouter() {
        return this.layouter;
    }

    @Override
    public void layout() {
        if (this.getLayouter() != null) {
            Rectangle2D.Double bounds = this.getBounds();
            Point2D.Double p = new Point2D.Double(bounds.x, bounds.y);
            Rectangle2D.Double r = this.getLayouter().layout(this, p, p);
            this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
            this.invalidateBounds();
        }
    }

    @Override
    public void setLayouter(Layouter newLayouter) {
        this.layouter = newLayouter;
    }

    @Override
    public Dimension2DDouble getPreferredSize() {
        if (this.layouter != null) {
            Rectangle2D.Double r = this.layouter.calculateLayout(this, this.getStartPoint(), this.getEndPoint());
            return new Dimension2DDouble(r.width, r.height);
        }
        return super.getPreferredSize();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            for (Figure child : this.getChildren()) {
                Rectangle2D.Double childBounds;
                if (!child.isVisible() || (childBounds = child.getDrawingArea()).isEmpty()) continue;
                if (this.cachedDrawingArea == null) {
                    this.cachedDrawingArea = childBounds;
                    continue;
                }
                this.cachedDrawingArea.add(childBounds);
            }
            if (this.cachedDrawingArea == null) {
                this.cachedDrawingArea = new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0);
            }
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.cachedBounds == null) {
            for (Figure child : this.getChildrenFrontToBack()) {
                if (!child.isVisible()) continue;
                Rectangle2D r = child.getBounds();
                if (AttributeKeys.TRANSFORM.get(child) != null) {
                    r = AttributeKeys.TRANSFORM.get(child).createTransformedShape(r).getBounds2D();
                }
                if (this.cachedBounds == null) {
                    this.cachedBounds = new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
                    continue;
                }
                this.cachedBounds.add(r);
            }
        }
        return this.cachedBounds == null ? new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0) : (Rectangle2D.Double)this.cachedBounds.clone();
    }

    @Override
    public void draw(Graphics2D g) {
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds != null) {
            for (Figure child : this.children) {
                if (!child.isVisible() || !child.getDrawingArea().intersects(clipBounds)) continue;
                child.draw(g);
            }
        } else {
            for (Figure child : this.children) {
                if (!child.isVisible()) continue;
                child.draw(g);
            }
        }
    }

    @Override
    public AbstractCompositeFigure clone() {
        AbstractCompositeFigure that = (AbstractCompositeFigure)super.clone();
        that.childHandler = new ChildHandler(that);
        that.children = new LinkedList();
        for (Figure thisChild : this.children) {
            Figure thatChild = (Figure)thisChild.clone();
            that.children.add(thatChild);
            thatChild.addFigureListener(that.childHandler);
        }
        return that;
    }

    protected void invalidateBounds() {
        this.cachedBounds = null;
        this.cachedDrawingArea = null;
    }

    @Override
    public Collection<Figure> getDecomposition() {
        LinkedList<Figure> list = new LinkedList<Figure>();
        list.add(this);
        list.addAll(this.getChildren());
        return list;
    }

    @Override
    public void read(DOMInput in) throws IOException {
        in.openElement("children");
        for (int i = 0; i < in.getElementCount(); ++i) {
            this.basicAdd((Figure)in.readObject(i));
        }
        in.closeElement();
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        out.openElement("children");
        for (Figure child : this.getChildren()) {
            out.writeObject(child);
        }
        out.closeElement();
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        LinkedList list = (LinkedList)geometry;
        Iterator i = list.iterator();
        for (Figure child : this.children) {
            child.restoreTransformTo(i.next());
        }
        this.invalidateBounds();
    }

    @Override
    public Object getTransformRestoreData() {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Figure child : this.children) {
            list.add(child.getTransformRestoreData());
        }
        return list;
    }

    @Override
    public void willChange() {
        super.willChange();
        if (this.getChangingDepth() == 1) {
            for (Figure child : this.children) {
                child.willChange();
            }
        }
    }

    @Override
    public void changed() {
        if (this.getChangingDepth() == 1) {
            for (Figure child : this.children) {
                child.changed();
            }
        }
        super.changed();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.invalidateBounds();
    }

    @Override
    protected void validate() {
        super.validate();
        this.layout();
        this.invalidateBounds();
    }

    public void removeAttribute(AttributeKey key) {
    }

    public boolean hasAttribute(AttributeKey key) {
        return false;
    }

    private static class ChildHandler
    extends FigureAdapter
    implements UndoableEditListener {
        private AbstractCompositeFigure owner;

        private ChildHandler(AbstractCompositeFigure owner) {
            this.owner = owner;
        }

        public void figureRequestRemove(FigureEvent e) {
            if (this.owner.getDrawing() != null) {
                this.owner.remove(e.getFigure());
            }
        }

        public void figureChanged(FigureEvent e) {
            if (!this.owner.isChanging()) {
                this.owner.willChange();
                this.owner.fireFigureChanged(e);
                this.owner.changed();
            }
        }

        public void figureAreaInvalidated(FigureEvent e) {
            if (!this.owner.isChanging()) {
                this.owner.fireAreaInvalidated(e.getInvalidatedArea());
            }
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            this.owner.fireUndoableEditHappened(e.getEdit());
        }
    }
}

