/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.teddyapplication;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.application.AbstractDocumentView;
import org.jhotdraw.samples.teddyapplication.CharacterSetAccessory;
import org.jhotdraw.samples.teddyapplication.FindDialog;
import org.jhotdraw.samples.teddyapplication.io.LFWriter;
import org.jhotdraw.samples.teddyapplication.regex.Matcher;
import org.jhotdraw.samples.teddyapplication.text.NumberedEditorKit;
import org.jhotdraw.samples.teddyapplication.text.NumberedViewFactory;
import org.jhotdraw.undo.UndoRedoManager;

public class TeddyView
extends AbstractDocumentView {
    private static Preferences prefs = Preferences.userNodeForPackage(TeddyView.class);
    protected JTextPane editor;
    protected EditorPanel editorViewport;
    protected UndoRedoManager undoManager;
    private FindDialog findDialog;
    private Matcher matcher;
    private CharacterSetAccessory characterSetAccessory;
    public JLabel caretInfoLabel;
    public JScrollPane scrollPane;
    public JPanel statusBar;

    public static void main(String[] args) {
        JFrame f = new JFrame();
        TeddyView v = new TeddyView();
        f.add(v);
        v.init();
        f.pack();
        f.show();
        v.start();
    }

    public TeddyView() {
        prefs = Preferences.userNodeForPackage(TeddyView.class);
    }

    protected JTextPane createEditor() {
        JTextPane p = new JTextPane();
        return p;
    }

    public void init() {
        this.initComponents();
        this.editor = this.createEditor();
        this.editorViewport = new EditorPanel();
        this.editorViewport.setEditor(this.editor);
        this.scrollPane.setViewportView(this.editorViewport);
        this.editor.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                TeddyView.this.caretUpdate(evt);
            }
        });
        this.scrollPane.getViewport().setBackground(this.editor.getBackground());
        this.scrollPane.getViewport().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                TeddyView.this.editor.requestFocus();
            }
        });
        this.statusBar.setVisible(prefs.getBoolean("statusBarVisible", false));
        this.editorViewport.setLineWrap(prefs.getBoolean("lineWrap", true));
        NumberedEditorKit editorKit = new NumberedEditorKit();
        ((NumberedViewFactory)editorKit.getViewFactory()).setLineNumbersVisible(prefs.getBoolean("lineNumbersVisible", false));
        this.editor.setEditorKit(editorKit);
        this.editor.setDocument(this.createDocument());
        Font font = this.getFont();
        MutableAttributeSet attrs = ((StyledEditorKit)this.editor.getEditorKit()).getInputAttributes();
        StyleConstants.setFontFamily(attrs, font.getFamily());
        StyleConstants.setFontSize(attrs, font.getSize());
        StyleConstants.setItalic(attrs, (font.getStyle() & 2) != 0);
        StyleConstants.setBold(attrs, (font.getStyle() & 1) != 0);
        this.setPreferredSize(new Dimension(400, 400));
        this.undoManager = new UndoRedoManager();
        this.editor.getDocument().addUndoableEditListener(this.undoManager);
        this.undoManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TeddyView.this.setModified(TeddyView.this.undoManager.hasSignificantEdits());
            }
        });
        this.initActions();
    }

    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
        this.editor.setEnabled(newValue);
        this.scrollPane.setEnabled(newValue);
    }

    public void setStatusBarVisible(boolean newValue) {
        boolean oldValue = this.statusBar.isVisible();
        this.statusBar.setVisible(newValue);
        this.validate();
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
        prefs.putBoolean("statusBarVisible", newValue);
        this.firePropertyChange("statusBarVisible", oldValue, newValue);
    }

    public boolean isStatusBarVisible() {
        return this.statusBar.isVisible();
    }

    public void setLineWrap(boolean newValue) {
        boolean oldValue = this.editorViewport.getLineWrap();
        this.editorViewport.setLineWrap(newValue);
        prefs.putBoolean("lineWrap", newValue);
        this.firePropertyChange("lineWrap", oldValue, newValue);
    }

    public boolean isLineWrap() {
        return this.editorViewport.getLineWrap();
    }

    private void initActions() {
        this.putAction("Edit.undo", this.undoManager.getUndoAction());
        this.putAction("Edit.redo", this.undoManager.getRedoAction());
    }

    private CharacterSetAccessory getAccessory() {
        if (this.characterSetAccessory == null) {
            this.characterSetAccessory = new CharacterSetAccessory();
        }
        return this.characterSetAccessory;
    }

    public JFileChooser getOpenChooser() {
        JFileChooser chooser = super.getOpenChooser();
        chooser.setAccessory(this.getAccessory());
        return chooser;
    }

    public JFileChooser getSaveChooser() {
        JFileChooser chooser = super.getSaveChooser();
        chooser.setAccessory(this.getAccessory());
        return chooser;
    }

    public void read(File f) throws IOException {
        this.read(f, this.getAccessory().getCharacterSet());
    }

    public void read(File f, String characterSet) throws IOException {
        final Document doc = this.readDocument(f, characterSet);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    TeddyView.this.editor.getDocument().removeUndoableEditListener(TeddyView.this.undoManager);
                    TeddyView.this.editor.setDocument(doc);
                    doc.addUndoableEditListener(TeddyView.this.undoManager);
                    TeddyView.this.undoManager.discardAllEdits();
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            InternalError error = new InternalError(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    public void write(File f) throws IOException {
        this.write(f, this.getAccessory().getCharacterSet(), this.getAccessory().getLineSeparator());
    }

    public void write(File f, String characterSet, String lineSeparator) throws IOException {
        this.writeDocument(this.editor.getDocument(), f, characterSet, lineSeparator);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    TeddyView.this.undoManager.setHasSignificantEdits(false);
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            InternalError error = new InternalError(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    private Document readDocument(File f, String characterSet) throws IOException {
        ProgressMonitorInputStream pin = new ProgressMonitorInputStream(this, "Reading " + f.getName(), new FileInputStream(f));
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)pin, characterSet));
        try {
            String line;
            StyledDocument doc = this.createDocument();
            MutableAttributeSet attrs = ((StyledEditorKit)this.editor.getEditorKit()).getInputAttributes();
            boolean isFirst = true;
            while ((line = in.readLine()) != null) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    doc.insertString(doc.getLength(), "\n", attrs);
                }
                doc.insertString(doc.getLength(), line, attrs);
            }
            StyledDocument styledDocument = doc;
            return styledDocument;
        }
        catch (BadLocationException e) {
            throw new IOException(e.getMessage());
        }
        catch (OutOfMemoryError e) {
            IOException ioe = new IOException("Out of memory.");
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            in.close();
        }
    }

    public void clear() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    TeddyView.this.editor.getDocument().removeUndoableEditListener(TeddyView.this.undoManager);
                    TeddyView.this.editor.setDocument(TeddyView.this.createDocument());
                    TeddyView.this.editor.getDocument().addUndoableEditListener(TeddyView.this.undoManager);
                    TeddyView.this.undoManager.discardAllEdits();
                }
            });
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    protected StyledDocument createDocument() {
        DefaultStyledDocument doc = new DefaultStyledDocument();
        doc.setParagraphAttributes(0, 1, ((StyledEditorKit)this.editor.getEditorKit()).getInputAttributes(), true);
        return doc;
    }

    private void writeDocument(Document doc, File f, String characterSet, String lineSeparator) throws IOException {
        LFWriter out = new LFWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), characterSet));
        out.setLineSeparator(lineSeparator);
        try {
            for (int i = 0; i < doc.getLength(); i += 256) {
                out.write(doc.getText(i, Math.min(256, doc.getLength() - i)));
            }
        }
        catch (BadLocationException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            out.close();
            this.undoManager.discardAllEdits();
        }
    }

    private void initComponents() {
        this.statusBar = new JPanel();
        this.caretInfoLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.statusBar.setLayout(new BorderLayout());
        this.caretInfoLabel.setFont(new Font("Lucida Grande", 0, 11));
        this.caretInfoLabel.setText("1:1");
        this.caretInfoLabel.setBorder(BorderFactory.createEmptyBorder(1, 3, 0, 3));
        this.statusBar.add((Component)this.caretInfoLabel, "Center");
        this.add((Component)this.statusBar, "South");
        this.scrollPane.setBorder(null);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)this.scrollPane, "Center");
    }

    public Document getDocument() {
        return this.editor.getDocument();
    }

    public void select(int start, int end) {
        this.editor.select(start, end);
        try {
            this.editor.scrollRectToVisible(this.editor.modelToView(start));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public int getSelectionStart() {
        return this.editor.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.editor.getSelectionEnd();
    }

    public int getLineCount() {
        Element map = this.getDocument().getDefaultRootElement();
        return map.getElementCount();
    }

    public void replaceRange(String str, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end before start");
        }
        Document doc = this.getDocument();
        if (doc != null) {
            try {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).replace(start, end - start, str, null);
                } else {
                    doc.remove(start, end - start);
                    doc.insertString(start, str, null);
                }
            }
            catch (BadLocationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public int getLineOfOffset(int offset) throws BadLocationException {
        Document doc = this.getDocument();
        if (offset < 0) {
            throw new BadLocationException("Can't translate offset to line", -1);
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException("Can't translate offset to line", doc.getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        return map.getElementIndex(offset);
    }

    public int getLineStartOffset(int line) throws BadLocationException {
        int lineCount = this.getLineCount();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= lineCount) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        Element lineElem = map.getElement(line);
        return lineElem.getStartOffset();
    }

    public void fireEdit(UndoableEdit edit) {
        this.undoManager.addEdit(edit);
    }

    private void caretUpdate(CaretEvent evt) {
        try {
            int pos = this.editor.getCaretPosition();
            int line = this.getLineOfOffset(pos);
            int lineStartOffset = this.getLineStartOffset(line);
            this.caretInfoLabel.setText(line + 1 + ":" + (pos - lineStartOffset + 1));
        }
        catch (BadLocationException e) {
            this.caretInfoLabel.setText(e.toString());
        }
    }

    public void setLineNumbersVisible(boolean newValue) {
        NumberedViewFactory viewFactory = (NumberedViewFactory)this.editor.getEditorKit().getViewFactory();
        boolean oldValue = viewFactory.isLineNumbersVisible();
        if (oldValue != newValue) {
            viewFactory.setLineNumbersVisible(newValue);
            prefs.putBoolean("lineNumbersVisible", newValue);
            this.firePropertyChange("lineNumbersVisible", oldValue, newValue);
            this.editor.revalidate();
            this.editor.repaint();
        }
    }

    public boolean isLineNumbersVisible() {
        NumberedViewFactory viewFactory = (NumberedViewFactory)this.editor.getEditorKit().getViewFactory();
        return viewFactory.isLineNumbersVisible();
    }

    private static class EditorPanel
    extends JPanel
    implements Scrollable {
        private JTextComponent editor;
        private boolean isLineWrap;

        private EditorPanel() {
        }

        public void setEditor(JTextComponent newValue) {
            this.editor = newValue;
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.add(this.editor);
            this.setBackground(UIManager.getColor("TextField.background"));
            this.setOpaque(true);
        }

        public void setLineWrap(boolean newValue) {
            this.isLineWrap = newValue;
            this.editor.revalidate();
            this.editor.repaint();
        }

        public boolean getLineWrap() {
            return this.isLineWrap;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.editor.getPreferredScrollableViewportSize();
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.editor.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.editor.getScrollableBlockIncrement(visibleRect, orientation, direction);
        }

        public boolean getScrollableTracksViewportWidth() {
            return this.isLineWrap;
        }

        public boolean getScrollableTracksViewportHeight() {
            return this.editor.getScrollableTracksViewportHeight();
        }
    }
}

