/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Naming
extends PreorderVisitor
implements Detector {
    String baseClassName;
    boolean classIsPublicOrProtected;
    HashMap<String, HashSet<String>> canonicalToTrueMapping = new HashMap();
    HashMap<String, HashSet<XMethod>> canonicalToXMethod = new HashMap();
    HashSet<String> visited = new HashSet();
    private BugReporter bugReporter;
    private static final Pattern sigType = Pattern.compile("L([^;]*/)?([^/]+;)");

    public static boolean definedIn(JavaClass clazz, XMethod m) {
        for (Method m2 : clazz.getMethods()) {
            if (!m.getName().equals(m2.getName()) || !m.getSignature().equals(m2.getSignature()) || m.isStatic() != m2.isStatic()) continue;
            return true;
        }
        return false;
    }

    public static boolean confusingMethodNames(XMethod m1, XMethod m2) {
        if (m1.isStatic() != m2.isStatic()) {
            return false;
        }
        if (m1.getClassName().equals(m2.getClassName())) {
            return false;
        }
        if (m1.getName().equalsIgnoreCase(m2.getName()) && !m1.getName().equals(m2.getName()) && m1.getSignature().equals(m2.getSignature())) {
            return true;
        }
        if (m1.getSignature().equals(m2.getSignature())) {
            return false;
        }
        return Naming.removePackageNamesFromSignature(m1.getSignature()).equals(Naming.removePackageNamesFromSignature(m2.getSignature()));
    }

    public Naming(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    private boolean checkSuper(XMethod m, HashSet<XMethod> others) {
        if (m.isStatic()) {
            return false;
        }
        if (m.getName().equals("<init>") || m.getName().equals("<clinit>")) {
            return false;
        }
        for (XMethod m2 : others) {
            try {
                if (!Naming.confusingMethodNames(m, m2) || !Repository.instanceOf((String)m.getClassName(), (String)m2.getClassName())) continue;
                int priority = 1;
                try {
                    JavaClass clazz = Repository.lookupClass((String)m.getClassName());
                    if (Naming.definedIn(clazz, m2)) {
                        priority += 2;
                    }
                    for (JavaClass i : clazz.getAllInterfaces()) {
                        if (!Naming.definedIn(i, m)) continue;
                        priority += 2;
                    }
                    for (JavaClass s : clazz.getSuperClasses()) {
                        if (!Naming.definedIn(s, m)) continue;
                        priority += 2;
                    }
                }
                catch (ClassNotFoundException e) {
                    ++priority;
                    AnalysisContext.reportMissingClass((ClassNotFoundException)e);
                }
                String pattern = "NM_VERY_CONFUSING";
                if (priority == 1 && AnalysisContext.currentXFactory().isCalled(m)) {
                    priority = 2;
                } else if (priority > 2 && m.getSignature().equals(m2.getSignature())) {
                    pattern = "NM_VERY_CONFUSING_INTENTIONAL";
                    priority = 2;
                }
                XFactory xFactory = AnalysisContext.currentXFactory();
                if (xFactory.getDeprecated().contains(m) || xFactory.getDeprecated().contains(m2)) {
                    ++priority;
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, pattern, priority).addClass(m.getClassName()).addMethod(m).addClass(m2.getClassName()).addMethod(m2));
                return true;
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass((ClassNotFoundException)e);
            }
        }
        return false;
    }

    private boolean checkNonSuper(XMethod m, HashSet<XMethod> others) {
        if (m.isStatic()) {
            return false;
        }
        if (m.getName().startsWith("<init>") || m.getName().startsWith("<clinit>")) {
            return false;
        }
        for (XMethod m2 : others) {
            if (!Naming.confusingMethodNames(m, m2)) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_CONFUSING", 3).addClass(m.getClassName()).addMethod(m).addClass(m2.getClassName()).addMethod(m2));
            return true;
        }
        return false;
    }

    public void report() {
        for (String allSmall : this.canonicalToTrueMapping.keySet()) {
            HashSet<String> s = this.canonicalToTrueMapping.get(allSmall);
            if (s.size() <= 1) continue;
            HashSet<XMethod> conflictingMethods = this.canonicalToXMethod.get(allSmall);
            Iterator<XMethod> j = conflictingMethods.iterator();
            while (j.hasNext()) {
                if (!this.checkSuper(j.next(), conflictingMethods)) continue;
                j.remove();
            }
            for (XMethod conflictingMethod : conflictingMethods) {
                if (this.checkNonSuper(conflictingMethod, conflictingMethods)) break;
            }
        }
    }

    public void visitJavaClass(JavaClass obj) {
        if (obj.isInterface()) {
            return;
        }
        String name = obj.getClassName();
        if (!this.visited.add(name)) {
            return;
        }
        try {
            JavaClass[] supers;
            for (JavaClass aSuper : supers = Repository.getSuperClasses((JavaClass)obj)) {
                this.visitJavaClass(aSuper);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        super.visitJavaClass(obj);
    }

    public void visit(JavaClass obj) {
        String name = obj.getClassName();
        String[] parts = name.split("[$+.]");
        this.baseClassName = parts[parts.length - 1];
        boolean bl = this.classIsPublicOrProtected = obj.isPublic() || obj.isProtected();
        if (this.baseClassName.length() == 1) {
            return;
        }
        if (Character.isLetter(this.baseClassName.charAt(0)) && !Character.isUpperCase(this.baseClassName.charAt(0)) && this.baseClassName.indexOf("_") == -1) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_CLASS_NAMING_CONVENTION", this.classIsPublicOrProtected ? 2 : 3).addClass((PreorderVisitor)this));
        }
        if (name.endsWith("Exception") && !obj.getSuperclassName().endsWith("Exception") && !obj.getSuperclassName().endsWith("Error") && !obj.getSuperclassName().endsWith("Throwable")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_CLASS_NOT_EXCEPTION", 2).addClass((PreorderVisitor)this));
        }
        super.visit(obj);
    }

    public void visit(Field obj) {
        if (this.getFieldName().length() == 1) {
            return;
        }
        if (!obj.isFinal() && Character.isLetter(this.getFieldName().charAt(0)) && !Character.isLowerCase(this.getFieldName().charAt(0)) && this.getFieldName().indexOf("_") == -1 && Character.isLetter(this.getFieldName().charAt(1)) && Character.isLowerCase(this.getFieldName().charAt(1))) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_FIELD_NAMING_CONVENTION", this.classIsPublicOrProtected && (obj.isPublic() || obj.isProtected()) ? 2 : 3).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this));
        }
    }

    private boolean isInnerClass(JavaClass obj) {
        for (Field f : obj.getFields()) {
            if (!f.getName().startsWith("this$")) continue;
            return true;
        }
        return false;
    }

    private boolean markedAsNotUsable(Method obj) {
        for (Attribute a : obj.getAttributes()) {
            if (!(a instanceof Deprecated)) continue;
            return true;
        }
        Code code = obj.getCode();
        if (code == null) {
            return false;
        }
        byte[] codeBytes = code.getCode();
        if (codeBytes.length > 1 && codeBytes.length < 10) {
            int lastOpcode = codeBytes[codeBytes.length - 1] & 0xFF;
            if (lastOpcode != 191) {
                return false;
            }
            for (byte b : codeBytes) {
                if ((b & 0xFF) != 177) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @CheckForNull
    private static Method findVoidConstructor(JavaClass clazz) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals("<init>") || !m.getSignature().equals("()V")) continue;
            return m;
        }
        return null;
    }

    public void visit(Method obj) {
        String mName = this.getMethodName();
        if (mName.length() == 1) {
            return;
        }
        if (mName.equals("isRequestedSessionIdFromURL") || mName.equals("isRequestedSessionIdFromUrl")) {
            return;
        }
        if (Character.isLetter(mName.charAt(0)) && !Character.isLowerCase(mName.charAt(0)) && Character.isLetter(mName.charAt(1)) && Character.isLowerCase(mName.charAt(1)) && mName.indexOf("_") == -1) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_METHOD_NAMING_CONVENTION", this.classIsPublicOrProtected && (obj.isPublic() || obj.isProtected()) ? 2 : 3).addClassAndMethod((PreorderVisitor)this));
        }
        String sig = this.getMethodSig();
        if (mName.equals(this.baseClassName) && sig.equals("()V")) {
            Code code = obj.getCode();
            Method realVoidConstructor = Naming.findVoidConstructor(this.getThisClass());
            if (code != null && !this.markedAsNotUsable(obj)) {
                int priority = 2;
                if (this.codeDoesSomething(code)) {
                    --priority;
                } else if (!obj.isPublic() && this.getThisClass().isPublic()) {
                    --priority;
                }
                if (realVoidConstructor == null) {
                    ++priority;
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_METHOD_CONSTRUCTOR_CONFUSION", priority).addClassAndMethod((PreorderVisitor)this).lowerPriorityIfDeprecated());
                return;
            }
        }
        if (obj.isAbstract()) {
            return;
        }
        if (obj.isPrivate()) {
            return;
        }
        if (mName.equals("equal") && sig.equals("(Ljava/lang/Object;)Z")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_BAD_EQUAL", 1).addClassAndMethod((PreorderVisitor)this).lowerPriorityIfDeprecated());
            return;
        }
        if (mName.equals("hashcode") && sig.equals("()I")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_LCASE_HASHCODE", 1).addClassAndMethod((PreorderVisitor)this).lowerPriorityIfDeprecated());
            return;
        }
        if (mName.equals("tostring") && sig.equals("()Ljava/lang/String;")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_LCASE_TOSTRING", 1).addClassAndMethod((PreorderVisitor)this).lowerPriorityIfDeprecated());
            return;
        }
        if (obj.isPrivate() || obj.isStatic() || mName.equals("<init>")) {
            return;
        }
        String trueName = new StringBuffer().append(mName).append(sig).toString();
        String sig2 = Naming.removePackageNamesFromSignature(sig);
        String allSmall = new StringBuffer().append(mName.toLowerCase()).append(sig2).toString();
        XMethod xm = XFactory.createXMethod((PreorderVisitor)this);
        HashSet<String> s = this.canonicalToTrueMapping.get(allSmall);
        if (s == null) {
            s = new HashSet();
            this.canonicalToTrueMapping.put(allSmall, s);
        }
        s.add(trueName);
        s = this.canonicalToXMethod.get(allSmall);
        if (s == null) {
            s = new HashSet();
            this.canonicalToXMethod.put(allSmall, s);
        }
        s.add((String)xm);
    }

    private boolean codeDoesSomething(Code code) {
        byte[] codeBytes = code.getCode();
        return codeBytes.length > 1;
    }

    private static String removePackageNamesFromSignature(String sig) {
        int end = sig.indexOf(")");
        Matcher m = sigType.matcher(sig.substring(0, end));
        return new StringBuffer().append(m.replaceAll("L$2")).append(sig.substring(end)).toString();
    }
}

