/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Method;

public class TestingGround
extends BytecodeScanningDetector {
    BugReporter bugReporter;
    int prevOpcode;

    public TestingGround(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        if (Character.isUpperCase(obj.getName().charAt(0))) {
            BugInstance bug = new BugInstance((Detector)this, "TESTING", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addString("method should start with lower case character");
            this.bugReporter.reportBug(bug);
        }
        this.prevOpcode = -1;
    }

    public void visit(Field obj) {
        if (obj.isFinal() && obj.isStatic() && obj.isPublic() && !obj.getName().equals(obj.getName().toUpperCase()) && !obj.getName().equals("serialVersionUID")) {
            BugInstance bug = new BugInstance((Detector)this, "TESTING", obj.getSignature().equals("I") ? 1 : 2).addClass((PreorderVisitor)this).addField((PreorderVisitor)this).addString("Should be upper case");
            this.bugReporter.reportBug(bug);
        }
    }

    public void visit(Code obj) {
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        if (this.prevOpcode == 135 && seen == 184 && this.getNameConstantOperand().equals("ceil") && this.getClassConstantOperand().equals("java.lang.Math")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "TESTING", 1).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this).addSourceLine((BytecodeScanningDetector)this));
        }
        this.prevOpcode = seen;
    }
}

