/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile;

public abstract class FieldOrMethodDescriptor {
    private String className;
    private String name;
    private String signature;
    private boolean isStatic;

    public FieldOrMethodDescriptor(String className, String name, String signature, boolean isStatic) {
        this.className = className;
        this.name = name;
        this.signature = signature;
        this.isStatic = isStatic;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    protected int compareTo(FieldOrMethodDescriptor o) {
        int cmp = this.className.compareTo(o.className);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.name.compareTo(o.name);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.signature.compareTo(o.signature);
        if (cmp != 0) {
            return cmp;
        }
        return (this.isStatic ? 1 : 0) - (o.isStatic ? 1 : 0);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FieldOrMethodDescriptor other = (FieldOrMethodDescriptor)obj;
        return this.className.equals(other.className) && this.name.equals(other.name) && this.signature.equals(other.signature) && this.isStatic == other.isStatic;
    }

    public int hashCode() {
        return this.className.hashCode() * 7919 + this.name.hashCode() * 3119 + this.signature.hashCode() * 131 + (this.isStatic ? 1 : 0);
    }

    public String toString() {
        return (this.isStatic ? "static " : "") + this.className + "." + this.name + ":" + this.signature;
    }
}

