/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class PCXReader
extends FormatReader {
    public static final byte PCX_MAGIC_BYTE = 10;
    private long offset;
    private int bytesPerLine;
    private int nColorPlanes;
    private byte[][] lut;

    public PCXReader() {
        super("PCX", "pcx");
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        boolean blockLen = true;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)1, (boolean)false)) {
            return false;
        }
        return stream.read() == 10;
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        return this.lut;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.in.seek(this.offset);
        byte[] b = new byte[this.bytesPerLine * this.getSizeY() * this.nColorPlanes];
        int pt = 0;
        block0: while (pt < b.length) {
            int val = this.in.read() & 0xFF;
            if ((val & 0xC0) >> 6 == 3) {
                int len = val & 0x3F;
                val = this.in.read() & 0xFF;
                for (int q = 0; q < len; ++q) {
                    b[pt++] = (byte)val;
                    if (pt % this.bytesPerLine == 0) continue block0;
                }
                continue;
            }
            b[pt++] = (byte)(val & 0xFF);
        }
        int src = y * this.nColorPlanes * this.bytesPerLine;
        for (int row = 0; row < h; ++row) {
            int rowOffset = row * this.nColorPlanes * this.bytesPerLine;
            for (int c = 0; c < this.nColorPlanes; ++c) {
                System.arraycopy(b, src + rowOffset + x, buf, c * w * h + row * w, w);
                rowOffset += this.bytesPerLine;
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offset = 0L;
            this.bytesPerLine = 0;
            this.nColorPlanes = 0;
            this.lut = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        LOGGER.info("Reading file header");
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = true;
        this.in.order(this.isLittleEndian());
        this.in.seek(1L);
        int version = this.in.read();
        this.in.skipBytes(1);
        int bitsPerPixel = this.in.read();
        short xMin = this.in.readShort();
        short yMin = this.in.readShort();
        short xMax = this.in.readShort();
        short yMax = this.in.readShort();
        m.sizeX = xMax - xMin;
        m.sizeY = yMax - yMin;
        this.in.skipBytes(version == 5 ? 53 : 51);
        this.nColorPlanes = this.in.read();
        this.bytesPerLine = this.in.readShort();
        short paletteType = this.in.readShort();
        this.offset = this.in.getFilePointer() + 58L;
        if (version == 5 && this.nColorPlanes == 1) {
            this.in.seek(this.in.length() - 768L);
            this.lut = new byte[3][256];
            for (int i = 0; i < this.lut[0].length; ++i) {
                for (int j = 0; j < this.lut.length; ++j) {
                    this.lut[j][i] = this.in.readByte();
                }
            }
            m.indexed = true;
        }
        this.addGlobalMeta("Palette type", paletteType);
        m.sizeZ = 1;
        m.sizeT = 1;
        m.sizeC = this.nColorPlanes;
        m.rgb = this.nColorPlanes > 1;
        m.imageCount = 1;
        m.pixelType = 1;
        m.dimensionOrder = "XYCZT";
        m.interleaved = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }
}

