/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.ImageCanvas;
import org.openmicroscopy.shoola.agents.imviewer.browser.ProjectionUI;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;

class ProjectionBICanvas
extends ImageCanvas {
    static final Color BACKGROUND_COLOR = Color.BLACK;
    static final Color TEXT_COLOR = Color.WHITE;
    static final String DEFAULT_TEXT = "Click here to create\n a projection preview.";
    static final String CREATION_TEXT = "Creating preview";
    private MouseAdapter listener;
    private ProjectionUI ui;
    private String text;

    private void attachListener() {
        if (this.listener != null) {
            return;
        }
        this.listener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ProjectionBICanvas.this.model.projectionPreview();
                ProjectionBICanvas.this.text = ProjectionBICanvas.CREATION_TEXT;
                ProjectionBICanvas.this.removeMouseListener(ProjectionBICanvas.this.listener);
                ProjectionBICanvas.this.repaint();
            }
        };
        this.addMouseListener(this.listener);
    }

    ProjectionBICanvas(BrowserModel model, BrowserUI view, ProjectionUI ui) {
        super(model, view);
        if (ui == null) {
            throw new IllegalArgumentException("No UI specified.");
        }
        this.ui = ui;
        this.text = DEFAULT_TEXT;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        BufferedImage img = this.model.getDisplayedProjectedImage();
        Graphics2D g2D = (Graphics2D)g;
        ImagePaintingFactory.setGraphicRenderingSettings(g2D);
        if (img == null) {
            img = this.model.getDisplayedImage();
            if (img != null) {
                this.attachListener();
                double f = this.model.getZoomFactor();
                int w = img.getWidth() - 1;
                int h = img.getHeight() - 1;
                w = (int)((double)w * f);
                h = (int)((double)h * f);
                g2D.setColor(BACKGROUND_COLOR);
                g2D.fillRect(0, 0, w, h);
                FontMetrics fm = g2D.getFontMetrics();
                g2D.setColor(TEXT_COLOR);
                int width = fm.stringWidth(this.text);
                if ((double)width + ((double)w - (double)width * f) / 2.0 > (double)w) {
                    int l = this.text.length();
                    String s1 = this.text.substring(0, l / 2);
                    String s2 = this.text.substring(l / 2 + 1, l);
                    width = fm.stringWidth(s1);
                    int x = (w - width) / 2;
                    g2D.drawString(s1, x, h / 2);
                    width = fm.stringWidth(s2);
                    x = (w - width) / 2;
                    g2D.drawString(s2, x, (h + fm.getHeight() + 10) / 2);
                } else {
                    g2D.drawString(this.text, (w - width) / 2, h / 2);
                }
            }
            return;
        }
        g2D.drawImage((Image)img, 0, 0, null);
        this.paintScaleBar(g2D, img.getWidth(), img.getHeight(), this.ui.getViewport());
        g2D.dispose();
    }
}

