/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.rnd;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;
import org.openmicroscopy.shoola.util.image.geom.Factory;

class PreviewCanvas
extends JPanel {
    private BufferedImage image;
    private boolean interpolate = true;

    PreviewCanvas() {
        this.setDoubleBuffered(true);
    }

    void setImage(BufferedImage image) {
        this.image = image;
        this.repaint();
    }

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    @Override
    public void paintComponent(Graphics g) {
        double yFactor;
        if (this.image == null) {
            return;
        }
        Dimension d = this.getSize();
        double xFactor = (double)d.width / (double)this.image.getWidth();
        double factor = xFactor < (yFactor = (double)d.height / (double)this.image.getHeight()) ? xFactor : yFactor;
        BufferedImage scaledImage = Factory.magnifyImage(this.image, factor, 0, this.interpolate);
        int x = (d.width - scaledImage.getWidth()) / 2;
        int y = (d.height - scaledImage.getHeight()) / 2;
        Graphics2D g2D = (Graphics2D)g;
        g2D.setColor(this.getBackground());
        g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2D.setColor(this.getForeground());
        ImagePaintingFactory.setGraphicRenderingSettings(g2D, this.interpolate);
        g2D.drawImage(scaledImage, null, x, y);
        g2D.dispose();
    }
}

