/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.svc;

import java.util.HashMap;
import java.util.Map;
import org.openmicroscopy.shoola.svc.SvcActivationException;
import org.openmicroscopy.shoola.svc.SvcActivator;
import org.openmicroscopy.shoola.svc.SvcDescriptor;
import org.openmicroscopy.shoola.svc.communicator.Communicator;
import org.openmicroscopy.shoola.svc.communicator.CommunicatorDescriptor;
import org.openmicroscopy.shoola.svc.communicator.CommunicatorFactory;

public class SvcRegistry {
    protected static final Map<Class<?>, Class<?>> activationMap = new HashMap();

    private static SvcActivator createActivator(Object type) throws SvcActivationException {
        if (type == null) {
            throw new SvcActivationException("No activator defined for the requested service.");
        }
        SvcActivator activator = null;
        try {
            Class activatorClass = (Class)type;
            activator = (SvcActivator)activatorClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new SvcActivationException("Couldn't instantiate activator for the requested service.", ie);
        }
        catch (IllegalAccessException iae) {
            throw new SvcActivationException("Couldn't instantiate activator for the requested service.", iae);
        }
        catch (ClassCastException cce) {
            throw new SvcActivationException("Invalid activator bound to the requested service: " + type + " doesn't implement ServiceActivator.");
        }
        return activator;
    }

    public static Communicator getCommunicator(SvcDescriptor desc) throws SvcActivationException {
        if (desc == null) {
            throw new NullPointerException("No service descriptor.");
        }
        Class<?> factory = activationMap.get(desc.getClass());
        Object service = null;
        if (factory != null) {
            try {
                SvcActivator activator = SvcRegistry.createActivator(factory);
                service = ((CommunicatorFactory)activator).activate(desc);
            }
            catch (Exception e) {
                throw new SvcActivationException("Descriptor not recognized", e);
            }
        } else {
            String msg = "Unknown service: " + desc.getSvcName() + ".";
            System.err.println("WARNING: SvcRegistry");
            System.err.print(msg);
        }
        return (Communicator)service;
    }

    static {
        activationMap.put(CommunicatorDescriptor.class, CommunicatorFactory.class);
    }
}

