/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import IceInternal.BasicStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamWrapper
extends InputStream {
    private BasicStream _s;
    private int _markPos;

    public InputStreamWrapper(int size, BasicStream s) {
        this._s = s;
        this._markPos = 0;
    }

    @Override
    public int read() throws IOException {
        try {
            return this._s.getBuffer().b.get();
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int count) throws IOException {
        try {
            this._s.getBuffer().b.get(b, offset, count);
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
        return count;
    }

    @Override
    public int available() {
        return this._s.getBuffer().b.remaining();
    }

    @Override
    public void mark(int readlimit) {
        this._markPos = this._s.pos();
    }

    @Override
    public void reset() throws IOException {
        this._s.pos(this._markPos);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

