/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ome.model.units.BigResult;
import omero.gateway.SecurityContext;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.FileData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.WellData;
import omero.gateway.model.WellSampleData;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.enums.UnitsLength;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImageObject;
import org.openmicroscopy.shoola.agents.events.treeviewer.DataObjectSelectionEvent;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.ROICountLoader;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.ChannelEditUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.file.modulo.ModuloInfo;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.omeeditpane.OMEWikiComponent;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiDataObject;

public class PropertiesUI
extends AnnotationUI
implements DocumentListener,
FocusListener,
PropertyChangeListener {
    static final String TITLE = "Properties";
    private static final String DEFAULT_DESCRIPTION_TEXT = "Add Description";
    private static final String CREATIONDATE_TEXT = "Creation Date: ";
    private static final String EDIT_DESC_TEXT = "Edit the description";
    private static final String EDIT_CHANNEL_TEXT = "Edit channel names";
    private static final int HEIGHT = 120;
    private static final int WIDTH = 100;
    private static final int MAX_CHANNELNAMES_LENGTH_IN_CHARS = 40;
    private JToggleButton descriptionButtonEdit;
    private String originalDescription;
    private JTextArea typePane;
    private OMEWikiComponent descriptionWiki;
    private JPanel descriptionPanel;
    private JLabel parentLabel;
    private JLabel gpLabel;
    private JLabel wellLabel;
    private JLabel channelsArea;
    private EditorControl controller;
    private String text;
    private JScrollPane descriptionScrollPane;
    private JButton editChannel;
    private ChannelEditUI channelEditPane;
    private JComponent channelsPane;
    private JLabel roiCountLabel;

    private void buildChannelsPane() {
        this.editChannel.setVisible(this.model.canEdit());
        this.channelsPane = this.channelsArea;
    }

    private Container getComponent(Container parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof JXTaskPane) {
            return parent;
        }
        return this.getComponent(parent.getParent());
    }

    private void resetComponentSize() {
        Container pane = this.getComponent(this.getParent());
        pane.setSize(this.getPreferredSize());
        pane.validate();
        pane.repaint();
    }

    private void editChannels() {
        Map data = this.model.getChannelData();
        if (data == null || data.size() == 0) {
            return;
        }
        if (this.channelEditPane == null) {
            Object ho = this.model.getParentRootObject();
            if (this.model.getParentRootObject() instanceof WellData) {
                ho = this.model.getGrandParentRootObject();
            }
            this.channelEditPane = new ChannelEditUI(this.model.getChannelData(), ho);
            this.channelEditPane.addPropertyChangeListener(this);
        }
        this.channelsPane = this.channelEditPane;
        this.editChannel.setVisible(false);
        this.removeAll();
        this.buildGUI();
        this.resetComponentSize();
    }

    private void cancelChannelsEdit() {
        this.buildChannelsPane();
        this.removeAll();
        this.buildGUI();
        this.resetComponentSize();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.parentLabel = new JLabel();
        Font f = this.parentLabel.getFont();
        Font newFont = f.deriveFont(f.getStyle(), f.getSize() - 2);
        this.parentLabel.setOpaque(false);
        this.parentLabel.setFont(newFont);
        this.parentLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.gpLabel = new JLabel();
        this.gpLabel.setOpaque(false);
        this.gpLabel.setFont(newFont);
        this.gpLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.wellLabel = new JLabel();
        this.wellLabel.setOpaque(false);
        this.wellLabel.setFont(newFont);
        this.wellLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.typePane = this.createTextPane();
        this.typePane.setEditable(false);
        newFont = f.deriveFont(f.getStyle(), f.getSize() - 2);
        this.descriptionWiki = new OMEWikiComponent(false);
        this.descriptionWiki.setDefaultText(DEFAULT_DESCRIPTION_TEXT);
        this.descriptionWiki.installObjectFormatters();
        this.descriptionWiki.setFont(newFont);
        this.descriptionWiki.setEnabled(false);
        this.descriptionWiki.setAllowOneClick(true);
        this.descriptionWiki.addFocusListener(this);
        this.descriptionWiki.addPropertyChangeListener(this);
        this.typePane.setFont(f.deriveFont(1));
        this.typePane.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
        f = this.parentLabel.getFont();
        this.parentLabel.setFont(f.deriveFont(1));
        this.parentLabel.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        f = this.gpLabel.getFont();
        this.gpLabel.setFont(f.deriveFont(1));
        this.gpLabel.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        f = this.wellLabel.getFont();
        this.wellLabel.setFont(f.deriveFont(1));
        this.wellLabel.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        this.channelsArea = UIUtilities.createComponent(null);
        this.channelsPane = this.channelsArea;
        IconManager icons = IconManager.getInstance();
        this.descriptionButtonEdit = new JToggleButton(icons.getIcon(54));
        this.formatButton(this.descriptionButtonEdit, EDIT_DESC_TEXT);
        this.editChannel = new JButton(icons.getIcon(54));
        this.formatButton(this.editChannel, EDIT_CHANNEL_TEXT);
        this.descriptionWiki.setEnabled(false);
        ItemListener l = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getSource() instanceof JToggleButton) {
                    JToggleButton b = (JToggleButton)e.getSource();
                    if (b.isSelected()) {
                        PropertiesUI.this.expandDescriptionField(true);
                        PropertiesUI.this.editField(PropertiesUI.this.descriptionWiki);
                    } else {
                        PropertiesUI.this.save();
                    }
                }
            }
        };
        this.descriptionButtonEdit.addItemListener(l);
        this.editChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesUI.this.editChannels();
            }
        });
    }

    private void formatButton(JButton button, String text) {
        button.setOpaque(false);
        UIUtilities.unifiedButtonLookAndFeel(button);
        button.setBackground(UIUtilities.BACKGROUND_COLOR);
        button.setToolTipText(text);
    }

    private void formatButton(JToggleButton button, String text) {
        button.setOpaque(false);
        button.setBackground(UIUtilities.BACKGROUND_COLOR);
        button.setBorder(new EmptyBorder(2, 2, 2, 2));
        button.setToolTipText(text);
    }

    private JPanel layoutPlateContent(PlateData plate) {
        JLabel value;
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        content.setLayout(new GridBagLayout());
        JLabel l = new JLabel();
        Font font = l.getFont();
        int size = font.getSize() - 2;
        LinkedHashMap<JLabel, JComponent> components = new LinkedHashMap<JLabel, JComponent>();
        String v = plate.getPlateType();
        if (v != null && v.trim().length() > 0) {
            l = UIUtilities.setTextFont("Type", 1, size);
            value = UIUtilities.createComponent(null);
            value.setFont(font.deriveFont(font.getStyle(), size));
            value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
            value.setText(v);
            components.put(l, value);
        }
        l = UIUtilities.setTextFont("External Identifier", 1, size);
        value = UIUtilities.createComponent(null);
        value.setFont(font.deriveFont(font.getStyle(), size));
        value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        v = plate.getExternalIdentifier();
        if (v == null || v.length() == 0) {
            v = "Not Set";
        }
        value.setText(v);
        components.put(l, value);
        l = UIUtilities.setTextFont("Status", 1, size);
        value = UIUtilities.createComponent(null);
        value.setFont(font.deriveFont(font.getStyle(), size));
        value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        v = plate.getStatus();
        if (v == null || v.length() == 0) {
            v = "Not Set";
        }
        value.setText(v);
        components.put(l, value);
        this.layoutComponents(content, components);
        return content;
    }

    private JPanel layoutWellContent(WellData well) {
        JLabel value;
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        content.setLayout(new GridBagLayout());
        JLabel l = new JLabel();
        Font font = l.getFont();
        int size = font.getSize() - 2;
        LinkedHashMap<JLabel, JComponent> components = new LinkedHashMap<JLabel, JComponent>();
        String v = well.getWellType();
        if (v != null && v.trim().length() > 0) {
            l = UIUtilities.setTextFont("Type", 1, size);
            value = UIUtilities.createComponent(null);
            value.setFont(font.deriveFont(font.getStyle(), size));
            value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
            value.setText(v);
            components.put(l, value);
        }
        l = UIUtilities.setTextFont("External Description", 1, size);
        value = UIUtilities.createComponent(null);
        value.setFont(font.deriveFont(font.getStyle(), size));
        value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        v = well.getExternalDescription();
        if (v == null || v.length() == 0) {
            v = "Not Set";
        }
        value.setText(v);
        components.put(l, value);
        l = UIUtilities.setTextFont("Status", 1, size);
        value = UIUtilities.createComponent(null);
        value.setFont(font.deriveFont(font.getStyle(), size));
        value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        v = well.getStatus();
        if (v == null || v.length() == 0) {
            v = "Not Set";
        }
        value.setText(v);
        components.put(l, value);
        this.layoutComponents(content, components);
        return content;
    }

    private JPanel layoutScreenContent(ScreenData screen) {
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        content.setLayout(new GridBagLayout());
        JLabel l = new JLabel();
        Font font = l.getFont();
        int size = font.getSize() - 2;
        LinkedHashMap<JLabel, JComponent> components = new LinkedHashMap<JLabel, JComponent>();
        l = UIUtilities.setTextFont("Protocol Identifier:", 1, size);
        JLabel value = UIUtilities.createComponent(null);
        value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        String v = screen.getProtocolIdentifier();
        if (v == null || v.length() == 0) {
            v = "Not Set";
        }
        value.setText(v);
        components.put(l, value);
        l = UIUtilities.setTextFont("Protocol Description:", 1, size);
        value = UIUtilities.createComponent(null);
        value.setFont(font.deriveFont(font.getStyle(), size));
        value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        v = screen.getProtocolDescription();
        if (v == null || v.length() == 0) {
            v = "Not Set";
        }
        value.setText(v);
        components.put(l, value);
        l = UIUtilities.setTextFont("ReagentSet Identifier:", 1, size);
        value = UIUtilities.createComponent(null);
        value.setFont(font.deriveFont(font.getStyle(), size));
        value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        v = screen.getReagentSetIdentifier();
        if (v == null || v.length() == 0) {
            v = "Not Set";
        }
        value.setText(v);
        components.put(l, value);
        l = UIUtilities.setTextFont("ReagentSet Description:", 1, size);
        value = UIUtilities.createComponent(null);
        value.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        value.setFont(font.deriveFont(font.getStyle(), size));
        v = screen.getReagentSetDescripion();
        if (v == null || v.length() == 0) {
            v = "Not Set";
        }
        value.setText(v);
        components.put(l, value);
        this.layoutComponents(content, components);
        return content;
    }

    private void layoutComponents(JPanel pane, Map<JLabel, JComponent> components) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        Iterator<Map.Entry<JLabel, JComponent>> i = components.entrySet().iterator();
        c.gridy = 0;
        while (i.hasNext()) {
            c.gridx = 0;
            Map.Entry<JLabel, JComponent> entry = i.next();
            ++c.gridy;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            pane.add((Component)entry.getKey(), c);
            ++c.gridx;
            pane.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            pane.add((Component)entry.getValue(), c);
        }
    }

    private String formatPixelsSize(Map details, JLabel component) {
        Object obj = details.get("Pixel size X ");
        if (obj instanceof BigResult) {
            MetadataViewerAgent.logBigResultExeption(this, obj, "Pixel size X ");
            return "N/A";
        }
        obj = details.get("Pixel size Y ");
        if (obj instanceof BigResult) {
            MetadataViewerAgent.logBigResultExeption(this, obj, "Pixel size Y ");
            return "N/A";
        }
        obj = details.get("Pixel size Z ");
        if (obj instanceof BigResult) {
            MetadataViewerAgent.logBigResultExeption(this, obj, "Pixel size Z ");
            return "N/A";
        }
        Length x = (Length)details.get("Pixel size X ");
        Length y = (Length)details.get("Pixel size Y ");
        Length z = (Length)details.get("Pixel size Z ");
        Double dx = null;
        Double dy = null;
        Double dz = null;
        boolean number = true;
        DecimalFormat nf = new DecimalFormat("0.00");
        UnitsLength unit = null;
        try {
            x = UIUtilities.transformSize(x);
            dx = x.getValue();
            unit = x.getUnit();
        }
        catch (Exception e) {
            number = false;
        }
        try {
            if (unit == null) {
                y = UIUtilities.transformSize(y);
                dy = y.getValue();
                unit = y.getUnit();
            } else {
                y = new LengthI(y, unit);
                dy = y.getValue();
            }
        }
        catch (Exception e) {
            number = false;
        }
        try {
            if (unit == null) {
                z = UIUtilities.transformSize(z);
                dz = z.getValue();
                unit = z.getUnit();
            } else {
                z = new LengthI(z, unit);
                dz = z.getValue();
            }
        }
        catch (Exception e) {
            number = false;
        }
        Object label = "Pixels Size (";
        Object value = "";
        Object tooltip = "<html><body>";
        if (dx != null && dx > 0.0) {
            value = (String)value + nf.format(dx);
            tooltip = (String)tooltip + "X: " + x.getValue() + " " + LengthI.lookupSymbol((UnitsLength)x.getUnit()) + "<br>";
            label = (String)label + "X";
        }
        if (dy != null && dy > 0.0) {
            value = ((String)value).length() == 0 ? (String)value + nf.format(dy) : (String)value + "x" + nf.format(dy);
            tooltip = (String)tooltip + "Y: " + y.getValue() + " " + LengthI.lookupSymbol((UnitsLength)y.getUnit()) + "<br>";
            label = (String)label + "Y";
        }
        if (dz != null && dz > 0.0) {
            value = ((String)value).length() == 0 ? (String)value + nf.format(dz) : (String)value + "x" + nf.format(dz);
            tooltip = (String)tooltip + "Z: " + z.getValue() + " " + LengthI.lookupSymbol((UnitsLength)z.getUnit()) + "<br>";
            label = (String)label + "Z";
        }
        label = (String)label + ") ";
        component.setToolTipText((String)tooltip);
        if (((String)value).length() == 0) {
            return null;
        }
        component.setText((String)value);
        if (unit == null) {
            unit = UnitsLength.MICROMETER;
        }
        label = (String)label + "(" + LengthI.lookupSymbol((UnitsLength)unit) + ")";
        return (String)label + ":";
    }

    private JPanel buildContentPanel(Map details, ImageData image) {
        JLabel value;
        JLabel label;
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.weightx = 1.0;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        JLabel l = new JLabel();
        Font font = l.getFont();
        int size = font.getSize() - 2;
        Object v = this.model.formatDate(image);
        if (!CommonsLangUtils.isEmpty((CharSequence)v)) {
            label = UIUtilities.setTextFont("Acquisition Date:", 1, size);
            value = UIUtilities.createComponent(null);
            value.setText((String)v);
            content.add((Component)label, c);
            ++c.gridx;
            content.add((Component)value, c);
            ++c.gridy;
            c.gridx = 0;
        }
        try {
            label = UIUtilities.setTextFont("Import Date:", 1, size);
            value = UIUtilities.createComponent(null);
            Timestamp time = image.getInserted();
            if (time != null) {
                v = UIUtilities.formatDefaultDate(time);
                value.setText((String)v);
                content.add((Component)label, c);
                ++c.gridx;
                content.add((Component)value, c);
                ++c.gridy;
            }
        }
        catch (Exception time) {
            // empty catch block
        }
        label = UIUtilities.setTextFont("Dimensions (XY):", 1, size);
        value = UIUtilities.createComponent(null);
        v = (String)details.get("Size X");
        v = (String)v + " x ";
        v = (String)v + (String)details.get("Size Y");
        value.setText((String)v);
        c.gridx = 0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add((Component)value, c);
        ++c.gridy;
        label = UIUtilities.setTextFont("Pixel Type:", 1, size);
        value = UIUtilities.createComponent(null);
        value.setText((String)details.get("Pixel Type"));
        c.gridx = 0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add((Component)value, c);
        value = UIUtilities.createComponent(null);
        String s = this.formatPixelsSize(details, value);
        if (s != null) {
            ++c.gridy;
            label = UIUtilities.setTextFont(s, 1, size);
            c.gridx = 0;
            content.add((Component)label, c);
            ++c.gridx;
            content.add((Component)value, c);
        }
        Map<Integer, ModuloInfo> modulo = this.model.getModulo();
        ModuloInfo moduloT = modulo.get(2);
        ++c.gridy;
        label = UIUtilities.setTextFont("Z-sections/Timepoints:", 1, size);
        value = UIUtilities.createComponent(null);
        v = (String)details.get("Number of sections");
        v = (String)v + " x ";
        if (moduloT != null) {
            String time = (String)details.get("Number of timepoints");
            int t = Integer.parseInt(time);
            v = (String)v + t / moduloT.getSize();
        } else {
            v = (String)v + (String)details.get("Number of timepoints");
        }
        value.setText((String)v);
        c.gridx = 0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add((Component)value, c);
        ++c.gridy;
        if (moduloT != null) {
            label = UIUtilities.setTextFont("t", 1, size);
            value = UIUtilities.createComponent(null);
            value.setText("" + moduloT.getSize());
            c.gridx = 0;
            content.add((Component)label, c);
            ++c.gridx;
            content.add((Component)value, c);
            ++c.gridy;
        }
        if (!this.model.isNumerousChannel() && this.model.getRefObjectID() > 0L) {
            label = UIUtilities.setTextFont("Channels:", 1, size);
            c.gridx = 0;
            content.add((Component)label, c);
            ++c.gridx;
            c.fill = 2;
            content.add((Component)this.channelsPane, c);
            c.fill = 0;
            ++c.gridx;
            content.add((Component)this.editChannel, c);
            ++c.gridy;
        }
        label = new JLabel("...");
        label = UIUtilities.setTextFont("ROI Count:", 1, size);
        c.gridx = 0;
        content.add((Component)label, c);
        ++c.gridx;
        this.roiCountLabel = UIUtilities.createComponent(null);
        this.roiCountLabel.setText("...");
        content.add((Component)this.roiCountLabel, c);
        this.loadROICount(image);
        return content;
    }

    private JTextArea createTextPane() {
        JTextArea pane = new JTextArea();
        pane.setOpaque(false);
        pane.setBackground(UIUtilities.BACKGROUND_COLOR);
        return pane;
    }

    private JPanel layoutEditablefield(Component button, JComponent component) {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        p.add((Component)component, c);
        ++c.gridx;
        if (button != null) {
            c.fill = 0;
            c.weightx = 0.0;
            c.anchor = 13;
            p.add(button, c);
        }
        return p;
    }

    private JPanel buildProperties() {
        Object refObject = this.model.getRefObject();
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 1));
        p.add(Box.createVerticalStrut(2));
        int w = 10;
        JPanel l = UIUtilities.buildComponentPanel(this.gpLabel, 0, 0);
        l.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(this.layoutEditablefield(Box.createHorizontalStrut(w), l));
        l = UIUtilities.buildComponentPanel(this.parentLabel, 0, 0);
        l.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(this.layoutEditablefield(Box.createHorizontalStrut(w), l));
        l = UIUtilities.buildComponentPanel(this.wellLabel, 0, 0);
        l.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(this.layoutEditablefield(Box.createHorizontalStrut(w), l));
        if (refObject instanceof ImageData || refObject instanceof DatasetData || refObject instanceof ProjectData || refObject instanceof TagAnnotationData || refObject instanceof WellSampleData || refObject instanceof PlateData || refObject instanceof ScreenData || refObject instanceof PlateAcquisitionData) {
            this.descriptionScrollPane = new JScrollPane(this.descriptionWiki);
            this.descriptionScrollPane.setBorder(AnnotationUI.EDIT_BORDER);
            this.descriptionPanel = new JPanel(new GridBagLayout());
            this.descriptionPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.gridx = 0;
            c.gridy = 0;
            c.gridheight = 2;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 18;
            this.descriptionPanel.add((Component)this.descriptionScrollPane, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridheight = 1;
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 12;
            this.descriptionPanel.add((Component)this.descriptionButtonEdit, c);
            boolean hasDescription = !this.descriptionWiki.getText().equals(DEFAULT_DESCRIPTION_TEXT);
            this.expandDescriptionField(hasDescription);
            p.add(this.descriptionPanel);
            p.add(Box.createVerticalStrut(5));
        }
        return p;
    }

    private void expandDescriptionField(boolean expand) {
        if (this.descriptionScrollPane == null) {
            return;
        }
        if (expand) {
            Dimension viewportSize = new Dimension(100, 120);
            this.descriptionScrollPane.getViewport().setPreferredSize(viewportSize);
        } else {
            this.descriptionScrollPane.getViewport().setPreferredSize(null);
        }
        this.revalidate();
    }

    private void buildGUI() {
        DataObject dob;
        Timestamp crDate;
        this.setBackground(UIUtilities.BACKGROUND);
        this.add(this.buildProperties());
        Object refObject = this.model.getRefObject();
        PixelsData data = null;
        ImageData img = null;
        if (refObject instanceof ImageData) {
            img = (ImageData)refObject;
            try {
                data = ((ImageData)refObject).getDefaultPixels();
            }
            catch (Exception exception) {}
        } else if (refObject instanceof WellData) {
            this.add(Box.createVerticalStrut(5));
            this.add(this.layoutWellContent((WellData)refObject));
        } else if (refObject instanceof WellSampleData) {
            img = ((WellSampleData)refObject).getImage();
            if (img != null && img.getId() > 0L) {
                data = img.getDefaultPixels();
            }
        } else if (refObject instanceof PlateData) {
            this.add(Box.createVerticalStrut(5));
            this.add(this.layoutPlateContent((PlateData)refObject));
        } else if (refObject instanceof ScreenData) {
            this.add(Box.createVerticalStrut(5));
            this.add(this.layoutScreenContent((ScreenData)refObject));
        }
        this.add(Box.createVerticalStrut(5));
        if (data != null) {
            this.add(this.buildContentPanel(EditorUtil.transformPixelsData(data), img));
        } else if ((refObject instanceof DatasetData || refObject instanceof ProjectData || refObject instanceof PlateData || refObject instanceof PlateAcquisitionData || refObject instanceof ScreenData) && (crDate = (dob = (DataObject)refObject).getCreated()) != null) {
            JLabel createDateLabel = new JLabel();
            Font font = createDateLabel.getFont();
            int size = font.getSize() - 2;
            createDateLabel.setFont(new JLabel().getFont().deriveFont(1, size));
            createDateLabel.setText(CREATIONDATE_TEXT);
            JLabel createDateValue = new JLabel();
            createDateValue.setFont(new JLabel().getFont().deriveFont(0, size));
            createDateValue.setText(UIUtilities.formatDefaultDate(crDate));
            JPanel p = new JPanel();
            p.setLayout(new GridLayout(1, 2));
            p.add(createDateLabel);
            p.add(createDateValue);
            p.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            p.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.add(p);
        }
    }

    private void editField(JComponent field) {
        this.descriptionWiki.setEnabled(true);
        this.descriptionScrollPane.setBorder(EDIT_BORDER_BLACK);
        field.requestFocus();
    }

    private String getWellLabel(WellData well, int columnIndex, int rowIndex) {
        int k = well.getRow() + 1;
        Object rowText = "";
        if (rowIndex == 1) {
            rowText = UIUtilities.LETTERS.get(k);
        } else if (rowIndex == 0) {
            rowText = "" + k;
        }
        k = well.getColumn() + 1;
        Object columnText = "";
        if (columnIndex == 1) {
            columnText = UIUtilities.LETTERS.get(k);
        } else if (columnIndex == 0) {
            columnText = "" + k;
        }
        String value = (String)rowText + "-" + (String)columnText;
        return value;
    }

    private void setParentLabel() {
        Object parent = this.model.getParentRootObject();
        if (parent instanceof WellData) {
            WellData well = (WellData)parent;
            PlateData plate = well.getPlate();
            Object text = plate.getName();
            String s = UIUtilities.formatPartialName((String)text);
            this.parentLabel.setText("Plate: " + s);
            this.parentLabel.setToolTipText((String)text);
            this.parentLabel.repaint();
            text = "Well " + this.getWellLabel(well, plate.getColumnSequenceIndex(), plate.getRowSequenceIndex());
            this.wellLabel.setText((String)text);
        }
        if ((parent = this.model.getGrandParentRootObject()) instanceof ScreenData) {
            ScreenData screen = (ScreenData)parent;
            this.text = "Screen: ";
            this.text = this.text + screen.getName();
            this.gpLabel.setText(this.text);
            this.gpLabel.repaint();
        }
    }

    PropertiesUI(EditorModel model, EditorControl controller) {
        super(model);
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.controller = controller;
        this.title = TITLE;
        this.initComponents();
    }

    private void editNames() {
        Object refObject = this.model.getRefObject();
        boolean b = this.model.canEdit();
        if (refObject instanceof FileData) {
            b = false;
        }
        this.descriptionButtonEdit.setEnabled(b);
    }

    @Override
    protected void buildUI() {
        this.removeAll();
        Object refObject = this.model.getRefObject();
        this.text = this.model.getObjectTypeAsString(refObject);
        if (this.model.isMultiSelection()) {
            return;
        }
        this.descriptionWiki.removeDocumentListener(this);
        boolean b = this.model.canEdit();
        this.originalDescription = this.model.getRefObjectDescription();
        if (CommonsLangUtils.isEmpty(this.originalDescription)) {
            this.originalDescription = DEFAULT_DESCRIPTION_TEXT;
        }
        this.descriptionWiki.setText(this.originalDescription);
        this.expandDescriptionField(!this.originalDescription.equals(DEFAULT_DESCRIPTION_TEXT));
        this.descriptionWiki.setCaretPosition(0);
        this.descriptionWiki.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.descriptionWiki.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        this.editNames();
        if (b) {
            this.descriptionWiki.addDocumentListener(this);
        }
        this.setParentLabel();
        this.buildChannelsPane();
        this.buildGUI();
    }

    void onChannelDataLoading() {
        this.editChannel.setEnabled(false);
    }

    void setFocusOnName() {
    }

    void setParentRootObject() {
        Object object = this.model.getRefObject();
        this.setParentLabel();
        if (!(object instanceof WellSampleData)) {
            return;
        }
        this.originalDescription = this.model.getRefObjectDescription();
        if (this.originalDescription == null || this.originalDescription.length() == 0) {
            this.originalDescription = DEFAULT_DESCRIPTION_TEXT;
        }
        this.descriptionWiki.setText(this.originalDescription);
        this.expandDescriptionField(!this.originalDescription.equals(DEFAULT_DESCRIPTION_TEXT));
        boolean b = this.model.canEdit();
        this.descriptionButtonEdit.setEnabled(b);
        this.descriptionButtonEdit.setSelected(false);
        if (b) {
            this.descriptionWiki.addDocumentListener(this);
        }
    }

    void save() {
        this.updateDataObject();
        this.model.fireAnnotationSaving(null, Collections.emptyList(), false);
    }

    void updateDataObject() {
        if (!this.hasDataToSave()) {
            return;
        }
        Object object = this.model.getRefObject();
        String desc = this.descriptionWiki.getText().trim();
        if (desc == null) {
            desc = "";
        }
        if (object instanceof ProjectData) {
            ProjectData p = (ProjectData)object;
            p.setDescription(desc);
        } else if (object instanceof DatasetData) {
            DatasetData p = (DatasetData)object;
            p.setDescription(desc);
        } else if (object instanceof ImageData) {
            ImageData p = (ImageData)object;
            p.setDescription(desc);
        } else if (object instanceof TagAnnotationData) {
            TagAnnotationData p = (TagAnnotationData)object;
            p.setTagDescription(desc);
        } else if (object instanceof ScreenData) {
            ScreenData p = (ScreenData)object;
            p.setDescription(desc);
        } else if (object instanceof PlateData) {
            PlateData p = (PlateData)object;
            p.setDescription(desc);
        } else if (object instanceof WellSampleData) {
            WellSampleData well = (WellSampleData)object;
            ImageData img = well.getImage();
            img.setDescription(desc);
        } else if (object instanceof FileData) {
            FileData f = (FileData)object;
            if (f.getId() > 0L) {
                return;
            }
        } else if (object instanceof PlateAcquisitionData) {
            PlateAcquisitionData pa = (PlateAcquisitionData)object;
            pa.setDescription(desc);
        }
    }

    void setChannelData(Map channels) {
        if (channels == null) {
            return;
        }
        this.editChannel.setEnabled(this.model.canEdit());
        int n = channels.size() - 1;
        Iterator k = channels.keySet().iterator();
        int j = 0;
        StringBuffer buffer = new StringBuffer();
        while (k.hasNext()) {
            buffer.append(((ChannelData)k.next()).getChannelLabeling());
            if (j != n) {
                buffer.append(", ");
            }
            ++j;
        }
        String text = CommonsLangUtils.wrap(buffer.toString(), 40, "<br>", true);
        this.channelsArea.setText("<html>" + text + "</html>");
        this.channelsArea.revalidate();
        this.channelsArea.repaint();
    }

    String getText() {
        return this.text;
    }

    @Override
    protected String getComponentTitle() {
        return TITLE;
    }

    @Override
    protected List<Object> getAnnotationToRemove() {
        return null;
    }

    @Override
    protected List<AnnotationData> getAnnotationToSave() {
        return null;
    }

    @Override
    protected boolean hasDataToSave() {
        if (this.model.isMultiSelection()) {
            return false;
        }
        String name = this.originalDescription;
        String value = this.descriptionWiki.getText();
        value = value.trim();
        if (name == null) {
            return value.length() != 0;
        }
        name = OMEWikiComponent.prepare(name.trim(), true);
        value = OMEWikiComponent.prepare(value.trim(), true);
        if (DEFAULT_DESCRIPTION_TEXT.equals(name) && DEFAULT_DESCRIPTION_TEXT.equals(value)) {
            return false;
        }
        return !name.equals(value);
    }

    @Override
    protected void clearData(Object oldObject) {
        this.originalDescription = this.model.getRefObjectDescription();
        this.descriptionWiki.removeDocumentListener(this);
        if (CommonsLangUtils.isEmpty(this.originalDescription)) {
            this.originalDescription = DEFAULT_DESCRIPTION_TEXT;
        }
        this.descriptionWiki.setText(this.originalDescription);
        this.expandDescriptionField(!this.originalDescription.equals(DEFAULT_DESCRIPTION_TEXT));
        this.descriptionButtonEdit.setSelected(false);
        this.descriptionWiki.addDocumentListener(this);
        this.channelEditPane = null;
        this.descriptionWiki.setEnabled(false);
        this.editNames();
        if (oldObject == null) {
            return;
        }
        if (!this.model.isSameObject(oldObject)) {
            this.channelsArea.setText("");
            this.parentLabel.setText("");
            this.wellLabel.setText("");
            this.gpLabel.setText("");
        }
    }

    @Override
    protected void clearDisplay() {
    }

    @Override
    protected void setComponentTitle() {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        String text = this.descriptionWiki.getText();
        this.editNames();
        if (CommonsLangUtils.isBlank(text)) {
            this.descriptionWiki.removeDocumentListener(this);
            this.descriptionWiki.setText(DEFAULT_DESCRIPTION_TEXT);
            this.descriptionWiki.addDocumentListener(this);
            this.firePropertyChange("save", (Object)false, (Object)true);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        if ("wikiDataObject".equals(name)) {
            WikiDataObject object = (WikiDataObject)evt.getNewValue();
            long id = object.getId();
            switch (object.getIndex()) {
                case 2: {
                    if (id <= 0L) break;
                    ViewImage event = new ViewImage(this.model.getSecurityContext(), new ViewImageObject(id), null);
                    event.setPlugin(MetadataViewerAgent.runAsPlugin());
                    bus.post(event);
                }
            }
        } else if ("wikiDataObjectOneClick".equals(name)) {
            WikiDataObject object = (WikiDataObject)evt.getNewValue();
            long id = object.getId();
            switch (object.getIndex()) {
                case 2: {
                    bus.post(new DataObjectSelectionEvent(ImageData.class, id));
                    break;
                }
                case 1: {
                    bus.post(new DataObjectSelectionEvent(DatasetData.class, id));
                    break;
                }
                case 0: {
                    bus.post(new DataObjectSelectionEvent(ProjectData.class, id));
                }
            }
        } else if ("Cancel".equals(name)) {
            this.cancelChannelsEdit();
        } else if ("Save".equals(name)) {
            List channels = (List)evt.getNewValue();
            this.model.fireChannelSaving(channels, false);
            this.cancelChannelsEdit();
        } else if ("ApplyToAll".equals(name)) {
            List channels = (List)evt.getNewValue();
            this.model.fireChannelSaving(channels, true);
            this.cancelChannelsEdit();
        } else if ("textUpdate".equals(name)) {
            this.firePropertyChange("save", (Object)false, (Object)true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    void loadROICount(ImageData image) {
        ROICountLoader l = new ROICountLoader(new SecurityContext(image.getGroupId()), this, image.getId());
        l.load();
    }

    public void updateROICount(int n) {
        this.roiCountLabel.setText("" + n);
    }
}

