/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.Collection;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ProjectData;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class HierarchyLoader
extends BatchCallTree {
    private long userID;
    private Collection rootNodes;
    private BatchCall loadCall;
    private SecurityContext ctx;

    private void validate(Class rootNodeType, List<Long> rootNodeIDs) {
        if (rootNodeType == null) {
            throw new IllegalArgumentException("No root node type.");
        }
        if (rootNodeIDs == null) {
            throw new IllegalArgumentException("No root node ids.");
        }
        if (rootNodeIDs.size() == 0) {
            throw new IllegalArgumentException("No root node ids.");
        }
        if (!rootNodeType.equals(ProjectData.class) && !rootNodeType.equals(DatasetData.class)) {
            throw new IllegalArgumentException("Unsupported type: " + rootNodeType);
        }
        this.loadCall = this.makeBatchCall(rootNodeType, rootNodeIDs);
    }

    private BatchCall makeBatchCall(final Class rootNodeType, final List rootNodeIDs) {
        return new BatchCall("Loading container tree: "){

            @Override
            public void doCall() throws Exception {
                OmeroDataService os = HierarchyLoader.this.context.getDataService();
                HierarchyLoader.this.rootNodes = os.loadContainerHierarchy(HierarchyLoader.this.ctx, rootNodeType, rootNodeIDs, true, HierarchyLoader.this.userID);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.rootNodes;
    }

    public HierarchyLoader(SecurityContext ctx, Class rootNodeType, List<Long> rootNodeIDs, long userID) {
        this.ctx = ctx;
        this.userID = userID;
        this.validate(rootNodeType, rootNodeIDs);
    }
}

