/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.model.ImportRequestData;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;

class OfflineImportRequestBuilder {
    private final Registry context;
    private final ImportableObject importContainer;
    private final ImportableFile importData;

    OfflineImportRequestBuilder(Registry context, ImportableObject importContainer, ImportableFile importData) {
        if (context == null) {
            throw new NullPointerException("No registry.");
        }
        if (importContainer == null) {
            throw new NullPointerException("No importContainer.");
        }
        if (importData == null) {
            throw new NullPointerException("No importData.");
        }
        this.context = context;
        this.importContainer = importContainer;
        this.importData = importData;
    }

    private void fillInUserAndServer(ImportRequestData data) {
        AdminService svc = this.context.getAdminService();
        ExperimenterData exp = this.importData.getUser();
        if (exp == null) {
            exp = svc.getUserDetails();
        }
        data.experimenterEmail = exp.getEmail();
        data.omeroHost = svc.getServerName();
        if (svc.getPort() > 0) {
            data.omeroPort = "" + svc.getPort();
        }
    }

    private void mapImportData(ImportRequestData data) {
        Collection<TagAnnotationData> tags;
        data.targetUri = this.importData.getOriginalFile().getAbsolutePath();
        DataObject target = this.importData.getDataset();
        if (target != null && target.getId() > 0L) {
            data.datasetId = "" + target.getId();
        }
        if ((target = this.importData.getParent()) != null && target instanceof ScreenData) {
            data.screenId = "" + target.getId();
        }
        if (CollectionUtils.isNotEmpty(tags = this.importContainer.getTags())) {
            ArrayList<CallSite> ids = new ArrayList<CallSite>();
            for (TagAnnotationData tag : tags) {
                if (tag.getId() <= 0L) continue;
                ids.add((CallSite)((Object)("" + tag.getId())));
            }
            data.annotationIds = ids.toArray(new String[ids.size()]);
        }
    }

    ImportRequestData buildRequest(String sessionKey) {
        ImportRequestData data = new ImportRequestData();
        this.fillInUserAndServer(data);
        this.mapImportData(data);
        data.sessionKey = sessionKey;
        return data;
    }
}

