/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.colourpicker.LookupTableIconUtil;

public class ColourIcon
implements Icon {
    public static final int DEFAULT_WIDTH = 16;
    public static final int DEFAULT_HEIGHT = 16;
    private static final Color BORDER_COLOR = Color.BLACK;
    private Color colour;
    private String lut;
    private int height;
    private int width;
    private boolean paintLineBorder = false;
    private Color borderColor = BORDER_COLOR;

    public ColourIcon() {
        this(16, 16);
    }

    public ColourIcon(Color color) {
        this(16, 16, color);
    }

    public ColourIcon(String lut) {
        this(16, 16, lut);
    }

    public ColourIcon(Dimension d) {
        this(d, (Color)null);
    }

    public ColourIcon(int width, int height) {
        this(new Dimension(width, height), (Color)null);
    }

    public ColourIcon(int width, int height, Color color) {
        this(new Dimension(width, height), color);
    }

    public ColourIcon(int width, int height, String lut) {
        this(new Dimension(width, height), lut);
    }

    public ColourIcon(Dimension d, Color color) {
        if (d == null) {
            this.width = 16;
            this.height = 16;
        } else {
            this.width = d.width;
            this.height = d.height;
        }
        if (this.width <= 0) {
            this.width = 16;
        }
        if (this.height <= 0) {
            this.height = 16;
        }
        this.setColour(color);
    }

    public ColourIcon(Dimension d, String lut) {
        if (d == null) {
            this.width = 16;
            this.height = 16;
        } else {
            this.width = d.width;
            this.height = d.height;
        }
        if (this.width <= 0) {
            this.width = 16;
        }
        if (this.height <= 0) {
            this.height = 16;
        }
        this.setLookupTable(lut);
    }

    public void paintLineBorder(boolean paintLineBorder) {
        this.paintLineBorder = paintLineBorder;
    }

    public void setColour(Color c) {
        this.colour = c;
    }

    public void setLookupTable(String lut) {
        this.lut = lut;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2D = (Graphics2D)g;
        if (CommonsLangUtils.isNotEmpty(this.lut)) {
            g2D.drawImage(LookupTableIconUtil.getLUTIconImage(this.lut), 4, 4, this.width - 1, this.height - 1, null);
            if (this.paintLineBorder) {
                g2D.setColor(this.borderColor);
                g2D.drawRect(3, 3, this.width, this.height);
            }
        } else if (this.colour != null) {
            g2D.setColor(this.colour);
            g2D.fillRect(4, 4, this.width - 2, this.height - 2);
            g2D.drawRect(4, 4, this.width - 2, this.height - 2);
            if (this.paintLineBorder) {
                g2D.setColor(this.borderColor);
                g2D.drawRect(3, 3, this.width, this.height);
            }
        }
    }
}

