/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class SearchHelp
extends JDialog {
    private JButton closeButton;
    private String helpURL = "";
    private boolean helpWebbrowserError = false;

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchHelp.this.close();
            }
        });
        this.getRootPane().setDefaultButton(this.closeButton);
    }

    private JPanel buildMain() {
        JPanel content = new JPanel();
        BoxLayout lay = new BoxLayout(content, 3);
        content.setLayout(lay);
        content.setBorder(new TitledBorder(""));
        content.add(new JLabel(this.formatText()));
        content.add(this.linkout("OMERO Help Website", this.helpURL));
        return content;
    }

    private JPanel buildControl() {
        JPanel content = new JPanel();
        content.add(this.closeButton);
        return UIUtilities.buildComponentPanelRight(content);
    }

    private String formatText() {
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body>");
        buf.append("<table>");
        buf.append("<tr><td>?</td><td>Single character wildcard</td>");
        buf.append("<tr><td>*</td><td>Multiple character wildcard</td>");
        buf.append("<tr><td>AND</td><td>Results will contain both terms e.g. GFP AND H2B</td>");
        buf.append("</table>");
        buf.append("<p/>");
        buf.append("<p>For more information see:</p>");
        buf.append("</body></html>");
        return buf.toString();
    }

    private JLabel linkout(String name, final String url) {
        JLabel l = new JLabel("<html><a href=\"\">" + name + "</a></html>");
        l.setCursor(new Cursor(12));
        l.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (Exception ex) {
                    SearchHelp.this.helpWebbrowserError = true;
                    SearchHelp.this.close();
                }
            }
        });
        return l;
    }

    public boolean hasError() {
        return this.helpWebbrowserError;
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        IconManager icons = IconManager.getInstance();
        TitlePanel title = new TitlePanel("Search Tips", "", icons.getIcon(76));
        c.add((Component)((Object)title), "North");
        c.add((Component)this.buildMain(), "Center");
        c.add((Component)this.buildControl(), "South");
    }

    public SearchHelp(JFrame owner, String helpURL) {
        super(owner);
        this.helpURL = helpURL;
        this.setModal(true);
        this.setResizable(false);
        this.initComponents();
        this.buildGUI();
        this.pack();
    }
}

