/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.DataType;

public class Misc {
    public static final int referenceSize = 4;
    public static final int objectSize = 16;
    public static final float defaultMaxRelativeDiffFloat = 1.0E-5f;
    public static final double defaultMaxRelativeDiffDouble = 1.0E-8;

    public static float absoluteDifference(float a, float b) {
        if (Float.compare(a, b) == 0) {
            return 0.0f;
        }
        return Math.abs(a - b);
    }

    public static double absoluteDifference(double a, double b) {
        if (Double.compare(a, b) == 0) {
            return 0.0;
        }
        return Math.abs(a - b);
    }

    public static float relativeDifference(float a, float b) {
        float absDiff = Misc.absoluteDifference(a, b);
        if (Float.compare(a, b) == 0) {
            return 0.0f;
        }
        if (a == 0.0f || b == 0.0f || absDiff < Float.MIN_NORMAL) {
            return absDiff / Float.MIN_NORMAL;
        }
        float maxAbsValue = Math.max(Math.abs(a), Math.abs(b));
        return absDiff / maxAbsValue;
    }

    public static double relativeDifference(double a, double b) {
        double absDiff = Misc.absoluteDifference(a, b);
        if (Double.compare(a, b) == 0) {
            return 0.0;
        }
        if (a == 0.0 || b == 0.0 || absDiff < Double.MIN_NORMAL) {
            return absDiff / Double.MIN_NORMAL;
        }
        double maxAbsValue = Math.max(Math.abs(a), Math.abs(b));
        return absDiff / maxAbsValue;
    }

    public static boolean nearlyEquals(float a, float b) {
        return Misc.nearlyEquals(a, b, 1.0E-5f);
    }

    public static boolean nearlyEquals(float a, float b, float maxRelDiff) {
        return Misc.relativeDifference(a, b) < maxRelDiff;
    }

    public static boolean nearlyEquals(double a, double b) {
        return Misc.nearlyEquals(a, b, 1.0E-8);
    }

    public static boolean nearlyEquals(double a, double b, double maxRelDiff) {
        return Misc.relativeDifference(a, b) < maxRelDiff;
    }

    public static boolean nearlyEqualsAbs(float a, float b, float maxAbsDiff) {
        return Misc.absoluteDifference(a, b) <= Math.abs(maxAbsDiff);
    }

    public static boolean nearlyEqualsAbs(double a, double b, double maxAbsDiff) {
        return Misc.absoluteDifference(a, b) <= Math.abs(maxAbsDiff);
    }

    @Deprecated
    public static String showInts(int[] inta) {
        Formatter f = new Formatter();
        Misc.showInts(inta, f);
        return f.toString();
    }

    public static String showInts(List<Integer> intList) {
        if (intList == null) {
            return "null";
        }
        Formatter f = new Formatter();
        for (int i : intList) {
            f.format("%d,", i);
        }
        return f.toString();
    }

    public static void showInts(int[] inta, Formatter f) {
        if (inta == null) {
            f.format("null", new Object[0]);
            return;
        }
        for (int i : inta) {
            f.format("%d, ", i);
        }
    }

    public static String showBytes(byte[] buff) {
        StringBuilder sbuff = new StringBuilder();
        for (int i = 0; i < buff.length; ++i) {
            int ub;
            int b = buff[i];
            int n = ub = b < 0 ? b + 256 : b;
            if (i > 0) {
                sbuff.append(" ");
            }
            sbuff.append(ub);
        }
        return sbuff.toString();
    }

    public static void showBytes(byte[] buff, Formatter f) {
        for (int n : buff) {
            int ub = n < 0 ? n + 256 : n;
            f.format("%3d ", ub);
        }
    }

    public static String showBits(byte[] bytes) {
        try (Formatter f = new Formatter();){
            int count = 0;
            for (byte b : bytes) {
                short s = DataType.unsignedByteToShort(b);
                f.format("%8s", Long.toBinaryString(s));
                if (++count % 10 != 0) continue;
                f.format("%n", new Object[0]);
            }
            String string = f.toString();
            return string;
        }
    }

    public static boolean compare(byte[] raw1, byte[] raw2, Formatter f) {
        if (raw1 == null || raw2 == null) {
            return false;
        }
        if (raw1.length != raw2.length) {
            f.format("length 1= %3d != length 2=%3d%n", raw1.length, raw2.length);
        }
        int len = Math.min(raw1.length, raw2.length);
        int ndiff = 0;
        for (int i = 0; i < len; ++i) {
            if (raw1[i] == raw2[i]) continue;
            f.format(" %3d : %3d != %3d%n", i + 1, raw1[i], raw2[i]);
            ++ndiff;
        }
        if (ndiff > 0) {
            f.format("Misc.compare %d bytes, %d are different %n", len, ndiff);
        }
        return ndiff == 0 && raw1.length == raw2.length;
    }

    public static boolean compare(float[] raw1, float[] raw2, Formatter f) {
        boolean ok = true;
        if (raw1.length != raw2.length) {
            f.format("compareFloat: length 1= %3d != length 2=%3d%n", raw1.length, raw2.length);
            ok = false;
        }
        int len = Math.min(raw1.length, raw2.length);
        int ndiff = 0;
        for (int i = 0; i < len; ++i) {
            if (Misc.nearlyEquals(raw1[i], raw2[i]) || Double.isNaN(raw1[i]) || Double.isNaN(raw2[i])) continue;
            f.format(" %5d : %3f != %3f%n", i, Float.valueOf(raw1[i]), Float.valueOf(raw2[i]));
            ++ndiff;
            ok = false;
        }
        if (ndiff > 0) {
            f.format("Misc.compare %d floats, %d are different %n", len, ndiff);
        }
        return ok;
    }

    public static boolean compare(int[] raw1, int[] raw2, Formatter f) {
        boolean ok = true;
        if (raw1.length != raw2.length) {
            f.format("compareFloat: length 1= %3d != length 2=%3d%n", raw1.length, raw2.length);
            ok = false;
        }
        int len = Math.min(raw1.length, raw2.length);
        int ndiff = 0;
        for (int i = 0; i < len; ++i) {
            if (raw1[i] == raw2[i]) continue;
            f.format(" %5d : %3d != %3d%n", i, raw1[i], raw2[i]);
            ++ndiff;
            ok = false;
        }
        if (ndiff > 0) {
            f.format("Misc.compare %d ints, %d are different %n", len, ndiff);
        }
        return ok;
    }

    @Deprecated
    public static int compare(int x, int y) {
        return Integer.compare(x, y);
    }

    @Deprecated
    public static int compare(long x, long y) {
        return Long.compare(x, y);
    }

    @Deprecated
    public static String stackTraceToString(StackTraceElement[] stackTrace) {
        StringBuilder buf = new StringBuilder();
        for (StackTraceElement ste : stackTrace) {
            buf.append(ste);
            buf.append("\n");
        }
        return buf.toString();
    }

    @Deprecated
    public static int getSize(Iterable ii) {
        if (ii instanceof Collection) {
            return ((Collection)ii).size();
        }
        int count = 0;
        for (Object i : ii) {
            ++count;
        }
        return count;
    }

    @Deprecated
    public static List getList(Iterable ii) {
        if (ii instanceof List) {
            return (List)ii;
        }
        ArrayList result = new ArrayList();
        for (Object i : ii) {
            result.add(i);
        }
        return result;
    }
}

