/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.TextField;
import java.util.Vector;

public class SpecifyROI
implements PlugIn,
DialogListener {
    private static double width;
    private static double height;
    private static double xRoi;
    private static double yRoi;
    private static boolean oval;
    private static boolean square;
    private static boolean centered;
    private static boolean scaledUnits;
    private static final int WIDTH = 0;
    private static final int HEIGHT = 1;
    private static final int X_ROI = 2;
    private static final int Y_ROI = 3;
    private static final int OVAL = 0;
    private static final int SQUARE = 1;
    private static final int CENTERED = 2;
    private static final int SCALED_UNITS = 3;
    private static Rectangle prevRoi;
    private static double prevPixelWidth;
    private int iSlice;
    private boolean bAbort;
    private ImagePlus imp;
    private Vector fields;
    private Vector checkboxes;
    private int stackSize;

    public void run(String arg) {
        this.imp = IJ.getImage();
        if (this.imp == null) {
            return;
        }
        this.stackSize = this.imp.getStackSize();
        Roi roi = this.imp.getRoi();
        Calibration cal = this.imp.getCalibration();
        if (roi != null && roi.getBounds().equals(prevRoi) && cal.pixelWidth == prevPixelWidth) {
            roi = null;
        }
        if (roi != null) {
            boolean rectOrOval = roi != null && (roi.getType() == 0 || roi.getType() == 1);
            oval = rectOrOval && roi.getType() == 1;
            Rectangle r = roi.getBounds();
            width = r.width;
            height = r.height;
            xRoi = r.x;
            yRoi = r.y;
            if (scaledUnits && cal.scaled()) {
                xRoi *= cal.pixelWidth;
                yRoi *= cal.pixelHeight;
                width *= cal.pixelWidth;
                height *= cal.pixelHeight;
            }
            if (centered) {
                xRoi += width / 2.0;
                yRoi += height / 2.0;
            }
        } else if (!this.validDialogValues()) {
            width = this.imp.getWidth() / 2;
            height = this.imp.getHeight() / 2;
            xRoi = width / 2.0;
            yRoi = height / 2.0;
        }
        this.iSlice = this.imp.getCurrentSlice();
        this.showDialog();
    }

    boolean validDialogValues() {
        Calibration cal = this.imp.getCalibration();
        double pw = cal.pixelWidth;
        double ph = cal.pixelHeight;
        if (width / pw < 1.0 || height / ph < 1.0) {
            return false;
        }
        return !(xRoi / pw > (double)this.imp.getWidth()) && !(yRoi / ph > (double)this.imp.getHeight());
    }

    void showDialog() {
        Roi roi;
        Calibration cal = this.imp.getCalibration();
        int digits = 0;
        if (scaledUnits && cal.scaled()) {
            digits = 2;
        }
        if ((roi = this.imp.getRoi()) == null) {
            this.drawRoi();
        }
        GenericDialog gd = new GenericDialog("Specify");
        gd.addNumericField("Width:", width, digits);
        gd.addNumericField("Height:", height, digits);
        gd.addNumericField("X coordinate:", xRoi, digits);
        gd.addNumericField("Y coordinate:", yRoi, digits);
        if (this.stackSize > 1) {
            gd.addNumericField("Slice:", this.iSlice, 0);
        }
        gd.addCheckbox("Oval", oval);
        gd.addCheckbox("Constrain square/circle", square);
        gd.addCheckbox("Centered", centered);
        if (cal.scaled()) {
            gd.addCheckbox("Scaled units (" + cal.getUnits() + ")", scaledUnits);
        }
        this.fields = gd.getNumericFields();
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            if (roi == null) {
                this.imp.deleteRoi();
            } else {
                this.imp.setRoi(roi);
            }
        }
    }

    void drawRoi() {
        double xPxl = xRoi;
        double yPxl = yRoi;
        if (centered) {
            xPxl -= width / 2.0;
            yPxl -= height / 2.0;
        }
        double widthPxl = width;
        double heightPxl = height;
        Calibration cal = this.imp.getCalibration();
        if (scaledUnits && cal.scaled()) {
            xPxl /= cal.pixelWidth;
            yPxl /= cal.pixelHeight;
            widthPxl /= cal.pixelWidth;
            heightPxl /= cal.pixelHeight;
            prevPixelWidth = cal.pixelWidth;
        }
        Roi roi = oval ? new OvalRoi(xPxl, yPxl, widthPxl, heightPxl) : new Roi(xPxl, yPxl, widthPxl, heightPxl);
        this.imp.setRoi(roi);
        prevRoi = roi.getBounds();
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        int digits;
        if (IJ.isMacOSX()) {
            IJ.wait(50);
        }
        Calibration cal = this.imp.getCalibration();
        width = gd.getNextNumber();
        height = gd.getNextNumber();
        xRoi = gd.getNextNumber();
        yRoi = gd.getNextNumber();
        if (this.stackSize > 1) {
            this.iSlice = (int)gd.getNextNumber();
        }
        oval = gd.getNextBoolean();
        square = gd.getNextBoolean();
        centered = gd.getNextBoolean();
        if (cal.scaled()) {
            scaledUnits = gd.getNextBoolean();
        }
        if (gd.invalidNumber() || width <= 0.0 || height <= 0.0) {
            return false;
        }
        Vector numFields = gd.getNumericFields();
        Vector checkboxes = gd.getCheckboxes();
        boolean newWidth = false;
        boolean newHeight = false;
        boolean newXY = false;
        if (e != null && e.getSource() == checkboxes.get(1) && square) {
            height = width = 0.5 * (width + height);
            newWidth = true;
            newHeight = true;
        }
        if (e != null && e.getSource() == checkboxes.get(2)) {
            double shiftBy = centered ? 0.5 : -0.5;
            xRoi += shiftBy * width;
            yRoi += shiftBy * height;
            newXY = true;
        }
        if (square && width != height && e != null) {
            if (e.getSource() == numFields.get(0)) {
                height = width;
                newHeight = true;
            } else if (e.getSource() == numFields.get(1)) {
                width = height;
                newWidth = true;
            }
        }
        if (e != null && cal.scaled() && e.getSource() == checkboxes.get(3)) {
            double xFactor = scaledUnits ? cal.pixelWidth : 1.0 / cal.pixelWidth;
            double yFactor = scaledUnits ? cal.pixelHeight : 1.0 / cal.pixelHeight;
            width *= xFactor;
            height *= yFactor;
            xRoi *= xFactor;
            yRoi *= yFactor;
            newWidth = true;
            newHeight = true;
            newXY = true;
        }
        int n = digits = scaledUnits || (double)((int)width) != width ? 2 : 0;
        if (newWidth) {
            ((TextField)numFields.get(0)).setText(IJ.d2s(width, digits));
        }
        if (newHeight) {
            ((TextField)numFields.get(1)).setText(IJ.d2s(height, digits));
        }
        int n2 = digits = scaledUnits || (double)((int)xRoi) != xRoi || (double)((int)yRoi) != yRoi ? 2 : 0;
        if (newXY) {
            ((TextField)numFields.get(2)).setText(IJ.d2s(xRoi, digits));
            ((TextField)numFields.get(3)).setText(IJ.d2s(yRoi, digits));
        }
        if (this.stackSize > 1 && this.iSlice > 0 && this.iSlice <= this.stackSize) {
            this.imp.setSlice(this.iSlice);
        }
        if (!(newWidth || newHeight || newXY)) {
            this.drawRoi();
        }
        return true;
    }

    static {
        prevPixelWidth = 1.0;
    }
}

