/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter;

import java.util.LinkedHashMap;
import ome.model.units.Time;
import ome.model.units.Unit;
import ome.units.quantity.Length;
import ome.xml.model.Image;
import ome.xml.model.StageLabel;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.Timestamp;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DataConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;

public class ImageConverter
extends DataConverter {
    public LinkedHashMap<String, TagData> convertData(Image image) {
        this.tagMap = new LinkedHashMap();
        if (image != null) {
            try {
                this.tagMap.put("Name", this.convertName(image.getName(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Name", this.convertName(null, true));
            }
            try {
                this.tagMap.put("Description", this.convertDescription(image.getDescription(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Description", this.convertDescription(null, true));
            }
            try {
                this.tagMap.put("Acquisition Time", this.convertAcqTime(image.getAcquisitionDate(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Acquisition Time", this.convertAcqTime(null, true));
            }
            try {
                String[] dimXY = new String[]{image.getPixels().getSizeX().toString(), image.getPixels().getSizeY().toString()};
                this.tagMap.put("Dim X x Y", this.convertDimXY(dimXY, true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Dim X x Y", this.convertDimXY(new String[]{null, null}, true));
            }
            try {
                this.tagMap.put("Pixel Depth", this.convertPixelType(image.getPixels().getType(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Pixel Depth", this.convertPixelType(null, true));
            }
            try {
                this.tagMap.put("Pixel Size (XY)", this.convertPixelSizeXY(image.getPixels().getPhysicalSizeX(), image.getPixels().getPhysicalSizeY(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Pixel Size (XY)", this.convertPixelSizeXY(null, null, true));
            }
            try {
                String[] dimZTC = new String[]{image.getPixels().getSizeZ().toString(), image.getPixels().getSizeT().toString(), image.getPixels().getSizeC().toString()};
                this.tagMap.put("Dim Z x T x C", this.convertDimZTC(dimZTC, true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Dim Z x T x C", this.convertDimZTC(new String[]{null, null, null}, true));
            }
            try {
                this.tagMap.put("Time Increment", this.convertTimeIncrement(image.getPixels().getTimeIncrement(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Time Increment", this.convertTimeIncrement(null, true));
            }
            try {
                StageLabel stage = image.getStageLabel();
                this.tagMap.put("Stage Label (XY)", this.convertStagePos(stage.getX(), stage.getY(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Stage Label (XY)", this.convertStagePos(null, null, true));
            }
        } else {
            this.tagMap.put("Name", this.convertName(null, true));
            this.tagMap.put("Description", this.convertDescription(null, true));
            this.tagMap.put("Acquisition Time", this.convertAcqTime(null, true));
            this.tagMap.put("Dim X x Y", this.convertDimXY(new String[]{null, null}, true));
            this.tagMap.put("Pixel Depth", this.convertPixelType(null, true));
            this.tagMap.put("Pixel Size (XY)", this.convertPixelSizeXY(null, null, true));
            this.tagMap.put("Dim Z x T x C", this.convertDimZTC(new String[]{null, null, null}, true));
            this.tagMap.put("Time Increment", this.convertTimeIncrement(null, true));
            this.tagMap.put("Stage Label (XY)", this.convertStagePos(null, null, true));
        }
        return this.tagMap;
    }

    private TagData convertName(String value, boolean prop) {
        return new TagData("OME:Image", "Name", value, prop, "TextField");
    }

    private TagData convertDescription(String value, Boolean prop) {
        return new TagData("OME:Image", "Description", value, (boolean)prop, "TextField");
    }

    private TagData convertAcqTime(Timestamp value, boolean prop) {
        String val = value != null ? (String)value.getValue() : "";
        return new TagData("OME:Image", "Acquisition Time", val, prop, "TimeStamp");
    }

    private TagData convertDimXY(String[] value, boolean prop) {
        return new TagData("OME:Image", "Dim X x Y", value, prop, "ArrayField", 2);
    }

    private TagData convertPixelType(PixelType value, boolean prop) {
        String val = value != null ? value.getValue() : "";
        return new TagData("OME:Image", "Pixel Depth", val, prop, "TextField");
    }

    private TagData convertPixelSizeXY(Length valueX, Length valueY, boolean prop) {
        ome.model.units.Length valX = null;
        if (valueX != null) {
            valX = new ome.model.units.Length(valueX);
        }
        ome.model.units.Length valY = null;
        if (valueY != null) {
            valY = new ome.model.units.Length(valueY);
        }
        Unit[] val = new Unit[]{valX, valY};
        TagData pixelSize = new TagData("OME:Image", "Pixel Size (XY)", val, ome.model.units.Length.class, prop, "ArrayField", 2);
        pixelSize.setDocumentListener(this.createDocumentListenerPosFloat(pixelSize, "Invalid input. Use float >0!"));
        return pixelSize;
    }

    private TagData convertDimZTC(String[] value, boolean prop) {
        return new TagData("OME:Image", "Dim Z x T x C", value, prop, "ArrayField", 3);
    }

    private TagData convertStagePos(Length valueX, Length valueY, boolean prop) {
        ome.model.units.Length valX = null;
        if (valueX != null) {
            valX = new ome.model.units.Length(valueX);
        }
        ome.model.units.Length valY = null;
        if (valueY != null) {
            valY = new ome.model.units.Length(valueY);
        }
        Unit[] val = new Unit[]{valX, valY};
        TagData stagePos = new TagData("OME:Image", "Stage Label (XY)", val, ome.model.units.Length.class, prop, "ArrayField", 2);
        return stagePos;
    }

    private TagData convertStepSize(String value, boolean prop) {
        return new TagData("OME:Image", "Step Size", value, prop, "TextField");
    }

    private TagData convertTimeIncrement(ome.units.quantity.Time value, boolean prop) {
        Time val = null;
        if (value != null) {
            val = new Time(value);
        }
        return new TagData("OME:Image", "Time Increment", (Unit)val, Time.class, prop, "TextField");
    }

    private TagData convertWellNr(String value, boolean prop) {
        return new TagData("OME:Image", "Well #", value, prop, "TextField");
    }
}

