/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ExceptionDialog
extends JDialog {
    private int dialogWidth = 600;
    private int dialogHeight = 200;
    private JLabel iconLabel = new JLabel();
    private boolean open = false;
    private JLabel errorLabel = new JLabel();
    private JTextArea errorTextArea = new JTextArea("");
    private JTextArea exceptionTextArea = new JTextArea("");
    private JPanel details = new JPanel(new BorderLayout());
    private JButton okButton = new JButton("OK");
    private JButton viewButton = new JButton("View Error");
    private JButton emailButton = new JButton("Email Error");
    private JPanel topPanel = new JPanel(new BorderLayout());

    public ExceptionDialog(String errorLabelText, String errorDescription, Throwable e, String clazz) {
        this.setSize(this.dialogWidth, this.dialogHeight);
        this.setLocation(100, 100);
        this.setModal(true);
        this.setResizable(false);
        this.errorTextArea.setText(errorDescription);
        this.errorLabel.setText(errorLabelText);
        if (e != null) {
            StringWriter errors = new StringWriter();
            e.printStackTrace(new PrintWriter(errors));
            this.exceptionTextArea.setText(errors.toString());
        } else {
            this.exceptionTextArea.setText("");
        }
        this.iconLabel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.iconLabel.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
        this.setupUI();
        this.setUpListeners();
    }

    public ExceptionDialog(String errorLabelText, Throwable e) {
        this(errorLabelText, null, e, "");
    }

    public ExceptionDialog(String label, String errorStr, String clazz) {
        this(label, errorStr, null, clazz);
    }

    public void setupUI() {
        this.setTitle("Error");
        this.errorTextArea.setLineWrap(true);
        this.errorTextArea.setWrapStyleWord(true);
        this.errorTextArea.setEditable(false);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.okButton);
        this.emailButton.setEnabled(false);
        buttonPanel.add(this.emailButton);
        buttonPanel.add(this.viewButton);
        this.errorTextArea.setBackground(this.iconLabel.getBackground());
        this.errorLabel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        Font txtFont = this.errorTextArea.getFont();
        Font boldFont = new Font(txtFont.getFontName(), 1, txtFont.getSize());
        this.errorLabel.setFont(boldFont);
        JScrollPane exceptionTextSP = new JScrollPane(this.exceptionTextArea);
        exceptionTextSP.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        exceptionTextSP.setPreferredSize(new Dimension(100, 200));
        exceptionTextSP.setVerticalScrollBarPolicy(22);
        this.details.add((Component)exceptionTextSP, "Center");
        this.topPanel.add((Component)this.iconLabel, "West");
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.errorLabel, "North");
        p.add((Component)this.errorTextArea, "Center");
        this.topPanel.add(p);
        this.add(this.topPanel);
        this.add((Component)buttonPanel, "South");
    }

    private void setUpListeners() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionDialog.this.setVisible(false);
            }
        });
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExceptionDialog.this.open) {
                    ExceptionDialog.this.viewButton.setText("View Error");
                    ExceptionDialog.this.topPanel.remove(ExceptionDialog.this.details);
                    ExceptionDialog.this.setSize(ExceptionDialog.this.dialogWidth, ExceptionDialog.this.dialogHeight);
                    ExceptionDialog.this.topPanel.revalidate();
                    ExceptionDialog.this.open = false;
                } else {
                    ExceptionDialog.this.viewButton.setText("Hide Error");
                    ExceptionDialog.this.topPanel.add((Component)ExceptionDialog.this.details, "South");
                    ExceptionDialog.this.setSize(ExceptionDialog.this.dialogWidth, ExceptionDialog.this.dialogHeight + 200);
                    ExceptionDialog.this.topPanel.revalidate();
                    ExceptionDialog.this.open = true;
                }
            }
        });
    }
}

