/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import java.util.Collection;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DataObject;
import org.openmicroscopy.shoola.agents.events.metadata.AnnotatedEvent;
import org.openmicroscopy.shoola.agents.metadata.MetadataLoader;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.event.EventBus;

public class DataSaver
extends MetadataLoader {
    private Collection<DataObject> data;
    private List<AnnotationData> toAdd;
    private List<Object> toRemove;
    private List<Object> acquisitionMetadata;
    private CallHandle handle;

    public DataSaver(MetadataViewer viewer, SecurityContext ctx, Collection<DataObject> data, List<AnnotationData> toAdd, List<Object> toRemove, List<Object> acquisitionMetadata, int loaderID) {
        super(viewer, ctx, null, loaderID);
        if (data == null) {
            throw new IllegalArgumentException("No object specified.");
        }
        this.data = data;
        this.toAdd = toAdd;
        this.toRemove = toRemove;
        this.acquisitionMetadata = acquisitionMetadata;
    }

    @Override
    public void load() {
        long userID = MetadataViewerAgent.getUserDetails().getId();
        this.handle = this.mhView.saveData(this.ctx, this.data, this.toAdd, this.toRemove, this.acquisitionMetadata, userID, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 4) {
            return;
        }
        this.viewer.onDataSave((List)this.data);
        boolean post = this.toAdd != null && this.toAdd.size() != 0 || this.toRemove != null && this.toRemove.size() != 0;
        int count = 0;
        if (this.toAdd != null) {
            count += this.toAdd.size();
        }
        if (this.toRemove != null) {
            count -= this.toRemove.size();
        }
        if (post) {
            EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
            bus.post(new AnnotatedEvent((List)this.data, count));
        }
    }
}

