/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.net;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.print.Pageable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.jhotdraw.app.AbstractProject;
import org.jhotdraw.draw.Constrainer;
import org.jhotdraw.draw.DOMStorableInputOutputFormat;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingPageable;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.draw.ImageOutputFormat;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.draw.TextInputFormat;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.gui.PlacardScrollPaneLayout;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.samples.net.NetFactory;
import org.jhotdraw.samples.net.figures.NodeFigure;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;

public class NetProject
extends AbstractProject {
    private UndoRedoManager undo;
    private DrawingEditor editor;
    private GridConstrainer visibleConstrainer = new GridConstrainer(10.0, 10.0);
    private GridConstrainer invisibleConstrainer = new GridConstrainer(1.0, 1.0);
    private Preferences prefs;
    private AbstractButton toggleGridButton;
    private JScrollPane scrollPane;
    private DefaultDrawingView view;

    public void init() {
        super.init();
        this.initComponents();
        JPanel zoomButtonPanel = new JPanel(new BorderLayout());
        this.scrollPane.setLayout(new PlacardScrollPaneLayout());
        this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setEditor(new DefaultDrawingEditor());
        this.undo = new UndoRedoManager();
        this.view.setDrawing(this.createDrawing());
        this.view.getDrawing().addUndoableEditListener(this.undo);
        this.initActions();
        this.undo.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                NetProject.this.setHasUnsavedChanges(NetProject.this.undo.hasSignificantEdits());
            }
        });
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JPanel placardPanel = new JPanel(new BorderLayout());
        AbstractButton pButton = ButtonFactory.createZoomButton(this.view);
        pButton.putClientProperty("Quaqua.Button.style", "placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        placardPanel.add((Component)pButton, "West");
        this.toggleGridButton = pButton = ButtonFactory.createToggleGridButton(this.view);
        pButton.putClientProperty("Quaqua.Button.style", "placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        labels.configureToolBarButton(pButton, "alignGridSmall");
        placardPanel.add((Component)pButton, "East");
        this.scrollPane.add((Component)placardPanel, "LOWER_LEFT_CORNER");
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        this.toggleGridButton.setSelected(this.prefs.getBoolean("project.gridVisible", false));
        this.setScaleFactor(this.prefs.getDouble("project.scaleFactor", 1.0));
        this.view.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name.equals("constrainer")) {
                    NetProject.this.prefs.putBoolean("project.gridVisible", ((Constrainer)evt.getNewValue()).isVisible());
                    NetProject.this.firePropertyChange("gridVisible", ((Constrainer)evt.getOldValue()).isVisible(), ((Constrainer)evt.getNewValue()).isVisible());
                } else if (name.equals("scaleFactor")) {
                    NetProject.this.prefs.putDouble("project.scaleFactor", (Double)evt.getNewValue());
                    NetProject.this.firePropertyChange("scaleFactor", evt.getOldValue(), evt.getNewValue());
                }
            }
        });
    }

    protected Drawing createDrawing() {
        DefaultDrawing drawing = new DefaultDrawing();
        DOMStorableInputOutputFormat ioFormat = new DOMStorableInputOutputFormat(new NetFactory());
        LinkedList<InputFormat> inputFormats = new LinkedList<InputFormat>();
        inputFormats.add(ioFormat);
        inputFormats.add(new TextInputFormat(new NodeFigure()));
        drawing.setInputFormats(inputFormats);
        LinkedList<OutputFormat> outputFormats = new LinkedList<OutputFormat>();
        outputFormats.add(ioFormat);
        outputFormats.add(new ImageOutputFormat());
        drawing.setOutputFormats(outputFormats);
        return drawing;
    }

    public Pageable createPageable() {
        return new DrawingPageable(this.view.getDrawing());
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    public void setEditor(DrawingEditor newValue) {
        DrawingEditor oldValue = this.editor;
        if (oldValue != null) {
            oldValue.remove(this.view);
        }
        this.editor = newValue;
        if (newValue != null) {
            newValue.add(this.view);
        }
    }

    public void setGridVisible(boolean newValue) {
        this.toggleGridButton.setSelected(newValue);
    }

    public boolean isGridVisible() {
        return this.view.getConstrainer().isVisible();
    }

    public double getScaleFactor() {
        return this.view.getScaleFactor();
    }

    public void setScaleFactor(double newValue) {
        this.view.setScaleFactor(newValue);
    }

    private void initActions() {
        this.putAction("undo", this.undo.getUndoAction());
        this.putAction("redo", this.undo.getRedoAction());
    }

    protected void setHasUnsavedChanges(boolean newValue) {
        super.setHasUnsavedChanges(newValue);
        this.undo.setHasSignificantEdits(newValue);
    }

    public void write(File f) throws IOException {
        Drawing drawing = this.view.getDrawing();
        OutputFormat outputFormat = drawing.getOutputFormats().get(0);
        outputFormat.write(f, drawing);
    }

    public void read(File f) throws IOException {
        try {
            final Drawing drawing = this.createDrawing();
            InputFormat inputFormat = drawing.getInputFormats().get(0);
            inputFormat.read(f, drawing);
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    NetProject.this.view.getDrawing().removeUndoableEditListener(NetProject.this.undo);
                    NetProject.this.view.setDrawing(drawing);
                    NetProject.this.view.getDrawing().addUndoableEditListener(NetProject.this.undo);
                    NetProject.this.undo.discardAllEdits();
                }
            });
        }
        catch (InterruptedException e) {
            InternalError error = new InternalError();
            e.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            InternalError error = new InternalError();
            e.initCause(e);
            throw error;
        }
    }

    public void setDrawingEditor(DrawingEditor newValue) {
        if (this.editor != null) {
            this.editor.remove(this.view);
        }
        this.editor = newValue;
        if (this.editor != null) {
            this.editor.add(this.view);
        }
    }

    public DrawingEditor getDrawingEditor() {
        return this.editor;
    }

    public void clear() {
        this.view.setDrawing(new DefaultDrawing());
        this.undo.discardAllEdits();
    }

    protected JFileChooser createOpenChooser() {
        JFileChooser c = super.createOpenChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Net Diagram", "xml"));
        return c;
    }

    protected JFileChooser createSaveChooser() {
        JFileChooser c = super.createSaveChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Net Diagram", "xml"));
        return c;
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.view = new DefaultDrawingView();
        this.setLayout(new BorderLayout());
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setViewportView(this.view);
        this.add((Component)this.scrollPane, "Center");
    }
}

