/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ProjectData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class AddAction
extends TreeViewerAction {
    private static final String NAME = "Add Existing...";
    private static final String NAME_DATASET = "Add Existing Dataset...";
    private static final String NAME_IMAGE = "Add Existing Image...";
    private static final String NAME_USER = "Edit group membership...";
    private static final String DESCRIPTION = "Add existing elements to the selected container.";
    private static final String DESCRIPTION_DATASET = "Add existing datasets to the selected project.";
    private static final String DESCRIPTION_IMAGE = "Add existing images to the selected dataset.";
    private static final String DESCRIPTION_USER = "Add/Remove existing users to/from the selected group.";

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!TreeViewerAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        if (selectedDisplay == null) {
            this.setEnabled(false);
            this.putValue("Name", NAME);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof String || ho instanceof ExperimenterData) {
            this.setEnabled(false);
            this.putValue("Name", NAME);
        } else if (ho instanceof ProjectData) {
            this.setEnabled(this.model.canLink(ho));
            this.putValue("Name", NAME_DATASET);
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DATASET));
        } else if (ho instanceof DatasetData) {
            this.setEnabled(this.model.canLink(ho));
            this.putValue("Name", NAME_IMAGE);
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_IMAGE));
        } else if (ho instanceof GroupData) {
            this.setEnabled(false);
            GroupData g = (GroupData)ho;
            if (TreeViewerAgent.isAdministrator() || this.model.isLeaderOfGroup(g)) {
                boolean multipleNodesSelected = false;
                Browser browser = this.model.getSelectedBrowser();
                TreeImageDisplay[] array = browser.getSelectedDisplays();
                if (array != null && array.length > 1) {
                    multipleNodesSelected = true;
                }
                this.setEnabled(!multipleNodesSelected && TreeViewerAgent.isAddToGroup());
            }
            this.putValue("Name", NAME_USER);
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_USER));
        } else {
            this.setEnabled(false);
            this.putValue("Name", NAME);
        }
        this.name = (String)this.getValue("Name");
    }

    public AddAction(TreeViewer model) {
        super(model);
        this.putValue("Name", NAME);
        this.name = (String)this.getValue("Name");
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(47));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Browser b = this.model.getSelectedBrowser();
        if (b == null) {
            return;
        }
        TreeImageDisplay d = b.getLastSelectedDisplay();
        if (d == null) {
            return;
        }
        Object ho = d.getUserObject();
        if (ho instanceof ProjectData || ho instanceof DatasetData || ho instanceof GroupData) {
            this.model.addExistingObjects((DataObject)ho);
        }
    }
}

