/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportCandidates;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.OMEROWrapper;
import ome.formats.importer.util.ProportionalTimeEstimatorImpl;
import ome.formats.importer.util.TimeEstimator;
import ome.util.checksum.ChecksumProvider;
import ome.util.checksum.ChecksumProviderFactory;
import ome.util.checksum.ChecksumProviderFactoryImpl;
import ome.util.checksum.ChecksumType;
import omero.ApiUsageException;
import omero.AuthenticationException;
import omero.ChecksumValidationException;
import omero.ConcurrencyException;
import omero.InternalException;
import omero.LockTimeout;
import omero.MissingPyramidException;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.RType;
import omero.ResourceError;
import omero.SecurityViolation;
import omero.ServerError;
import omero.SessionException;
import omero.ValidationException;
import omero.api.ExporterPrx;
import omero.api.IAdminPrx;
import omero.api.IContainerPrx;
import omero.api.IMetadataPrx;
import omero.api.IPixelsPrx;
import omero.api.IProjectionPrx;
import omero.api.IQueryPrx;
import omero.api.IRenderingSettingsPrx;
import omero.api.IRepositoryInfoPrx;
import omero.api.IRoiPrx;
import omero.api.IScriptPrx;
import omero.api.ITypesPrx;
import omero.api.IUpdatePrx;
import omero.api.RawFileStorePrx;
import omero.api.RawPixelsStorePrx;
import omero.api.RenderingEnginePrx;
import omero.api.RoiOptions;
import omero.api.Save;
import omero.api.SearchPrx;
import omero.api.StatefulServiceInterfacePrx;
import omero.api.ThumbnailStorePrx;
import omero.cmd.Chmod2;
import omero.cmd.CmdCallbackI;
import omero.cmd.ERR;
import omero.cmd.GraphException;
import omero.cmd.HandlePrx;
import omero.cmd.Request;
import omero.cmd.Response;
import omero.constants.projection.ProjectionType;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.exception.RenderingServiceException;
import omero.gateway.facility.BrowseFacility;
import omero.gateway.facility.DataManagerFacility;
import omero.gateway.facility.ROIFacility;
import omero.gateway.facility.RawDataFacility;
import omero.gateway.facility.SearchFacility;
import omero.gateway.facility.TransferFacility;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.BooleanAnnotationData;
import omero.gateway.model.ChannelAcquisitionData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.EllipseData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FileData;
import omero.gateway.model.FilesetData;
import omero.gateway.model.FolderData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageAcquisitionData;
import omero.gateway.model.ImageData;
import omero.gateway.model.InstrumentData;
import omero.gateway.model.LightSourceData;
import omero.gateway.model.LongAnnotationData;
import omero.gateway.model.MapAnnotationData;
import omero.gateway.model.MaskData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.PointData;
import omero.gateway.model.PolygonData;
import omero.gateway.model.PolylineData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ROIData;
import omero.gateway.model.ROIResult;
import omero.gateway.model.RatingAnnotationData;
import omero.gateway.model.RectangleData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.SearchParameters;
import omero.gateway.model.SearchResultCollection;
import omero.gateway.model.TableResult;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TermAnnotationData;
import omero.gateway.model.TextData;
import omero.gateway.model.TextualAnnotationData;
import omero.gateway.model.TimeAnnotationData;
import omero.gateway.model.WellData;
import omero.gateway.model.WellSampleData;
import omero.gateway.util.PojoMapper;
import omero.gateway.util.Requests;
import omero.grid.BoolColumn;
import omero.grid.Column;
import omero.grid.Data;
import omero.grid.DoubleColumn;
import omero.grid.ImageColumn;
import omero.grid.ImportProcessPrx;
import omero.grid.ImportRequest;
import omero.grid.LongColumn;
import omero.grid.ProcessCallbackI;
import omero.grid.RepositoryMap;
import omero.grid.RepositoryPrx;
import omero.grid.RoiColumn;
import omero.grid.SharedResourcesPrx;
import omero.grid.StringColumn;
import omero.grid.TablePrx;
import omero.grid.WellColumn;
import omero.model.ChecksumAlgorithm;
import omero.model.ChecksumAlgorithmI;
import omero.model.Dataset;
import omero.model.DatasetI;
import omero.model.DetailsI;
import omero.model.EllipseI;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.ExperimenterGroupI;
import omero.model.FileAnnotation;
import omero.model.Fileset;
import omero.model.GroupExperimenterMap;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImageI;
import omero.model.Instrument;
import omero.model.LabelI;
import omero.model.Laser;
import omero.model.LightSource;
import omero.model.LogicalChannel;
import omero.model.MaskI;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.model.Permissions;
import omero.model.PermissionsI;
import omero.model.Pixels;
import omero.model.PixelsType;
import omero.model.Plate;
import omero.model.PlateAcquisition;
import omero.model.PlateAcquisitionI;
import omero.model.PlateI;
import omero.model.PointI;
import omero.model.PolygonI;
import omero.model.PolylineI;
import omero.model.Project;
import omero.model.ProjectI;
import omero.model.RectangleI;
import omero.model.RenderingDef;
import omero.model.Screen;
import omero.model.ScreenI;
import omero.model.TagAnnotation;
import omero.model.TagAnnotationI;
import omero.model.Well;
import omero.model.WellI;
import omero.model.WellSample;
import omero.model.WellSampleI;
import omero.rtypes;
import omero.sys.Parameters;
import omero.sys.ParametersI;
import omero.sys.Roles;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.env.data.ConnectionExceptionHandler;
import org.openmicroscopy.shoola.env.data.DataServicesFactory;
import org.openmicroscopy.shoola.env.data.FSAccessException;
import org.openmicroscopy.shoola.env.data.FSFileSystemView;
import org.openmicroscopy.shoola.env.data.ImportException;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.ProcessException;
import org.openmicroscopy.shoola.env.data.RequestCallback;
import org.openmicroscopy.shoola.env.data.ScriptCallback;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.EnumerationObject;
import org.openmicroscopy.shoola.env.data.model.FigureParam;
import org.openmicroscopy.shoola.env.data.model.ImportableObject;
import org.openmicroscopy.shoola.env.data.model.MovieExportParam;
import org.openmicroscopy.shoola.env.data.model.SaveAsParam;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.model.TableParameters;
import org.openmicroscopy.shoola.env.data.util.ModelMapper;
import org.openmicroscopy.shoola.env.data.util.SearchDataContext;
import org.openmicroscopy.shoola.env.data.util.Status;
import org.openmicroscopy.shoola.env.rnd.PixelsServicesFactory;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class OMEROGateway {
    private static final String REF_FILESET = "/Fileset";
    private static final String REF_IMAGE = "/Image";
    private static final String REF_DATASET = "/Dataset";
    private static final String REF_PROJECT = "/Project";
    private static final String REF_SCREEN = "/Screen";
    private static final String REF_PLATE = "/Plate";
    private static final String REF_ROI = "/Roi";
    private static final String REF_PLATE_ACQUISITION = "/PlateAcquisition";
    private static final String REF_WELL = "/Well";
    private static final String REF_ANNOTATION = "/Annotation";
    private static final String REF_TAG = "/TagAnnotation";
    private static final String REF_TERM = "/TermAnnotation";
    private static final String REF_FILE = "/FileAnnotation";
    private static final String REF_GROUP = "/ExperimenterGroup";
    static final String KEEP = "KEEP";
    private static final String DEFAULT_MIMETYPE = "application/octet-stream";
    private static final String OVERLAYS = "Overlays";
    private static final int INC = 262144;
    static final int MAX_RETRIEVAL = 50;
    private static final int MAX_TABLE_ROW_RETRIEVAL = 100000;
    private static final List<Character> SUPPORTED_SPECIAL_CHAR;
    private static final List<String> WILD_CARDS;
    private static final List<String> SCRIPTS_UI_AVAILABLE;
    private static final List<String> SCRIPTS_NOT_AVAILABLE_TO_USER;
    private static final ChecksumProviderFactory checksumProviderFactory;
    private DataServicesFactory dsFactory;
    private Map<String, List<EnumerationObject>> enumerations;
    private Map<Long, FSFileSystemView> fsViews;
    private Gateway gw;
    private Map<SecurityContext, Set<Long>> renderingEngines = new HashMap<SecurityContext, Set<Long>>();

    private String createFileSetQuery() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("select fs from Fileset as fs ");
        buffer.append("join fetch fs.images as image ");
        buffer.append("left outer join fetch fs.usedFiles as usedFile ");
        buffer.append("join fetch usedFile.originalFile as f ");
        buffer.append("join fetch f.hasher ");
        buffer.append("where image.id in (:imageIds)");
        return buffer.toString();
    }

    private void log(String msg) {
        this.dsFactory.getLogger().debug((Object)this, msg);
    }

    boolean isServerRunning(SecurityContext ctx) {
        if (!this.gw.isConnected()) {
            return false;
        }
        try {
            return null != this.gw.getConnector(ctx, true, true);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private Permissions createPermissions(int level) {
        String perms = "rw----";
        switch (level) {
            case 1: {
                perms = "rwr---";
                break;
            }
            case 2: {
                perms = "rwra--";
                break;
            }
            case 3: {
                perms = "rwrw--";
                break;
            }
            case 4: {
                perms = "rwrwr-";
            }
        }
        return new PermissionsI(perms);
    }

    private long getScriptID(SecurityContext ctx, String name, String message) throws DSOutOfServiceException, DSAccessException {
        IScriptPrx svc = this.getScriptService(ctx);
        try {
            return svc.getScriptID(name);
        }
        catch (Exception e) {
            this.handleException(e, message);
            return -1L;
        }
    }

    private ScriptCallback runScript(SecurityContext ctx, long scriptID, Map<String, RType> parameters) throws ProcessException {
        ScriptCallback cb = null;
        try {
            ProcessCallbackI pcb = this.gw.runScript(ctx, scriptID, parameters);
            cb = new ScriptCallback(scriptID, pcb);
        }
        catch (Exception e) {
            this.handleConnectionException(e);
            throw new ProcessException("Cannot run script with ID:" + scriptID, e);
        }
        return cb;
    }

    void closeService(SecurityContext ctx, StatefulServiceInterfacePrx svc) {
        if (ctx == null || svc == null) {
            return;
        }
        if (svc instanceof RenderingEnginePrx && this.renderingEngines.containsKey(ctx)) {
            try {
                this.renderingEngines.get(ctx).remove(((RenderingEnginePrx)svc).getPixels().getId().getValue());
            }
            catch (ServerError serverError) {
                // empty catch block
            }
        }
        this.gw.closeService(ctx, svc);
    }

    private TableResult createOverlay(long imageID, TablePrx table) throws DSAccessException {
        if (table == null) {
            return null;
        }
        try {
            Column[] cols = table.getHeaders();
            int imageIndex = -1;
            int roiIndex = -1;
            int colorIndex = -1;
            int size = 0;
            for (int i = 0; i < cols.length; ++i) {
                if (cols[i] instanceof ImageColumn) {
                    imageIndex = i;
                    ++size;
                    continue;
                }
                if (cols[i] instanceof RoiColumn) {
                    roiIndex = i;
                    ++size;
                    continue;
                }
                if (!(cols[i] instanceof LongColumn) || !"Color".equals(cols[i].name)) continue;
                colorIndex = i;
                ++size;
            }
            if (imageIndex == -1 || roiIndex == -1) {
                return null;
            }
            String[] headers = new String[size];
            String[] headersDescriptions = new String[size];
            headers[0] = cols[imageIndex].name;
            headersDescriptions[0] = cols[imageIndex].description;
            headers[1] = cols[roiIndex].name;
            headersDescriptions[1] = cols[roiIndex].description;
            headers[1] = cols[roiIndex].name;
            headersDescriptions[1] = cols[roiIndex].description;
            int n = (int)table.getNumberOfRows();
            long[] a = new long[]{imageIndex, roiIndex, colorIndex};
            long[] b = new long[]{};
            Data d = table.slice(a, b);
            ArrayList<Integer> rows = new ArrayList<Integer>();
            Column column = d.columns[imageIndex];
            if (column instanceof ImageColumn) {
                for (int j = 0; j < n; ++j) {
                    Long value = ((ImageColumn)column).values[j];
                    if (value != imageID) continue;
                    rows.add(j);
                }
            }
            Object[][] data = new Object[rows.size()][size];
            int k = 0;
            Iterator r = rows.iterator();
            column = d.columns[roiIndex];
            Column columnColor = null;
            if (colorIndex != -1) {
                columnColor = d.columns[colorIndex];
            }
            while (r.hasNext()) {
                Integer row = (Integer)r.next();
                data[k][0] = row;
                data[k][1] = ((RoiColumn)column).values[row];
                if (columnColor != null) {
                    data[k][2] = ((LongColumn)columnColor).values[row];
                }
                ++k;
            }
            table.close();
            return new TableResult(data, headers);
        }
        catch (Exception e) {
            try {
                if (table != null) {
                    table.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new DSAccessException("Unable to read the table.");
        }
    }

    private void translateTableResult(Data src, Object[][] dst, int offset, int length, Map<Integer, Integer> indexes) {
        Column[] cols = src.columns;
        for (int i = 0; i < cols.length; ++i) {
            int j;
            Column column = cols[i];
            if (column instanceof LongColumn) {
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((LongColumn)column).values[j];
                }
                continue;
            }
            if (column instanceof DoubleColumn) {
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((DoubleColumn)column).values[j];
                }
                continue;
            }
            if (column instanceof StringColumn) {
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((StringColumn)column).values[j];
                }
                continue;
            }
            if (column instanceof BoolColumn) {
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((BoolColumn)column).values[j];
                }
                continue;
            }
            if (column instanceof RoiColumn) {
                indexes.put(TableResult.ROI_COLUMN_INDEX, i);
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((RoiColumn)column).values[j];
                }
                continue;
            }
            if (column instanceof ImageColumn) {
                indexes.put(TableResult.IMAGE_COLUMN_INDEX, i);
                for (j = 0; j < length; ++j) {
                    dst[j + offset][i] = ((ImageColumn)column).values[j];
                }
                continue;
            }
            if (!(column instanceof WellColumn)) continue;
            indexes.put(TableResult.WELL_COLUMN_INDEX, i);
            for (j = 0; j < length; ++j) {
                dst[j + offset][i] = ((WellColumn)column).values[j];
            }
        }
    }

    private TableResult createTableResult(TablePrx table, long[] rows) throws DSAccessException {
        if (table == null) {
            return null;
        }
        try {
            Column[] cols = table.getHeaders();
            String[] headers = new String[cols.length];
            String[] headersDescriptions = new String[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                headers[i] = cols[i].name;
                headersDescriptions[i] = cols[i].description;
            }
            int totalRowCount = rows.length;
            Object[][] data = new Object[totalRowCount][cols.length];
            long[] columns = new long[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                columns[i] = i;
            }
            int rowOffset = 0;
            int rowCount = 0;
            HashMap<Integer, Integer> indexes = new HashMap<Integer, Integer>();
            for (int rowsToGo = totalRowCount; rowsToGo > 0; rowsToGo -= rowCount) {
                rowCount = Math.min(100000, totalRowCount - rowOffset);
                long[] rowSubset = new long[rowCount];
                System.arraycopy(rows, rowOffset, rowSubset, 0, rowCount);
                Data d = table.slice(columns, rowSubset);
                for (int i = 0; i < cols.length; ++i) {
                    this.translateTableResult(d, data, rowOffset, rowCount, indexes);
                }
                rowOffset += rowCount;
            }
            table.close();
            TableResult tr = new TableResult(data, headers);
            tr.setIndexes(indexes);
            return tr;
        }
        catch (Exception e) {
            try {
                if (table != null) {
                    table.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new DSAccessException("Unable to read the table.", e);
        }
    }

    private void handleException(Throwable t, String message) throws DSOutOfServiceException, DSAccessException {
        boolean b = this.handleConnectionException(t);
        if (!b) {
            return;
        }
        if (!this.gw.isConnected()) {
            return;
        }
        Throwable cause = t.getCause();
        if (cause instanceof SecurityViolation) {
            String s = "For security reasons, cannot access data. \n";
            throw new DSAccessException(s + message, cause);
        }
        if (cause instanceof SessionException) {
            String s = "Session is not valid. \n";
            throw new DSOutOfServiceException(s + message, cause);
        }
        if (cause instanceof AuthenticationException) {
            String s = "Cannot initialize the session. \n";
            throw new DSOutOfServiceException(s + message, cause);
        }
        if (cause instanceof ResourceError) {
            String s = "Fatal error. Please contact the administrator. \n";
            if (t.toString().contains("No space")) {
                s = "Server ran out of disk space. Please contact the administrator. \n";
            }
            throw new DSOutOfServiceException(s + message, t);
        }
        throw new DSAccessException("Cannot access data. \n" + message, t);
    }

    boolean handleConnectionException(Throwable e) {
        ConnectionExceptionHandler handler = new ConnectionExceptionHandler();
        int index = handler.handleConnectionException(e);
        if (index < 0) {
            return true;
        }
        this.dsFactory.sessionExpiredExit(index, e);
        return false;
    }

    private void handleFSException(Throwable t, String message) throws FSAccessException {
        boolean b = this.handleConnectionException(t);
        if (!b) {
            return;
        }
        if (!this.gw.isConnected()) {
            return;
        }
        Throwable cause = t.getCause();
        Object s = "\nImage not ready. Please try again later.";
        if (cause instanceof ConcurrencyException) {
            ConcurrencyException mpe = (ConcurrencyException)cause;
            FSAccessException fsa = new FSAccessException(message + (String)s, cause);
            if (mpe instanceof MissingPyramidException || mpe instanceof LockTimeout) {
                fsa.setIndex(1);
            }
            fsa.setBackOffTime(mpe.backOff);
            throw fsa;
        }
        if (t instanceof ConcurrencyException) {
            ConcurrencyException mpe = (ConcurrencyException)t;
            s = (String)s + UIUtilities.calculateHMSFromMilliseconds(mpe.backOff);
            FSAccessException fsa = new FSAccessException(message + (String)s, t);
            if (mpe instanceof MissingPyramidException || mpe instanceof LockTimeout) {
                fsa.setIndex(1);
            }
            fsa.setBackOffTime(mpe.backOff);
            throw fsa;
        }
    }

    private String printErrorText(Throwable e) {
        return UIUtilities.printErrorText(e);
    }

    private Object handleSearchResult(String type, Collection r, SearchPrx svc) throws ServerError {
        boolean hasNext = false;
        try {
            hasNext = svc.hasNext();
        }
        catch (Exception e) {
            int size = 0;
            if (e instanceof InternalException) {
                size = -1;
            } else {
                svc.getBatchSize();
            }
            return size;
        }
        if (!hasNext) {
            return r;
        }
        List l = svc.results();
        for (IObject object : l) {
            long id;
            if (!type.equals(object.getClass().getName()) || r.contains(id = object.getId().getValue())) continue;
            r.add(id);
        }
        return r;
    }

    private List<String> formatText(List<String> terms, String field) {
        if (CollectionUtils.isEmpty(terms)) {
            return null;
        }
        if (CommonsLangUtils.isBlank(field)) {
            return terms;
        }
        ArrayList<String> formatted = new ArrayList<String>(terms.size());
        Iterator<String> j = terms.iterator();
        while (j.hasNext()) {
            formatted.add(field + ":" + j.next());
        }
        return formatted;
    }

    private List<String> formatText(List<String> terms, String firstField, String sep, String secondField) {
        if (CollectionUtils.isEmpty(terms)) {
            return null;
        }
        ArrayList<String> formatted = new ArrayList<String>(terms.size());
        for (String v : terms) {
            String value = firstField + ":" + v + " " + sep + " " + secondField + ":" + v;
            formatted.add(value);
        }
        return formatted;
    }

    private String getTableForLink(Class klass) {
        String table = null;
        if (Dataset.class.equals((Object)klass)) {
            table = "DatasetImageLink";
        } else if (DatasetI.class.equals((Object)klass)) {
            table = "DatasetImageLink";
        } else if (Project.class.equals((Object)klass)) {
            table = "ProjectDatasetLink";
        } else if (ProjectI.class.equals((Object)klass)) {
            table = "ProjectDatasetLink";
        } else if (Screen.class.equals((Object)klass)) {
            table = "ScreenPlateLink";
        } else if (ScreenI.class.equals((Object)klass)) {
            table = "ScreenPlateLink";
        } else if (PlateAcquisition.class.equals((Object)klass)) {
            table = "PlateAcquisitionWellSampleLink";
        } else if (PlateAcquisitionI.class.equals((Object)klass)) {
            table = "PlateAcquisitionWellSampleLink";
        } else if (TagAnnotation.class.equals((Object)klass)) {
            table = "AnnotationAnnotationLink";
        } else if (TagAnnotationI.class.equals((Object)klass)) {
            table = "AnnotationAnnotationLink";
        }
        return table;
    }

    private String getAnnotationTableLink(Class klass) {
        String table = null;
        table = Dataset.class.equals((Object)klass) || DatasetI.class.equals((Object)klass) || DatasetData.class.equals((Object)klass) ? "DatasetAnnotationLink" : (Project.class.equals((Object)klass) || ProjectI.class.equals((Object)klass) || ProjectData.class.equals((Object)klass) ? "ProjectAnnotationLink" : (Image.class.equals((Object)klass) || ImageI.class.equals((Object)klass) || ImageData.class.equals((Object)klass) ? "ImageAnnotationLink" : (Screen.class.equals((Object)klass) || ScreenI.class.equals((Object)klass) || ScreenData.class.equals((Object)klass) ? "ScreenAnnotationLink" : (Plate.class.equals((Object)klass) || PlateI.class.equals((Object)klass) || PlateData.class.equals((Object)klass) ? "PlateAnnotationLink" : (PlateAcquisition.class.equals((Object)klass) || PlateAcquisitionI.class.equals((Object)klass) || PlateAcquisitionData.class.equals((Object)klass) ? "PlateAcquisitionAnnotationLink" : (WellSample.class.equals((Object)klass) || WellSampleI.class.equals((Object)klass) || WellSampleData.class.equals((Object)klass) ? "ScreenAnnotationLink" : (Well.class.equals((Object)klass) || WellI.class.equals((Object)klass) || WellData.class.equals((Object)klass) ? "WellAnnotationLink" : (RectangleData.class.equals((Object)klass) || RectangleI.class.equals((Object)klass) || EllipseData.class.equals((Object)klass) || EllipseI.class.equals((Object)klass) || PointData.class.equals((Object)klass) || PointI.class.equals((Object)klass) || PolygonData.class.equals((Object)klass) || PolygonI.class.equals((Object)klass) || PolylineData.class.equals((Object)klass) || PolylineI.class.equals((Object)klass) || TextData.class.equals((Object)klass) || LabelI.class.equals((Object)klass) || MaskData.class.equals((Object)klass) || MaskI.class.equals((Object)klass) ? "ShapeAnnotationLink" : (ROIData.class.equals((Object)klass) ? "RoiAnnotationLink" : "AnnotationAnnotationLink")))))))));
        return table;
    }

    private String getTableForClass(Class klass) {
        if (DatasetData.class.equals((Object)klass)) {
            return "Dataset";
        }
        if (ProjectData.class.equals((Object)klass)) {
            return "Project";
        }
        if (ImageData.class.equals((Object)klass)) {
            return "Image";
        }
        if (ScreenData.class.equals((Object)klass)) {
            return "Screen";
        }
        if (PlateData.class.equals((Object)klass)) {
            return "Plate";
        }
        if (PlateAcquisitionData.class.equals((Object)klass)) {
            return "PlateAcquisition";
        }
        return null;
    }

    private String convertProperty(Class nodeType, String property) {
        if (nodeType.equals(DatasetData.class)) {
            if (property.equals("images")) {
                return "ome.model.containers.Dataset_imageLinks";
            }
        } else {
            throw new IllegalArgumentException("NodeType or property not supported");
        }
        return null;
    }

    private List loadLinks(SecurityContext ctx, String table, long childID, long userID) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            if (table == null) {
                return new ArrayList();
            }
            ParametersI param = new ParametersI();
            param.map.put("id", rtypes.rlong((long)childID));
            StringBuffer sb = new StringBuffer();
            sb.append("select link from " + table + " as link ");
            sb.append("left outer join fetch link.child as child ");
            sb.append("left outer join fetch link.parent parent ");
            if (childID >= 0L) {
                sb.append("where link.child.id = :id");
                param.addId(childID);
                if (userID >= 0L) {
                    sb.append(" and link.details.owner.id = :userID");
                    param.map.put("userID", rtypes.rlong((long)userID));
                }
            } else if (userID >= 0L) {
                sb.append("where link.details.owner.id = :userID");
                param.map.put("userID", rtypes.rlong((long)userID));
            }
            return service.findAllByQuery(sb.toString(), (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for child ID: " + childID);
            return new ArrayList();
        }
    }

    private SharedResourcesPrx getSharedResources(SecurityContext ctx) throws DSAccessException, DSOutOfServiceException {
        return this.gw.getSharedResources(ctx);
    }

    private IRenderingSettingsPrx getRenderingSettingsService(SecurityContext ctx) throws DSAccessException, DSOutOfServiceException {
        return this.gw.getRenderingSettingsService(ctx);
    }

    private OMEROMetadataStoreClient getImportStore(SecurityContext ctx, String userName) throws DSAccessException, DSOutOfServiceException {
        return this.gw.getImportStore(ctx, userName);
    }

    private IScriptPrx getScriptService(SecurityContext ctx) throws DSAccessException, DSOutOfServiceException {
        return this.gw.getScriptService(ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void needDefault(long pixelsID, Object prx) throws DSAccessException, DSOutOfServiceException {
        try {
            RenderingEnginePrx re;
            if (prx instanceof ThumbnailStorePrx) {
                ThumbnailStorePrx service = (ThumbnailStorePrx)prx;
                if (service.setPixelsId(pixelsID)) return;
            }
            if (!(prx instanceof RenderingEnginePrx) || (re = (RenderingEnginePrx)prx).lookupRenderingDef(pixelsID)) return;
            re.resetDefaultSettings(true);
            re.lookupRenderingDef(pixelsID);
            return;
        }
        catch (Throwable e) {
            this.handleConnectionException(e);
            this.handleException(e, "Cannot set the rendering defaults.");
        }
    }

    private List<String> prepareTextSearch(String[] terms, SearchPrx service) throws DSAccessException, DSOutOfServiceException {
        if (terms == null || terms.length == 0) {
            return null;
        }
        ArrayList<String> formattedTerms = new ArrayList<String>(terms.length);
        try {
            for (int j = 0; j < terms.length; ++j) {
                String value = terms[j];
                if (this.startWithWildCard(value)) {
                    service.setAllowLeadingWildcard(true);
                }
                int n = value.length();
                char[] arr = new char[n];
                Object v = "";
                value.getChars(0, n, arr, 0);
                for (int i = 0; i < arr.length; ++i) {
                    v = SUPPORTED_SPECIAL_CHAR.contains(Character.valueOf(arr[i])) ? (String)v + "\\" + arr[i] : (String)v + arr[i];
                }
                Object formatted = value.contains(" ") ? "\"" + ((String)v).toLowerCase() + "\"" : ((String)v).toLowerCase();
                formattedTerms.add((String)formatted);
            }
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot format text for search.");
        }
        return formattedTerms;
    }

    private List<String> prepareTextSearch(Collection<String> terms, SearchPrx service) throws DSAccessException, DSOutOfServiceException {
        if (CollectionUtils.isEmpty(terms)) {
            return null;
        }
        String[] values = new String[terms.size()];
        Iterator<String> i = terms.iterator();
        int index = 0;
        while (i.hasNext()) {
            values[index] = i.next();
            ++index;
        }
        return this.prepareTextSearch(values, service);
    }

    private boolean startWithWildCard(String value) {
        if (CommonsLangUtils.isBlank(value)) {
            return false;
        }
        Iterator<String> i = WILD_CARDS.iterator();
        String card = null;
        while (i.hasNext()) {
            card = i.next();
            if (!value.startsWith(card)) continue;
            return true;
        }
        return false;
    }

    private String convertAnnotation(Class pojo) {
        if (TextualAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.CommentAnnotation";
        }
        if (TagAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.TagAnnotation";
        }
        if (RatingAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.LongAnnotation";
        }
        if (LongAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.LongAnnotation";
        }
        if (FileAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.FileAnnotation";
        }
        if (TermAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.UriAnnotation";
        }
        if (TimeAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.TimeAnnotation";
        }
        if (BooleanAnnotationData.class.equals((Object)pojo)) {
            return "ome.model.annotations.BooleanAnnotation";
        }
        return null;
    }

    OMEROGateway(DataServicesFactory dsFactory) {
        if (dsFactory == null) {
            throw new IllegalArgumentException("No Data service factory.");
        }
        this.dsFactory = dsFactory;
        this.enumerations = new HashMap<String, List<EnumerationObject>>();
        this.gw = new Gateway(dsFactory.getLogger());
    }

    public Gateway getGateway() {
        return this.gw;
    }

    String createDeleteCommand(String data) {
        if (ImageData.class.getName().equals(data)) {
            return REF_IMAGE;
        }
        if (DatasetData.class.getName().equals(data)) {
            return REF_DATASET;
        }
        if (ProjectData.class.getName().equals(data)) {
            return REF_PROJECT;
        }
        if (ScreenData.class.getName().equals(data)) {
            return REF_SCREEN;
        }
        if (PlateData.class.getName().equals(data)) {
            return REF_PLATE;
        }
        if (ROIData.class.getName().equals(data)) {
            return REF_ROI;
        }
        if (PlateAcquisitionData.class.getName().equals(data)) {
            return REF_PLATE_ACQUISITION;
        }
        if (FilesetData.class.getName().equals(data)) {
            return REF_FILESET;
        }
        if (WellData.class.getName().equals(data)) {
            return REF_WELL;
        }
        if (PlateAcquisitionData.class.getName().equals(data)) {
            return REF_PLATE_ACQUISITION;
        }
        if (TagAnnotationData.class.getName().equals(data) || TermAnnotationData.class.getName().equals(data) || FileAnnotationData.class.getName().equals(data) || TextualAnnotationData.class.getName().equals(data) || MapAnnotationData.class.getName().equals(data)) {
            return REF_ANNOTATION;
        }
        throw new IllegalArgumentException("Cannot delete the speficied type.");
    }

    String createDeleteOption(String data) {
        if (TagAnnotationData.class.getName().equals(data)) {
            return REF_TAG;
        }
        if (TermAnnotationData.class.getName().equals(data)) {
            return REF_TERM;
        }
        if (FileAnnotationData.class.getName().equals(data)) {
            return REF_FILE;
        }
        throw new IllegalArgumentException("Cannot delete the speficied type.");
    }

    boolean isConnected() {
        return this.gw.isConnected();
    }

    ExperimenterData getUserDetails(SecurityContext ctx, String name, boolean connectionError) throws DSOutOfServiceException, DSAccessException {
        try {
            IAdminPrx service = this.gw.getAdminService(ctx);
            return (ExperimenterData)PojoMapper.asDataObject((IObject)service.lookupExperimenter(name));
        }
        catch (Exception e) {
            if (connectionError) {
                this.handleConnectionException(e);
            }
            throw new DSOutOfServiceException("Cannot retrieve user's data " + this.printErrorText(e), e);
        }
    }

    ExperimenterData connect(UserCredentials c) throws DSOutOfServiceException {
        return this.gw.connect(c);
    }

    String getSessionId(ExperimenterData user) {
        try {
            return this.gw.getSessionId(user);
        }
        catch (DSOutOfServiceException e) {
            this.dsFactory.getLogger().warn((Object)this, "Cannot get session ID.");
            return null;
        }
    }

    Map<String, String> getOmeroClientProperties(long groupId) throws DSOutOfServiceException, DSAccessException {
        if (this.isConnected()) {
            try {
                return this.gw.getConfigService(new SecurityContext(groupId)).getClientConfigValues();
            }
            catch (Exception e) {
                this.handleException(e, "Cannot access config service. ");
            }
        }
        return null;
    }

    Map<String, String> getServerProperties(long groupId) throws DSOutOfServiceException, DSAccessException {
        if (this.isConnected()) {
            try {
                String regex = "^omero\\.cluster";
                return this.gw.getConfigService(new SecurityContext(groupId)).getConfigValues(regex);
            }
            catch (Exception e) {
                this.handleException(e, "Cannot access config service. ");
            }
        }
        return null;
    }

    FSFileSystemView getFSRepositories(SecurityContext ctx, long userID) throws DSOutOfServiceException, DSAccessException {
        if (this.fsViews == null) {
            this.fsViews = new HashMap<Long, FSFileSystemView>();
        }
        if (this.fsViews.containsKey(userID)) {
            return this.fsViews.get(userID);
        }
        FSFileSystemView view = null;
        try {
            RepositoryMap m = this.getSharedResources(ctx).repositories();
            List proxys = m.proxies;
            List names = m.descriptions;
            Iterator i = names.iterator();
            int index = 0;
            HashMap<FileData, RepositoryPrx> repositories = new HashMap<FileData, RepositoryPrx>();
            while (i.hasNext()) {
                FileData f = new FileData((OriginalFile)i.next(), true);
                if (!f.getName().contains("Tmp")) {
                    RepositoryPrx proxy = (RepositoryPrx)proxys.get(index);
                    repositories.put(f, proxy);
                }
                ++index;
            }
            view = new FSFileSystemView(userID, repositories);
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot load the repositories");
        }
        if (view != null) {
            this.fsViews.put(userID, view);
        }
        return view;
    }

    void changeCurrentGroup(SecurityContext ctx, ExperimenterData exp, long groupID) throws DSOutOfServiceException, DSAccessException {
        List<GroupData> groups = exp.getGroups();
        Iterator<GroupData> i = groups.iterator();
        GroupData group = null;
        boolean in = false;
        while (i.hasNext()) {
            group = i.next();
            if (group.getId() != groupID) continue;
            in = true;
            break;
        }
        if (in) {
            try {
                IAdminPrx svc = this.gw.getAdminService(ctx);
                svc.setDefaultGroup(exp.asExperimenter(), (ExperimenterGroup)new ExperimenterGroupI(groupID, false));
            }
            catch (Exception e) {
                this.handleException(e, "Can't modify the current group for user:" + exp.getId());
            }
        }
        String s = "Can't modify the current group.\n\n";
        if (!in) {
            throw new DSOutOfServiceException(s);
        }
    }

    String getServerVersion() throws DSOutOfServiceException {
        try {
            return this.gw.getServerVersion();
        }
        catch (Exception e) {
            this.handleConnectionException(e);
            Object s = "Can't retrieve the server version.\n\n";
            s = (String)s + this.printErrorText(e);
            throw new DSOutOfServiceException((String)s, e);
        }
    }

    String lookupLdapAuthExperimenter(SecurityContext ctx, long userID) throws DSOutOfServiceException {
        try {
            IAdminPrx svc = this.gw.getAdminService(ctx);
            return svc.lookupLdapAuthExperimenter(userID);
        }
        catch (Throwable e) {
            this.handleConnectionException(e);
            Object s = "Can't find the LDAP information.\n\n";
            s = (String)s + this.printErrorText(e);
            throw new DSOutOfServiceException((String)s, e);
        }
    }

    Map<SecurityContext, Set<Long>> getRenderingEngines() {
        return this.renderingEngines;
    }

    void logout() {
        this.gw.disconnect();
    }

    Collection<DataObject> loadContainerHierarchy(SecurityContext ctx, Class rootType, List rootIDs, Parameters options) throws DSOutOfServiceException, DSAccessException {
        try {
            BrowseFacility f = this.gw.getFacility(BrowseFacility.class);
            return f.getHierarchy(ctx, rootType, rootIDs, options);
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot load hierarchy for " + rootType + ".");
            return new HashSet<DataObject>();
        }
    }

    Collection<DataObject> findContainerHierarchy(SecurityContext ctx, Class rootNodeType, List leavesIDs, Parameters options) throws DSOutOfServiceException, DSAccessException {
        try {
            IContainerPrx service = this.gw.getPojosService(ctx);
            return PojoMapper.convertToDataObjects(service.findContainerHierarchies(PojoMapper.getModelType(rootNodeType).getName(), leavesIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find hierarchy for " + rootNodeType + ".");
            return new HashSet<DataObject>();
        }
    }

    Map loadAnnotations(SecurityContext ctx, Class nodeType, List nodeIDs, List<Class> annotationTypes, List annotatorIDs, Parameters options) throws DSOutOfServiceException, DSAccessException {
        ArrayList<String> types = new ArrayList<String>();
        if (annotationTypes != null && annotationTypes.size() > 0) {
            types = new ArrayList(annotationTypes.size());
            Iterator<Class> i = annotationTypes.iterator();
            while (i.hasNext()) {
                String k = this.convertAnnotation(i.next());
                if (k == null) continue;
                types.add(k);
            }
        }
        try {
            IMetadataPrx service = this.gw.getMetadataService(ctx);
            return PojoMapper.asDataObjects(service.loadAnnotations(PojoMapper.getModelType(nodeType).getName(), nodeIDs, types, annotatorIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find annotations for " + nodeType + ".");
            return new HashMap();
        }
    }

    Collection<DataObject> loadAnnotation(SecurityContext ctx, List<Long> annotationIds) throws DSOutOfServiceException, DSAccessException {
        if (annotationIds == null || annotationIds.size() == 0) {
            return new HashSet<DataObject>();
        }
        try {
            IMetadataPrx service = this.gw.getMetadataService(ctx);
            return PojoMapper.convertToDataObjects(service.loadAnnotation(annotationIds));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find the annotations.");
            return new HashSet<DataObject>();
        }
    }

    Collection findAllAnnotations(SecurityContext ctx, Class type, long userID) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            String table = this.getAnnotationTableLink(type);
            if (table == null) {
                return null;
            }
            String sql = "select link from " + table + " as link";
            sql = sql + " left outer join link.child as child";
            ParametersI p = new ParametersI();
            p.map = new HashMap();
            p.map.put("uid", rtypes.rlong((long)userID));
            sql = sql + " where link.details.owner.id = :uid";
            return service.findAllByQuery(sql, (Parameters)p);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for userID: " + userID);
            return new ArrayList();
        }
    }

    Collection<ImageData> getContainerImages(SecurityContext ctx, Class nodeType, List nodeIDs, Parameters options) throws DSOutOfServiceException, DSAccessException {
        try {
            IContainerPrx service = this.gw.getPojosService(ctx);
            return PojoMapper.convertToDataObjects(service.getImages(PojoMapper.getModelType(nodeType).getName(), nodeIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find images for " + nodeType + ".");
            return new HashSet<ImageData>();
        }
    }

    Collection<ImageData> getUserImages(SecurityContext ctx, long userID, boolean orphan) throws DSOutOfServiceException, DSAccessException {
        try {
            BrowseFacility browse = this.gw.getFacility(BrowseFacility.class);
            if (!orphan) {
                return browse.getUserImages(ctx);
            }
            return browse.getOrphanedImages(ctx, userID);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find user images.");
            return new HashSet<ImageData>();
        }
    }

    Map getCollectionCount(SecurityContext ctx, Class rootNodeType, String property, List ids, Parameters options) throws DSOutOfServiceException, DSAccessException {
        try {
            IMetadataPrx service = this.gw.getMetadataService(ctx);
            IContainerPrx svc = this.gw.getPojosService(ctx);
            if (TagAnnotationData.class.equals((Object)rootNodeType)) {
                return service.getTaggedObjectsCount(ids, options);
            }
            String p = this.convertProperty(rootNodeType, property);
            if (p == null) {
                return null;
            }
            return PojoMapper.asDataObjects(svc.getCollectionCount(PojoMapper.getModelType(rootNodeType).getName(), p, ids, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot count the collection.");
            return new HashMap();
        }
    }

    IObject createObject(SecurityContext ctx, IObject object) throws DSOutOfServiceException, DSAccessException {
        return this.createObject(ctx, object, null);
    }

    IObject createObject(SecurityContext ctx, IObject object, String userName) throws DSOutOfServiceException, DSAccessException {
        try {
            return this.saveAndReturnObject(ctx, object, null, userName);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return null;
        }
    }

    List<IObject> createObjects(SecurityContext ctx, List<IObject> objects) throws DSOutOfServiceException, DSAccessException {
        return this.createObjects(ctx, objects, null);
    }

    List<IObject> createObjects(SecurityContext ctx, List<IObject> objects, String userName) throws DSOutOfServiceException, DSAccessException {
        try {
            return this.saveAndReturnObject(ctx, objects, null, userName);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot create the objects.");
            return new ArrayList<IObject>();
        }
    }

    void deleteObject(SecurityContext ctx, IObject object) throws DSOutOfServiceException, DSAccessException {
        this.deleteObjects(ctx, Collections.singletonList(object));
    }

    void deleteObjects(SecurityContext ctx, List<IObject> objects) throws DSOutOfServiceException, DSAccessException {
        try {
            DataManagerFacility dmf = this.gw.getFacility(DataManagerFacility.class);
            CmdCallbackI cb = dmf.delete(ctx, objects);
            Response res = cb.loop(100, 250L);
            if (res instanceof GraphException) {
                GraphException ge = (GraphException)res;
                throw new Exception("Cannot delete the object: " + ge.message);
            }
            if (res instanceof ERR) {
                throw new Exception("Cannot delete the object.");
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot delete the object.");
        }
    }

    IObject saveAndReturnObject(SecurityContext ctx, IObject object, Map options) throws DSOutOfServiceException, DSAccessException {
        try {
            IUpdatePrx service = this.gw.getUpdateService(ctx);
            if (options == null) {
                return service.saveAndReturnObject(object);
            }
            return service.saveAndReturnObject(object, options);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return null;
        }
    }

    IObject saveAndReturnObject(SecurityContext ctx, IObject object, Map options, String userName) throws DSOutOfServiceException, DSAccessException {
        try {
            IUpdatePrx service = this.gw.getUpdateService(ctx, userName);
            if (options == null) {
                return service.saveAndReturnObject(object);
            }
            return service.saveAndReturnObject(object, options);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return null;
        }
    }

    List<IObject> saveAndReturnObject(SecurityContext ctx, List<IObject> objects, Map options, String userName) throws DSOutOfServiceException, DSAccessException {
        try {
            IUpdatePrx service = this.gw.getUpdateService(ctx, userName);
            return service.saveAndReturnArray(objects);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return new ArrayList<IObject>();
        }
    }

    IObject updateObject(SecurityContext ctx, IObject object, Parameters options) throws DSOutOfServiceException, DSAccessException {
        try {
            IContainerPrx service = this.gw.getPojosService(ctx);
            IObject r = service.updateDataObject(object, options);
            return this.findIObject(ctx, r);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return null;
        }
    }

    List<IObject> updateObjects(SecurityContext ctx, List<IObject> objects, Parameters options) throws DSOutOfServiceException, DSAccessException {
        try {
            IContainerPrx service = this.gw.getPojosService(ctx);
            List l = service.updateDataObjects(objects, options);
            if (l == null) {
                return l;
            }
            Iterator i = l.iterator();
            ArrayList<IObject> r = new ArrayList<IObject>(l.size());
            while (i.hasNext()) {
                IObject io = this.findIObject(ctx, (IObject)i.next());
                if (io == null) continue;
                r.add(io);
            }
            return r;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return new ArrayList<IObject>();
        }
    }

    Pixels getPixels(SecurityContext ctx, long pixelsID) throws DSOutOfServiceException, DSAccessException {
        try {
            IPixelsPrx service = this.gw.getPixelsService(ctx);
            return service.retrievePixDescription(pixelsID);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the pixels set for " + pixelsID);
            return null;
        }
    }

    byte[] getThumbnail(SecurityContext ctx, long pixelsID, int sizeX, int sizeY, long userID) throws RenderingServiceException, DSOutOfServiceException {
        return this.retrieveThumbnail(ctx, pixelsID, sizeX, sizeY, userID);
    }

    private byte[] retrieveThumbnail(SecurityContext ctx, long pixelsID, int sizeX, int sizeY, long userID) throws RenderingServiceException, DSOutOfServiceException {
        ThumbnailStorePrx service = null;
        try {
            Object def;
            service = this.gw.getThumbnailService(ctx);
            this.needDefault(pixelsID, service);
            if (userID >= 0L && (def = this.getRenderingDef(ctx, pixelsID, userID)) != null) {
                service.setRenderingDefId(def.getId().getValue());
            }
            def = service.getThumbnail(rtypes.rint((int)sizeX), rtypes.rint((int)sizeY));
            return def;
        }
        catch (Throwable t) {
            this.handleConnectionException(t);
            if (t instanceof ServerError) {
                throw new DSOutOfServiceException("Thumbnail service null for pixelsID: " + pixelsID, t);
            }
            throw new RenderingServiceException("Cannot get thumbnail", t);
        }
        finally {
            if (service != null) {
                this.gw.closeService(ctx, (StatefulServiceInterfacePrx)service);
            }
        }
    }

    byte[] getThumbnailByLongestSide(SecurityContext ctx, long pixelsID, int maxLength) throws RenderingServiceException, DSOutOfServiceException {
        return this.retrieveThumbnailByLongestSide(ctx, pixelsID, maxLength);
    }

    private byte[] retrieveThumbnailByLongestSide(SecurityContext ctx, long pixelsID, int maxLength) throws RenderingServiceException, DSOutOfServiceException {
        ThumbnailStorePrx service = null;
        try {
            service = this.gw.getThumbnailService(ctx);
            byte[] byArray = service.getThumbnailByLongestSide(rtypes.rint((int)maxLength));
            return byArray;
        }
        catch (Throwable t) {
            this.handleConnectionException(t);
            if (t instanceof ServerError) {
                throw new DSOutOfServiceException("Thumbnail service null for pixelsID: " + pixelsID, t);
            }
            throw new RenderingServiceException("Cannot get thumbnail", t);
        }
        finally {
            if (service != null) {
                this.gw.closeService(ctx, (StatefulServiceInterfacePrx)service);
            }
        }
    }

    Map getThumbnailSet(SecurityContext ctx, List<Long> pixelsID, int maxLength, boolean reset) throws RenderingServiceException, DSOutOfServiceException {
        return this.retrieveThumbnailSet(ctx, pixelsID, maxLength, reset);
    }

    private Map retrieveThumbnailSet(SecurityContext ctx, List<Long> pixelsID, int maxLength, boolean reset) throws RenderingServiceException, DSOutOfServiceException {
        ThumbnailStorePrx service = null;
        try {
            service = this.gw.getThumbnailService(ctx);
            Map map = service.getThumbnailByLongestSideSet(rtypes.rint((int)maxLength), pixelsID);
            return map;
        }
        catch (Throwable t) {
            this.handleConnectionException(t);
            if (t instanceof ServerError) {
                throw new DSOutOfServiceException("Thumbnail service null for pixelsID: " + pixelsID, t);
            }
            throw new RenderingServiceException("Cannot get thumbnail", t);
        }
        finally {
            this.gw.closeService(ctx, (StatefulServiceInterfacePrx)service);
        }
    }

    RenderingEnginePrx createRenderingEngine(SecurityContext ctx, long pixelsID) throws DSOutOfServiceException, DSAccessException, FSAccessException {
        return this.generateRenderingEngine(ctx, pixelsID);
    }

    private RenderingEnginePrx generateRenderingEngine(SecurityContext ctx, long pixelsID) throws DSOutOfServiceException, DSAccessException, FSAccessException {
        RenderingEnginePrx service = null;
        try {
            service = this.gw.getRenderingService(ctx, pixelsID);
            service.lookupPixels(pixelsID);
            this.needDefault(pixelsID, service);
            service.load();
            Set<Long> pixIds = this.renderingEngines.get(ctx);
            if (pixIds == null) {
                pixIds = new HashSet<Long>();
                this.renderingEngines.put(ctx, pixIds);
            }
            pixIds.add(pixelsID);
            return service;
        }
        catch (Throwable t) {
            this.log(t.getMessage());
            this.gw.closeService(ctx, (StatefulServiceInterfacePrx)service);
            String s = "Cannot start the Rendering Engine.";
            this.handleFSException(t, s);
            this.handleException(t, s);
            return null;
        }
    }

    IObject findAnnotationLink(SecurityContext ctx, Class type, long parentID, long childID, long userID) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            String table = this.getAnnotationTableLink(type);
            if (table == null) {
                return null;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("select link from " + table + " as link ");
            buffer.append("left outer join fetch link.details.owner ");
            buffer.append("where link.parent.id = :parentID");
            ParametersI p = new ParametersI();
            p.map = new HashMap();
            p.map.put("parentID", rtypes.rlong((long)parentID));
            if (userID >= 0L) {
                buffer.append(" and link.details.owner.id = :userID");
                p.map.put("userID", rtypes.rlong((long)userID));
            }
            if (childID >= 0L) {
                buffer.append(" and link.child.id = :childID");
                p.map.put("childID", rtypes.rlong((long)childID));
            }
            return service.findByQuery(buffer.toString(), (Parameters)p);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for parent ID: " + parentID + " and child ID: " + childID);
            return null;
        }
    }

    List findAnnotationLinks(SecurityContext ctx, Class parentType, long parentID, List<Long> children) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            String table = this.getAnnotationTableLink(parentType);
            if (table == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("select link from " + table + " as link");
            sb.append(" left outer join fetch link.details.owner as owner");
            sb.append(" left outer join fetch link.child as child");
            sb.append(" left outer join fetch link.parent as parent");
            ParametersI p = new ParametersI();
            if (parentID > 0L) {
                sb.append(" where link.parent.id = :parentID");
                if (children != null && children.size() > 0) {
                    sb.append(" and link.child.id in (:childIDs)");
                    p.addLongs("childIDs", children);
                }
                p.map.put("parentID", rtypes.rlong((long)parentID));
            } else if (children != null && children.size() > 0) {
                sb.append(" where link.child.id in (:childIDs)");
                p.addLongs("childIDs", children);
            }
            return service.findAllByQuery(sb.toString(), (Parameters)p);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the annotation links for parent ID: " + parentID);
            return new ArrayList();
        }
    }

    IObject findLink(SecurityContext ctx, IObject parent, IObject child) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            String table = this.getTableForLink(parent.getClass());
            if (table == null) {
                return null;
            }
            String sql = "select link from " + table + " as link where link.parent.id = :parentID and link.child.id = :childID";
            ParametersI param = new ParametersI();
            param.map = new HashMap();
            param.map.put("parentID", parent.getId());
            param.map.put("childID", child.getId());
            return service.findByQuery(sql, (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for parent ID: " + parent.getId() + " and child ID: " + child.getId());
            return null;
        }
    }

    List findLinks(SecurityContext ctx, IObject parent, List children) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            String table = this.getTableForLink(parent.getClass());
            if (table == null) {
                return null;
            }
            ParametersI param = new ParametersI();
            param.map.put("parentID", parent.getId());
            String sql = "select link from " + table + " as link where link.parent.id = :parentID";
            if (children != null && children.size() > 0) {
                sql = sql + " and link.child.id in (:childIDs)";
                param.addLongs("childIDs", (Collection)children);
            }
            return service.findAllByQuery(sql, (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for parent ID: " + parent.getId());
            return new ArrayList();
        }
    }

    List findLinks(SecurityContext ctx, Class parentClass, List children, long userID) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            String table = this.getTableForLink(parentClass);
            if (table == null) {
                return null;
            }
            String sql = "select link from " + table + " as link where link.child.id in (:childIDs)";
            ParametersI param = new ParametersI();
            param.addLongs("childIDs", (Collection)children);
            if (userID >= 0L) {
                sql = sql + " and link.details.owner.id = :userID";
                param.map.put("userID", rtypes.rlong((long)userID));
            }
            return service.findAllByQuery(sql, (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for the specified children");
            return new ArrayList();
        }
    }

    List findDatasetLinks(SecurityContext ctx, List children, long userID) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            Object sql = "SELECT link FROM DatasetImageLink AS link LEFT JOIN FETCH link.parent dataset WHERE link.child.id IN (:childIDs)";
            ParametersI param = new ParametersI();
            param.addLongs("childIDs", (Collection)children);
            if (userID >= 0L) {
                sql = (String)sql + " and link.details.owner.id = :userID";
                param.map.put("userID", rtypes.rlong((long)userID));
            }
            return service.findAllByQuery((String)sql, (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested datasets for the specified children");
            return new ArrayList();
        }
    }

    List findAnnotationLinks(SecurityContext ctx, Class node, long nodeID, List children, long userID) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            String table = this.getAnnotationTableLink(node);
            if (table == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("select link from " + table + " as link ");
            sb.append("left outer join fetch link.child child ");
            sb.append("left outer join fetch link.parent parent ");
            sb.append("left outer join fetch parent.details.owner ");
            sb.append("left outer join fetch child.details.owner ");
            sb.append("left outer join fetch link.details.owner ");
            sb.append("where link.child.id in (:childIDs)");
            ParametersI param = new ParametersI();
            param.addLongs("childIDs", (Collection)children);
            if (nodeID > 0L) {
                sb.append(" and link.parent.id = :parentID");
                param.map.put("parentID", rtypes.rlong((long)nodeID));
            }
            if (userID >= 0L) {
                sb.append(" and link.details.owner.id = :userID");
                param.map.put("userID", rtypes.rlong((long)userID));
            }
            return service.findAllByQuery(sb.toString(), (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for the specified children");
            return new ArrayList();
        }
    }

    Multimap<Long, IObject> findAnnotationLinks(SecurityContext ctx, Class<?> node, List<Long> nodeIDs, List<Long> children, long userID) throws DSOutOfServiceException, DSAccessException {
        ArrayListMultimap map = ArrayListMultimap.create();
        try {
            List list;
            IQueryPrx service = this.gw.getQueryService(ctx);
            String table = this.getAnnotationTableLink(node);
            if (table == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("select link from " + table + " as link ");
            sb.append("left outer join fetch link.child child ");
            sb.append("left outer join fetch link.parent parent ");
            sb.append("left outer join fetch parent.details.owner ");
            sb.append("left outer join fetch child.details.owner ");
            sb.append("left outer join fetch link.details.owner ");
            sb.append("where link.child.id in (:childIDs)");
            ParametersI param = new ParametersI();
            param.addLongs("childIDs", children);
            sb.append(" and link.parent.id in (:parentIDs)");
            param.addLongs("parentIDs", nodeIDs);
            if (userID >= 0L) {
                sb.append(" and link.details.owner.id = :userID");
                param.map.put("userID", rtypes.rlong((long)userID));
            }
            if (CollectionUtils.isNotEmpty((Collection)(list = service.findAllByQuery(sb.toString(), (Parameters)param)))) {
                for (IObject link : list) {
                    IObject p = ModelMapper.getParentFromLink(link);
                    map.put((Object)p.getId().getValue(), (Object)link);
                }
            }
            return map;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for the specified children");
            return map;
        }
    }

    List findLinks(SecurityContext ctx, Class parentClass, long childID, long userID) throws DSOutOfServiceException, DSAccessException {
        if (FileAnnotation.class.equals((Object)parentClass)) {
            ArrayList results = new ArrayList();
            results.addAll(this.loadLinks(ctx, "ProjectAnnotationLink", childID, userID));
            results.addAll(this.loadLinks(ctx, "DatasetAnnotationLink", childID, userID));
            results.addAll(this.loadLinks(ctx, "ImageAnnotationLink", childID, userID));
            results.addAll(this.loadLinks(ctx, "ScreenAnnotationLink", childID, userID));
            results.addAll(this.loadLinks(ctx, "PlateAnnotationLink", childID, userID));
            results.addAll(this.loadLinks(ctx, "WellAnnotationLink", childID, userID));
            results.addAll(this.loadLinks(ctx, "PlateAcquisitionAnnotationLink", childID, userID));
            return results;
        }
        return this.loadLinks(ctx, this.getTableForLink(parentClass), childID, userID);
    }

    Set<DataObject> findPlateFromImage(SecurityContext ctx, long childID, long userID) throws DSOutOfServiceException, DSAccessException {
        HashSet<DataObject> data = new HashSet<DataObject>();
        ArrayList<Long> ids = new ArrayList<Long>();
        ParametersI param = new ParametersI();
        param.addLong("imageID", childID);
        StringBuilder sb = new StringBuilder();
        sb.append("select well from Well as well ");
        sb.append("left outer join fetch well.plate as pt ");
        sb.append("left outer join fetch well.wellSamples as ws ");
        sb.append("left outer join fetch ws.image as img ");
        sb.append("where img.id = :imageID");
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            List results = service.findAllByQuery(sb.toString(), (Parameters)param);
            for (Well well : results) {
                Plate plate = well.getPlate();
                long id = plate.getId().getValue();
                if (ids.contains(id)) continue;
                data.add(PojoMapper.asDataObject((IObject)plate));
                ids.add(id);
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find the plates containing the image.");
        }
        return data;
    }

    Set<DataObject> findPlateFromRun(SecurityContext ctx, long childID, long userID) throws DSOutOfServiceException, DSAccessException {
        HashSet<DataObject> data = new HashSet<DataObject>();
        ArrayList<Long> ids = new ArrayList<Long>();
        ParametersI param = new ParametersI();
        param.addLong("acqId", childID);
        StringBuilder sb = new StringBuilder();
        sb.append("select plate from Plate as plate where plate.id = (select acq.plate from PlateAcquisition acq where acq.id = :acqId)");
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            List results = service.findAllByQuery(sb.toString(), (Parameters)param);
            for (Plate plate : results) {
                long id = plate.getId().getValue();
                if (ids.contains(id)) continue;
                data.add(PojoMapper.asDataObject((IObject)plate));
                ids.add(id);
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find the plates containing the image.");
        }
        return data;
    }

    IObject findIObject(SecurityContext ctx, IObject o) throws DSOutOfServiceException, DSAccessException {
        try {
            BrowseFacility browse = this.gw.getFacility(BrowseFacility.class);
            return browse.findIObject(ctx, o);
        }
        catch (ExecutionException e) {
            this.log("Can't get a BrowseFacility");
            return null;
        }
    }

    IObject findIObjectByName(SecurityContext ctx, Class dataObject, String name, long ownerID) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            ParametersI param = new ParametersI();
            param.map.put("name", rtypes.rstring((String)name));
            param.map.put("ownerID", rtypes.rlong((long)ownerID));
            String table = this.getTableForClass(dataObject);
            String sql = "select o from " + table + " as o";
            sql = sql + " where o.name = :name";
            sql = sql + " and o.details.owner.id = :ownerID";
            return service.findByQuery(sql, (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested object.");
            return null;
        }
    }

    IObject findIObject(SecurityContext ctx, String klassName, long id) throws DSOutOfServiceException, DSAccessException {
        return this.findIObject(ctx, klassName, id, false);
    }

    IObject findIObjectByQuery(SecurityContext ctx, String query, boolean allGroups) throws DSOutOfServiceException, DSAccessException {
        try {
            HashMap<String, Object> m = new HashMap<String, Object>();
            if (allGroups) {
                m.put("omero.group", "-1");
            } else {
                m.put("omero.group", "" + ctx.getGroupID());
            }
            IQueryPrx service = this.gw.getQueryService(ctx);
            return service.findByQuery(query, null, m);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested object with query: " + query);
            return null;
        }
    }

    IObject findIObject(SecurityContext ctx, String klassName, long id, boolean allGroups) throws DSOutOfServiceException, DSAccessException {
        try {
            BrowseFacility browse = this.gw.getFacility(BrowseFacility.class);
            return browse.findIObject(ctx, klassName, id, allGroups);
        }
        catch (ExecutionException e) {
            this.log("Can't get a BrowseFacility");
            return null;
        }
    }

    Set<GroupData> getAvailableGroups(SecurityContext ctx, ExperimenterData user) throws DSOutOfServiceException, DSAccessException {
        HashSet<GroupData> pojos = new HashSet<GroupData>();
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            ParametersI p = new ParametersI();
            p.addId(user.getId());
            List groups = service.findAllByQuery("select distinct g from ExperimenterGroup as g join fetch g.groupExperimenterMap as map join fetch map.parent e left outer join fetch map.child u left outer join fetch u.groupExperimenterMap m2 left outer join fetch m2.parent p where g.id in   (select m.parent from GroupExperimenterMap m   where m.child.id = :id )", (Parameters)p);
            for (ExperimenterGroup group : groups) {
                pojos.add((GroupData)PojoMapper.asDataObject((IObject)group));
            }
            return pojos;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the available groups ");
            return pojos;
        }
    }

    public List<File> getArchivedFiles(SecurityContext ctx, File dir, ImageData image) throws DSAccessException, DSOutOfServiceException {
        TransferFacility fc = null;
        try {
            fc = this.gw.getFacility(TransferFacility.class);
        }
        catch (ExecutionException e) {
            throw new DSOutOfServiceException(e.getMessage());
        }
        return fc.downloadImage(ctx, dir.getAbsolutePath(), image.getId());
    }

    File downloadFile(SecurityContext ctx, File file, long fileID) throws DSAccessException, DSOutOfServiceException {
        if (file == null) {
            return null;
        }
        return this.download(ctx, file, fileID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File download(SecurityContext ctx, File file, long fileID) throws DSAccessException, DSOutOfServiceException {
        if (file == null) {
            return null;
        }
        OriginalFile of = this.getOriginalFile(ctx, fileID);
        if (of == null) {
            return null;
        }
        String path = file.getAbsolutePath();
        RawFileStorePrx store = null;
        try {
            store = this.gw.getRawFileService(ctx);
            store.setFileId(fileID);
        }
        catch (Throwable e) {
            this.gw.closeService(ctx, (StatefulServiceInterfacePrx)store);
            this.handleException(e, "Cannot set the file's id.");
            return null;
        }
        try {
            long size = -1L;
            long offset = 0L;
            FileOutputStream stream = new FileOutputStream(file);
            try {
                try {
                    size = store.size();
                    offset = 0L;
                    while (offset + 262144L < size) {
                        stream.write(store.read(offset, 262144));
                        offset += 262144L;
                    }
                }
                finally {
                    stream.write(store.read(offset, (int)(size - offset)));
                    stream.close();
                }
            }
            catch (Exception e) {
                if (stream != null) {
                    stream.close();
                }
                if (file != null) {
                    file.delete();
                }
            }
        }
        catch (IOException e) {
            if (file != null) {
                file.delete();
            }
            throw new DSAccessException("Cannot create file  " + path, e);
        }
        finally {
            this.gw.closeService(ctx, (StatefulServiceInterfacePrx)store);
        }
        return file;
    }

    OriginalFile getOriginalFile(SecurityContext ctx, long id) throws DSAccessException, DSOutOfServiceException {
        OriginalFile of = null;
        try {
            IQueryPrx svc = this.gw.getQueryService(ctx);
            ParametersI param = new ParametersI();
            param.map.put("id", rtypes.rlong((long)id));
            of = (OriginalFile)svc.findByQuery("select p from OriginalFile as p where p.id = :id", (Parameters)param);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve original file");
        }
        return of;
    }

    List getOriginalFiles(SecurityContext ctx, long pixelsID) throws DSAccessException, DSOutOfServiceException {
        List files = null;
        try {
            IQueryPrx svc = this.gw.getQueryService(ctx);
            ParametersI param = new ParametersI();
            param.map.put("id", rtypes.rlong((long)pixelsID));
            files = svc.findAllByQuery("select ofile from OriginalFile as ofile left join ofile.pixelsFileMaps as pfm left join pfm.child as child where child.id = :id", (Parameters)param);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve original file");
        }
        return files;
    }

    OriginalFile uploadFile(SecurityContext ctx, File file, String mimeType, long originalFileID) throws DSAccessException, DSOutOfServiceException {
        return this.upload(ctx, file, mimeType, originalFileID);
    }

    private OriginalFile upload(SecurityContext ctx, File file, String mimeType, long originalFileID) throws DSAccessException, DSOutOfServiceException {
        if (file == null) {
            throw new IllegalArgumentException("No file to upload");
        }
        if (CommonsLangUtils.isBlank(mimeType)) {
            mimeType = DEFAULT_MIMETYPE;
        }
        boolean fileCreated = false;
        ChecksumAlgorithmI checksumAlgorithm = new ChecksumAlgorithmI();
        checksumAlgorithm.setValue(rtypes.rstring((String)"SHA1-160"));
        OriginalFile save = null;
        Long fileId = null;
        try {
            String path;
            String absolutePath;
            String name;
            OriginalFileI oFile;
            IUpdatePrx update = this.gw.getUpdateService(ctx, null);
            if (originalFileID <= 0L) {
                oFile = new OriginalFileI();
                name = file.getName();
                oFile.setName(rtypes.rstring((String)name));
                absolutePath = file.getAbsolutePath();
                path = absolutePath.substring(0, absolutePath.length() - name.length());
                oFile.setPath(rtypes.rstring((String)path));
                oFile.setSize(rtypes.rlong((long)file.length()));
                oFile.setMimetype(rtypes.rstring((String)mimeType));
                oFile.setHasher((ChecksumAlgorithm)checksumAlgorithm);
                save = (OriginalFile)update.saveAndReturnObject((IObject)oFile);
                fileId = save.getId().getValue();
                fileCreated = true;
            } else {
                oFile = (OriginalFile)this.findIObject(ctx, OriginalFile.class.getName(), originalFileID);
                if (oFile == null) {
                    oFile = new OriginalFileI();
                    name = file.getName();
                    oFile.setName(rtypes.rstring((String)name));
                    absolutePath = file.getAbsolutePath();
                    path = absolutePath.substring(0, absolutePath.length() - name.length());
                    oFile.setPath(rtypes.rstring((String)path));
                    oFile.setSize(rtypes.rlong((long)file.length()));
                    oFile.setMimetype(rtypes.rstring((String)mimeType));
                    oFile.setHasher((ChecksumAlgorithm)checksumAlgorithm);
                    save = (OriginalFile)update.saveAndReturnObject((IObject)oFile);
                    fileId = save.getId().getValue();
                    fileCreated = true;
                } else {
                    OriginalFileI newFile = new OriginalFileI();
                    newFile.setId(rtypes.rlong((long)originalFileID));
                    newFile.setName(rtypes.rstring((String)file.getName()));
                    newFile.setPath(rtypes.rstring((String)file.getAbsolutePath()));
                    newFile.setSize(rtypes.rlong((long)file.length()));
                    ChecksumAlgorithm oldHasher = oFile.getHasher();
                    if (oldHasher == null) {
                        oldHasher = checksumAlgorithm;
                    }
                    newFile.setHasher(oldHasher);
                    newFile.setMimetype(oFile.getMimetype());
                    save = (OriginalFile)update.saveAndReturnObject((IObject)newFile);
                    fileId = save.getId().getValue();
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot set the file's id.");
        }
        byte[] buf = new byte[262144];
        FileInputStream stream = null;
        ChecksumProvider hasher = checksumProviderFactory.getProvider(ChecksumType.SHA1);
        RawFileStorePrx store = null;
        try {
            int rlen;
            store = this.gw.getRawFileService(ctx);
            store.setFileId(fileId.longValue());
            stream = new FileInputStream(file);
            long pos = 0L;
            while ((rlen = stream.read(buf)) > 0) {
                store.write(buf, pos, rlen);
                pos += (long)rlen;
                ByteBuffer bbuf = ByteBuffer.wrap(buf);
                ((Buffer)bbuf).limit(rlen);
                hasher.putBytes(bbuf);
            }
            stream.close();
            OriginalFile f = store.save();
            if (f != null) {
                String serverHash;
                save = f;
                String clientHash = hasher.checksumAsString();
                if (!clientHash.equals(serverHash = save.getHash().getValue())) {
                    throw new ImportException("file checksum mismatch on upload: " + file + " (client has " + clientHash + ", server has " + serverHash + ")");
                }
            }
        }
        catch (Exception e) {
            try {
                if (fileCreated) {
                    this.deleteObject(ctx, (IObject)save);
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception ex) {
                this.log("Exception on upload cleanup: " + e);
            }
            this.handleConnectionException(e);
            throw new DSAccessException("Cannot upload the file with path " + file.getAbsolutePath(), e);
        }
        finally {
            if (store != null) {
                this.gw.closeService(ctx, (StatefulServiceInterfacePrx)store);
            }
        }
        return save;
    }

    void changePassword(SecurityContext ctx, String password, String oldPassword) throws DSOutOfServiceException, DSAccessException {
        try {
            IAdminPrx service = this.gw.getAdminService(ctx, true);
            service.changePasswordWithOldPassword(rtypes.rstring((String)oldPassword), rtypes.rstring((String)password));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot modify password. ");
        }
    }

    void updateExperimenter(SecurityContext ctx, Experimenter exp, long currentUserID) throws DSOutOfServiceException, DSAccessException {
        if (exp == null) {
            return;
        }
        try {
            IAdminPrx svc = this.gw.getAdminService(ctx);
            if (exp.getId().getValue() == currentUserID) {
                svc.updateSelf(exp);
            } else {
                svc.updateExperimenter(exp);
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the user. ");
        }
    }

    RequestCallback updateGroupPermissions(SecurityContext ctx, GroupData group, int permissions) throws DSOutOfServiceException, DSAccessException {
        if (group.getPermissions().getPermissionsLevel() != permissions && permissions >= 0) {
            try {
                String r = "rw----";
                switch (permissions) {
                    case 1: {
                        r = "rwr---";
                        break;
                    }
                    case 2: {
                        r = "rwra--";
                        break;
                    }
                    case 3: {
                        r = "rwrw--";
                        break;
                    }
                    case 4: {
                        r = "rwrwr-";
                    }
                }
                Chmod2 chmod = (Chmod2)((Requests.Chmod2Builder)Requests.chmod().target(new IObject[]{group.asGroup()})).toPerms(r).build();
                ArrayList<Request> l = new ArrayList<Request>();
                l.add((Request)chmod);
                return new RequestCallback(this.gw.submit(ctx, l, null));
            }
            catch (Throwable e) {
                this.handleException(e, "Cannot update the group's permissions. ");
            }
        }
        return null;
    }

    void updateGroup(SecurityContext ctx, GroupData group) throws DSOutOfServiceException, DSAccessException {
        try {
            IAdminPrx svc = this.gw.getAdminService(ctx);
            ExperimenterGroup g = group.asGroup();
            svc.updateGroup(g);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the group. ");
        }
    }

    void modifyExperimentersRoles(SecurityContext ctx, boolean toAdd, List<ExperimenterData> experimenters, String systemGroup) throws DSOutOfServiceException, DSAccessException {
        try {
            IAdminPrx svc = this.gw.getAdminService(ctx);
            if (toAdd) {
                Iterator<ExperimenterData> i = experimenters.iterator();
                boolean added = false;
                ExperimenterGroup gs = svc.lookupGroup(systemGroup);
                while (i.hasNext()) {
                    ExperimenterData exp = i.next();
                    List<GroupData> list = exp.getGroups();
                    for (GroupData group : list) {
                        if (!this.dsFactory.getAdmin().isSecuritySystemGroup(group.getId(), systemGroup)) continue;
                        added = true;
                    }
                    if (added) continue;
                    ArrayList<ExperimenterGroup> groups = new ArrayList<ExperimenterGroup>();
                    groups.add(gs);
                    svc.addGroups(exp.asExperimenter(), groups);
                }
            } else {
                for (ExperimenterData exp : experimenters) {
                    List<GroupData> list = exp.getGroups();
                    ArrayList<ExperimenterGroup> groups = new ArrayList<ExperimenterGroup>();
                    for (GroupData group : list) {
                        if (!this.dsFactory.getAdmin().isSecuritySystemGroup(group.getId(), systemGroup)) continue;
                        groups.add(group.asGroup());
                    }
                    if (groups.size() <= 0) continue;
                    svc.removeGroups(exp.asExperimenter(), groups);
                }
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot modify the roles of the experimenters.");
        }
    }

    void handleGroupOwners(SecurityContext ctx, boolean toAdd, ExperimenterGroup group, List<Experimenter> experimenters) throws DSOutOfServiceException, DSAccessException {
        try {
            IAdminPrx svc = this.gw.getAdminService(ctx);
            if (toAdd) {
                svc.addGroupOwners(group, experimenters);
            } else {
                svc.removeGroupOwners(group, experimenters);
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot handle the group ownership. ");
        }
    }

    byte[] getPlane(SecurityContext ctx, long pixelsID, int z, int t, int c) throws DSOutOfServiceException, DSAccessException, FSAccessException {
        return this.retrievePlane(ctx, pixelsID, z, t, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] retrievePlane(SecurityContext ctx, long pixelsID, int z, int t, int c) throws DSOutOfServiceException, DSAccessException, FSAccessException {
        RawPixelsStorePrx service = null;
        try {
            byte[] plane;
            service = this.gw.getPixelsStore(ctx);
            service.setPixelsId(pixelsID, false);
            byte[] byArray = plane = service.getPlane(z, c, t);
            return byArray;
        }
        catch (Throwable e) {
            if (e instanceof ValidationException) {
                byte[] byArray = null;
                return byArray;
            }
            String s = "Cannot retrieve the plane (z=" + z + ", t=" + t + ", c=" + c + ") for pixelsID: " + pixelsID;
            this.handleFSException(e, s);
            this.handleException(e, s);
        }
        finally {
            if (service != null) {
                this.gw.closeService(ctx, (StatefulServiceInterfacePrx)service);
            }
        }
        return null;
    }

    long getFreeSpace(SecurityContext ctx, Class type, long id) throws DSOutOfServiceException, DSAccessException {
        try {
            IRepositoryInfoPrx service = this.gw.getRepositoryService(ctx);
            return service.getFreeSpaceInKilobytes();
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot retrieve the free space");
            return -1L;
        }
    }

    long getUsedSpace(SecurityContext ctx, Class type, long id) throws DSOutOfServiceException, DSAccessException {
        try {
            IRepositoryInfoPrx svc = this.gw.getRepositoryService(ctx);
            IQueryPrx service = this.gw.getQueryService(ctx);
            if (id < 0L) {
                return svc.getUsedSpaceInKilobytes();
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("select f from OriginalFile as f ");
            buffer.append("left outer join fetch f.details.owner as o ");
            buffer.append("where o.id = :userID");
            ParametersI param = new ParametersI();
            param.addLong("userID", id);
            List result = service.findAllByQuery(buffer.toString(), (Parameters)param);
            if (result == null) {
                return -1L;
            }
            Iterator i = result.iterator();
            long count = 0L;
            while (i.hasNext()) {
                OriginalFile f = (OriginalFile)i.next();
                if (f.getSize() == null) continue;
                count += f.getSize().getValue();
            }
            return count;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot retrieve the free space");
            return -1L;
        }
    }

    Collection getImages(SecurityContext ctx, Parameters map, boolean asDataObject) throws DSOutOfServiceException, DSAccessException {
        try {
            IContainerPrx service = this.gw.getPojosService(ctx);
            List result = service.getImagesByOptions(map);
            if (asDataObject) {
                return PojoMapper.convertToDataObjects(result);
            }
            return result;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the images imported during the specified period.");
            return new HashSet();
        }
    }

    Map resetRenderingSettings(SecurityContext ctx, Class rootNodeType, List nodes) throws DSOutOfServiceException, DSAccessException {
        List success = new ArrayList();
        ArrayList failure = new ArrayList();
        try {
            IRenderingSettingsPrx service = this.getRenderingSettingsService(ctx);
            String klass = PojoMapper.getModelType(rootNodeType).getName();
            if (klass.equals(Image.class.getName())) {
                failure.addAll(nodes);
            }
            success = service.resetDefaultsInSet(klass, nodes);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot reset the rendering settings.");
        }
        for (Long id : success) {
            if (!failure.contains(id)) continue;
            failure.remove(id);
        }
        HashMap result = new HashMap(2);
        result.put(true, success);
        result.put(false, failure);
        return result;
    }

    Map setMinMaxSettings(SecurityContext ctx, Class rootNodeType, List nodes) throws DSOutOfServiceException, DSAccessException {
        List success = new ArrayList();
        ArrayList failure = new ArrayList();
        try {
            IRenderingSettingsPrx service = this.getRenderingSettingsService(ctx);
            String klass = PojoMapper.getModelType(rootNodeType).getName();
            if (klass.equals(Image.class.getName())) {
                failure.addAll(nodes);
            }
            success = service.resetMinMaxInSet(klass, nodes);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot reset the rendering settings.");
        }
        for (Long id : success) {
            if (!failure.contains(id)) continue;
            failure.remove(id);
        }
        HashMap result = new HashMap(2);
        result.put(true, success);
        result.put(false, failure);
        return result;
    }

    Map setOwnerRenderingSettings(SecurityContext ctx, Class rootNodeType, List nodes) throws DSOutOfServiceException, DSAccessException {
        List success = new ArrayList();
        ArrayList failure = new ArrayList();
        try {
            IRenderingSettingsPrx service = this.getRenderingSettingsService(ctx);
            String klass = PojoMapper.getModelType(rootNodeType).getName();
            if (klass.equals(Image.class.getName())) {
                failure.addAll(nodes);
            }
            success = service.resetDefaultsByOwnerInSet(klass, nodes);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot reset the rendering settings.");
        }
        for (Long id : success) {
            if (!failure.contains(id)) continue;
            failure.remove(id);
        }
        HashMap result = new HashMap(2);
        result.put(true, success);
        result.put(false, failure);
        return result;
    }

    Map pasteRenderingSettings(SecurityContext ctx, long pixelsID, Class rootNodeType, List nodes) throws DSOutOfServiceException, DSAccessException {
        List success = new ArrayList();
        List failure = new ArrayList();
        try {
            IRenderingSettingsPrx service = this.getRenderingSettingsService(ctx);
            Map m = service.applySettingsToSet(pixelsID, PojoMapper.getModelType(rootNodeType).getName(), nodes);
            success = (List)m.get(true);
            failure = (List)m.get(false);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot paste the rendering settings.");
        }
        HashMap result = new HashMap(2);
        result.put(true, success);
        result.put(false, failure);
        return result;
    }

    Map<DataObject, Collection<RndProxyDef>> getRenderingSettings(SecurityContext ctx, long pixelsID, long userID) throws DSOutOfServiceException, DSAccessException {
        ArrayListMultimap tmp = ArrayListMultimap.create();
        try {
            IPixelsPrx service = this.gw.getPixelsService(ctx);
            List results = service.retrieveAllRndSettings(pixelsID, userID);
            if (CollectionUtils.isEmpty((Collection)results)) {
                return tmp.asMap();
            }
            Iterator i = results.iterator();
            HashMap<Long, DataObject> users = new HashMap<Long, DataObject>();
            while (i.hasNext()) {
                RenderingDef rndDef = (RenderingDef)i.next();
                Experimenter exp = rndDef.getDetails().getOwner();
                DataObject user = (DataObject)users.get(exp.getId().getValue());
                if (user == null) {
                    user = PojoMapper.asDataObject((IObject)exp);
                    users.put(exp.getId().getValue(), user);
                }
                tmp.put((Object)user, (Object)PixelsServicesFactory.convert(rndDef));
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the rendering settings for: " + pixelsID);
        }
        return tmp.asMap();
    }

    List<RndProxyDef> getRenderingSettingsFor(SecurityContext ctx, long pixelsID, long userID) throws DSOutOfServiceException, DSAccessException {
        try {
            IPixelsPrx service = this.gw.getPixelsService(ctx);
            List results = service.retrieveAllRndSettings(pixelsID, userID);
            ArrayList<RndProxyDef> l = new ArrayList<RndProxyDef>();
            if (CollectionUtils.isEmpty((Collection)results)) {
                return l;
            }
            Iterator i = results.iterator();
            while (i.hasNext()) {
                l.add(PixelsServicesFactory.convert((RenderingDef)i.next()));
            }
            return l;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the rendering settings for: " + pixelsID);
            return new ArrayList<RndProxyDef>();
        }
    }

    RenderingDef getRenderingDef(SecurityContext ctx, long pixelsID, long userID) throws DSOutOfServiceException, DSAccessException {
        try {
            IPixelsPrx service = this.gw.getPixelsService(ctx);
            return service.retrieveRndSettingsFor(pixelsID, userID);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the rendering settings");
            return null;
        }
    }

    Collection<DataObject> loadSpecificAnnotation(SecurityContext ctx, Class type, List<String> toInclude, List<String> toExclude, Parameters options) throws DSOutOfServiceException, DSAccessException {
        try {
            IMetadataPrx service = this.gw.getMetadataService(ctx);
            return PojoMapper.convertToDataObjects(service.loadSpecifiedAnnotations(PojoMapper.getModelType(type).getName(), toInclude, toExclude, options));
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the annotations");
            return new HashSet<DataObject>();
        }
    }

    long countSpecificAnnotation(SecurityContext ctx, Class type, List<String> toInclude, List<String> toExclude, Parameters options) throws DSOutOfServiceException, DSAccessException {
        try {
            IMetadataPrx service = this.gw.getMetadataService(ctx);
            RLong value = service.countSpecifiedAnnotations(PojoMapper.getModelType(type).getName(), toInclude, toExclude, options);
            if (value == null) {
                return -1L;
            }
            return value.getValue();
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the annotations");
            return -1L;
        }
    }

    long countAnnotationsUsedNotOwned(SecurityContext ctx, Class annotationType, long userID) throws DSOutOfServiceException, DSAccessException {
        long count = 0L;
        try {
            IMetadataPrx service = this.gw.getMetadataService(ctx);
            RLong value = service.countAnnotationsUsedNotOwned(this.convertAnnotation(annotationType), userID);
            if (value != null) {
                count = value.getValue();
            }
            if (count < 0L) {
                count = 0L;
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot count the type of annotation used by the specified user");
        }
        return count;
    }

    Collection loadAnnotationsUsedNotOwned(SecurityContext ctx, Class annotationType, long userID) throws DSOutOfServiceException, DSAccessException {
        HashSet<TagAnnotationData> result = new HashSet<TagAnnotationData>();
        try {
            IMetadataPrx service = this.gw.getMetadataService(ctx);
            List set = service.loadAnnotationsUsedNotOwned(this.convertAnnotation(annotationType), userID);
            for (IObject o : set) {
                if (!TagAnnotationData.class.equals((Object)annotationType)) continue;
                result.add(new TagAnnotationData((TagAnnotation)o));
            }
            return result;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot find the Used Tags.");
            return result;
        }
    }

    Collection<DataObject> searchByTime(SecurityContext ctx, SearchDataContext context) throws DSOutOfServiceException, DSAccessException {
        ParametersI param = new ParametersI();
        param.map = new HashMap();
        StringBuffer buf = new StringBuffer();
        buf.append("select img from Image as img ");
        buf.append("left outer join fetch img.pixels as pix ");
        buf.append("left outer join fetch pix.pixelsType as pt ");
        buf.append("left outer join fetch img.details.owner as owner ");
        boolean condition = false;
        Timestamp start = context.getStart();
        Timestamp end = context.getEnd();
        switch (context.getTimeIndex()) {
            case 0: {
                if (start != null) {
                    condition = true;
                    buf.append("where img.acquisitionDate > :start ");
                    param.map.put("start", rtypes.rtime((long)start.getTime()));
                    if (end == null) break;
                    param.map.put("end", rtypes.rtime((long)end.getTime()));
                    buf.append("and img.acquisitionDate < :end ");
                    break;
                }
                if (end == null) break;
                condition = true;
                param.map.put("end", rtypes.rtime((long)end.getTime()));
                buf.append("where img.acquisitionDate < :end ");
                break;
            }
            case 1: {
                if (start != null) {
                    condition = true;
                    param.map.put("start", rtypes.rtime((long)start.getTime()));
                    buf.append("where img.details.creationEvent.time > :start ");
                    if (end == null) break;
                    param.map.put("end", rtypes.rtime((long)end.getTime()));
                    buf.append("and img.details.creationEvent.time < :end ");
                    break;
                }
                if (end == null) break;
                condition = true;
                param.map.put("end", rtypes.rtime((long)end.getTime()));
                buf.append("where img.details.creationEvent.time < :end ");
                break;
            }
        }
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            List<ExperimenterData> l = context.getOwners();
            ArrayList<Long> ids = new ArrayList<Long>();
            if (l != null) {
                Iterator<ExperimenterData> i = l.iterator();
                while (i.hasNext()) {
                    ids.add(i.next().getId());
                }
            }
            param.addLongs("ids", ids);
            if (condition) {
                buf.append(" and owner.id in (:ids)");
            } else {
                buf.append("where owner.id in (:ids)");
            }
            return PojoMapper.convertToDataObjects(service.findAllByQuery(buf.toString(), (Parameters)param));
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot retrieve the images.");
            return new HashSet<DataObject>();
        }
    }

    SearchResultCollection search(SecurityContext ctx, SearchParameters context) throws DSOutOfServiceException, DSAccessException {
        try {
            SearchFacility search = this.gw.getFacility(SearchFacility.class);
            return search.search(ctx, context);
        }
        catch (ExecutionException e) {
            this.log("Can't get a SearchFacility");
            return new SearchResultCollection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object performSearch(SecurityContext ctx, SearchDataContext context) throws DSOutOfServiceException, DSAccessException {
        HashMap<Integer, Object> results = new HashMap<Integer, Object>();
        List<Class> types = context.getTypes();
        List<Integer> scopes = context.getScope();
        if (CollectionUtils.isEmpty(types)) {
            return new HashMap();
        }
        SearchPrx service = null;
        try {
            service = this.gw.getSearchService(ctx);
            service.clearQueries();
            service.setAllowLeadingWildcard(true);
            service.setCaseSensitive(context.isCaseSensitive());
            Timestamp start = context.getStart();
            Timestamp end = context.getEnd();
            if (start != null || end != null) {
                switch (context.getTimeIndex()) {
                    case 0: {
                        if (start != null && end != null) {
                            service.onlyCreatedBetween(rtypes.rtime((long)start.getTime()), rtypes.rtime((long)end.getTime()));
                            break;
                        }
                        if (start != null && end == null) {
                            service.onlyCreatedBetween(rtypes.rtime((long)start.getTime()), null);
                            break;
                        }
                        if (start != null || end == null) break;
                        service.onlyCreatedBetween(null, rtypes.rtime((long)end.getTime()));
                        break;
                    }
                    case 1: {
                        if (start != null && end != null) {
                            service.onlyModifiedBetween(rtypes.rtime((long)start.getTime()), rtypes.rtime((long)end.getTime()));
                            break;
                        }
                        if (start != null && end == null) {
                            service.onlyModifiedBetween(rtypes.rtime((long)start.getTime()), null);
                            break;
                        }
                        if (start != null || end == null) break;
                        service.onlyModifiedBetween(null, rtypes.rtime((long)end.getTime()));
                        break;
                    }
                    case 2: {
                        if (start != null && end != null) {
                            service.onlyAnnotatedBetween(rtypes.rtime((long)start.getTime()), rtypes.rtime((long)end.getTime()));
                            break;
                        }
                        if (start != null && end == null) {
                            service.onlyAnnotatedBetween(rtypes.rtime((long)start.getTime()), null);
                            break;
                        }
                        if (start != null || end == null) break;
                        service.onlyAnnotatedBetween(null, rtypes.rtime((long)end.getTime()));
                    }
                }
            }
            List<ExperimenterData> users = context.getOwners();
            ArrayList<DetailsI> owners = new ArrayList<DetailsI>();
            if (users != null && users.size() > 0) {
                for (ExperimenterData exp : users) {
                    DetailsI d = new DetailsI();
                    d.setOwner(exp.asExperimenter());
                    owners.add(d);
                }
            }
            List<String> some = this.prepareTextSearch(context.getSome(), service);
            List<String> must = this.prepareTextSearch(context.getMust(), service);
            List<String> none = this.prepareTextSearch(context.getNone(), service);
            ArrayList<String> supportedTypes = new ArrayList<String>();
            Iterator<Object> i = types.iterator();
            while (i.hasNext()) {
                supportedTypes.add(PojoMapper.getModelType((Class)i.next()).getName());
            }
            i = scopes.iterator();
            while (i.hasNext()) {
                results.put((Integer)i.next(), new ArrayList());
            }
            i = scopes.iterator();
            List<String> fSome = null;
            List<String> fMust = null;
            List<String> fNone = null;
            List<String> fSomeSec = null;
            List<String> fMustSec = null;
            List<String> fNoneSec = null;
            service.onlyType(Image.class.getName());
            while (i.hasNext()) {
                Integer key = (Integer)i.next();
                List rType = (List)results.get(key);
                Object size = null;
                if (key == 1) {
                    fSome = this.formatText(some, "tag");
                    fMust = this.formatText(must, "tag");
                    fNone = this.formatText(none, "tag");
                } else if (key == 2) {
                    fSome = this.formatText(some, "name");
                    fMust = this.formatText(must, "name");
                    fNone = this.formatText(none, "name");
                } else if (key == 5) {
                    fSome = this.formatText(some, "description");
                    fMust = this.formatText(must, "description");
                    fNone = this.formatText(none, "description");
                } else if (key == 3) {
                    fSome = this.formatText(some, "file.name");
                    fMust = this.formatText(must, "file.name");
                    fNone = this.formatText(none, "file.name");
                    fSomeSec = this.formatText(some, "file.contents");
                    fMustSec = this.formatText(must, "file.contents");
                    fNoneSec = this.formatText(none, "file.contents");
                } else if (key == 0) {
                    fSome = this.formatText(some, "annotation", "NOT", "tag");
                    fMust = this.formatText(must, "annotation", "NOT", "tag");
                    fNone = this.formatText(none, "annotation", "NOT", "tag");
                } else if (key == 4) {
                    fSome = this.formatText(some, "url");
                    fMust = this.formatText(must, "url");
                    fNone = this.formatText(none, "url");
                } else if (key == 8) {
                    fSome = this.formatText(some, "id");
                    fMust = this.formatText(must, "id");
                    fNone = this.formatText(none, "id");
                } else {
                    fSome = this.formatText(some, "");
                    fMust = this.formatText(must, "");
                    fNone = this.formatText(none, "");
                }
                service.bySomeMustNone(fSome, fMust, fNone);
                size = this.handleSearchResult(PojoMapper.convertTypeForSearch(Image.class), rType, service);
                if (size instanceof Integer) {
                    results.put(key, size);
                }
                service.clearQueries();
                if (size instanceof Integer || fSomeSec == null || fSomeSec.size() <= 0) continue;
                service.bySomeMustNone(fSomeSec, fMustSec, fNoneSec);
                size = this.handleSearchResult(PojoMapper.convertTypeForSearch(Image.class), rType, service);
                if (size instanceof Integer) {
                    results.put(key, size);
                }
                service.clearQueries();
            }
            HashMap<Integer, Object> hashMap = results;
            return hashMap;
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot perform the search.");
        }
        finally {
            if (service != null) {
                this.gw.closeService(ctx, (StatefulServiceInterfacePrx)service);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List filterBy(SecurityContext ctx, Class annotationType, List<String> terms, Timestamp start, Timestamp end, ExperimenterData exp) throws DSOutOfServiceException, DSAccessException {
        SearchPrx service = null;
        try {
            service = this.gw.getSearchService(ctx);
            if (start != null && end != null) {
                service.onlyAnnotatedBetween(rtypes.rtime((long)start.getTime()), rtypes.rtime((long)end.getTime()));
            }
            if (exp != null) {
                DetailsI d = new DetailsI();
                d.setOwner(exp.asExperimenter());
            }
            List<String> t = this.prepareTextSearch(terms, service);
            service.onlyType(PojoMapper.getModelType(annotationType).getName());
            ArrayList rType = new ArrayList();
            service.bySomeMustNone(t, null, null);
            Object size = this.handleSearchResult(PojoMapper.convertTypeForSearch(annotationType), rType, service);
            if (size instanceof Integer) {
                rType = new ArrayList();
            }
            ArrayList arrayList = rType;
            return arrayList;
        }
        catch (Exception e) {
            this.handleException(e, "Filtering by annotation not valid");
        }
        finally {
            if (service != null) {
                this.gw.closeService(ctx, (StatefulServiceInterfacePrx)service);
            }
        }
        return new ArrayList();
    }

    Collection<DataObject> fetchContainers(SecurityContext ctx, Class type, long userID) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            ParametersI p = new ParametersI();
            p.map = new HashMap();
            p.map.put("id", rtypes.rlong((long)userID));
            String table = this.getTableForClass(type);
            return PojoMapper.convertToDataObjects(service.findAllByQuery("from " + table + " as p where p.details.owner.id = :id", (Parameters)p));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the containers.");
            return new HashSet<DataObject>();
        }
    }

    Collection<DataObject> getAnnotatedObjects(SecurityContext ctx, Class type, Set<Long> annotationIds, Set<Long> ownerIds) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            ParametersI param = new ParametersI();
            param.addLongs("ids", annotationIds);
            StringBuilder sb = new StringBuilder();
            if (type.equals(ImageData.class)) {
                sb.append("select img from Image as img ");
                sb.append("left outer join fetch img.annotationLinksCountPerOwner img_a_c ");
                sb.append("left outer join fetch img.annotationLinks ail ");
                sb.append("left outer join fetch img.pixels as pix ");
                sb.append("left outer join fetch pix.pixelsType as pt ");
                sb.append("where ail.child.id in (:ids)");
                if (ownerIds != null && ownerIds.size() > 0) {
                    sb.append(" and img.details.owner.id in (:ownerIds)");
                    param.addLongs("ownerIds", ownerIds);
                }
                return PojoMapper.convertToDataObjects(service.findAllByQuery(sb.toString(), (Parameters)param));
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the annotated objects");
        }
        return new HashSet<DataObject>();
    }

    Map getDataObjectsTaggedCount(SecurityContext ctx, List rootNodeIDs) throws DSOutOfServiceException, DSAccessException {
        try {
            long r;
            Long value;
            List l;
            ParametersI param;
            IQueryPrx service = this.gw.getQueryService(ctx);
            StringBuilder sb = new StringBuilder();
            sb.append("select img from Image as img ");
            sb.append("left outer join fetch img.annotationLinks ail ");
            sb.append("where ail.child.id = :tagID");
            Iterator i = rootNodeIDs.iterator();
            HashMap<Long, Long> m = new HashMap<Long, Long>();
            while (i.hasNext()) {
                Long id = (Long)i.next();
                param = new ParametersI();
                param.addLong("tagID", id.longValue());
                l = service.findAllByQuery(sb.toString(), (Parameters)param);
                if (l == null) continue;
                m.put(id, Long.valueOf(l.size()));
            }
            sb = new StringBuilder();
            sb.append("select d from Dataset as d ");
            sb.append("left outer join fetch d.annotationLinks ail ");
            sb.append("where ail.child.id = :tagID");
            for (Long id : rootNodeIDs) {
                param = new ParametersI();
                param.addLong("tagID", id.longValue());
                value = (Long)m.get(id);
                l = service.findAllByQuery(sb.toString(), (Parameters)param);
                if (l != null) {
                    r = l.size();
                    value = value == null ? Long.valueOf(r) : Long.valueOf(value + r);
                }
                m.put(id, value);
            }
            sb = new StringBuilder();
            sb.append("select d from Project as d ");
            sb.append("left outer join fetch d.annotationLinks ail ");
            sb.append("where ail.child.id = :tagID");
            for (Long id : rootNodeIDs) {
                param = new ParametersI();
                param.addLong("tagID", id.longValue());
                value = (Long)m.get(id);
                l = service.findAllByQuery(sb.toString(), (Parameters)param);
                if (l != null) {
                    r = l.size();
                    value = value == null ? Long.valueOf(r) : Long.valueOf(value + r);
                }
                m.put(id, value);
            }
            return m;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot count the collection.");
            return new HashMap();
        }
    }

    ImageData projectImage(SecurityContext ctx, long pixelsID, int startT, int endT, int startZ, int endZ, int stepping, ProjectionType algorithm, List<Integer> channels, String name, String pixType) throws DSOutOfServiceException, DSAccessException {
        try {
            IProjectionPrx service = this.gw.getProjectionService(ctx);
            PixelsType type = null;
            if (pixType != null) {
                IQueryPrx svc = this.gw.getQueryService(ctx);
                List l = svc.findAll(PixelsType.class.getName(), null);
                for (PixelsType pt : l) {
                    String value = pt.getValue().getValue();
                    if (!value.equals(pixType)) continue;
                    type = pt;
                    break;
                }
            }
            long imageID = service.projectPixels(pixelsID, type, algorithm, startT, endT, channels, stepping, startZ, endZ, name);
            return this.getImage(ctx, imageID, new Parameters());
        }
        catch (Exception e) {
            this.handleException(e, "Cannot project the image.");
            return null;
        }
    }

    ImageData getImage(SecurityContext ctx, long imageID, Parameters options) throws DSOutOfServiceException, DSAccessException {
        try {
            Iterator<ImageData> i;
            Collection<ImageData> result = this.getContainerImages(ctx, ImageData.class, Arrays.asList(imageID), options);
            if (result != null && result.size() == 1 && (i = result.iterator()).hasNext()) {
                return i.next();
            }
            return null;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the image.");
            return null;
        }
    }

    RenderingDef createRenderingDef(SecurityContext ctx, long pixelsID) throws DSOutOfServiceException, DSAccessException {
        try {
            IPixelsPrx svc = this.gw.getPixelsService(ctx);
            Pixels pixels = svc.retrievePixDescription(pixelsID);
            if (pixels == null) {
                return null;
            }
            IRenderingSettingsPrx service = this.getRenderingSettingsService(ctx);
            return service.createNewRenderingDef(pixels);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot create settings for: " + pixelsID);
            return null;
        }
    }

    PlateData getImportedPlate(SecurityContext ctx, long imageID) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            List results = null;
            StringBuilder sb = new StringBuilder();
            ParametersI param = new ParametersI();
            param.addLong("imageID", imageID);
            sb.append("select plate from Plate as plate ");
            sb.append("left outer join fetch plate.wells as well ");
            sb.append("left outer join fetch well.wellSamples as ws ");
            sb.append("left outer join fetch ws.image as img ");
            sb.append("left outer join fetch img.pixels as pix ");
            sb.append("left outer join fetch pix.pixelsType as pt ");
            sb.append("where img.id = :imageID");
            results = service.findAllByQuery(sb.toString(), (Parameters)param);
            if (results.size() > 0) {
                return new PlateData((Plate)results.get(0));
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load plate");
        }
        return null;
    }

    Set loadPlateWells(SecurityContext ctx, long plateID, long acquisitionID) throws DSOutOfServiceException, DSAccessException {
        try {
            StringBuilder sb;
            IQueryPrx service = this.gw.getQueryService(ctx);
            List results = null;
            HashSet<WellData> wells = new HashSet<WellData>();
            ParametersI param = new ParametersI();
            param.addLong("plateID", plateID);
            if (acquisitionID < 0L) {
                sb = new StringBuilder();
                sb.append("select pa from PlateAcquisition as pa ");
                sb.append("where pa.plate.id = :plateID");
                results = service.findAllByQuery(sb.toString(), (Parameters)param);
                if (results != null && results.size() > 0) {
                    acquisitionID = ((PlateAcquisition)results.get(0)).getId().getValue();
                }
            }
            sb = new StringBuilder();
            sb.append("select well from Well as well ");
            sb.append("left outer join fetch well.plate as pt ");
            sb.append("left outer join fetch well.wellSamples as ws ");
            sb.append("left outer join fetch ws.plateAcquisition as pa ");
            sb.append("left outer join fetch ws.image as img ");
            sb.append("left outer join fetch img.details.creationEvent as cre ");
            sb.append("left outer join fetch img.details.updateEvent as evt ");
            sb.append("left outer join fetch img.pixels as pix ");
            sb.append("left outer join fetch pix.pixelsType as pt ");
            sb.append("where well.plate.id = :plateID");
            if (acquisitionID > 0L) {
                sb.append(" and pa.id = :acquisitionID");
                param.addLong("acquisitionID", acquisitionID);
            }
            results = service.findAllByQuery(sb.toString(), (Parameters)param);
            Iterator i = results.iterator();
            while (i.hasNext()) {
                wells.add((WellData)PojoMapper.asDataObject((IObject)((Well)i.next())));
            }
            return wells;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load plate");
            return new HashSet();
        }
    }

    Set<WellData> loadPlateWells(SecurityContext ctx, List<Long> plateIDs) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            ArrayList<RLong> ids = new ArrayList<RLong>(plateIDs.size());
            Iterator<Long> j = plateIDs.iterator();
            while (j.hasNext()) {
                ids.add(rtypes.rlong((long)j.next()));
            }
            List results = null;
            HashSet<WellData> wells = new HashSet<WellData>();
            ParametersI param = new ParametersI();
            param.add("plateIDs", (RType)rtypes.rlist(ids));
            StringBuilder sb = new StringBuilder();
            sb.append("select well from Well as well ");
            sb.append("left outer join fetch well.plate as pt ");
            sb.append("left outer join fetch well.wellSamples as ws ");
            sb.append("left outer join fetch ws.plateAcquisition as pa ");
            sb.append("left outer join fetch ws.image as img ");
            sb.append("left outer join fetch img.details.creationEvent as cre ");
            sb.append("left outer join fetch img.details.updateEvent as evt ");
            sb.append("left outer join fetch img.pixels as pix ");
            sb.append("left outer join fetch pix.pixelsType as pt ");
            sb.append("where well.plate.id in (:plateIDs)");
            results = service.findAllByQuery(sb.toString(), (Parameters)param);
            Iterator i = results.iterator();
            while (i.hasNext()) {
                wells.add((WellData)PojoMapper.asDataObject((IObject)((Well)i.next())));
            }
            return wells;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load plate");
            return new HashSet<WellData>();
        }
    }

    Object loadImageAcquisitionData(SecurityContext ctx, long imageID) throws DSOutOfServiceException, DSAccessException {
        ParametersI po = new ParametersI();
        po.acquisitionData();
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ids.add(imageID);
        try {
            IContainerPrx service = this.gw.getPojosService(ctx);
            List images = service.getImages(Image.class.getName(), ids, (Parameters)po);
            if (images != null && images.size() == 1) {
                return new ImageAcquisitionData((Image)images.get(0));
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load image acquisition data.");
        }
        return null;
    }

    Object loadChannelAcquisitionData(SecurityContext ctx, long channelID) throws DSOutOfServiceException, DSAccessException {
        try {
            IMetadataPrx service = this.gw.getMetadataService(ctx);
            IQueryPrx query = this.gw.getQueryService(ctx);
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(channelID);
            List l = service.loadChannelAcquisitionData(ids);
            if (l != null && l.size() == 1) {
                LogicalChannel lc = (LogicalChannel)l.get(0);
                ChannelAcquisitionData data = new ChannelAcquisitionData(lc);
                LightSourceData src = data.getLightSource();
                if (src == null || src.isLoaded()) {
                    return data;
                }
                IObject io = src.asIObject();
                if (io instanceof Laser) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("select l from Laser as l ");
                    sb.append("left outer join fetch l.type ");
                    sb.append("left outer join fetch l.laserMedium ");
                    sb.append("left outer join fetch l.pulse as pulse ");
                    sb.append("left outer join fetch l.pump as pump ");
                    sb.append("left outer join fetch pump.type as pt ");
                    sb.append("where l.id = :id");
                    ParametersI param = new ParametersI();
                    param.addId(src.getId());
                    Laser laser = (Laser)query.findByQuery(sb.toString(), (Parameters)param);
                    if (laser != null) {
                        data.setLightSource(new LightSourceData((LightSource)laser));
                    }
                }
                return data;
            }
            return null;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load channel acquisition data.");
            return null;
        }
    }

    IObject getEnumeration(SecurityContext ctx, Class klass, String value) throws DSOutOfServiceException, DSAccessException {
        try {
            ITypesPrx service = this.gw.getTypesService(ctx);
            return service.getEnumeration(klass.getName(), value);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot find the enumeration's value.");
            return null;
        }
    }

    List<EnumerationObject> getEnumerations(SecurityContext ctx, String klassName) throws DSOutOfServiceException, DSAccessException {
        try {
            ITypesPrx service = this.gw.getTypesService(ctx);
            List<EnumerationObject> r = this.enumerations.get(klassName);
            if (r != null) {
                return r;
            }
            List l = service.allEnumerations(klassName);
            r = new ArrayList<EnumerationObject>();
            if (l == null) {
                return r;
            }
            Iterator i = l.iterator();
            while (i.hasNext()) {
                r.add(new EnumerationObject(i.next()));
            }
            this.enumerations.put(klassName, r);
            return r;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot find the enumeration's value.");
            return new ArrayList<EnumerationObject>();
        }
    }

    Collection<DataObject> loadTags(SecurityContext ctx, Long id, Parameters options) throws DSOutOfServiceException, DSAccessException {
        try {
            IMetadataPrx service = this.gw.getMetadataService(ctx);
            ArrayList<Long> ids = new ArrayList<Long>(1);
            ids.add(id);
            Map m = service.loadTagContent(ids, options);
            if (m == null || m.size() == 0) {
                return new ArrayList<DataObject>();
            }
            return PojoMapper.convertToDataObjects((Collection)m.get(id));
        }
        catch (Exception e) {
            this.handleException(e, "Cannot find the Tags.");
            return new ArrayList<DataObject>();
        }
    }

    Collection loadTagSets(SecurityContext ctx, Parameters options) throws DSOutOfServiceException, DSAccessException {
        try {
            IMetadataPrx service = this.gw.getMetadataService(ctx);
            return PojoMapper.convertToDataObjects(service.loadTagSets(options));
        }
        catch (Exception e) {
            this.handleException(e, "Cannot find the Tags.");
            return new HashSet();
        }
    }

    List<IObject> loadPlaneInfo(SecurityContext ctx, long pixelsID, int z, int t, int channel) throws DSOutOfServiceException, DSAccessException {
        StringBuilder sb = new StringBuilder();
        ParametersI param = new ParametersI();
        sb.append("select info from PlaneInfo as info ");
        sb.append("where pixels.id = :id");
        param.addLong("id", pixelsID);
        if (z >= 0) {
            sb.append(" and info.theZ = :z");
            param.map.put("z", rtypes.rint((int)z));
        }
        if (t >= 0) {
            sb.append(" and info.theT = :t");
            param.map.put("t", rtypes.rint((int)t));
        }
        if (channel >= 0) {
            sb.append(" and info.theC = :c");
            param.map.put("c", rtypes.rint((int)channel));
        }
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            return service.findAllByQuery(sb.toString(), (Parameters)param);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the plane info for pixels: " + pixelsID);
            return new ArrayList<IObject>();
        }
    }

    void fillEnumerations(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        this.getEnumerations(ctx, OmeroMetadataService.IMMERSION);
        this.getEnumerations(ctx, OmeroMetadataService.CORRECTION);
        this.getEnumerations(ctx, OmeroMetadataService.MEDIUM);
        this.getEnumerations(ctx, OmeroMetadataService.FORMAT);
        this.getEnumerations(ctx, OmeroMetadataService.DETECTOR_TYPE);
        this.getEnumerations(ctx, OmeroMetadataService.BINNING);
        this.getEnumerations(ctx, OmeroMetadataService.CONTRAST_METHOD);
        this.getEnumerations(ctx, OmeroMetadataService.ILLUMINATION_TYPE);
        this.getEnumerations(ctx, OmeroMetadataService.PHOTOMETRIC_INTERPRETATION);
        this.getEnumerations(ctx, OmeroMetadataService.ACQUISITION_MODE);
        this.getEnumerations(ctx, OmeroMetadataService.LASER_MEDIUM);
        this.getEnumerations(ctx, OmeroMetadataService.LASER_TYPE);
        this.getEnumerations(ctx, OmeroMetadataService.LASER_PULSE);
        this.getEnumerations(ctx, OmeroMetadataService.ARC_TYPE);
        this.getEnumerations(ctx, OmeroMetadataService.FILAMENT_TYPE);
        this.getEnumerations(ctx, OmeroMetadataService.FILTER_TYPE);
        this.getEnumerations(ctx, OmeroMetadataService.MICROSCOPE_TYPE);
    }

    ScriptCallback saveAs(SecurityContext ctx, long userID, SaveAsParam param) throws ProcessException, DSOutOfServiceException, DSAccessException {
        long id = this.getScriptID(ctx, "/omero/export_scripts/Batch_Image_Export.py", "Cannot start /omero/export_scripts/Batch_Image_Export.py");
        if (id <= 0L) {
            return null;
        }
        List<DataObject> objects = param.getObjects();
        ArrayList<RLong> ids = new ArrayList<RLong>();
        Iterator<DataObject> i = objects.iterator();
        String type = "Image";
        while (i.hasNext()) {
            DataObject data = i.next();
            if (data instanceof DatasetData) {
                type = "Dataset";
            }
            ids.add(rtypes.rlong((long)data.getId()));
        }
        HashMap<String, RType> map = new HashMap<String, RType>();
        map.put("IDs", (RType)rtypes.rlist(ids));
        map.put("Data_Type", (RType)rtypes.rstring((String)type));
        map.put("Format", (RType)rtypes.rstring((String)param.getIndexAsString()));
        if (CommonsLangUtils.isNotEmpty(param.getBatchExportFilename())) {
            map.put("Folder_Name", (RType)rtypes.rstring((String)param.getBatchExportFilename()));
        }
        return this.runScript(ctx, id, map);
    }

    ScriptCallback createMovie(SecurityContext ctx, long imageID, long pixelsID, long userID, List<Integer> channels, MovieExportParam param) throws ProcessException, DSOutOfServiceException, DSAccessException {
        long id = this.getScriptID(ctx, param.getScriptName(), "Cannot start " + param.getScriptName());
        if (id <= 0L) {
            return null;
        }
        ArrayList<RInt> set = new ArrayList<RInt>(channels.size());
        Iterator<Integer> i = channels.iterator();
        while (i.hasNext()) {
            set.add(rtypes.rint((int)i.next()));
        }
        RenderingDef def = null;
        int startZ = param.getStartZ();
        int endZ = param.getEndZ();
        if (!param.isZSectionSet()) {
            def = this.getRenderingDef(ctx, pixelsID, userID);
            startZ = def.getDefaultZ().getValue();
            endZ = def.getDefaultZ().getValue();
        }
        int startT = param.getStartT();
        int endT = param.getEndT();
        if (!param.isTimeIntervalSet()) {
            if (def == null) {
                def = this.getRenderingDef(ctx, pixelsID, userID);
            }
            startT = def.getDefaultT().getValue();
            endT = def.getDefaultT().getValue();
        }
        HashMap<String, RType> map = new HashMap<String, RType>();
        map.put("IDs", (RType)rtypes.rlist((RType[])new RType[]{rtypes.rlong((long)imageID)}));
        map.put("Movie_Name", (RType)rtypes.rstring((String)param.getName()));
        map.put("Z_Start", (RType)rtypes.rint((int)startZ));
        map.put("Z_End", (RType)rtypes.rint((int)endZ));
        map.put("T_Start", (RType)rtypes.rint((int)startT));
        map.put("T_End", (RType)rtypes.rint((int)endT));
        map.put("Channels", (RType)rtypes.rlist(set));
        map.put("FPS", (RType)rtypes.rint((int)param.getFps()));
        map.put("Show_Plane_Info", (RType)rtypes.rbool((boolean)param.isLabelVisible()));
        map.put("Show_Time", (RType)rtypes.rbool((boolean)param.isLabelVisible()));
        map.put("Split_View", (RType)rtypes.rbool((boolean)false));
        map.put("Scalebar", (RType)rtypes.rint((int)param.getScaleBar()));
        map.put("Format", (RType)rtypes.rstring((String)param.getFormatAsString()));
        if (param.getColor() != null) {
            map.put("Overlay_Colour", (RType)rtypes.rstring((String)param.getColor()));
        }
        return this.runScript(ctx, id, map);
    }

    List<ScriptObject> loadRunnableScripts(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        ArrayList<ScriptObject> scripts = new ArrayList<ScriptObject>();
        try {
            ScriptObject script;
            RString value;
            IScriptPrx svc = this.getScriptService(ctx);
            List storedScripts = svc.getScripts();
            if (CollectionUtils.isEmpty((Collection)storedScripts)) {
                return scripts;
            }
            Iterator j = storedScripts.iterator();
            String v = null;
            while (j.hasNext()) {
                OriginalFile of = (OriginalFile)j.next();
                value = of.getName();
                v = of.getPath().getValue() + value.getValue();
                if (SCRIPTS_NOT_AVAILABLE_TO_USER.contains(v) || SCRIPTS_UI_AVAILABLE.contains(v)) continue;
                script = new ScriptObject(of.getId().getValue(), of.getPath().getValue(), of.getName().getValue());
                value = of.getMimetype();
                if (value != null) {
                    script.setMIMEType(value.getValue());
                }
                scripts.add(script);
            }
            storedScripts = svc.getUserScripts(new ArrayList());
            for (OriginalFile of : storedScripts) {
                value = of.getName();
                script = new ScriptObject(of.getId().getValue(), of.getPath().getValue(), of.getName().getValue());
                value = of.getMimetype();
                if (value != null) {
                    script.setMIMEType(value.getValue());
                }
                script.setOfficial(false);
                scripts.add(script);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the scripts. ");
        }
        return scripts;
    }

    List<ScriptObject> loadRunnableScriptsWithUI(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        ArrayList<ScriptObject> scripts = new ArrayList<ScriptObject>();
        try {
            IScriptPrx svc = this.getScriptService(ctx);
            List storedScripts = svc.getScripts();
            if (CollectionUtils.isEmpty((Collection)storedScripts)) {
                return scripts;
            }
            Iterator j = storedScripts.iterator();
            String v = null;
            while (j.hasNext()) {
                OriginalFile of = (OriginalFile)j.next();
                RString value = of.getName();
                v = of.getPath().getValue() + value.getValue();
                if (!SCRIPTS_UI_AVAILABLE.contains(v)) continue;
                ScriptObject script = new ScriptObject(of.getId().getValue(), of.getPath().getValue(), of.getName().getValue());
                value = of.getMimetype();
                if (value != null) {
                    script.setMIMEType(value.getValue());
                }
                scripts.add(script);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the scripts with UI. ");
        }
        return scripts;
    }

    ScriptObject loadScript(SecurityContext ctx, long scriptID) throws ProcessException {
        ScriptObject script = null;
        try {
            IScriptPrx svc = this.getScriptService(ctx);
            script = new ScriptObject(scriptID, "", "");
            script.setJobParams(svc.getParams(scriptID));
        }
        catch (Exception e) {
            this.handleConnectionException(e);
            throw new ProcessException("Cannot load the script: " + scriptID, e);
        }
        return script;
    }

    Map<Long, String> getScriptsAsString(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        try {
            IScriptPrx svc = this.getScriptService(ctx);
            List scripts = svc.getScripts();
            HashMap<Long, String> m = new HashMap<Long, String>();
            if (scripts != null) {
                Iterator i = scripts.iterator();
                String name = null;
                while (i.hasNext()) {
                    OriginalFile of = (OriginalFile)i.next();
                    RString v = of.getName();
                    if (v != null) {
                        name = v.getValue();
                    }
                    if (name == null) continue;
                    m.put(of.getId().getValue(), name);
                }
            }
            return m;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the scripts. ");
            return new HashMap<Long, String>();
        }
    }

    List<OriginalFile> getScripts(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        try {
            IScriptPrx svc = this.getScriptService(ctx);
            return svc.getScripts();
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the scripts. ");
            return new ArrayList<OriginalFile>();
        }
    }

    ScriptCallback createFigure(SecurityContext ctx, List<Long> objectIDs, Class type, FigureParam param, long userID) throws ProcessException, DSOutOfServiceException, DSAccessException {
        List<Integer> splitActive;
        long id = this.getScriptID(ctx, param.getScriptName(), "Cannot start " + param.getScriptName());
        if (id <= 0L) {
            return null;
        }
        int scriptIndex = param.getIndex();
        ArrayList<RLong> ids = new ArrayList<RLong>(objectIDs.size());
        Iterator<Long> i = objectIDs.iterator();
        while (i.hasNext()) {
            ids.add(rtypes.rlong((long)i.next()));
        }
        HashMap<String, RType> map = new HashMap<String, RType>();
        RString dataType = rtypes.rstring((String)"Image");
        if (DatasetData.class.equals((Object)type)) {
            dataType = rtypes.rstring((String)"Dataset");
        }
        map.put("Data_Type", (RType)dataType);
        switch (scriptIndex) {
            case 2: {
                DataObject d = param.getAnchor();
                long parentID = -1L;
                if (d instanceof DatasetData || d instanceof ProjectData) {
                    parentID = d.getId();
                }
                map.put("IDs", (RType)rtypes.rlist(ids));
                List<Long> tags = param.getTags();
                if (tags != null && tags.size() > 0) {
                    ids = new ArrayList(tags.size());
                    i = tags.iterator();
                    while (i.hasNext()) {
                        ids.add(rtypes.rlong((long)i.next()));
                    }
                    map.put("Tag_IDs", (RType)rtypes.rlist(ids));
                }
                if (parentID > 0L) {
                    map.put("Parent_ID", (RType)rtypes.rlong((long)parentID));
                }
                map.put("Show_Untagged_Images", (RType)rtypes.rbool((boolean)param.isIncludeUntagged()));
                map.put("Thumbnail_Size", (RType)rtypes.rint((int)param.getWidth()));
                map.put("Max_Columns", (RType)rtypes.rint((int)param.getMaxPerColumn()));
                map.put("Format", (RType)rtypes.rstring((String)param.getFormatAsString()));
                map.put("Figure_Name", (RType)rtypes.rstring((String)param.getName()));
                return this.runScript(ctx, id, map);
            }
            case 3: {
                map.put("Max_Columns", (RType)rtypes.rint((int)param.getMaxPerColumn()));
            }
        }
        LinkedHashMap<CallSite, RLong> merge = new LinkedHashMap<CallSite, RLong>();
        Map<Integer, Integer> mergeChannels = param.getMergeChannels();
        if (mergeChannels != null) {
            for (Map.Entry<Integer, Integer> entry : mergeChannels.entrySet()) {
                merge.put((CallSite)((Object)("" + entry.getKey())), rtypes.rlong((long)entry.getValue().intValue()));
            }
        }
        LinkedHashMap<CallSite, RString> split = new LinkedHashMap<CallSite, RString>();
        Map<Integer, String> splitChannels = param.getSplitChannels();
        if (splitChannels != null) {
            for (Map.Entry<Integer, Object> entry : splitChannels.entrySet()) {
                split.put((CallSite)((Object)("" + entry.getKey())), rtypes.rstring((String)((String)entry.getValue())));
            }
        }
        if ((splitActive = param.getSplitActive()) != null && splitActive.size() > 0) {
            ArrayList<RInt> sa = new ArrayList<RInt>(splitActive.size());
            Iterator<Integer> k = splitActive.iterator();
            while (k.hasNext()) {
                sa.add(rtypes.rint((int)k.next()));
            }
            map.put("Split_Indexes", (RType)rtypes.rlist(sa));
        }
        map.put("Merged_Names", (RType)rtypes.rbool((boolean)param.getMergedLabel()));
        map.put("IDs", (RType)rtypes.rlist(ids));
        if (param.getStartZ() >= 0) {
            map.put("Z_Start", (RType)rtypes.rint((int)param.getStartZ()));
        }
        if (param.getEndZ() >= 0) {
            map.put("Z_End", (RType)rtypes.rint((int)param.getEndZ()));
        }
        if (split.size() > 0) {
            map.put("Channel_Names", (RType)rtypes.rmap(split));
        }
        if (merge.size() > 0) {
            map.put("Merged_Colours", (RType)rtypes.rmap(merge));
        }
        if (scriptIndex == 3) {
            List<Integer> times = param.getTimepoints();
            ArrayList<RInt> ts = new ArrayList<RInt>(objectIDs.size());
            Iterator<Integer> k = times.iterator();
            while (k.hasNext()) {
                ts.add(rtypes.rint((int)k.next()));
            }
            map.put("T_Indexes", (RType)rtypes.rlist(ts));
            map.put("Time_Units", (RType)rtypes.rstring((String)param.getTimeAsString()));
        } else {
            map.put("Split_Panels_Grey", (RType)rtypes.rbool((boolean)param.isSplitGrey()));
        }
        if (param.getScaleBar() > 0) {
            map.put("Scalebar", (RType)rtypes.rint((int)param.getScaleBar()));
        }
        map.put("Overlay_Colour", (RType)rtypes.rstring((String)param.getColor()));
        map.put("Width", (RType)rtypes.rint((int)param.getWidth()));
        map.put("Height", (RType)rtypes.rint((int)param.getHeight()));
        map.put("Stepping", (RType)rtypes.rint((int)param.getStepping()));
        map.put("Format", (RType)rtypes.rstring((String)param.getFormatAsString()));
        map.put("Algorithm", (RType)rtypes.rstring((String)param.getProjectionTypeAsString()));
        map.put("Figure_Name", (RType)rtypes.rstring((String)param.getName()));
        map.put("Image_Labels", (RType)rtypes.rstring((String)param.getLabelAsString()));
        if (scriptIndex == 1) {
            map.put("ROI_Zoom", (RType)rtypes.rfloat((float)((float)param.getMagnificationFactor())));
        }
        return this.runScript(ctx, id, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    Object importImageFile(SecurityContext ctx, ImportableObject object, IObject container, ImportContainer ic, Status status, boolean close, String userName) throws ImportException, DSAccessException, DSOutOfServiceException {
        ImportRequest req;
        HandlePrx handle;
        ImportProcessPrx proc;
        ImportLibrary library;
        status.setImportContainer(ic);
        ImportConfig config = new ImportConfig();
        if (container != null) {
            String name = container.getClass().getName();
            if (name.endsWith("I")) {
                name = name.substring(0, name.length() - 1);
            }
            config.target.set((Object)(name + ":" + container.getId().getValue()));
            ic.setTarget(container);
        }
        ic.setUserPixels(object.getPixelsSize());
        OMEROMetadataStoreClient omsc = null;
        OMEROWrapper reader = null;
        ImportLibrary.ImportCallback cb = null;
        try {
            HashMap hashMap;
            ArrayList<String> checksums;
            String[] srcFiles;
            block42: {
                omsc = this.getImportStore(ctx, userName);
                reader = new OMEROWrapper(config);
                library = new ImportLibrary(omsc, reader);
                library.addObserver((IObserver)status);
                proc = library.createImport(ic);
                srcFiles = ic.getUsedFiles();
                checksums = new ArrayList<String>();
                byte[] buf = new byte[omsc.getDefaultBlockSize()];
                hashMap = new HashMap();
                ProportionalTimeEstimatorImpl estimator = new ProportionalTimeEstimatorImpl(ic.getUsedFilesTotalSize());
                if (status.isMarkedAsCancel()) {
                    Boolean bl = false;
                    return bl;
                }
                library.notifyObservers((ImportEvent)new ImportEvent.FILESET_UPLOAD_START(null, 0, srcFiles.length, null, null, null));
                for (int i = 0; i < srcFiles.length; ++i) {
                    try {
                        checksums.add(library.uploadFile(proc, srcFiles, i, checksumProviderFactory, (TimeEstimator)estimator, buf));
                        continue;
                    }
                    catch (Throwable e) {
                        this.handleConnectionException(e);
                    }
                }
                handle = proc.verifyUpload(checksums);
                try {
                    proc.close();
                    break block42;
                }
                catch (Exception e) {
                    this.dsFactory.getLogger().error((Object)this, "Cannot close import process.");
                }
                break block42;
                catch (ChecksumValidationException cve) {
                    ImportException e;
                    Map map;
                    try {
                        map = cve.failingChecksums;
                        e = new ImportException(cve);
                    }
                    catch (Throwable throwable) {
                        try {
                            proc.close();
                        }
                        catch (Exception e2) {
                            this.dsFactory.getLogger().error((Object)this, "Cannot close import process.");
                        }
                        library.notifyObservers((ImportEvent)new ImportEvent.FILESET_UPLOAD_END(null, 0, srcFiles.length, null, null, srcFiles, checksums, hashMap, null));
                        throw throwable;
                    }
                    try {
                        proc.close();
                    }
                    catch (Exception e3) {
                        this.dsFactory.getLogger().error((Object)this, "Cannot close import process.");
                    }
                    library.notifyObservers((ImportEvent)new ImportEvent.FILESET_UPLOAD_END(null, 0, srcFiles.length, null, null, srcFiles, checksums, map, null));
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (omsc != null && close) {
                        this.closeImport(ctx, userName);
                    }
                    return e;
                }
            }
            library.notifyObservers((ImportEvent)new ImportEvent.FILESET_UPLOAD_END(null, 0, srcFiles.length, null, null, srcFiles, checksums, hashMap, null));
            req = (ImportRequest)handle.getRequest();
        }
        catch (Throwable e) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cb != null) {
                cb.close(true);
            }
            this.handleConnectionException(e);
            status.markedAsFailed(e);
            if (close) {
                this.closeImport(ctx, userName);
            }
            ImportException importException = new ImportException(e);
            return importException;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
            if (omsc != null && close) {
                this.closeImport(ctx, userName);
            }
        }
        Fileset fs = req.activity.getParent();
        status.setFilesetData(new FilesetData(fs));
        ImportLibrary.ImportCallback importCallback = cb = library.createCallback(proc, handle, ic);
        return importCallback;
    }

    ImportCandidates getImportCandidates(SecurityContext ctx, ImportableObject object, File file, Status status) throws ImportException {
        OMEROWrapper reader = null;
        try {
            ImportConfig config = new ImportConfig();
            config.checksumAlgorithm.set((Object)object.getChecksumAlgorithm());
            if (object.skipThumbnails()) {
                config.doThumbnails.set((Object)false);
            }
            if (object.skipMinMax()) {
                config.noStatsInfo.set((Object)true);
            }
            reader = new OMEROWrapper(config);
            String[] paths = new String[]{file.getAbsolutePath()};
            ImportCandidates icans = new ImportCandidates(reader, paths, (IObserver)status);
            for (ImportContainer ic : icans.getContainers()) {
                if (object.isOverrideName()) {
                    String name = UIUtilities.getDisplayedFileName(file.getAbsolutePath(), object.getDepthForName());
                    ic.setUserSpecifiedName(name);
                }
                if (object.skipThumbnails()) {
                    ic.setDoThumbnails(false);
                }
                if (!object.skipMinMax()) continue;
                ic.setNoStatsInfo(true);
            }
            ImportCandidates importCandidates = icans;
            return importCandidates;
        }
        catch (Throwable e) {
            throw new ImportException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    void removeREService(SecurityContext ctx, long pixelsID) {
        this.gw.shutdownRenderingEngine(ctx, pixelsID);
    }

    DataObject loadFolder(String absolutePath) throws DSOutOfServiceException, DSAccessException {
        return null;
    }

    Object loadInstrument(SecurityContext ctx, long id) throws DSOutOfServiceException, DSAccessException {
        try {
            IMetadataPrx service = this.gw.getMetadataService(ctx);
            Instrument instrument = service.loadInstrument(id);
            if (instrument == null) {
                return null;
            }
            return new InstrumentData(instrument);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the instrument: " + id);
            return null;
        }
    }

    List<TableResult> loadTabularData(SecurityContext ctx, TableParameters parameters, long userID) throws DSOutOfServiceException, DSAccessException {
        TablePrx tablePrx = null;
        long id2 = -1L;
        ArrayList<TableResult> results = new ArrayList<TableResult>();
        try {
            List<Long> ids;
            SharedResourcesPrx svc = this.getSharedResources(ctx);
            if (parameters.getNodeType() != null) {
                ArrayList<Long> objects = new ArrayList<Long>(1);
                objects.add(parameters.getNodeID());
                Map map = this.loadAnnotations(ctx, parameters.getNodeType(), objects, null, null, new Parameters());
                Collection list = (Collection)map.get(parameters.getNodeID());
                Iterator j = list.iterator();
                ids = new ArrayList<Long>();
                while (j.hasNext()) {
                    FileAnnotationData fa;
                    Object k = j.next();
                    if (!(k instanceof FileAnnotationData) || !"openmicroscopy.org/omero/bulk_annotations".equals((fa = (FileAnnotationData)k).getNameSpace())) continue;
                    ids.add(fa.getFileID());
                }
            } else {
                ids = parameters.getOriginalFileIDs();
            }
            if (ids != null && ids.size() > 0) {
                for (long id2 : ids) {
                    tablePrx = svc.openTable((OriginalFile)new OriginalFileI(id2, false));
                    if (tablePrx == null) continue;
                    long[] rows = new long[(int)tablePrx.getNumberOfRows()];
                    for (int j = 0; j < rows.length; ++j) {
                        rows[j] = j;
                    }
                    TableResult result = this.createTableResult(tablePrx, rows);
                    if (result == null) continue;
                    results.add(result);
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the table: " + id2);
        }
        return results;
    }

    List<ROIResult> loadROI(SecurityContext ctx, long imageID, List<Long> measurements, long userID) throws DSOutOfServiceException, DSAccessException {
        try {
            ROIFacility roifac = this.gw.getFacility(ROIFacility.class);
            return roifac.loadROIs(ctx, imageID, measurements, userID);
        }
        catch (ExecutionException e1) {
            this.handleException(e1, "Cannot load the ROI for image: " + imageID);
            return Collections.EMPTY_LIST;
        }
    }

    Collection<ROIData> saveROI(SecurityContext ctx, long imageID, long userID, List<ROIData> roiList) throws DSOutOfServiceException, DSAccessException {
        try {
            ROIFacility roifac = this.gw.getFacility(ROIFacility.class);
            return roifac.saveROIs(ctx, imageID, userID, roiList);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot Save the ROI for image: " + imageID);
            return Collections.EMPTY_LIST;
        }
    }

    Collection loadROIMeasurements(SecurityContext ctx, long imageID, long userID) throws DSOutOfServiceException, DSAccessException {
        try {
            IRoiPrx svc = this.gw.getROIService(ctx);
            RoiOptions options = new RoiOptions();
            options.userId = rtypes.rlong((long)userID);
            Collection<FileAnnotationData> files = PojoMapper.convertToDataObjects(svc.getRoiMeasurements(imageID, options));
            ArrayList<Object> results = new ArrayList<Object>();
            if (files != null) {
                for (FileAnnotationData fa : files) {
                    if (OVERLAYS.equals(fa.getDescription())) {
                        long tableID = fa.getId();
                        TableResult table = this.createOverlay(imageID, svc.getTable(tableID));
                        if (table == null) continue;
                        table.setTableID(tableID);
                        results.add(table);
                        continue;
                    }
                    results.add(fa);
                }
            }
            return results;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot load the ROI measurements for image: " + imageID);
            return new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportImageAsOMEObject(SecurityContext ctx, int index, File f, long imageID) throws DSAccessException, DSOutOfServiceException {
        FileOutputStream stream = null;
        DSAccessException exception = null;
        try {
            ExporterPrx store = this.gw.getExporterService(ctx);
            stream = new FileOutputStream(f);
            try {
                store.addImage(imageID);
                try {
                    long size = 0L;
                    size = index == 1 ? store.generateXml() : store.generateTiff();
                    long offset = 0L;
                    try {
                        offset = 0L;
                        while (offset + 262144L < size) {
                            stream.write(store.read(offset, 262144));
                            offset += 262144L;
                        }
                    }
                    catch (Throwable throwable) {
                        stream.write(store.read(offset, (int)(size - offset)));
                        stream.close();
                        throw throwable;
                    }
                    stream.write(store.read(offset, (int)(size - offset)));
                    stream.close();
                }
                catch (Exception e) {
                    if (stream != null) {
                        stream.close();
                    }
                    if (f != null) {
                        f.delete();
                    }
                    exception = new DSAccessException("Cannot export the image as an OME-formats ", e);
                    this.handleConnectionException(e);
                }
            }
            finally {
                this.gw.closeService(ctx, (StatefulServiceInterfacePrx)store);
                if (exception != null) {
                    throw exception;
                }
            }
        }
        catch (Throwable t) {
            if (f != null) {
                f.delete();
            }
            throw new DSAccessException("Cannot export the image as an OME-TIFF", t);
        }
    }

    ScriptCallback runScript(SecurityContext ctx, ScriptObject script) throws ProcessException, DSOutOfServiceException, DSAccessException {
        long id = -1L;
        try {
            id = script.getScriptID();
            if (id < 0L) {
                return null;
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot run the script.");
        }
        return this.runScript(ctx, id, script.getValueToPass());
    }

    Object uploadScript(SecurityContext ctx, ScriptObject script, boolean official) throws DSOutOfServiceException, DSAccessException, ValidationException {
        FileInputStream stream = null;
        try {
            IScriptPrx svc = this.getScriptService(ctx);
            StringBuffer buf = new StringBuffer("");
            try {
                int c;
                File file = new File(script.getPath());
                stream = new FileInputStream(file);
                while ((c = stream.read()) != -1) {
                    buf.append((char)c);
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                try {
                    stream.close();
                }
                catch (Exception c) {
                    // empty catch block
                }
                this.handleException(e, "Cannot upload the script: " + script.getName() + ".");
                return -1;
            }
            String path = script.getFolder();
            List<OriginalFile> scripts = this.getScripts(ctx);
            if (scripts.size() > 0) {
                Iterator<OriginalFile> i = scripts.iterator();
                StringBuilder buffer = new StringBuilder();
                while (i.hasNext()) {
                    buffer.setLength(0);
                    OriginalFile of = i.next();
                    RString v = of.getPath();
                    if (v != null) {
                        buffer.append(v.getValue());
                    }
                    if ((v = of.getName()) != null) {
                        buffer.append(v.getValue());
                    }
                    if (!buffer.toString().equals(path)) continue;
                    svc.editScript(of, buf.toString());
                    return of.getId().getValue();
                }
            }
            if (official) {
                return svc.uploadOfficialScript(path, buf.toString());
            }
            return svc.uploadScript(path, buf.toString());
        }
        catch (Exception e) {
            if (e instanceof ValidationException) {
                throw (ValidationException)e;
            }
            this.handleException(e, "Cannot upload the script: " + script.getName() + ".");
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }
    }

    List<ExperimenterData> createExperimenters(SecurityContext ctx, AdminObject object, Roles roles) throws DSOutOfServiceException, DSAccessException {
        ArrayList<ExperimenterData> results = new ArrayList<ExperimenterData>();
        try {
            IAdminPrx svc = this.gw.getAdminService(ctx);
            Map<ExperimenterData, UserCredentials> m = object.getExperimenters();
            Iterator<Map.Entry<ExperimenterData, UserCredentials>> i = m.entrySet().iterator();
            List<GroupData> groups = object.getGroups();
            ExperimenterGroup g = null;
            ArrayList<Object> l = new ArrayList<Object>();
            if (groups != null && groups.size() >= 1) {
                g = groups.get(0).asGroup();
                Iterator<GroupData> j = groups.iterator();
                while (j.hasNext()) {
                    l.add(j.next().asGroup());
                }
            }
            boolean systemGroup = false;
            ExperimenterGroupI userGroup = new ExperimenterGroupI(roles.userGroupId, false);
            ExperimenterGroupI system = new ExperimenterGroupI(roles.systemGroupId, false);
            while (i.hasNext()) {
                Map.Entry<ExperimenterData, UserCredentials> entry = i.next();
                Experimenter exp = (Experimenter)ModelMapper.createIObject(entry.getKey());
                UserCredentials uc = entry.getValue();
                Experimenter value = this.lookupExperimenter(ctx, uc.getUser().getUsername());
                if (value != null) continue;
                if (uc.isAdministrator().booleanValue()) {
                    l.add(userGroup);
                    l.add(system);
                } else {
                    l.add(userGroup);
                }
                if (g == null) {
                    g = (ExperimenterGroup)l.get(0);
                    systemGroup = true;
                }
                exp.setOmeName(rtypes.rstring((String)uc.getUser().getUsername()));
                exp.setLdap(rtypes.rbool((boolean)false));
                String password = uc.getUser().getPassword();
                long id = password != null && password.length() > 0 ? svc.createExperimenterWithPassword(exp, rtypes.rstring((String)password), g, l) : svc.createExperimenter(exp, g, l);
                exp = svc.getExperimenter(id);
                if (uc.isOwner().booleanValue() && !systemGroup) {
                    svc.setGroupOwner(g, exp);
                }
                results.add((ExperimenterData)PojoMapper.asDataObject((IObject)exp));
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot create the experimenters.");
        }
        return results;
    }

    GroupData createGroup(SecurityContext ctx, AdminObject object, Roles roles) throws DSOutOfServiceException, DSAccessException {
        try {
            IAdminPrx svc = this.gw.getAdminService(ctx);
            Map<ExperimenterData, UserCredentials> m = object.getExperimenters();
            Iterator<Map.Entry<ExperimenterData, UserCredentials>> i = m.entrySet().iterator();
            GroupData groupData = object.getGroup();
            ExperimenterGroup g = this.lookupGroup(ctx, groupData.getName());
            if (g != null) {
                return null;
            }
            g = new ExperimenterGroupI();
            g.setName(rtypes.rstring((String)groupData.getName()));
            g.setLdap(rtypes.rbool((boolean)false));
            g.setDescription(rtypes.rstring((String)groupData.getDescription()));
            g.getDetails().setPermissions(this.createPermissions(object.getPermissions()));
            long groupID = svc.createGroup(g);
            g = svc.getGroup(groupID);
            ArrayList<ExperimenterGroup> list = new ArrayList<ExperimenterGroup>();
            list.add(g);
            ArrayList<ExperimenterGroupI> l = new ArrayList<ExperimenterGroupI>();
            GroupData defaultGroup = null;
            ExperimenterGroupI userGroup = new ExperimenterGroupI(roles.userGroupId, false);
            ExperimenterGroupI systemGroup = new ExperimenterGroupI(roles.systemGroupId, false);
            while (i.hasNext()) {
                Experimenter exp;
                Map.Entry<ExperimenterData, UserCredentials> entry = i.next();
                UserCredentials uc = entry.getValue();
                Experimenter value = this.lookupExperimenter(ctx, uc.getUser().getUsername());
                if (value != null) {
                    exp = value;
                    ExperimenterData expData = new ExperimenterData(exp);
                    defaultGroup = expData.getDefaultGroup();
                    if (this.dsFactory.getAdmin().isSecuritySystemGroup(defaultGroup.getId())) {
                        defaultGroup = null;
                    }
                } else {
                    exp = (Experimenter)ModelMapper.createIObject(entry.getKey());
                    if (uc.isAdministrator().booleanValue()) {
                        l.add(userGroup);
                        l.add(systemGroup);
                    } else {
                        l.add(userGroup);
                    }
                    exp.setOmeName(rtypes.rstring((String)uc.getUser().getUsername()));
                    exp.setLdap(rtypes.rbool((boolean)false));
                    String password = uc.getUser().getPassword();
                    long id = password != null && password.length() > 0 ? svc.createExperimenterWithPassword(exp, rtypes.rstring((String)password), g, l) : svc.createExperimenter(exp, g, l);
                    exp = svc.getExperimenter(id);
                }
                svc.setGroupOwner(g, exp);
                if (defaultGroup != null) continue;
                svc.setDefaultGroup(exp, g);
            }
            return (GroupData)PojoMapper.asDataObject((IObject)g);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot create group and owner.");
            return null;
        }
    }

    Map<Long, Long> countExperimenters(SecurityContext ctx, List<Long> groupIds) throws DSOutOfServiceException, DSAccessException {
        HashMap<Long, Long> r = new HashMap<Long, Long>();
        try {
            IQueryPrx svc = this.gw.getQueryService(ctx);
            ParametersI p = new ParametersI();
            p.addLongs("gids", groupIds);
            List list = svc.findAllByQuery("select m from GroupExperimenterMap as m left outer join fetch m.parent where m.parent.id in (:gids)", (Parameters)p);
            for (GroupExperimenterMap g : list) {
                ExperimenterGroup group = g.getParent();
                long id = group.getId().getValue();
                groupIds.remove(id);
                Long count = (Long)r.get(id);
                if (count == null) {
                    count = 0L;
                }
                Long l = count;
                Long l2 = count = Long.valueOf(count + 1L);
                r.put(id, count);
            }
            if (groupIds.size() > 0) {
                Iterator<Object> i = groupIds.iterator();
                while (i.hasNext()) {
                    r.put((Long)i.next(), 0L);
                }
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot count the experimenters.");
        }
        return r;
    }

    List<GroupData> getGroups(SecurityContext ctx, long experimenterID) throws DSOutOfServiceException, DSAccessException {
        ArrayList<GroupData> pojos = new ArrayList<GroupData>();
        if (experimenterID < 0L) {
            return pojos;
        }
        try {
            IQueryPrx svc = this.gw.getQueryService(ctx);
            List groups = null;
            ParametersI p = new ParametersI();
            p.addId(experimenterID);
            groups = svc.findAllByQuery("select distinct g from ExperimenterGroup g left outer join fetch g.groupExperimenterMap m left outer join fetch m.child u  where u.id = :id", (Parameters)p);
            for (ExperimenterGroup group : groups) {
                if (this.dsFactory.getAdmin().isSecuritySystemGroup(group.getId().getValue())) continue;
                pojos.add((GroupData)PojoMapper.asDataObject((IObject)group));
            }
        }
        catch (Exception e) {
            this.handleConnectionException(e);
        }
        return pojos;
    }

    List<GroupData> loadGroups(SecurityContext ctx, long id) throws DSOutOfServiceException, DSAccessException {
        ArrayList<GroupData> pojos = new ArrayList<GroupData>();
        try {
            IQueryPrx svc = this.gw.getQueryService(ctx);
            List groups = null;
            if (id < 0L) {
                groups = svc.findAllByQuery("select distinct g from ExperimenterGroup g ", null);
            } else {
                ParametersI p = new ParametersI();
                p.addId(id);
                groups = svc.findAllByQuery("select distinct g from ExperimenterGroup g left outer join fetch g.groupExperimenterMap m left outer join fetch m.child u left outer join fetch u.groupExperimenterMap m2 left outer join fetch m2.parent where g.id = :id", (Parameters)p);
            }
            pojos.addAll(PojoMapper.convertToDataObjects(groups));
            return pojos;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the available groups ");
            return pojos;
        }
    }

    List<GroupData> loadGroupsForExperimenter(SecurityContext ctx, long id) throws DSOutOfServiceException, DSAccessException {
        ArrayList<GroupData> pojos = new ArrayList<GroupData>();
        try {
            IQueryPrx svc = this.gw.getQueryService(ctx);
            List groups = null;
            ParametersI p = new ParametersI();
            p.addId(id);
            groups = svc.findAllByQuery("select distinct g from ExperimenterGroup g left outer join fetch g.groupExperimenterMap m left outer join fetch m.child u  where u.id = :id", (Parameters)p);
            pojos.addAll(PojoMapper.convertToDataObjects(groups));
            return pojos;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the available groups ");
            return pojos;
        }
    }

    List<ExperimenterData> loadExperimenters(SecurityContext ctx, long groupID) throws DSOutOfServiceException, DSAccessException {
        ArrayList<ExperimenterData> pojos = new ArrayList<ExperimenterData>();
        try {
            IAdminPrx service = this.gw.getAdminService(ctx);
            List l = service.lookupExperimenters();
            pojos.addAll(PojoMapper.convertToDataObjects(l));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the existing groups.");
        }
        return pojos;
    }

    List<ExperimenterData> deleteExperimenters(SecurityContext ctx, List<ExperimenterData> experimenters) throws DSOutOfServiceException, DSAccessException {
        ArrayList<ExperimenterData> r = new ArrayList<ExperimenterData>();
        for (ExperimenterData exp : experimenters) {
            try {
                IAdminPrx svc = this.gw.getAdminService(ctx);
                svc.deleteExperimenter(exp.asExperimenter());
            }
            catch (Exception e) {
                this.handleConnectionException(e);
                r.add(exp);
            }
        }
        return r;
    }

    List<ExperimenterData> copyExperimenters(SecurityContext ctx, GroupData group, Collection experimenters) throws DSOutOfServiceException, DSAccessException {
        ArrayList<ExperimenterData> r = new ArrayList<ExperimenterData>();
        Iterator i = experimenters.iterator();
        ArrayList<ExperimenterGroup> groups = new ArrayList<ExperimenterGroup>();
        groups.add(group.asGroup());
        while (i.hasNext()) {
            ExperimenterData exp = (ExperimenterData)i.next();
            try {
                IAdminPrx svc = this.gw.getAdminService(ctx);
                svc.addGroups(exp.asExperimenter(), groups);
            }
            catch (Exception e) {
                this.handleConnectionException(e);
                r.add(exp);
            }
        }
        return r;
    }

    List<ExperimenterData> removeExperimenters(SecurityContext ctx, GroupData group, Collection experimenters) throws DSOutOfServiceException, DSAccessException {
        ArrayList<ExperimenterData> r = new ArrayList<ExperimenterData>();
        Iterator i = experimenters.iterator();
        ArrayList<ExperimenterGroup> groups = new ArrayList<ExperimenterGroup>();
        groups.add(group.asGroup());
        while (i.hasNext()) {
            ExperimenterData exp = (ExperimenterData)i.next();
            try {
                IAdminPrx svc = this.gw.getAdminService(ctx);
                svc.removeGroups(exp.asExperimenter(), groups);
            }
            catch (Exception e) {
                this.handleConnectionException(e);
                r.add(exp);
            }
        }
        return r;
    }

    List<GroupData> deleteGroups(SecurityContext ctx, List<GroupData> groups) throws DSOutOfServiceException, DSAccessException {
        ArrayList<GroupData> r = new ArrayList<GroupData>();
        IAdminPrx svc = null;
        for (GroupData g : groups) {
            try {
                svc = this.gw.getAdminService(ctx);
                svc.deleteGroup(g.asGroup());
            }
            catch (Exception e) {
                this.handleConnectionException(e);
                r.add(g);
            }
        }
        return r;
    }

    void resetPassword(SecurityContext ctx, String userName, long userID, String password) throws DSOutOfServiceException, DSAccessException {
        try {
            IAdminPrx svc = this.gw.getAdminService(ctx, true);
            svc.changeUserPassword(userName, rtypes.rstring((String)password));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot modify the password for:" + userName);
        }
    }

    boolean resetUserName(SecurityContext ctx, String userName, ExperimenterData experimenter) throws DSOutOfServiceException, DSAccessException {
        try {
            IAdminPrx service = this.gw.getAdminService(ctx);
            Experimenter value = this.lookupExperimenter(ctx, userName);
            if (value == null) {
                Experimenter exp = experimenter.asExperimenter();
                exp.setOmeName(rtypes.rstring((String)userName));
                service.updateExperimenter(exp);
                return true;
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot modify the loginName for:" + experimenter.getId());
        }
        return false;
    }

    void reportForgottenPassword(SecurityContext ctx, String userName, String email) throws DSOutOfServiceException, DSAccessException {
    }

    ExperimenterGroup lookupGroup(SecurityContext ctx, String name) throws DSOutOfServiceException, DSAccessException {
        try {
            IAdminPrx svc = this.gw.getAdminService(ctx);
            return svc.lookupGroup(name);
        }
        catch (Exception e) {
            if (e instanceof ApiUsageException) {
                return null;
            }
            this.handleException(e, "Cannot load the group.");
            return null;
        }
    }

    Experimenter lookupExperimenter(SecurityContext ctx, String name) throws DSOutOfServiceException, DSAccessException {
        try {
            IAdminPrx svc = this.gw.getAdminService(ctx);
            return svc.lookupExperimenter(name);
        }
        catch (Exception e) {
            if (e instanceof ApiUsageException) {
                return null;
            }
            this.handleException(e, "Cannot load the required group.");
            return null;
        }
    }

    byte[] getUserPhoto(SecurityContext ctx, long fileID, long size) throws DSOutOfServiceException, DSAccessException {
        return this.retrieveUserPhoto(ctx, fileID, size);
    }

    private byte[] retrieveUserPhoto(SecurityContext ctx, long fileID, long size) throws DSOutOfServiceException, DSAccessException {
        RawFileStorePrx store = null;
        try {
            store = this.gw.getRawFileService(ctx);
            store.setFileId(fileID);
            byte[] byArray = store.read(0L, (int)size);
            return byArray;
        }
        catch (Exception e) {
            this.handleConnectionException(e);
            throw new DSAccessException("Cannot read the file" + fileID, e);
        }
        finally {
            if (store != null) {
                this.gw.closeService(ctx, (StatefulServiceInterfacePrx)store);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long uploadExperimenterPhoto(SecurityContext ctx, File file, String format, long experimenterID) throws DSOutOfServiceException, DSAccessException {
        IAdminPrx svc = this.gw.getAdminService(ctx);
        FileInputStream stream = null;
        try {
            int offset;
            stream = new FileInputStream(file);
            long length = file.length();
            byte[] bytes = new byte[(int)length];
            int r = 0;
            for (offset = 0; offset < bytes.length && (r = stream.read(bytes, offset, bytes.length - offset)) >= 0; offset += r) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            long l = svc.uploadMyUserPhoto(file.getName(), format, bytes);
            return l;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot upload the photo.");
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e2) {
                this.dsFactory.getLogger().debug((Object)this, "Cannot close stream.");
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean isLargeImage(SecurityContext ctx, long pixelsId) throws DSOutOfServiceException, DSAccessException {
        RawPixelsStorePrx store = null;
        try {
            store = this.gw.getPixelsStore(ctx);
            store.setPixelsId(pixelsId, true);
            Boolean bl = store.requiresPixelsPyramid();
            return bl;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot start the Raw pixels store.");
        }
        finally {
            if (store != null) {
                this.gw.closeService(ctx, (StatefulServiceInterfacePrx)store);
            }
        }
        return null;
    }

    void closeImport(SecurityContext ctx, String userName) {
        this.gw.closeImport(ctx, userName);
    }

    void addExperimenters(SecurityContext ctx, GroupData group, List<ExperimenterData> experimenters) throws DSOutOfServiceException, DSAccessException {
        Iterator<ExperimenterData> i = experimenters.iterator();
        try {
            IAdminPrx svc = this.gw.getAdminService(ctx);
            ArrayList<ExperimenterGroup> groups = new ArrayList<ExperimenterGroup>();
            groups.add(group.asGroup());
            while (i.hasNext()) {
                svc.addGroups(i.next().asExperimenter(), groups);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Cannot add the experimenters.");
        }
    }

    SecurityContext checkContext(SecurityContext ctx, DataObject ho) {
        if (ctx == null && ho.getId() >= 0L) {
            return new SecurityContext(ho.getGroupId());
        }
        if (ho.getId() < 0L) {
            return ctx;
        }
        if (ho.getGroupId() == ctx.getGroupID()) {
            return ctx;
        }
        return new SecurityContext(ho.getGroupId());
    }

    private boolean contains(Save save, List<Save> saves) {
        for (Save save2 : saves) {
            if (save2.obj != save.obj) continue;
            return true;
        }
        return false;
    }

    RequestCallback transfer(SecurityContext ctx, SecurityContext target, Map<DataObject, List<IObject>> map, Map<String, String> options) throws DSOutOfServiceException, DSAccessException {
        try {
            Iterator<Map.Entry<DataObject, List<IObject>>> i = map.entrySet().iterator();
            ArrayList<Request> commands = new ArrayList<Request>();
            ArrayList<Save> saves = new ArrayList<Save>();
            HashMap<String, ArrayList<Long>> objects = new HashMap<String, ArrayList<Long>>();
            while (i.hasNext()) {
                Map.Entry<DataObject, List<IObject>> entry = i.next();
                DataObject data = entry.getKey();
                List<IObject> l = entry.getValue();
                String key = PojoMapper.getGraphType(data.getClass());
                ArrayList<Long> values = (ArrayList<Long>)objects.get(key);
                if (values == null) {
                    values = new ArrayList<Long>();
                    objects.put(key, values);
                }
                values.add(data.getId());
                for (IObject obj : l) {
                    Save save = new Save();
                    save.obj = obj;
                    if (this.contains(save, saves)) continue;
                    saves.add(save);
                }
            }
            commands.add((Request)((Requests.Chgrp2Builder)Requests.chgrp().target(objects)).toGroup(target.getGroupID()).build());
            commands.addAll(saves);
            return new RequestCallback(this.gw.submit(ctx, commands, target));
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot transfer the data.");
            return null;
        }
    }

    boolean canDelete(IObject ho) {
        if (ho == null) {
            return false;
        }
        return ho.getDetails().getPermissions().canDelete();
    }

    List<IObject> getPixels(SecurityContext ctx, List<DataObject> objects) throws DSOutOfServiceException, DSAccessException {
        try {
            Iterator<WellSampleData> j;
            IContainerPrx container = this.gw.getPojosService(ctx);
            IQueryPrx query = this.gw.getQueryService(ctx);
            DataObject ho = objects.get(0);
            ArrayList<Long> ids = new ArrayList<Long>();
            Iterator<DataObject> i = objects.iterator();
            while (i.hasNext()) {
                ids.add(i.next().getId());
            }
            if (ho instanceof DatasetData) {
                List images = container.getImages(PojoMapper.getModelType(ho.getClass()).getName(), ids, new Parameters());
                Iterator j2 = images.iterator();
                ids.clear();
                while (j2.hasNext()) {
                    ids.add(((Image)j2.next()).getId().getValue());
                }
            } else if (ho instanceof PlateData) {
                Set<WellData> wells = this.loadPlateWells(ctx, ids);
                ids.clear();
                for (WellData well : wells) {
                    j = well.getWellSamples().iterator();
                    if (!j.hasNext()) continue;
                    ids.add(j.next().getImage().getId());
                }
            }
            if (ids.size() == 0) {
                return null;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("select p from Pixels as p ");
            buffer.append("left outer join fetch p.pixelsType as pt ");
            buffer.append("left outer join fetch p.channels as c ");
            buffer.append("left outer join fetch c.logicalChannel as lc ");
            buffer.append("left outer join fetch c.statsInfo ");
            buffer.append("left outer join fetch lc.photometricInterpretation ");
            buffer.append("left outer join fetch lc.illumination ");
            buffer.append("left outer join fetch lc.mode ");
            buffer.append("left outer join fetch lc.contrastMethod ");
            buffer.append("join fetch p.image as i ");
            buffer.append("where i.id in (:ids)");
            ParametersI param = new ParametersI();
            ArrayList<RLong> l = new ArrayList<RLong>(ids.size());
            j = ids.iterator();
            while (j.hasNext()) {
                l.add(rtypes.rlong((long)((Long)((Object)j.next()))));
            }
            param.add("ids", (RType)rtypes.rlist(l));
            return query.findAllByQuery(buffer.toString(), (Parameters)param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the pixels sets");
            return null;
        }
    }

    void removeGroup(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        if (ctx == null) {
            return;
        }
        try {
            this.gw.closeConnector(ctx);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot close connector");
        }
    }

    Collection<DataObject> getFileSet(SecurityContext ctx, Collection<Long> imageIds) throws DSOutOfServiceException, DSAccessException {
        try {
            IQueryPrx service = this.gw.getQueryService(ctx);
            ArrayList<RLong> l = new ArrayList<RLong>(imageIds.size());
            Iterator<Long> j = imageIds.iterator();
            while (j.hasNext()) {
                l.add(rtypes.rlong((long)j.next()));
            }
            ParametersI param = new ParametersI();
            param.add("imageIds", (RType)rtypes.rlist(l));
            return PojoMapper.convertToDataObjects(service.findAllByQuery(this.createFileSetQuery(), (Parameters)param));
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the file set");
            return new HashSet<DataObject>();
        }
    }

    void shutDownDerivedConnector(SecurityContext ctx) throws Exception {
        this.gw.shutDownDerivedConnector(ctx);
    }

    Map<Long, Collection<AnnotationData>> loadSpecifiedAnnotationsLinkedTo(SecurityContext ctx, Class<? extends DataObject> rootType, List<Long> rootIDs, Class<?> annotationType, List<String> nsInclude, List<String> nsExclude, Parameters options) throws DSOutOfServiceException, DSAccessException {
        String type = this.convertAnnotation(annotationType);
        try {
            IMetadataPrx service = this.gw.getMetadataService(ctx);
            return PojoMapper.asDataObjects(service.loadSpecifiedAnnotationsLinkedTo(type, nsInclude, nsExclude, PojoMapper.getModelType(rootType).getName(), rootIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find annotation of " + annotationType + " for " + rootType + ".");
            return new HashMap<Long, Collection<AnnotationData>>();
        }
    }

    RequestCallback submit(List<Request> commands, SecurityContext ctx) throws ProcessException, DSOutOfServiceException, DSAccessException {
        try {
            return new RequestCallback(this.gw.submit(ctx, commands, null));
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot execute the command.");
            throw new ProcessException("Cannot execute the command.", e);
        }
    }

    Map<Long, Map<Boolean, List<Long>>> getImagesBySplitFilesets(SecurityContext ctx, Class<? extends DataObject> rootType, List<Long> rootIDs, Parameters options) throws DSOutOfServiceException, DSAccessException {
        try {
            IContainerPrx service = this.gw.getPojosService(ctx);
            HashMap<String, List<Long>> m = new HashMap<String, List<Long>>();
            m.put(PojoMapper.getModelType(rootType).getName(), rootIDs);
            return service.getImagesBySplitFilesets(m, options);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find split images.");
            return null;
        }
    }

    Roles getSystemRoles(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        IAdminPrx svc = this.gw.getAdminService(ctx);
        try {
            return svc.getSecurityRoles();
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot load system users.");
            return null;
        }
    }

    Map<Long, List<IObject>> loadLogFiles(SecurityContext ctx, Class<? extends DataObject> rootType, List<Long> rootIDs) throws DSOutOfServiceException, DSAccessException {
        try {
            IMetadataPrx service = this.gw.getMetadataService(ctx);
            return service.loadLogFiles(PojoMapper.getModelType(rootType).getName(), rootIDs);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot load log files for " + rootType + ".");
            return new HashMap<Long, List<IObject>>();
        }
    }

    RenderingDef getRenderingDef(SecurityContext ctx, long rndID) throws DSOutOfServiceException, DSAccessException {
        try {
            IPixelsPrx service = this.gw.getPixelsService(ctx);
            return service.loadRndSettings(rndID);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve the rendering settings");
            return null;
        }
    }

    boolean canCreate(SecurityContext ctx) throws DSOutOfServiceException {
        Boolean value = this.gw.canCreate(ctx);
        if (value == null) {
            return false;
        }
        return value;
    }

    public Collection<String> getLookupTables(SecurityContext ctx) throws DSOutOfServiceException, DSAccessException {
        try {
            return this.gw.getFacility(BrowseFacility.class).getLookupTables(ctx);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve lookup tables.");
            return null;
        }
    }

    public Map<Integer, int[]> getHistogram(SecurityContext ctx, PixelsData pixels, int[] channels, int z, int t) throws DSOutOfServiceException, DSAccessException {
        try {
            RawDataFacility f = this.gw.getFacility(RawDataFacility.class);
            return f.getHistogram(ctx, pixels, channels, z, t);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve lookup tables.");
            return null;
        }
    }

    public int getROICount(SecurityContext ctx, long imageId) throws DSOutOfServiceException, DSAccessException {
        try {
            return this.gw.getFacility(ROIFacility.class).getROICount(ctx, imageId);
        }
        catch (Exception e) {
            this.handleException(e, "Cannot retrieve ROI count.");
            return -1;
        }
    }

    public Collection<FolderData> saveROIFolders(SecurityContext ctx, Collection<FolderData> folders) throws DSOutOfServiceException, DSAccessException {
        try {
            DataManagerFacility dm = this.gw.getFacility(DataManagerFacility.class);
            List<IObject> objs = new ArrayList<IObject>(folders.size());
            for (FolderData f : folders) {
                objs.add(f.asIObject());
            }
            objs = dm.saveAndReturnObject(ctx, objs, null, null);
            Collection<FolderData> result = PojoMapper.asCastedDataObjects(objs);
            return result;
        }
        catch (Exception e) {
            this.handleException(e, "Cannot save ROI folders");
            return Collections.EMPTY_LIST;
        }
    }

    static {
        checksumProviderFactory = new ChecksumProviderFactoryImpl();
        SUPPORTED_SPECIAL_CHAR = new ArrayList<Character>();
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf('-'));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf('+'));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf('['));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf(']'));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf(')'));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf('('));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf(':'));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf('|'));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf('!'));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf('{'));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf('}'));
        SUPPORTED_SPECIAL_CHAR.add(Character.valueOf('^'));
        WILD_CARDS = new ArrayList<String>();
        WILD_CARDS.add("*");
        WILD_CARDS.add("?");
        WILD_CARDS.add("~");
        SCRIPTS_UI_AVAILABLE = new ArrayList<String>();
        SCRIPTS_UI_AVAILABLE.add("/omero/figure_scripts/ROI_Split_Figure.py");
        SCRIPTS_UI_AVAILABLE.add("/omero/figure_scripts/Thumbnail_Figure.py");
        SCRIPTS_UI_AVAILABLE.add("/omero/figure_scripts/Movie_Figure.py");
        SCRIPTS_UI_AVAILABLE.add("/omero/figure_scripts/Split_View_Figure.py");
        SCRIPTS_UI_AVAILABLE.add("/omero/export_scripts/Make_Movie.py");
        SCRIPTS_NOT_AVAILABLE_TO_USER = new ArrayList<String>();
        SCRIPTS_NOT_AVAILABLE_TO_USER.add("/omero/import_scripts/Populate_ROI.py");
    }
}

