/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openmicroscopy.shoola.util.file.ImportErrorObject;
import org.openmicroscopy.shoola.util.ui.FileTableNode;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class FileTable
extends JScrollPane {
    private static final double[] COLUMNS = new double[]{-1.0};
    private JPanel entries;
    private List<FileTableNode> nodes;

    private void addRow(TableLayout layout, int index, JComponent c) {
        layout.insertRow(index, -2.0);
        if (index % 2 == 0) {
            c.setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
        } else {
            c.setBackground(UIUtilities.BACKGROUND_COLOUR_ODD);
        }
        this.entries.add((Component)c, "0, " + index);
    }

    private void initialize(List<ImportErrorObject> files) {
        Iterator<ImportErrorObject> i = files.iterator();
        this.nodes = new ArrayList<FileTableNode>();
        while (i.hasNext()) {
            this.nodes.add(new FileTableNode(i.next()));
        }
    }

    private void buildGUI() {
        this.entries = new JPanel();
        this.entries.setBackground(UIUtilities.BACKGROUND);
        TableLayout layout = new TableLayout();
        layout.setColumn(COLUMNS);
        this.entries.setLayout((LayoutManager)layout);
        Iterator<FileTableNode> i = this.nodes.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.addRow(layout, index, i.next());
            ++index;
        }
        this.setOpaque(false);
        this.getViewport().add(this.entries);
    }

    FileTable(List<ImportErrorObject> files) {
        this.initialize(files);
        this.buildGUI();
    }

    List<FileTableNode> getSelectedFiles() {
        return this.nodes;
    }
}

