/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.OptionsDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MessageBox
extends OptionsDialog {
    public static final String OPTION_SELECTED_PROPERTY = "optionSelected";
    public static final int YES_OPTION = 1;
    public static final int NO_OPTION = 0;
    public static final int CANCEL = 2;
    private int option;

    @Override
    protected void onYesSelection() {
        this.option = 1;
        this.firePropertyChange(OPTION_SELECTED_PROPERTY, -1, this.option);
    }

    @Override
    protected void onNoSelection() {
        this.option = 0;
        this.firePropertyChange(OPTION_SELECTED_PROPERTY, -1, this.option);
    }

    @Override
    protected void onCancel() {
        this.option = 2;
        this.firePropertyChange(OPTION_SELECTED_PROPERTY, -1, this.option);
    }

    public MessageBox(JDialog owner, String title, String message) {
        this(owner, title, message, (Icon)IconManager.getInstance().getIcon(16));
    }

    public MessageBox(JFrame owner, String title, String message) {
        this(owner, title, message, (Icon)IconManager.getInstance().getIcon(16));
    }

    public MessageBox(JDialog owner, String title, String message, Icon icon) {
        super(owner, title, message, icon);
        this.pack();
    }

    public MessageBox(JFrame owner, String title, String message, Icon icon) {
        super(owner, title, message, icon);
        this.pack();
    }

    public int showMsgBox() {
        return this.showMsgBox(this.getParent().getLocation());
    }

    public int showMsgBox(Point location) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MessageBox.this.option = 2;
            }
        });
        this.setLocation(location);
        this.setVisible(true);
        return this.option;
    }

    public int centerMsgBox() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MessageBox.this.option = 2;
            }
        });
        UIUtilities.centerAndShow(this);
        return this.option;
    }
}

