/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleConfiguration;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagDataProp;

public class ModuleContent {
    private LinkedHashMap<String, TagData> tagList;
    private String type;
    private String[] parents;

    public ModuleContent(LinkedHashMap<String, TagData> list, String type, String[] parents) {
        this.tagList = list;
        this.type = type;
        this.parents = parents;
    }

    public ModuleContent(ModuleContent orig) {
        if (orig != null) {
            if (orig.tagList != null) {
                this.tagList = new LinkedHashMap();
                for (Map.Entry<String, TagData> entry : orig.tagList.entrySet()) {
                    this.tagList.put(entry.getKey(), new TagData(entry.getValue()));
                }
            }
            this.type = orig.type;
            if (orig.parents != null) {
                this.parents = (String[])orig.parents.clone();
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String[] getParents() {
        return this.parents;
    }

    public void setParents(String[] parents) {
        this.parents = parents;
    }

    public boolean hasParent(String type) {
        if (this.parents != null && type != null) {
            for (String s : this.parents) {
                if (!type.equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getIdents() {
        if (this.tagList == null) {
            return new String[]{"ID", "Model", "Manufactur"};
        }
        String[] attrNames = this.getAttributeNames();
        if (attrNames != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String s : attrNames) {
                if (s.contains("User::")) continue;
                list.add(s);
            }
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    public List<TagData> getInput() {
        ArrayList<TagData> result = new ArrayList<TagData>();
        for (Map.Entry<String, TagData> entry : this.tagList.entrySet()) {
            if (!entry.getValue().valueHasChanged()) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    public LinkedHashMap<String, TagData> getList() {
        return this.tagList;
    }

    public void setAttributes(LinkedHashMap<String, TagData> list) {
        this.takeOverProperties(list);
        this.tagList = list;
    }

    private void takeOverProperties(LinkedHashMap<String, TagData> list) {
        if (this.tagList == null) {
            return;
        }
        for (Map.Entry<String, TagData> entry : this.tagList.entrySet()) {
            if (!list.containsKey(entry.getKey())) continue;
            TagData data = list.get(entry.getKey());
            data.setVisible(entry.getValue().isVisible());
            if (!data.getTagUnitString().equals(entry.getValue().getTagUnitString())) {
                data.setTagUnit(entry.getValue().getTagUnitString());
            }
            data.setValueRequired(entry.getValue().isRequired());
        }
    }

    public List<TagData> getTagList() {
        if (this.tagList != null) {
            return new ArrayList<TagData>(this.tagList.values());
        }
        return null;
    }

    public TagData getTag(String tagName) {
        if (this.tagList == null || !this.tagList.containsKey(tagName)) {
            return null;
        }
        return this.tagList.get(tagName);
    }

    public void set(String key, TagData tagData) {
        if (this.tagList != null && this.tagList.containsKey(key)) {
            this.tagList.put(key, tagData);
        }
    }

    public void setData(LinkedHashMap<String, TagData> newData) {
        if (newData == null) {
            return;
        }
        if (this.tagList == null) {
            this.setAttributes(newData);
        } else {
            for (Map.Entry<String, TagData> entry : newData.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
        }
    }

    public String getAttributeValue(String id) {
        if (this.tagList == null || !this.tagList.containsKey(id)) {
            return null;
        }
        return this.tagList.get(id).getTagValue();
    }

    public String[] getAttributeNames() {
        if (this.tagList == null) {
            return null;
        }
        return this.tagList.keySet().toArray(new String[this.tagList.size()]);
    }

    public void print() {
        if (this.tagList == null) {
            ImporterAgent.getRegistry().getLogger().debug((Object)this, "-- PRINT ModuleContent: \n\tno tag data!");
        } else {
            for (TagData t : this.getTagList()) {
                if (t == null) continue;
                t.print();
            }
        }
    }

    public void set(String attributeName, String[] valueAt) {
        if (this.tagList != null && this.tagList.containsKey(attributeName)) {
            TagData t = this.tagList.get(attributeName);
            t.saveTagValue(valueAt);
            this.tagList.put(attributeName, t);
        }
    }

    public void resetInput() {
        if (this.tagList == null) {
            return;
        }
        for (Map.Entry<String, TagData> entry : this.tagList.entrySet()) {
            entry.getValue().dataHasChanged(false);
        }
    }

    public void setAllDataChanged() {
        if (this.tagList == null) {
            return;
        }
        for (Map.Entry<String, TagData> entry : this.tagList.entrySet()) {
            entry.getValue().dataHasChanged(true);
        }
    }

    public ModuleConfiguration getProperties() {
        if (this.tagList == null) {
            return null;
        }
        ModuleConfiguration conf = new ModuleConfiguration();
        for (Map.Entry<String, TagData> entry : this.tagList.entrySet()) {
            TagData t = entry.getValue();
            if (t == null) continue;
            conf.put(entry.getKey(), new TagDataProp(t.getProperties()));
        }
        return conf;
    }

    public void setProperties(ModuleConfiguration conf) {
        if (this.tagList == null) {
            return;
        }
        for (Map.Entry<String, TagData> entry : this.tagList.entrySet()) {
            TagDataProp p = conf.getConfigurationFor(entry.getKey());
            if (p == null) continue;
            entry.getValue().setProperties(p);
        }
    }

    public Boolean isContainer() {
        if (this.tagList == null || this.tagList.isEmpty()) {
            return true;
        }
        return false;
    }

    public boolean hasRequiredData() {
        if (this.tagList != null) {
            for (Map.Entry<String, TagData> entry : this.tagList.entrySet()) {
                if (!entry.getValue().isRequired()) continue;
                return true;
            }
        }
        return false;
    }
}

