/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MDEHelper;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.redesign.ObjectTable;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.view.CommonViewer;

public class ContentViewer
extends JXTaskPane {
    private String title;
    private ModuleContent content;
    private ObjectTable availableElems;
    private CommonViewer tagPane;
    private String tagLayout;
    private JPanel mainPanel;
    private final int LABEL_W = 170;

    public ContentViewer(String title, ObjectTable avElems, ModuleContent content) {
        this.title = title;
        this.content = content;
        this.availableElems = avElems;
        this.layoutComponents();
        Font font = this.getFont();
        this.setFont(font.deriveFont(font.getStyle(), font.getSize() - 2));
        this.setCollapsed(false);
        this.setTitle(title);
        this.add(this.mainPanel);
    }

    private void layoutComponents() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (this.content != null) {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            String tableLayout = "North";
            this.tagLayout = "North";
            if (this.availableElems != null) {
                int idx = this.availableElems.getElementIndex(this.content);
                JPanel p = this.availableElems.buildGUI(idx, -1, this);
                this.mainPanel.add((Component)p, tableLayout);
                this.tagLayout = "Center";
            }
            this.tagPane = new CommonViewer(this.content);
            this.mainPanel.add((Component)this.tagPane, this.tagLayout);
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    public void replaceData(ModuleContent newC, ModuleContent origC) {
        this.content = MDEHelper.replaceUnchangedData(this.content, origC, newC);
        this.title = newC.getAttributeValue("Model") != null ? newC.getAttributeValue("Model") : "";
        this.mainPanel.remove(this.tagPane);
        this.tagPane = new CommonViewer(this.content);
        this.mainPanel.add((Component)this.tagPane, this.tagLayout);
        this.tagPane.revalidate();
        this.tagPane.repaint();
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }
}

