/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer;

import java.util.ArrayList;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.imviewer.DataLoader;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class ProjectionSaver
extends DataLoader {
    public static final int PREVIEW = 0;
    public static final int PROJECTION = 1;
    private boolean applySettings;
    private int index;
    private ProjectionParam ref;
    private CallHandle handle;

    private void checkIndex(int value) {
        switch (value) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Projection index not supported.");
            }
        }
    }

    public ProjectionSaver(ImViewer model, SecurityContext ctx, ProjectionParam ref, int index) {
        this(model, ctx, ref, index, false);
    }

    public ProjectionSaver(ImViewer model, SecurityContext ctx, ProjectionParam ref, int index, boolean applySettings) {
        super(model, ctx);
        if (ref == null) {
            throw new IllegalArgumentException("Parameters not specified.");
        }
        this.checkIndex(index);
        this.index = index;
        this.ref = ref;
        this.applySettings = applySettings;
    }

    @Override
    public void load() {
        switch (this.index) {
            case 0: {
                this.handle = this.ivView.renderProjected(this.ctx, this.ref.getPixelsID(), this.ref.getStartZ(), this.ref.getEndZ(), this.ref.getStepping(), this.ref.getAlgorithm(), this.ref.getChannels(), this);
                break;
            }
            case 1: {
                this.handle = this.ivView.projectImage(this.ctx, this.ref, this);
            }
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        switch (this.index) {
            case 0: {
                this.viewer.setProjectionPreview(null);
                break;
            }
            case 1: {
                this.viewer.setProjectedImage(null, null, null, false);
            }
        }
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 7) {
            return;
        }
        switch (this.index) {
            case 0: {
                this.viewer.setProjectionPreview(result);
                break;
            }
            case 1: {
                ArrayList<DataObject> l = new ArrayList<DataObject>();
                if (this.ref.getDatasets() != null) {
                    l.addAll(this.ref.getDatasets());
                }
                this.viewer.setProjectedImage((ImageData)result, this.ref.getChannels(), l, this.applySettings);
            }
        }
    }
}

