/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import omero.gateway.SecurityContext;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.MapAnnotationData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.WellData;
import omero.gateway.model.WellSampleData;
import omero.log.LogMessage;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsSaved;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.browser.Browser;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserDisplay;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserSet;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.util.DataToSave;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerControl;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerModel;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerUI;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.util.DataObjectRegistration;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ui.MovieExportDialog;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.model.DeleteActivityParam;
import org.openmicroscopy.shoola.env.data.model.FigureParam;
import org.openmicroscopy.shoola.env.data.model.MovieActivityParam;
import org.openmicroscopy.shoola.env.data.model.MovieExportParam;
import org.openmicroscopy.shoola.env.data.model.ScriptActivityParam;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class MetadataViewerComponent
extends AbstractComponent
implements MetadataViewer {
    private MetadataViewerModel model;
    private MetadataViewerControl controller;
    private MetadataViewerUI view;

    private void createMovie(MovieExportParam parameters) {
        if (parameters == null) {
            return;
        }
        Object refObject = this.model.getRefObject();
        ImageData img = null;
        if (refObject instanceof ImageData) {
            img = (ImageData)refObject;
        } else if (refObject instanceof WellSampleData) {
            img = ((WellSampleData)refObject).getImage();
        }
        if (img == null) {
            return;
        }
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        MovieActivityParam activity = new MovieActivityParam(parameters, img);
        IconManager icons = IconManager.getInstance();
        activity.setIcon(icons.getIcon(74));
        un.notifyActivity(this.model.getSecurityContext(), activity);
    }

    private void deleteAnnotations(List<AnnotationData> toDelete) {
        if (toDelete == null || toDelete.size() == 0) {
            return;
        }
        boolean silent = this.containsMapAnnotationsOnly(toDelete);
        ArrayList<DeletableObject> l = new ArrayList<DeletableObject>();
        Iterator<AnnotationData> j = toDelete.iterator();
        while (j.hasNext()) {
            l.add(new DeletableObject(j.next()));
        }
        IconManager icons = IconManager.getInstance();
        DeleteActivityParam p = new DeleteActivityParam((Icon)icons.getIcon(115), l);
        p.setFailureIcon(icons.getIcon(114));
        p.setUIRegister(!silent);
        UserNotifier un = TreeViewerAgent.getRegistry().getUserNotifier();
        un.notifyActivity(this.model.getSecurityContext(), p);
    }

    private boolean containsMapAnnotationsOnly(List<AnnotationData> list) {
        if (list == null) {
            return false;
        }
        boolean mapAnnosOnly = true;
        for (AnnotationData d : list) {
            if (d instanceof MapAnnotationData) continue;
            mapAnnosOnly = false;
            break;
        }
        return mapAnnosOnly;
    }

    MetadataViewerComponent(MetadataViewerModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new MetadataViewerControl();
        this.view = new MetadataViewerUI();
    }

    void initialize() {
        this.controller.initialize(this, this.view);
        this.view.initialize(this.controller, this.model);
        if (!(this.model.getRefObject() instanceof String)) {
            this.setSelectionMode(true);
        }
    }

    void saveBeforeClose() {
        this.firePropertyChange("saveData", true, false);
    }

    void setDisplayMode(int displayMode) {
    }

    @Override
    public void activate(Map channelData) {
        switch (this.model.getState()) {
            case 1: {
                this.model.getEditor().setChannelsData(channelData, false);
                this.setRootObject(this.model.getRefObject(), this.model.getUserID(), this.model.getSecurityContext());
                break;
            }
            case 4: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    @Override
    public void applyRenderingSettings(RndProxyDef rndDef) {
        this.model.applyRenderingSettings(rndDef);
    }

    @Override
    public void discard() {
        this.model.discard();
        this.fireStateChange();
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public void cancel(int loaderID) {
        if (this.model.getState() == 4) {
            return;
        }
        this.model.cancel(loaderID);
    }

    @Override
    public void setMetadata(Map<DataObject, StructuredDataResults> results, int loaderID) {
        if (results == null || results.size() == 0) {
            return;
        }
        Browser browser = this.model.getBrowser();
        Iterator<Map.Entry<DataObject, StructuredDataResults>> i = results.entrySet().iterator();
        if (results.size() == 1) {
            while (i.hasNext()) {
                Map.Entry<DataObject, StructuredDataResults> e = i.next();
                DataObject node = e.getKey();
                if (!this.model.isSameObject(node)) {
                    this.model.setStructuredDataResults(null, loaderID);
                    this.fireStateChange();
                    return;
                }
                StructuredDataResults data = e.getValue();
                this.model.setStructuredDataResults(results, loaderID);
                browser.setParents(null, data.getParents());
                this.model.getEditor().setStructuredDataResults();
                this.fireStateChange();
            }
        } else if (this.model.isSameSelection(results.keySet())) {
            this.model.setStructuredDataResults(results, loaderID);
            this.model.getEditor().setStructuredDataResults();
        }
    }

    @Override
    public JComponent getSelectionUI() {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getBrowser().getUI();
    }

    @Override
    public JComponent getEditorUI() {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getEditor().getUI();
    }

    @Override
    public Editor getEditor() {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getEditor();
    }

    @Override
    public boolean isRendererLoaded() {
        return this.model.getEditor().getRenderer() != null;
    }

    @Override
    public JComponent getUI() {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.view.getUI();
    }

    @Override
    public JFrame getParentUI() {
        if (this.model.getState() == 4) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.view;
    }

    @Override
    public void setRootObject(Object root, long userID, SecurityContext ctx) {
        WellSampleData ws;
        if (root instanceof WellSampleData && (ws = (WellSampleData)root).getId() < 0L) {
            root = null;
        }
        if (root == null) {
            root = "";
            userID = -1L;
        }
        boolean same = this.model.isSameObject(root);
        this.model.setRootObject(root, ctx);
        if (this.model.isSingleMode()) {
            this.model.fireStructuredDataLoading(root);
            this.fireStateChange();
        }
        this.view.setRootObject();
        this.model.setUserID(userID);
        if (!same) {
            this.setParentRootObject(null, null);
        }
    }

    @Override
    public void refresh() {
        if (this.model.isSingleMode()) {
            this.model.fireStructuredDataLoading(this.model.getRefObject());
        } else {
            this.model.setRelatedNodes(this.model.getRelatedNodes());
        }
        this.fireStateChange();
        this.view.setRootObject();
    }

    @Override
    public void setParentRootObject(Object parent, Object grandParent) {
        this.model.setParentRootObject(parent, grandParent);
    }

    @Override
    public void loadContainers(TreeBrowserDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node specified.");
        }
        this.model.fireParentLoading((TreeBrowserSet)node);
    }

    @Override
    public void setContainers(TreeBrowserDisplay node, Object result) {
        Browser browser = this.model.getBrowser();
        if (node == null) {
            StructuredDataResults data = this.model.getStructuredData();
            if (data != null) {
                data.setParents((Collection)result);
                browser.setParents(null, (Collection)result);
            }
        } else {
            browser.setParents((TreeBrowserSet)node, (Collection)result);
        }
        this.model.getEditor().setStatus(false);
    }

    @Override
    public List getRelatedNodes() {
        return this.model.getRelatedNodes();
    }

    @Override
    public void saveData(DataToSave object, List<AnnotationData> toDelete, List<Object> metadata, DataObject data, boolean asynch) {
        if (data == null) {
            return;
        }
        List<AnnotationData> toAdd = null;
        List<Object> toRemove = null;
        if (object != null) {
            toAdd = object.getToAdd();
            toRemove = object.getToRemove();
        }
        Object refObject = this.model.getRefObject();
        ArrayList<DataObject> toSave = new ArrayList<DataObject>();
        if (refObject instanceof FileData) {
            FileData fa = (FileData)data;
            if (fa.getId() > 0L) {
                toSave.add(data);
                this.model.fireSaving(object, metadata, toSave, asynch);
                this.fireStateChange();
                this.deleteAnnotations(toDelete);
            } else {
                DataObjectRegistration r = new DataObjectRegistration(toAdd, toRemove, toDelete, metadata, data);
                this.firePropertyChange("register", null, r);
            }
            return;
        }
        List<DataObject> nodes = this.model.getRelatedNodes();
        if (!this.model.isSingleMode()) {
            if (nodes != null) {
                for (DataObject o : nodes) {
                    if (o instanceof WellSampleData) {
                        WellSampleData wsd = (WellSampleData)o;
                        if (wsd.getImage() == null) continue;
                        toSave.add(wsd.getImage());
                        continue;
                    }
                    toSave.add(o);
                }
            }
        } else {
            toSave.add(data);
        }
        boolean b = true;
        if (refObject instanceof ProjectData || refObject instanceof ScreenData || refObject instanceof PlateData || refObject instanceof DatasetData || refObject instanceof WellSampleData || refObject instanceof PlateAcquisitionData || refObject instanceof WellData) {
            this.model.fireSaving(object, metadata, toSave, asynch);
        } else if (refObject instanceof ImageData) {
            ImageData img = (ImageData)refObject;
            if (img.getId() < 0L) {
                DataObjectRegistration r = new DataObjectRegistration(toAdd, toRemove, toDelete, metadata, data);
                this.firePropertyChange("register", null, r);
                return;
            }
            this.model.fireSaving(object, metadata, toSave, asynch);
        } else if (refObject instanceof TagAnnotationData && CollectionUtils.isEmpty(toAdd) && CollectionUtils.isEmpty(toRemove)) {
            this.model.fireSaving(object, metadata, toSave, asynch);
            b = false;
        }
        if (toDelete != null && toDelete.size() > 0) {
            this.deleteAnnotations(toDelete);
        }
        if (b) {
            this.fireStateChange();
        }
    }

    @Override
    public boolean hasDataToSave() {
        Editor editor = this.model.getEditor();
        if (editor == null) {
            return false;
        }
        return editor.hasDataToSave();
    }

    @Override
    public void saveData() {
        this.firePropertyChange("saveData", false, true);
    }

    @Override
    public void clearDataToSave() {
        this.firePropertyChange("clearSaveData", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void onDataSave(List<DataObject> data) {
        if (data == null) {
            return;
        }
        if (this.model.getState() == 4) {
            return;
        }
        DataObject dataObject = null;
        if (data.size() == 1) {
            dataObject = data.get(0);
        }
        if (dataObject != null && this.model.isSameObject(dataObject)) {
            this.setRootObject(this.model.getRefObject(), this.model.getUserID(), this.model.getSecurityContext());
            this.model.setState(3);
            this.firePropertyChange("onDataSave", null, dataObject);
        } else {
            if (this.model.isSameSelection(data)) {
                this.model.setRelatedNodes(data);
            } else {
                this.model.setState(3);
            }
            this.firePropertyChange("onDataSave", null, data);
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.fireStateChange();
    }

    @Override
    public void setSelectionMode(boolean single) {
        this.model.setSelectionMode(single);
        this.model.getEditor().setSelectionMode(single);
    }

    @Override
    public boolean isSingleMode() {
        return this.model.isSingleMode();
    }

    @Override
    public void setRelatedNodes(List nodes) {
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        Iterator i = nodes.iterator();
        ArrayList<DataObject> results = new ArrayList<DataObject>();
        while (i.hasNext()) {
            DataObject data;
            Object object = i.next();
            if (!(object instanceof DataObject) || ids.contains((data = (DataObject)object).getId())) continue;
            results.add(data);
            ids.add(data.getId());
        }
        this.model.setRelatedNodes(results);
        this.firePropertyChange("relatedNodes", false, true);
    }

    @Override
    public void onAdminUpdated(Object data) {
        Object o = data;
        if (data instanceof Map) {
            Map l = (Map)data;
            if (l.size() > 0) {
                UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
                StringBuffer buf = new StringBuffer();
                buf.append("Unable to update the following experimenters:\n");
                for (Map.Entry entry : l.entrySet()) {
                    Object node = entry.getKey();
                    if (!(node instanceof ExperimenterData)) continue;
                    ExperimenterData exp = (ExperimenterData)node;
                    Exception ex = (Exception)entry.getValue();
                    buf.append(exp.getFirstName() + " " + exp.getLastName());
                    buf.append("\n->" + ex.getMessage());
                    buf.append("\n");
                }
                un.notifyInfo("Update experimenters", buf.toString());
            }
            this.firePropertyChange("clearSaveData", null, data);
            this.setRootObject(null, -1L, null);
        } else {
            this.setRootObject(o, this.model.getUserID(), this.model.getAdminContext());
        }
        this.firePropertyChange("adminUpdated", null, data);
    }

    @Override
    public void loadParents() {
        StructuredDataResults data = this.model.getStructuredData();
        if (data == null) {
            return;
        }
        if (data.getParents() != null) {
            return;
        }
        Object ho = data.getRelatedObject();
        if (ho != null && ho instanceof DataObject) {
            this.model.loadParents(ho.getClass(), ((DataObject)ho).getId());
            this.setStatus(true);
            this.firePropertyChange("loadingParents", false, true);
        }
    }

    @Override
    public StructuredDataResults getStructuredData() {
        return this.model.getStructuredData();
    }

    @Override
    public StructuredDataResults getParentStructuredData() {
        return this.model.getParentStructuredData();
    }

    @Override
    public void setStatus(boolean busy) {
        this.model.getEditor().setStatus(busy);
    }

    @Override
    public void showTagWizard() {
        if (this.model.getState() == 4) {
            return;
        }
        this.model.getEditor().loadExistingTags();
    }

    @Override
    public String getObjectPath() {
        return this.model.getRefObjectPath();
    }

    @Override
    public void makeMovie(int scaleBar, Color overlayColor) {
        int maxZ;
        Object refObject = this.model.getRefObject();
        if (refObject instanceof WellSampleData) {
            WellSampleData wsd = (WellSampleData)refObject;
            refObject = wsd.getImage();
        }
        if (!(refObject instanceof ImageData)) {
            return;
        }
        PixelsData data = null;
        ImageData img = (ImageData)refObject;
        try {
            data = ((ImageData)refObject).getDefaultPixels();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (data == null) {
            return;
        }
        int maxT = data.getSizeT();
        int defaultZ = maxZ = data.getSizeZ();
        int defaultT = maxT;
        Object value = data.getSizeC();
        if (this.model.getEditor().getChannelData() != null) {
            value = this.model.getEditor().getChannelData();
        }
        String name = EditorUtil.getPartialName(img.getName());
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        MovieExportDialog dialog = new MovieExportDialog(f, name, maxT, maxZ, defaultZ, defaultT, value);
        dialog.setBinaryAvailable(MetadataViewerAgent.isBinaryAvailable());
        dialog.setScaleBarDefault(scaleBar, overlayColor);
        dialog.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                Object src = evt.getSource();
                if ("createMovie".equals(name)) {
                    if (src instanceof MovieExportDialog) {
                        MovieExportDialog d = (MovieExportDialog)src;
                        MetadataViewerComponent.this.createMovie(d.getParameters());
                    }
                } else if ("viewSelectedScript".equals(name) && src instanceof MovieExportDialog) {
                    String script = (String)evt.getNewValue();
                    ScriptObject object = MetadataViewerComponent.this.model.getEditor().getScriptFromName(script);
                    if (object == null) {
                        return;
                    }
                    MetadataViewerComponent.this.manageScript(object, 102);
                }
            }
        });
        dialog.centerDialog();
    }

    @Override
    public int getRndIndex() {
        if (this.model.getState() == 4) {
            return -1;
        }
        return this.model.getIndex();
    }

    @Override
    public void renderPlane() {
        Object obj = this.model.getRefObject();
        if (obj instanceof WellSampleData) {
            WellSampleData wsd = (WellSampleData)obj;
            obj = wsd.getImage();
        }
        if (!(obj instanceof ImageData)) {
            return;
        }
        long imageID = ((ImageData)obj).getId();
        switch (this.getRndIndex()) {
            case 0: {
                this.model.getEditor().getRenderer().renderPreview();
                break;
            }
            case 1: {
                this.firePropertyChange("renderPlane", -1, imageID);
            }
        }
    }

    @Override
    public void applyToAll() {
        Object obj = this.model.getRefObject();
        if (obj instanceof ImageData) {
            this.firePropertyChange("applySettings", null, obj);
        } else if (obj instanceof WellSampleData) {
            WellSampleData wsd = (WellSampleData)obj;
            Object[] objects = new Object[]{wsd, wsd.asWellSample().getWell().getPlate().getId().getValue()};
            this.firePropertyChange("applySettings", null, objects);
        }
    }

    @Override
    public void onSettingsApplied() {
        this.firePropertyChange("settingsApplied", false, true);
    }

    @Override
    public void onRndLoaded(boolean reload) {
        Renderer rnd = this.getRenderer();
        if (rnd != null) {
            rnd.addPropertyChangeListener(this.controller);
        }
        this.firePropertyChange("rndLoaded", !reload, reload);
    }

    @Override
    public Renderer getRenderer() {
        if (this.model.getEditor() == null) {
            return null;
        }
        return this.model.getEditor().getRenderer();
    }

    @Override
    public void onChannelSelected(int index) {
        if (this.getRndIndex() != 1) {
            return;
        }
        this.firePropertyChange("selectedChannel", -1, index);
    }

    @Override
    public Dimension getIdealRendererSize() {
        Renderer rnd = this.getRenderer();
        if (rnd == null) {
            return new Dimension(0, 0);
        }
        return rnd.getUI().getPreferredSize();
    }

    @Override
    public void onRndSettingsCopied(Collection<Long> imageIds) {
        if (CollectionUtils.isEmpty(imageIds)) {
            return;
        }
        Renderer rnd = this.getRenderer();
        if (rnd == null) {
            return;
        }
        Object ob = this.model.getRefObject();
        ImageData img = null;
        if (ob instanceof WellSampleData) {
            WellSampleData wsd = (WellSampleData)ob;
            img = wsd.getImage();
        } else if (ob instanceof ImageData) {
            img = (ImageData)ob;
        }
        if (img == null) {
            return;
        }
        if (!imageIds.contains(img.getId())) {
            return;
        }
        rnd.refresh();
        rnd.renderPreview();
    }

    @Override
    public boolean isNumerousChannel() {
        return this.model.isNumerousChannel();
    }

    @Override
    public void setSelectedTab(int index) {
        this.model.getEditor().setSelectedTab(index);
    }

    @Override
    public void activityOptions(Component source, Point location, int index) {
        ArrayList<Serializable> l = new ArrayList<Serializable>();
        l.add(source);
        l.add(location);
        l.add(Integer.valueOf(index));
        this.firePropertyChange("activityOptions", null, l);
    }

    @Override
    public void createFigure(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof FigureParam) {
            this.firePropertyChange("generateFigure", null, value);
        }
    }

    @Override
    public void manageScript(ScriptObject value, int index) {
        if (value == null) {
            return;
        }
        ScriptActivityParam p = null;
        switch (index) {
            case 100: {
                p = new ScriptActivityParam(value, 0);
                break;
            }
            case 101: {
                p = new ScriptActivityParam(value, 2);
                break;
            }
            case 102: {
                p = new ScriptActivityParam(value, 3);
            }
        }
        if (p != null) {
            this.firePropertyChange("handleScript", null, p);
        }
    }

    @Override
    public void reloadRenderingControl(boolean value) {
        if (value) {
            this.model.getEditor().loadRenderingControl(1);
        } else {
            this.firePropertyChange("closeRenderer", null, this.model.getRefObject());
        }
    }

    @Override
    public void resetRenderingControl() {
        this.model.getEditor().loadRenderingControl(2);
    }

    @Override
    public void reloadRenderingControl() {
        this.model.getEditor().loadRenderingControl();
    }

    @Override
    public void onChannelColorChanged(int index) {
        this.view.onChannelColorChanged(index);
        this.firePropertyChange("channelColorChanged", -1, index);
    }

    @Override
    public Object getRefObject() {
        return this.model.getRefObject();
    }

    @Override
    public void updateAdminObject(Object data, boolean async) {
        if (data instanceof ExperimenterData) {
            this.model.fireExperimenterSaving((ExperimenterData)data, async);
        } else if (data instanceof AdminObject) {
            this.model.fireAdminSaving((AdminObject)data, async);
        } else if (data instanceof GroupData) {
            this.model.fireChangeGroup((GroupData)data);
        }
    }

    @Override
    public long getUserID() {
        return this.model.getUserID();
    }

    @Override
    public void resetPassword(String newPass) {
        this.firePropertyChange("resetPassword", null, newPass);
    }

    @Override
    public void loadViewedBy() {
        ImageData ref = this.model.getImage();
        if (ref != null) {
            this.model.fireViewedByLoading();
        }
    }

    @Override
    public void setViewedBy(Map result) {
        this.model.setViewedBy(result);
        this.view.createViewedByItems();
        this.model.fireThumbnailsLoading();
    }

    @Override
    public void setThumbnails(Map<Long, BufferedImage> thumbnails, long imageID) {
        Object ref = this.model.getRefObject();
        ImageData image = null;
        if (ref instanceof ImageData) {
            image = (ImageData)ref;
        } else if (ref instanceof WellSampleData) {
            image = ((WellSampleData)ref).getImage();
        }
        if (image == null) {
            return;
        }
        if (image.getId() == imageID) {
            this.view.setThumbnails(thumbnails);
        }
    }

    @Override
    public void uploadScript() {
        this.firePropertyChange("uploadScript", false, true);
    }

    @Override
    public void saveSettings() {
        Renderer rnd = this.model.getEditor().getRenderer();
        if (rnd != null) {
            this.model.fireThumbnailsLoading();
        }
        if (rnd != null && this.getRndIndex() == 0) {
            long imageID = -1L;
            long pixelsID = -1L;
            Object obj = this.model.getRefObject();
            if (obj instanceof WellSampleData) {
                WellSampleData wsd = (WellSampleData)obj;
                obj = wsd.getImage();
            }
            if (obj instanceof ImageData) {
                ImageData data = (ImageData)obj;
                imageID = data.getId();
                pixelsID = data.getDefaultPixels().getId();
            }
            if (this.model.canAnnotate()) {
                Registry reg = MetadataViewerAgent.getRegistry();
                RndProxyDef def = null;
                try {
                    def = rnd.saveCurrentSettings();
                }
                catch (Exception e) {
                    try {
                        reg.getImageService().resetRenderingService(this.model.getSecurityContext(), pixelsID);
                        def = rnd.saveCurrentSettings();
                    }
                    catch (Exception ex) {
                        String s = "Data Retrieval Failure: ";
                        LogMessage msg = new LogMessage();
                        msg.print(s);
                        msg.print((Throwable)e);
                        reg.getLogger().error((Object)this, msg);
                    }
                }
                EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
                bus.post(new RndSettingsSaved(pixelsID, def));
            }
            if (imageID >= 0L && this.model.canAnnotate()) {
                this.firePropertyChange("renderThumbnail", -1, imageID);
                this.model.fireViewedByLoading();
            }
        }
    }

    @Override
    public void onGroupSwitched(boolean success) {
        if (!success) {
            return;
        }
        ExperimenterData exp = MetadataViewerAgent.getUserDetails();
        this.setRootObject(null, exp.getId(), this.model.getSecurityContext());
        this.setParentRootObject(null, null);
        this.model.getEditor().onGroupSwitched(success);
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.model.getSecurityContext();
    }

    @Override
    public boolean isSameObject(Object object) {
        return this.model.isSameObject(object);
    }

    @Override
    public Map<DataObject, StructuredDataResults> getAllStructuredData() {
        return this.model.getAllStructuredData();
    }

    @Override
    public StructuredDataResults getStructuredData(Object refObject) {
        return this.model.getStructuredData(refObject);
    }

    @Override
    public void onUpdatedChannels(List<ChannelData> channels) {
        Renderer rnd = this.getRenderer();
        if (rnd != null) {
            rnd.onUpdatedChannels(channels);
        }
        this.model.getEditor().onUpdatedChannels(channels);
    }

    @Override
    public ExperimenterData getCurrentUser() {
        return this.model.getCurrentUser();
    }

    public String toString() {
        return this.model.getInstanceToSave();
    }

    @Override
    public boolean hasRndSettingsCopied() {
        return this.model.hasRndSettingsCopied();
    }

    @Override
    public void applyCopiedRndSettings() {
        if (this.getRenderer() == null) {
            return;
        }
        this.model.fireLoadRndSettings();
    }

    @Override
    public RndProxyDef getAlternativeRenderingSettings() {
        return this.model.getAlternativeRenderingSettings();
    }

    @Override
    public void reloadROICount() {
        this.model.getEditor().reloadROICount();
    }

    @Override
    public void setHistogramData(int ch, int[] data) {
        this.model.getEditor().getRenderer().setHistogramData(ch, data);
    }
}

