/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.FileAnnotationData;
import org.apache.commons.io.FilenameUtils;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.SaveAsParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.SaveAsLoader;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class SaveAsActivity
extends ActivityComponent {
    private static final String DESCRIPTION_CREATION = "Saving Images as ";
    private static final String DESCRIPTION_CREATED = "Images saved in";
    private static final String DESCRIPTION_CANCEL = "Images saving cancelled";
    private SaveAsParam parameters;

    private String getFileName(String name) {
        File directory = this.parameters.getFolder();
        File[] files = directory.listFiles();
        String dirPath = directory.getAbsolutePath() + File.separator;
        String extension = "." + FilenameUtils.getExtension((String)name);
        return this.getFileName(files, name, name, dirPath, 1, extension);
    }

    public SaveAsActivity(UserNotifier viewer, Registry registry, SecurityContext ctx, SaveAsParam parameters) {
        super(viewer, registry, ctx);
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters not valid.");
        }
        this.parameters = parameters;
        this.initialize(DESCRIPTION_CREATION + parameters.getIndexAsString(), parameters.getIcon());
    }

    @Override
    protected UserNotifierLoader createLoader() {
        this.loader = new SaveAsLoader(this.viewer, this.registry, this.ctx, this.parameters, this);
        return this.loader;
    }

    @Override
    public void endActivity(Object result) {
        if (this.parameters.isDeleteWhenFinished()) {
            if (result instanceof Map) {
                DataObject fa = null;
                Map m = (Map)result;
                for (Object obj : m.values()) {
                    if (!(obj instanceof FileAnnotationData)) continue;
                    fa = (FileAnnotationData)obj;
                    break;
                }
                if (fa != null && fa.isLoaded()) {
                    this.download("", fa, new File(this.parameters.getFolder(), ((FileAnnotationData)fa).getFileName()), this.parameters.isDeleteWhenFinished());
                    super.endActivity(null);
                } else {
                    super.endActivity(result);
                }
            }
        } else {
            super.endActivity(result);
        }
    }

    @Override
    protected void notifyActivityEnd() {
        if (!this.parameters.isDeleteWhenFinished()) {
            if (this.result instanceof FileAnnotationData) {
                FileAnnotationData data = (FileAnnotationData)this.result;
                Object name = "";
                name = data.isLoaded() ? data.getFileName() : "Annotation_" + data.getId();
                name = this.getFileName((String)name);
                this.download("", this.result, new File(this.parameters.getFolder(), (String)name), false);
            }
            this.type.setText("Images saved in " + this.parameters.getFolder().getName());
        }
    }

    @Override
    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    @Override
    protected void notifyActivityError() {
    }
}

