/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.SimpleHistogramBin;
import org.jfree.data.statistics.SimpleHistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class HistogramPane
extends JPanel {
    private static final Color MARKER_COLOR = Color.BLACK;
    private static int SIZE = 256;
    private ValueMarker markerStart;
    private ValueMarker markerEnd;
    private IntervalXYDataset dataset;

    private void initialize() {
        this.dataset = new SimpleHistogramDataset((Comparable)((Object)"Data"));
        ((SimpleHistogramDataset)this.dataset).setAdjustForBinSize(false);
        this.markerStart = new ValueMarker(0.0);
        this.markerStart.setPaint((Paint)MARKER_COLOR);
        this.markerEnd = new ValueMarker((double)SIZE);
        this.markerEnd.setPaint((Paint)MARKER_COLOR);
    }

    private void buildLayout() {
        this.setBackground(UIUtilities.BACKGROUND);
        this.setLayout(new BorderLayout());
        JFreeChart jfreechart = ChartFactory.createHistogram((String)"", null, null, (IntervalXYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        XYPlot xyplot = (XYPlot)jfreechart.getPlot();
        ValueAxis range = xyplot.getRangeAxis();
        range.setVisible(false);
        range = xyplot.getDomainAxis();
        range.setVisible(false);
        xyplot.addDomainMarker((Marker)this.markerStart);
        xyplot.addDomainMarker((Marker)this.markerEnd);
        xyplot.setForegroundAlpha(0.85f);
        xyplot.setBackgroundPaint((Paint)UIUtilities.BACKGROUND);
        XYBarRenderer xybarrenderer = (XYBarRenderer)xyplot.getRenderer();
        xybarrenderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        xybarrenderer.setSeriesPaint(0, (Paint)Color.gray);
        xybarrenderer.setDrawBarOutline(false);
        ChartPanel jpanel = new ChartPanel(jfreechart);
        jpanel.setDomainZoomable(false);
        jpanel.setRangeZoomable(false);
        jpanel.setPreferredSize(new Dimension(300, 150));
        jpanel.setSize(new Dimension(300, 150));
        this.add((Component)jpanel, "Center");
    }

    public HistogramPane() {
        this.initialize();
    }

    public void setImage(BufferedImage image) {
        this.removeAll();
        this.dataset = new HistogramDataset();
        if (image != null) {
            WritableRaster raster = image.getRaster();
            int w = image.getWidth();
            int h = image.getHeight();
            double[] r = new double[w * h];
            r = raster.getSamples(0, 0, w, h, 0, r);
            ((HistogramDataset)this.dataset).addSeries((Comparable)((Object)""), r, SIZE);
        }
        this.buildLayout();
        this.revalidate();
    }

    public void setData(int[] data) {
        this.removeAll();
        this.dataset = new SimpleHistogramDataset((Comparable)((Object)"Data"));
        ((SimpleHistogramDataset)this.dataset).setAdjustForBinSize(false);
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                SimpleHistogramBin bin = new SimpleHistogramBin((double)i, (double)i + 0.999);
                bin.setItemCount(data[i]);
                ((SimpleHistogramDataset)this.dataset).addBin(bin);
            }
        }
        this.buildLayout();
        this.revalidate();
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    public void setInputWindow(double start, double end) {
        this.markerEnd.setValue(end * (double)SIZE);
        this.markerStart.setValue(start * (double)SIZE);
    }
}

