/*
 * Decompiled with CFR 0.152.
 */
package IceUtil;

import IceUtil.Store;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class Cache {
    private final Map<Object, CacheValue> _map = new HashMap<Object, CacheValue>();
    private final Store _store;

    public Cache(Store store) {
        this._store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getIfPinned(Object key) {
        Map<Object, CacheValue> map = this._map;
        synchronized (map) {
            CacheValue val = this._map.get(key);
            return val == null ? null : val.obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unpin(Object key) {
        Map<Object, CacheValue> map = this._map;
        synchronized (map) {
            CacheValue val = this._map.remove(key);
            return val == null ? null : val.obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Object, CacheValue> map = this._map;
        synchronized (map) {
            this._map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map<Object, CacheValue> map = this._map;
        synchronized (map) {
            return this._map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pin(Object key, Object o) {
        Map<Object, CacheValue> map = this._map;
        synchronized (map) {
            CacheValue existingVal = this._map.put(key, new CacheValue(o));
            if (existingVal != null) {
                this._map.put(key, existingVal);
                return existingVal.obj;
            }
            return null;
        }
    }

    public Object pin(Object key) {
        return this.pinImpl(key, null);
    }

    public Object putIfAbsent(Object key, Object newObj) {
        return this.pinImpl(key, newObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object pinImpl(Object key, Object newObj) {
        Object obj;
        CountDownLatch latch;
        CacheValue val;
        while (true) {
            val = null;
            latch = null;
            Map<Object, CacheValue> map = this._map;
            synchronized (map) {
                val = this._map.get(key);
                if (val == null) {
                    val = new CacheValue();
                    this._map.put(key, val);
                } else {
                    if (val.obj != null) {
                        return val.obj;
                    }
                    if (val.latch == null) {
                        val.latch = new CountDownLatch(1);
                    }
                    latch = val.latch;
                }
            }
            if (latch == null) break;
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            obj = this._store.load(key);
        }
        catch (RuntimeException e) {
            Map<Object, CacheValue> map = this._map;
            synchronized (map) {
                this._map.remove(key);
                latch = val.latch;
                val.latch = null;
            }
            if (latch != null) {
                latch.countDown();
                assert (latch.getCount() == 0L);
            }
            throw e;
        }
        Map<Object, CacheValue> map = this._map;
        synchronized (map) {
            if (obj != null) {
                val.obj = obj;
            } else if (newObj == null) {
                this._map.remove(key);
            } else {
                val.obj = newObj;
            }
            latch = val.latch;
            val.latch = null;
        }
        if (latch != null) {
            latch.countDown();
            assert (latch.getCount() == 0L);
        }
        return obj;
    }

    private static class CacheValue {
        Object obj = null;
        CountDownLatch latch = null;

        CacheValue() {
        }

        CacheValue(Object obj) {
            this.obj = obj;
        }
    }
}

