/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import omero.RString;
import omero.gateway.model.DataObject;
import omero.gateway.model.DetectorData;
import omero.gateway.model.DichroicData;
import omero.gateway.model.FilterData;
import omero.gateway.model.FilterSetData;
import omero.gateway.model.LightSourceData;
import omero.gateway.model.OTFData;
import omero.gateway.model.ObjectiveData;
import omero.model.Detector;
import omero.model.Dichroic;
import omero.model.Filter;
import omero.model.FilterSet;
import omero.model.Instrument;
import omero.model.LightSource;
import omero.model.Microscope;
import omero.model.MicroscopeType;
import omero.model.OTF;
import omero.model.Objective;

public class InstrumentData
extends DataObject {
    private List<ObjectiveData> objectives;
    private List<LightSourceData> lightSources;
    private List<FilterData> filters;
    private List<FilterSetData> filterSets;
    private List<DichroicData> dichroics;
    private List<DetectorData> detectors;
    private List<OTFData> otfs;

    public InstrumentData(Instrument instrument) {
        if (instrument == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(instrument);
    }

    public String getMicroscopeType() {
        Microscope m = ((Instrument)this.asIObject()).getMicroscope();
        if (m == null) {
            return null;
        }
        MicroscopeType v = m.getType();
        if (v == null) {
            return "";
        }
        return v.getValue().getValue();
    }

    public String getMicroscopeModel() {
        Microscope m = ((Instrument)this.asIObject()).getMicroscope();
        if (m == null) {
            return null;
        }
        RString v = m.getModel();
        if (v == null) {
            return "";
        }
        return v.getValue();
    }

    public String getMicroscopeSerialNumber() {
        Microscope m = ((Instrument)this.asIObject()).getMicroscope();
        if (m == null) {
            return null;
        }
        RString v = m.getSerialNumber();
        if (v == null) {
            return "";
        }
        return v.getValue();
    }

    public String getMicroscopeLotNumber() {
        Microscope m = ((Instrument)this.asIObject()).getMicroscope();
        if (m == null) {
            return null;
        }
        RString v = m.getLotNumber();
        if (v == null) {
            return "";
        }
        return v.getValue();
    }

    public String getMicroscopeManufacturer() {
        Microscope m = ((Instrument)this.asIObject()).getMicroscope();
        if (m == null) {
            return null;
        }
        RString v = m.getManufacturer();
        if (v == null) {
            return "";
        }
        return v.getValue();
    }

    public List<OTFData> getOTF() {
        if (this.otfs != null) {
            return this.otfs;
        }
        this.otfs = new ArrayList<OTFData>();
        Instrument instrument = (Instrument)this.asIObject();
        if (instrument.sizeOfOtf() > 0) {
            List<OTF> list = instrument.copyOtf();
            Iterator<OTF> i = list.iterator();
            while (i.hasNext()) {
                this.otfs.add(new OTFData(i.next()));
            }
        }
        return this.otfs;
    }

    public List<ObjectiveData> getObjectives() {
        if (this.objectives != null) {
            return this.objectives;
        }
        this.objectives = new ArrayList<ObjectiveData>();
        Instrument instrument = (Instrument)this.asIObject();
        if (instrument.sizeOfObjective() > 0) {
            List<Objective> list = instrument.copyObjective();
            Iterator<Objective> i = list.iterator();
            while (i.hasNext()) {
                this.objectives.add(new ObjectiveData(i.next()));
            }
        }
        return this.objectives;
    }

    public List<FilterData> getFilters() {
        if (this.filters != null) {
            return this.filters;
        }
        this.filters = new ArrayList<FilterData>();
        Instrument instrument = (Instrument)this.asIObject();
        if (instrument.sizeOfFilter() > 0) {
            List<Filter> list = instrument.copyFilter();
            Iterator<Filter> i = list.iterator();
            while (i.hasNext()) {
                this.filters.add(new FilterData(i.next()));
            }
        }
        return this.filters;
    }

    public List<FilterSetData> getFilterSets() {
        if (this.filterSets != null) {
            return this.filterSets;
        }
        this.filterSets = new ArrayList<FilterSetData>();
        Instrument instrument = (Instrument)this.asIObject();
        if (instrument.sizeOfFilterSet() > 0) {
            List<FilterSet> list = instrument.copyFilterSet();
            Iterator<FilterSet> i = list.iterator();
            while (i.hasNext()) {
                this.filterSets.add(new FilterSetData(i.next()));
            }
        }
        return this.filterSets;
    }

    public List<LightSourceData> getLightSources() {
        if (this.lightSources != null) {
            return this.lightSources;
        }
        this.lightSources = new ArrayList<LightSourceData>();
        Instrument instrument = (Instrument)this.asIObject();
        if (instrument.sizeOfLightSource() > 0) {
            List<LightSource> list = instrument.copyLightSource();
            Iterator<LightSource> i = list.iterator();
            while (i.hasNext()) {
                this.lightSources.add(new LightSourceData(i.next()));
            }
        }
        return this.lightSources;
    }

    public List<DetectorData> getDetectors() {
        if (this.detectors != null) {
            return this.detectors;
        }
        this.detectors = new ArrayList<DetectorData>();
        Instrument instrument = (Instrument)this.asIObject();
        if (instrument.sizeOfDetector() > 0) {
            List<Detector> list = instrument.copyDetector();
            Iterator<Detector> i = list.iterator();
            while (i.hasNext()) {
                this.detectors.add(new DetectorData(i.next()));
            }
        }
        return this.detectors;
    }

    public List<DichroicData> getDichroics() {
        if (this.dichroics != null) {
            return this.dichroics;
        }
        this.dichroics = new ArrayList<DichroicData>();
        Instrument instrument = (Instrument)this.asIObject();
        if (instrument.sizeOfDichroic() > 0) {
            List<Dichroic> list = instrument.copyDichroic();
            Iterator<Dichroic> i = list.iterator();
            while (i.hasNext()) {
                this.dichroics.add(new DichroicData(i.next()));
            }
        }
        return this.dichroics;
    }
}

