/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import java.util.Map;
import ucar.nc2.filter.Filter;
import ucar.nc2.filter.FilterProvider;

public class Shuffle
extends Filter {
    private static final String name = "shuffle";
    private static final int id = 2;
    private int elemSize;
    private static final int DEFAULT_SIZE = 4;

    public Shuffle(Map<String, Object> properties) {
        try {
            this.elemSize = (Integer)properties.get("elementsize");
        }
        catch (Exception ex) {
            this.elemSize = 4;
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public byte[] encode(byte[] dataIn) {
        if (dataIn.length % this.elemSize != 0 || this.elemSize <= 1) {
            return dataIn;
        }
        int nElems = dataIn.length / this.elemSize;
        int[] start = new int[this.elemSize];
        for (int k = 0; k < this.elemSize; ++k) {
            start[k] = k * nElems;
        }
        byte[] result = new byte[dataIn.length];
        for (int i = 0; i < nElems; ++i) {
            for (int j = 0; j < this.elemSize; ++j) {
                result[i + start[j]] = dataIn[i * this.elemSize + j];
            }
        }
        return result;
    }

    @Override
    public byte[] decode(byte[] dataIn) {
        if (dataIn.length % this.elemSize == 0 && this.elemSize > 1) {
            int nElems = dataIn.length / this.elemSize;
            byte[] result = new byte[dataIn.length];
            for (int j = 0; j < this.elemSize; ++j) {
                int sourceIndex = j * nElems;
                int destIndex = j;
                for (int i = 0; i < nElems; ++i) {
                    result[destIndex] = dataIn[sourceIndex];
                    ++sourceIndex;
                    destIndex += this.elemSize;
                }
            }
            return result;
        }
        return dataIn;
    }

    public static class Provider
    implements FilterProvider {
        @Override
        public String getName() {
            return Shuffle.name;
        }

        @Override
        public int getId() {
            return 2;
        }

        @Override
        public Filter create(Map<String, Object> properties) {
            return new Shuffle(properties);
        }
    }
}

