/*
 * Decompiled with CFR 0.152.
 */
package ome.services.throttling;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import ome.services.throttling.Callback;
import ome.system.OmeroContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Queue {
    private static final Logger log = LoggerFactory.getLogger(Queue.class);
    private final OmeroContext ctx;
    private final BlockingQueue<Callback> q = new LinkedBlockingQueue<Callback>();
    private final AtomicBoolean done = new AtomicBoolean();

    public Queue(OmeroContext ctx) {
        this.done.set(false);
        this.ctx = ctx;
    }

    public void put(Callback callback) {
        block4: {
            boolean cont;
            boolean bl = cont = !this.done.get();
            if (cont) {
                while (true) {
                    try {
                        this.q.put(callback);
                        break block4;
                    }
                    catch (InterruptedException e) {
                        log.warn("Queue interrupted during put");
                        continue;
                    }
                    break;
                }
            }
            callback.exception(new CancelledException(), this.ctx);
        }
    }

    public Callback take() {
        Callback cb = null;
        try {
            cb = this.q.take();
        }
        catch (InterruptedException e) {
            log.warn("Queue interrupted during take");
        }
        return cb;
    }

    public void destroy() {
        boolean wasDone = this.done.getAndSet(true);
        if (!wasDone) {
            for (Callback cb : this.q) {
                cb.exception(new CancelledException(), this.ctx);
            }
        }
    }

    static class CancelledException
    extends Exception {
        CancelledException() {
        }
    }
}

