/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.teddyapplication.text;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.text.Element;
import javax.swing.text.ParagraphView;
import org.jhotdraw.samples.teddyapplication.text.NumberedViewFactory;

public class NumberedParagraphView
extends ParagraphView {
    private NumberedViewFactory viewFactory;

    public NumberedParagraphView(Element e, NumberedViewFactory viewFactory) {
        super(e);
        this.viewFactory = viewFactory;
    }

    protected short getLeftInset() {
        short left = super.getLeftInset();
        int digits = (int)Math.log10(this.getDocument().getDefaultRootElement().getElementCount()) + 2;
        FontMetrics fm = this.getGraphics().getFontMetrics();
        short numbersWidth = (short)(fm.getStringBounds("0", this.getGraphics()).getWidth() * (double)digits);
        return this.viewFactory.isLineNumbersVisible() ? (short)(left + numbersWidth) : left;
    }

    public void paintChild(Graphics g, Rectangle r, int n) {
        super.paintChild(g, r, n);
        if (this.viewFactory.isLineNumbersVisible() && n == 0) {
            g.setColor(Color.gray);
            int lineAscent = g.getFontMetrics().getAscent();
            int lineNumber = this.getDocument().getDefaultRootElement().getElementIndex(this.getStartOffset());
            int numberX = r.x - this.getLeftInset();
            int numberY = r.y + lineAscent;
            g.drawString(Integer.toString(lineNumber + 1), numberX, numberY);
        }
    }
}

