/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.api.local.LocalAdmin;
import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.conditions.SecurityViolation;
import ome.model.IObject;
import ome.model.core.OriginalFile;
import ome.model.enums.AdminPrivilege;
import ome.model.enums.EventType;
import ome.model.internal.Details;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.EventLog;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.GroupExperimenterMap;
import ome.model.meta.Session;
import ome.security.SystemTypes;
import ome.security.basic.BasicEventContext;
import ome.security.basic.LightAdminPrivileges;
import ome.security.basic.PrincipalHolder;
import ome.security.basic.TokenHolder;
import ome.services.messages.RegisterServiceCleanupMessage;
import ome.services.sessions.SessionContext;
import ome.services.sessions.state.SessionCache;
import ome.services.sessions.stats.SessionStats;
import ome.services.sharing.ShareStore;
import ome.system.EventContext;
import ome.system.Principal;
import ome.system.Roles;
import ome.tools.hibernate.HibernateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class CurrentDetails
implements PrincipalHolder {
    private static Logger log = LoggerFactory.getLogger(CurrentDetails.class);
    private final SessionCache cache;
    private final Roles roles;
    private final SystemTypes sysTypes;
    private final LightAdminPrivileges adminPrivileges;
    private final ThreadLocal<LinkedList<BasicEventContext>> contexts = new ThreadLocal();
    private final Set<String> managedRepoUuids;
    private final Set<String> scriptRepoUuids;
    private final ThreadLocal<Map<String, String>> delayedCallContext = new ThreadLocal();

    public CurrentDetails() {
        this(null);
    }

    public CurrentDetails(SessionCache cache) {
        this.cache = cache;
        this.roles = new Roles();
        this.sysTypes = new SystemTypes(this.roles);
        this.adminPrivileges = new LightAdminPrivileges(this.roles);
        this.managedRepoUuids = Collections.emptySet();
        this.scriptRepoUuids = Collections.emptySet();
    }

    public CurrentDetails(SessionCache cache, Roles roles, SystemTypes sysTypes, LightAdminPrivileges adminPrivileges, Set<String> managedRepoUuids, Set<String> scriptRepoUuids) {
        this.cache = cache;
        this.roles = roles;
        this.sysTypes = sysTypes;
        this.adminPrivileges = adminPrivileges;
        this.managedRepoUuids = managedRepoUuids;
        this.scriptRepoUuids = scriptRepoUuids;
    }

    private LinkedList<BasicEventContext> list() {
        LinkedList<BasicEventContext> list = this.contexts.get();
        if (list == null) {
            list = new LinkedList();
            this.contexts.set(list);
        }
        return list;
    }

    public Map<String, String> setContext(Map<String, String> ctx) {
        LinkedList<BasicEventContext> list = this.list();
        if (list.size() == 0) {
            this.delayedCallContext.set(ctx);
            return null;
        }
        return list.getLast().setCallContext(ctx);
    }

    public Map<String, String> getContext() {
        return this.list().getLast().getCallContext();
    }

    protected void checkDelayedCallContext(BasicEventContext bec) {
        Map<String, String> ctx = this.delayedCallContext.get();
        this.delayedCallContext.set(null);
        bec.setCallContext(ctx);
    }

    @Override
    public int size() {
        return this.list().size();
    }

    @Override
    public Principal getLast() {
        return this.list().getLast().getPrincipal();
    }

    @Override
    public void login(Principal principal) {
        String uuid = principal.getName();
        SessionContext ctx = this.cache.getSessionContext(uuid);
        SessionStats stats = ctx.stats();
        BasicEventContext c = new BasicEventContext(principal, stats);
        this.login(c);
    }

    @Override
    public void login(BasicEventContext bec) {
        if (log.isDebugEnabled()) {
            log.debug("Logging in :" + (Object)((Object)bec));
        }
        this.checkDelayedCallContext(bec);
        this.list().add(bec);
        bec.getStats().methodIn();
    }

    @Override
    public int logout() {
        LinkedList<BasicEventContext> list = this.list();
        BasicEventContext bec = list.removeLast();
        bec.getStats().methodOut();
        if (log.isDebugEnabled()) {
            log.debug("Logged out: " + (Object)((Object)bec));
        }
        return list.size();
    }

    public boolean isReady() {
        BasicEventContext c = this.current();
        return c.getEvent() != null && c.getGroup() != null && c.getOwner() != null;
    }

    public boolean isGraphCritical(Details details) {
        EventContext ec = this.getCurrentEventContext();
        long gid = ec.getCurrentGroupId();
        Permissions perms = ec.getCurrentGroupPermissions();
        if (gid < 0L) {
            try {
                ExperimenterGroup g = details.getGroup();
                gid = g.getId();
                perms = g.getDetails().getPermissions();
            }
            catch (NullPointerException npe) {
                throw new SecurityViolation("isGraphCriticalCheck: not enough context");
            }
            if (gid == this.roles.getUserGroupId()) {
                throw new SecurityViolation("isGraphCriticalCheck: Current group < 0 while accessing 'user' group!");
            }
        }
        boolean admin = ec.isCurrentUserAdmin();
        boolean pi = ec.getLeaderOfGroupsList().contains(gid);
        if (perms.isGranted(Permissions.Role.WORLD, Permissions.Right.READ)) {
            return false;
        }
        if (perms.isGranted(Permissions.Role.GROUP, Permissions.Right.READ)) {
            return false;
        }
        return admin || pi;
    }

    public boolean isOwnerOrSupervisor(IObject object) {
        if (object == null) {
            throw new ApiUsageException("Object can't be null");
        }
        Long o = HibernateUtils.nullSafeOwnerId(object);
        Long g = object instanceof ExperimenterGroup ? object.getId() : HibernateUtils.nullSafeGroupId(object);
        EventContext ec = this.getCurrentEventContext();
        if (ec.getLeaderOfGroupsList().contains(g)) {
            return true;
        }
        if (ec.getCurrentUserId().equals(o)) {
            return true;
        }
        if (!ec.isCurrentUserAdmin()) {
            return false;
        }
        boolean isSysType = this.sysTypes.isSystemType(object.getClass());
        Set privileges = ec.getCurrentAdminPrivileges();
        if (isSysType) {
            if (object instanceof Experimenter) {
                return privileges.contains(this.adminPrivileges.getPrivilege("ModifyUser"));
            }
            if (object instanceof ExperimenterGroup) {
                return privileges.contains(this.adminPrivileges.getPrivilege("ModifyGroup"));
            }
            if (object instanceof GroupExperimenterMap) {
                return privileges.contains(this.adminPrivileges.getPrivilege("ModifyGroupMembership"));
            }
            return true;
        }
        if (object instanceof OriginalFile) {
            String repo = ((OriginalFile)object).getRepo();
            if (repo != null) {
                if (this.managedRepoUuids.contains(repo)) {
                    return privileges.contains(this.adminPrivileges.getPrivilege("WriteManagedRepo"));
                }
                if (this.scriptRepoUuids.contains(repo)) {
                    return privileges.contains(this.adminPrivileges.getPrivilege("WriteScriptRepo"));
                }
                return privileges.contains(this.adminPrivileges.getPrivilege("WriteFile"));
            }
            return privileges.contains(this.adminPrivileges.getPrivilege("WriteFile"));
        }
        return privileges.contains(this.adminPrivileges.getPrivilege("WriteOwned"));
    }

    void checkAndInitialize(EventContext ec, LocalAdmin admin, ShareStore store) {
        this.current().checkAndInitialize(ec, admin, store);
    }

    BasicEventContext current() {
        BasicEventContext c = this.list().getLast();
        return c;
    }

    public EventContext getCurrentEventContext() {
        return this.current();
    }

    public void invalidateCurrentEventContext() {
        BasicEventContext c = this.current();
        c.invalidate();
        if (log.isDebugEnabled()) {
            log.debug("Invalidated login: " + (Object)((Object)c));
        }
    }

    public Event newEvent(Session session, EventType type, TokenHolder tokenHolder) {
        BasicEventContext c = this.current();
        Event e = new Event();
        e.setType(type);
        e.setTime(new Timestamp(System.currentTimeMillis()));
        tokenHolder.setToken(e.getGraphHolder());
        e.getDetails().setPermissions(Permissions.READ_ONLY);
        e.setExperimenter(c.getOwner());
        e.setExperimenterGroup(c.getGroup());
        e.setSession(session);
        c.setEvent(e);
        return e;
    }

    public void addLog(String action, Class klass, Long id) {
        Assert.notNull((Object)action);
        Assert.notNull((Object)klass);
        Assert.notNull((Object)id);
        if (Event.class.isAssignableFrom(klass) || EventLog.class.isAssignableFrom(klass)) {
            if (log.isDebugEnabled()) {
                log.debug("Not logging creation of logging type:" + klass);
            }
            return;
        }
        if (!this.isReady()) {
            throw new InternalException("Not ready to add EventLog");
        }
        if (log.isInfoEnabled()) {
            log.info("Adding log:" + action + "," + klass + "," + id);
        }
        BasicEventContext c = this.current();
        List<EventLog> list = this.current().getLogs();
        if (list == null) {
            list = new ArrayList<EventLog>();
            c.setLogs(list);
        }
        EventLog l = new EventLog();
        l.setAction(action);
        l.setEntityType(klass.getName());
        l.setEntityId(id);
        l.setEvent(c.getEvent());
        Details d = Details.create();
        d.setPermissions(Permissions.WORLD_IMMUTABLE);
        l.getDetails().copy(d);
        list.add(l);
    }

    public SessionStats getStats() {
        return this.current().getStats();
    }

    public List<EventLog> getLogs() {
        ArrayList logs = this.current().getLogs();
        return logs == null ? new ArrayList() : logs;
    }

    public void clearLogs() {
        this.current().setLogs(null);
    }

    public Details createDetails() {
        BasicEventContext c = this.current();
        Details d = Details.create((Object[])new Object[]{c, c.getCallContext()});
        d.setCreationEvent(c.getEvent());
        d.setUpdateEvent(c.getEvent());
        d.setOwner(c.getOwner());
        d.setGroup(c.getGroup());
        Permissions groupPerms = c.getCurrentGroupPermissions();
        Permissions p = new Permissions(groupPerms);
        d.setPermissions(p);
        return d;
    }

    public void applyContext(Details details, boolean changePerms) {
        BasicEventContext c = this.current();
        details.setContexts(new Object[]{c, c.getCallContext()});
        if (changePerms) {
            Permissions groupPerms = c.getCurrentGroupPermissions();
            if (groupPerms != Permissions.DUMMY) {
                details.setPermissions(new Permissions(groupPerms));
            } else {
                ExperimenterGroup group = details.getGroup();
                if (group != null) {
                    Long gid = details.getGroup().getId();
                    Permissions p = c.getPermissionsForGroup(gid);
                    if (p != null) {
                        details.setPermissions(new Permissions(p));
                    } else if (gid.equals(this.roles.getUserGroupId())) {
                        details.setPermissions(new Permissions(Permissions.EMPTY));
                    } else {
                        throw new InternalException("No permissions: " + details);
                    }
                }
            }
        }
    }

    public void loadPermissions(org.hibernate.Session session) {
        this.current().loadPermissions(session);
    }

    public Experimenter getOwner() {
        return this.current().getOwner();
    }

    public Experimenter getSudoer() {
        return this.current().getSudoer();
    }

    public ExperimenterGroup getGroup() {
        return this.current().getGroup();
    }

    public Set<AdminPrivilege> getAdminPrivileges() {
        return this.current().getAdminPrivileges();
    }

    public Event getEvent() {
        return this.current().getEvent();
    }

    void setValues(Experimenter owner, Experimenter sudoer, ExperimenterGroup group, Permissions perms, boolean isAdmin, Set<AdminPrivilege> adminPrivileges, boolean isReadOnly, Long shareId) {
        BasicEventContext c = this.current();
        c.setOwner(owner);
        c.setSudoer(sudoer);
        c.setGroup(group, perms);
        c.setAdmin(isAdmin);
        c.setAdminPrivileges(adminPrivileges);
        c.setReadOnly(isReadOnly);
        c.setShareId(shareId);
    }

    void updateEvent(Event event) {
        this.current().setEvent(event);
    }

    public boolean isCurrentUserGuest() {
        return this.current().getCurrentUserId().longValue() == this.roles.getGuestId();
    }

    public void addCleanup(RegisterServiceCleanupMessage cleanup) {
        Set<RegisterServiceCleanupMessage> cleanups = this.current().getServiceCleanups();
        if (cleanups == null) {
            cleanups = new HashSet<RegisterServiceCleanupMessage>();
            this.current().setServiceCleanups(cleanups);
        }
        cleanups.add(cleanup);
    }

    public Set<RegisterServiceCleanupMessage> emptyCleanups() {
        Set<RegisterServiceCleanupMessage> set = this.current().getServiceCleanups();
        if (this.current().getServiceCleanups() == null) {
            return Collections.emptySet();
        }
        HashSet<RegisterServiceCleanupMessage> copy = new HashSet<RegisterServiceCleanupMessage>(set);
        set.clear();
        return copy;
    }

    public boolean addDisabled(String id) {
        Set<String> s = this.current().getDisabledSubsystems();
        if (s == null) {
            s = new HashSet<String>();
            this.current().setDisabledSubsystems(s);
        }
        return s.add(id);
    }

    public boolean addAllDisabled(String ... ids) {
        Set<String> s = this.current().getDisabledSubsystems();
        if (s == null) {
            s = new HashSet<String>();
            this.current().setDisabledSubsystems(s);
        }
        if (ids != null) {
            return Collections.addAll(s, ids);
        }
        return false;
    }

    public boolean removeDisabled(String id) {
        Set<String> s = this.current().getDisabledSubsystems();
        if (s != null && id != null) {
            return s.remove(id);
        }
        return false;
    }

    public boolean removeAllDisabled(String ... ids) {
        Set<String> s = this.current().getDisabledSubsystems();
        if (s != null && ids != null) {
            boolean changed = false;
            for (String string : ids) {
                changed |= s.remove(string);
            }
        }
        return false;
    }

    public void clearDisabled() {
        this.current().setDisabledSubsystems(null);
    }

    public boolean isDisabled(String id) {
        if (this.size() == 0) {
            return false;
        }
        Set<String> s = this.current().getDisabledSubsystems();
        return s != null && id != null && s.contains(id);
    }
}

