/*
 * Decompiled with CFR 0.152.
 */
package ome.services.fulltext;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import ome.services.fulltext.FullTextBridge;
import ome.services.fulltext.FullTextIndexer;
import ome.services.sessions.SessionManager;
import ome.services.util.ExecutionThread;
import ome.services.util.Executor;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.util.DetailsFieldBridge;
import ome.util.SqlAction;
import org.hibernate.Session;
import org.hibernate.search.bridge.FieldBridge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Deprecated
public class FullTextThread
extends ExecutionThread {
    private static final Logger log = LoggerFactory.getLogger(FullTextThread.class);
    private static final Principal DEFAULT_PRINCIPAL = new Principal("root", "system", "FullText");
    private static final Executor.Work<?> PREPARE_INDEXING = new Executor.SimpleWork((Object)"FullTextIndexer", "prepare", new Object[0]){

        @Override
        public synchronized void setSqlAction(SqlAction sql) {
            if (this.getSqlAction() == null) {
                super.setSqlAction(sql);
            }
        }

        @Override
        @Transactional(readOnly=false)
        public Object doWork(Session session, ServiceFactory sf) {
            this.getSqlAction().refreshEventLogFromUpdatedAnnotations();
            return null;
        }
    };
    protected final boolean waitForLock;
    protected final FullTextIndexer indexer;
    protected final FullTextBridge bridge;
    private boolean isactive = true;
    private final Lock activeLock = new ReentrantLock(true);

    public FullTextThread(SessionManager manager, Executor executor, FullTextIndexer indexer, FullTextBridge bridge) {
        this(manager, executor, indexer, bridge, DEFAULT_PRINCIPAL);
    }

    public FullTextThread(SessionManager manager, Executor executor, FullTextIndexer indexer, FullTextBridge bridge, boolean waitForLock) {
        this(manager, executor, indexer, bridge, DEFAULT_PRINCIPAL, waitForLock);
    }

    public FullTextThread(SessionManager manager, Executor executor, FullTextIndexer indexer, FullTextBridge bridge, Principal principal) {
        super(manager, executor, indexer, principal);
        Assert.notNull((Object)bridge);
        this.indexer = indexer;
        this.bridge = bridge;
        this.waitForLock = false;
    }

    public FullTextThread(SessionManager manager, Executor executor, FullTextIndexer indexer, FullTextBridge bridge, Principal principal, boolean waitForLock) {
        super(manager, executor, indexer, principal);
        Assert.notNull((Object)bridge);
        this.indexer = indexer;
        this.bridge = bridge;
        this.waitForLock = waitForLock;
    }

    public void start() {
        log.info("Initializing Full-Text Indexer");
    }

    @Override
    public void doRun() {
        boolean gotLock;
        this.activeLock.lock();
        try {
            if (!this.isactive) {
                log.info("Inactive; skipping");
                return;
            }
        }
        finally {
            this.activeLock.unlock();
        }
        HashMap<String, String> callContext = new HashMap<String, String>();
        callContext.put("omero.group", "-1");
        if (this.waitForLock) {
            DetailsFieldBridge.lock();
            gotLock = true;
        } else {
            gotLock = DetailsFieldBridge.tryLock();
        }
        if (gotLock) {
            try {
                DetailsFieldBridge.setFieldBridge((FieldBridge)this.bridge);
                this.executor.execute(callContext, this.getPrincipal(), PREPARE_INDEXING);
                this.executor.execute(callContext, this.getPrincipal(), this.work);
            }
            finally {
                DetailsFieldBridge.unlock();
            }
        } else {
            log.info("Currently running; skipping");
        }
    }

    public void stop() {
        log.info("Shutting down Full-Text Indexer");
        this.indexer.loader.setStop(true);
        boolean acquiredLock = false;
        try {
            acquiredLock = this.activeLock.tryLock(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("active lock acquisition interrupted.");
        }
        if (!acquiredLock) {
            log.error("Could not acquire active lock for indexer within 60 seconds. Overriding.");
        }
        if (!(acquiredLock = DetailsFieldBridge.tryLock())) {
            log.error("Could not acquire bridge lock. Waiting 60 seconds and aborting.");
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                log.warn("bridge lock acquisition interrupted.");
            }
        }
        this.isactive = false;
        if (acquiredLock) {
            DetailsFieldBridge.unlock();
        }
    }
}

