/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.PixelsData;
import omero.gateway.model.PlateData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.fsimporter.DataImporterLoader;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class ImportResultLoader
extends DataImporterLoader {
    private CallHandle handle;
    private final Collection<DataObject> ids;
    private final Class<?> nodeType;
    private Object comp;
    private List<Object> result;

    public ImportResultLoader(Importer viewer, SecurityContext ctx, Collection<DataObject> ids, Class<?> nodeType, Object comp) {
        super(viewer, ctx);
        if (CollectionUtils.isEmpty(ids) || nodeType == null) {
            throw new IllegalArgumentException("No data to load");
        }
        if (!PlateData.class.equals(nodeType) && !ThumbnailData.class.equals(nodeType)) {
            throw new IllegalArgumentException("Type not supported");
        }
        this.ids = ids;
        this.nodeType = nodeType;
        this.comp = comp;
    }

    @Override
    public void load() {
        if (this.nodeType.equals(PlateData.class)) {
            ArrayList<Long> objects = new ArrayList<Long>();
            for (PixelsData pixelsData : this.ids) {
                objects.add(pixelsData.getImage().getId());
            }
            this.handle = this.dmView.loadPlateFromImage(this.ctx, objects, this);
        } else if (this.nodeType.equals(ThumbnailData.class)) {
            this.handle = this.hiBrwView.loadThumbnails(this.ctx, this.ids, 96, 96, -1L, 0, this);
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        if (this.viewer.getState() == 5 || !ThumbnailData.class.equals(this.nodeType)) {
            return;
        }
        ThumbnailData td = (ThumbnailData)fe.getPartialResult();
        if (td != null) {
            if (this.result == null) {
                this.result = new ArrayList<Object>();
            }
            this.result.add(td);
            if (this.result.size() == this.ids.size()) {
                this.viewer.setImportResult(this.result, this.comp);
            }
        }
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 5 || !PlateData.class.equals(this.nodeType)) {
            return;
        }
        Map m = (Map)result;
        if (m.size() == 1) {
            Iterator i = m.values().iterator();
            while (i.hasNext()) {
                this.viewer.setImportResult(i.next(), this.comp);
            }
        }
    }
}

