/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import ome.xml.model.Experimenter;

public class ExperimenterListModel
extends DefaultListModel<String> {
    private List<Experimenter> exp = new ArrayList<Experimenter>();

    public Experimenter getExperimenterAt(int index) {
        Experimenter e = null;
        if (this.exp != null && this.exp.size() > 0) {
            e = this.exp.get(index);
        }
        return e;
    }

    @Override
    public void addElement(Experimenter e) {
        String name;
        if (this.exp == null) {
            this.exp = new ArrayList<Experimenter>();
        }
        if (e != null && (name = ExperimenterListModel.getExperimenterName(e)) != null && !name.equals("") && this.elementExists(name) == -1) {
            this.exp.add(e);
            this.addElement(name);
        }
    }

    public void addElement(int index, Experimenter e) {
        String name;
        if (index < this.exp.size() && (name = ExperimenterListModel.getExperimenterName(e)) != null && !name.equals("") && this.elementExists(name) == -1) {
            this.exp.set(index, e);
            this.set(index, name);
        }
    }

    public static String getExperimenterName(Experimenter e) {
        Object res = null;
        if (e != null) {
            String fName = e.getFirstName() != null && !e.getFirstName().equals("") ? e.getFirstName() : "";
            String lName = e.getLastName() != null && !e.getLastName().equals("") ? e.getLastName() : "";
            res = fName.equals("") ? lName : fName + " " + lName;
        }
        return res;
    }

    public List<Experimenter> getList() {
        ArrayList<Experimenter> list = new ArrayList<Experimenter>();
        for (int i = 0; i < this.getSize(); ++i) {
            list.add(this.getExperimenterAt(i));
        }
        return list;
    }

    public void setList(List<Experimenter> list) {
        this.exp = list;
    }

    public void replace(int editRow, Experimenter ex) {
        this.addElement(editRow, ex);
    }

    public void removeExperimenter(int index) {
        if (index < this.exp.size()) {
            this.exp.remove(index);
            this.remove(index);
        }
    }

    public int elementExists(String item) {
        for (int i = 0; i < this.getSize(); ++i) {
            Experimenter e = this.getExperimenterAt(i);
            String data = ExperimenterListModel.getExperimenterName(e);
            if (data == null || !data.toLowerCase().equals(item.toLowerCase())) continue;
            return i;
        }
        return -1;
    }
}

