/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.BooleanAnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DoubleAnnotationData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.LongAnnotationData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TermAnnotationData;
import omero.gateway.model.TimeAnnotationData;
import omero.gateway.model.XMLAnnotationData;
import omero.model.OriginalFile;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.DataObjectListCellRenderer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ToolTipGenerator;
import org.openmicroscopy.shoola.agents.util.editorpreview.PreviewPanel;
import org.openmicroscopy.shoola.agents.util.ui.EditorDialog;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadAndLaunchActivityParam;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.filter.file.BMPFilter;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.filter.file.JPEGFilter;
import org.openmicroscopy.shoola.util.filter.file.PNGFilter;
import org.openmicroscopy.shoola.util.filter.file.TIFFFilter;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialog;

class DocComponent
extends JPanel
implements ActionListener,
PropertyChangeListener {
    static final int LOAD_FROM_SERVER = 0;
    static final int LOAD_FROM_LOCAL = 1;
    private static final int REMOVE = 0;
    private static final int EDIT = 1;
    private static final int DOWNLOAD = 2;
    private static final int OPEN = 3;
    private static final ImmutableCollection<CustomizedFileFilter> FILTERS = ImmutableList.of((Object)new TIFFFilter(), (Object)new JPEGFilter(), (Object)new PNGFilter(), (Object)new BMPFilter());
    private static final int TEXT_LENGTH = 10;
    private Object data;
    private EditorModel model;
    private JMenuItem unlinkButton;
    private JMenuItem editButton;
    private JMenuItem downloadButton;
    private JMenuItem openButton;
    private JMenuItem infoButton;
    private JLabel label;
    private Point popupPoint;
    private String originalDescription;
    private String originalName;
    private JButton menuButton;
    private PreviewPanel preview;
    private int imageToLoad;
    private Icon thumbnail;
    private JPopupMenu popMenu;
    private boolean deletable;
    private boolean isModulo;
    private boolean selectable;
    private JCheckBox checkbox;

    private boolean setControlsEnabled(boolean enabled) {
        int count = 0;
        if (this.infoButton != null) {
            this.infoButton.setEnabled(true);
            this.infoButton.setVisible(true);
            ++count;
        }
        if (!enabled) {
            if (this.unlinkButton != null) {
                this.unlinkButton.setEnabled(false);
                this.unlinkButton.setVisible(false);
            }
            if (this.editButton != null) {
                this.editButton.setEnabled(false);
                this.editButton.setVisible(false);
            }
            if (this.downloadButton != null) {
                this.downloadButton.setEnabled(false);
                this.downloadButton.setVisible(false);
            }
            return count > 0;
        }
        boolean b = false;
        if (this.unlinkButton != null) {
            b = this.model.canDeleteLink(this.data);
            if (b && this.isModulo) {
                b = false;
            }
            this.unlinkButton.setEnabled(b);
            this.unlinkButton.setVisible(b);
            if (b) {
                ++count;
            }
        }
        if (this.editButton != null) {
            b = this.model.canEdit(this.data);
            this.editButton.setEnabled(b);
            this.editButton.setVisible(b);
            if (b) {
                ++count;
            }
        }
        if (this.downloadButton != null) {
            b = true;
            this.downloadButton.setEnabled(b);
            this.downloadButton.setVisible(b);
            if (b) {
                ++count;
            }
        }
        if (this.openButton != null) {
            b = true;
            this.openButton.setEnabled(b);
            this.openButton.setVisible(b);
            if (b) {
                ++count;
            }
        }
        return count > 0;
    }

    private void openFile() {
        if (!(this.data instanceof FileAnnotationData)) {
            return;
        }
        FileAnnotationData fa = (FileAnnotationData)this.data;
        Registry reg = MetadataViewerAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        OriginalFile f = (OriginalFile)fa.getContent();
        Environment env = (Environment)reg.lookup("/env");
        long dataId = fa.getId();
        File dir = new File(env.getOmeroFilesHome() + File.separatorChar + "file annotation " + dataId);
        if (!dir.exists()) {
            dir.mkdir();
        }
        DownloadAndLaunchActivityParam activity = f != null && f.isLoaded() ? new DownloadAndLaunchActivityParam(f, dir, null) : new DownloadAndLaunchActivityParam(dataId, 1, dir, null);
        un.notifyActivity(this.model.getSecurityContext(), activity);
    }

    private void showMenu(JComponent invoker, Point p) {
        if (this.popMenu == null) {
            this.popMenu = new JPopupMenu();
            if (this.editButton != null) {
                this.popMenu.add(this.editButton);
            }
            if (this.unlinkButton != null) {
                this.popMenu.add(this.unlinkButton);
            }
            if (this.downloadButton != null) {
                this.popMenu.add(this.downloadButton);
            }
            if (this.openButton != null) {
                this.popMenu.add(this.openButton);
            }
            if (this.infoButton != null) {
                this.popMenu.add(this.infoButton);
            }
        }
        this.popMenu.show(invoker, p.x, p.y);
    }

    private void displayInformation(JComponent invoker, Point p) {
        JComponent comp;
        String text = this.label.getToolTipText();
        if (text == null || text.trim().length() == 0) {
            return;
        }
        if (this.preview != null) {
            comp = this.preview;
        } else {
            JLabel l = new JLabel();
            l.setText(text);
            comp = l;
        }
        TinyDialog d = new TinyDialog(null, comp, 1);
        d.setModal(false);
        d.getContentPane().setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
        SwingUtilities.convertPointToScreen(p, invoker);
        d.pack();
        d.setLocation(p);
        d.setVisible(true);
    }

    private void checkAnnotators(ToolTipGenerator tt, AnnotationData annotation) {
        List<ExperimenterData> annotators = this.model.getAnnotators(annotation);
        if (annotators.size() == 0) {
            return;
        }
        Iterator<ExperimenterData> i = annotators.iterator();
        tt.addLine("Linked by:", true);
        while (i.hasNext()) {
            ExperimenterData annotator = i.next();
            tt.addLine(EditorUtil.formatExperimenter(annotator));
        }
        if (annotators.size() > 1) {
            Object text = this.label.getText();
            text = (String)text + " [" + annotators.size() + "]";
            this.label.setText((String)text);
        }
    }

    private String formatAnnotators(DataObject object, AnnotationData annotation) {
        StringBuffer buffer = new StringBuffer();
        List<ExperimenterData> annotators = this.model.getAnnotators(object, annotation);
        if (annotators.size() == 0) {
            return null;
        }
        long userID = this.model.getCurrentUser().getId();
        Iterator<ExperimenterData> i = annotators.iterator();
        int n = annotators.size() - 1;
        int index = 0;
        buffer.append(" (");
        while (i.hasNext()) {
            ExperimenterData annotator = i.next();
            if (annotator.getId() == userID) continue;
            buffer.append(EditorUtil.formatExperimenter(annotator));
            if (index != n) {
                buffer.append(", ");
            }
            ++index;
        }
        if (index == 0) {
            return null;
        }
        buffer.append(")");
        return buffer.toString();
    }

    private String formatToolTip(AnnotationData annotation, String name) {
        Timestamp created;
        String desc;
        String ns;
        ToolTipGenerator tt = new ToolTipGenerator();
        if (this.model.isMultiSelection()) {
            Map<DataObject, Boolean> m = null;
            Object text = "";
            if (annotation instanceof TagAnnotationData) {
                m = this.model.getTaggedObjects(annotation);
                text = (String)text + "Can remove Tag from ";
            } else if (annotation instanceof FileAnnotationData) {
                m = this.model.getObjectsWith(annotation);
                text = (String)text + "Can remove Attachment from ";
            } else if (annotation instanceof XMLAnnotationData) {
                m = this.model.getObjectsWith(annotation);
                text = (String)text + "Can remove XML files from ";
            } else if (annotation instanceof TermAnnotationData) {
                m = this.model.getObjectsWith(annotation);
                text = (String)text + "Can remove Term from ";
            }
            if (m == null) {
                return "";
            }
            Iterator<Map.Entry<DataObject, Boolean>> j = m.entrySet().iterator();
            Collection<Boolean> l = m.values();
            int n = 0;
            Iterator<Boolean> k = l.iterator();
            while (k.hasNext()) {
                if (!k.next().booleanValue()) continue;
                ++n;
            }
            tt.addLineNoBr((String)text + n + " ");
            int index = 0;
            while (j.hasNext()) {
                Map.Entry<DataObject, Boolean> e = j.next();
                if (index == 0) {
                    tt.addLine(this.model.getObjectTypeAsString(e.getKey()) + "s", true);
                    ++index;
                }
                tt.addLine("ID " + e.getKey().getId(), UIUtilities.formatPartialName(this.model.getObjectName(e.getKey())), true);
                String s = this.formatAnnotators(e.getKey(), annotation);
                if (s == null) continue;
                tt.addLine(s);
            }
            return tt.toString();
        }
        if (name != null) {
            tt.addLine("Name", name, true);
        }
        ExperimenterData exp = null;
        if (annotation.getId() > 0L) {
            exp = this.model.getOwner(annotation);
            tt.addLine("ID", "" + annotation.getId(), true);
        }
        if (!CommonsLangUtils.isEmpty(ns = annotation.getNameSpace()) && !EditorUtil.isInternalNS(ns)) {
            tt.addLine("Namespace", ns, true);
        }
        if (!CommonsLangUtils.isEmpty(desc = annotation.getDescription())) {
            tt.addLine("Description", desc, true);
        }
        if (exp != null) {
            tt.addLine("Owner", EditorUtil.formatExperimenter(exp), true);
        }
        if ((created = annotation.getCreated()) != null) {
            tt.addLine("Date", UIUtilities.formatDefaultDate(created), true);
        }
        if (this.data instanceof FileAnnotationData) {
            FileAnnotationData fa = (FileAnnotationData)this.data;
            long size = ((FileAnnotationData)annotation).getFileSize();
            tt.addLine("File ID", "" + fa.getFileID(), true);
            tt.addLine("Size", UIUtilities.formatFileSize(size), true);
            this.checkAnnotators(tt, annotation);
        } else if (this.data instanceof TagAnnotationData || this.data instanceof XMLAnnotationData || this.data instanceof TermAnnotationData || this.data instanceof LongAnnotationData || this.data instanceof DoubleAnnotationData || this.data instanceof BooleanAnnotationData) {
            this.checkAnnotators(tt, annotation);
        }
        return tt.toString();
    }

    private void initButtons() {
        IconManager icons = IconManager.getInstance();
        this.menuButton = new JButton(icons.getIcon(96));
        UIUtilities.unifiedButtonLookAndFeel(this.menuButton);
        this.menuButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.menuButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DocComponent.this.showMenu(DocComponent.this.menuButton, e.getPoint());
            }
        });
        this.infoButton = new JMenuItem(icons.getIcon(19));
        this.infoButton.setText("Info...");
        this.infoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DocComponent.this.popMenu.setVisible(false);
                DocComponent.this.displayInformation(DocComponent.this.label, e.getPoint());
            }
        });
        this.unlinkButton = new JMenuItem(icons.getIcon(57));
        this.unlinkButton.setText("Remove");
        this.unlinkButton.addActionListener(this);
        this.unlinkButton.setActionCommand("0");
        if (this.data instanceof FileAnnotationData) {
            FileAnnotationData fa = (FileAnnotationData)this.data;
            this.unlinkButton.setToolTipText("Remove the file.");
            if (fa.getId() > 0L) {
                this.unlinkButton.setEnabled(this.deletable);
                this.downloadButton = new JMenuItem(icons.getIcon(59));
                this.downloadButton.setText("Download...");
                this.downloadButton.setToolTipText("Download the selected file.");
                this.downloadButton.setActionCommand("2");
                this.downloadButton.addActionListener(this);
                String ns = fa.getNameSpace();
                this.openButton = new JMenuItem(icons.getIcon(121));
                this.openButton.setText("View");
                this.openButton.setToolTipText("View the file.");
                this.openButton.setActionCommand("3");
                this.openButton.addActionListener(this);
                if ("openmicroscopy.org/omero/import/companionFile".equals(ns) || "openmicroscopy.org/omero/measurement".equals(ns)) {
                    this.unlinkButton = null;
                }
            }
        } else if (this.data instanceof TagAnnotationData || this.data instanceof XMLAnnotationData || this.data instanceof TermAnnotationData || this.data instanceof LongAnnotationData || this.data instanceof DoubleAnnotationData || this.data instanceof BooleanAnnotationData) {
            this.unlinkButton.setToolTipText("Remove the annotation.");
            this.editButton = new JMenuItem(icons.getIcon(54));
            if (this.isModulo) {
                this.editButton.setText("View");
            } else {
                this.editButton.setText("Edit");
            }
            this.editButton.setActionCommand("1");
            this.editButton.addActionListener(this);
            this.editButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    DocComponent.this.popupPoint = e.getPoint();
                }
            });
        }
    }

    private void initComponents() {
        this.isModulo = this.model.isModulo(this.data);
        this.imageToLoad = -1;
        this.initButtons();
        this.label = new JLabel();
        this.label.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        this.checkbox = new JCheckBox();
        if (this.data == null) {
            this.label.setText("None");
        } else if (this.data instanceof FileAnnotationData) {
            String fileName;
            FileAnnotationData f = (FileAnnotationData)this.data;
            String s = fileName = f.getFileName();
            if ("openmicroscopy.org/omero/measurement".equals(f.getNameSpace())) {
                String desc = f.getDescription();
                if (desc != null && desc.trim().length() > 0) {
                    this.label.setText(desc);
                } else {
                    this.label.setText(UIUtilities.formatPartialName(EditorUtil.getPartialName(fileName)));
                }
                s = this.label.getText();
            } else {
                this.label.setText(UIUtilities.formatPartialName(EditorUtil.getPartialName(fileName)));
            }
            this.label.setToolTipText(this.formatToolTip(f, s));
            UnmodifiableIterator i = FILTERS.iterator();
            long id = f.getId();
            while (i.hasNext()) {
                CustomizedFileFilter filter = (CustomizedFileFilter)i.next();
                if (!filter.accept(fileName)) continue;
                this.imageToLoad = id > 0L ? 0 : 1;
                break;
            }
            if (id < 0L) {
                this.label.setForeground(DataObjectListCellRenderer.NEW_FOREGROUND_COLOR);
            }
            switch (this.imageToLoad) {
                case 1: {
                    if (this.thumbnail != null) break;
                    this.setThumbnail(f.getFilePath());
                }
            }
        } else if (this.data instanceof File) {
            File f = (File)this.data;
            this.label.setText(EditorUtil.getPartialName(f.getName()));
            this.label.setForeground(Color.BLUE);
        } else if (this.data instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)this.data;
            this.label.setText(tag.getTagValue());
            this.label.setToolTipText(this.formatToolTip(tag, null));
            if (tag.getId() < 0L) {
                this.label.setForeground(DataObjectListCellRenderer.NEW_FOREGROUND_COLOR);
            }
        } else if (this.data instanceof XMLAnnotationData) {
            XMLAnnotationData tag = (XMLAnnotationData)this.data;
            this.label.setText(EditorUtil.truncate(tag.getText(), 10, false));
            this.label.setToolTipText(this.formatToolTip(tag, null));
            if (tag.getId() < 0L) {
                this.label.setForeground(DataObjectListCellRenderer.NEW_FOREGROUND_COLOR);
            }
        } else if (this.data instanceof TermAnnotationData) {
            TermAnnotationData tag = (TermAnnotationData)this.data;
            this.label.setText(tag.getTerm());
            this.label.setToolTipText(this.formatToolTip(tag, null));
            if (tag.getId() < 0L) {
                this.label.setForeground(DataObjectListCellRenderer.NEW_FOREGROUND_COLOR);
            }
        } else if (this.data instanceof LongAnnotationData) {
            LongAnnotationData tag = (LongAnnotationData)this.data;
            this.label.setText(tag.getContentAsString());
            this.label.setToolTipText(this.formatToolTip(tag, null));
            if (tag.getId() < 0L) {
                this.label.setForeground(DataObjectListCellRenderer.NEW_FOREGROUND_COLOR);
            }
        } else if (this.data instanceof DoubleAnnotationData) {
            DoubleAnnotationData tag = (DoubleAnnotationData)this.data;
            this.label.setText(tag.getContentAsString());
            this.label.setToolTipText(this.formatToolTip(tag, null));
            if (tag.getId() < 0L) {
                this.label.setForeground(DataObjectListCellRenderer.NEW_FOREGROUND_COLOR);
            }
        } else if (this.data instanceof BooleanAnnotationData) {
            BooleanAnnotationData tag = (BooleanAnnotationData)this.data;
            this.label.setText(tag.getContentAsString());
            this.label.setToolTipText(this.formatToolTip(tag, null));
            if (tag.getId() < 0L) {
                this.label.setForeground(DataObjectListCellRenderer.NEW_FOREGROUND_COLOR);
            }
        } else if (this.data instanceof TimeAnnotationData) {
            TimeAnnotationData tag = (TimeAnnotationData)this.data;
            this.label.setText(tag.getContentAsString());
            this.label.setToolTipText(this.formatToolTip(tag, null));
            if (tag.getId() < 0L) {
                this.label.setForeground(DataObjectListCellRenderer.NEW_FOREGROUND_COLOR);
            }
        }
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 1 && e.isPopupTrigger()) {
                    DocComponent.this.showMenu(DocComponent.this.label, e.getPoint());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DocComponent.this.showMenu(DocComponent.this.label, e.getPoint());
                }
            }
        });
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new FlowLayout(0, 0, 0));
        if (this.selectable) {
            this.add(this.checkbox);
        }
        this.add(this.label);
        JToolBar bar = new JToolBar();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.setOpaque(true);
        boolean b = this.setControlsEnabled(this.data != null);
        int count = 0;
        if (this.editButton != null) {
            ++count;
        }
        if (this.unlinkButton != null) {
            ++count;
        }
        if (this.downloadButton != null) {
            ++count;
        }
        if (this.infoButton != null) {
            ++count;
        }
        if (this.openButton != null) {
            ++count;
        }
        if (count > 0 && this.data != null) {
            this.menuButton.setEnabled(true);
            if (this.model.isAcrossGroups()) {
                this.menuButton.setEnabled(false);
            }
            bar.add(this.menuButton);
            if (!b) {
                bar.add(Box.createHorizontalStrut(8));
            }
            this.add(bar);
        }
    }

    private void editDescription() {
        String text;
        if (!(this.data instanceof AnnotationData)) {
            return;
        }
        this.originalDescription = text = this.model.getAnnotationDescription((AnnotationData)this.data);
        SwingUtilities.convertPointToScreen(this.popupPoint, this);
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        int type = 1;
        if (this.isModulo) {
            type = 2;
        }
        EditorDialog d = new EditorDialog(f, (AnnotationData)this.data, false, type);
        if (this.isModulo) {
            d.allowEdit(false);
        }
        d.addPropertyChangeListener(this);
        d.setOriginalDescription(this.originalDescription);
        d.setSize(300, 250);
        UIUtilities.showOnScreen(d, this.popupPoint);
    }

    private void download() {
        String name = null;
        if (this.data instanceof FileAnnotationData) {
            name = ((FileAnnotationData)this.data).getFileName();
        }
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(f, 1, "Download", "Select where to download the file.", null, true, true);
        if (CommonsLangUtils.isNotBlank(name)) {
            chooser.setSelectedFileFull(name);
        }
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(77));
        chooser.setApproveButtonText("Download");
        chooser.addPropertyChangeListener(this);
        chooser.centerDialog();
    }

    DocComponent(Object data, EditorModel model, boolean deletable, boolean selectable) {
        if (model == null) {
            throw new IllegalArgumentException("No Model.");
        }
        this.originalDescription = null;
        this.model = model;
        this.data = data;
        this.deletable = deletable;
        this.selectable = selectable;
        this.initComponents();
        this.buildGUI();
    }

    DocComponent(Object data, EditorModel model) {
        this(data, model, true, false);
    }

    boolean hasThumbnailToLoad() {
        return false;
    }

    public Object getData() {
        return this.data;
    }

    boolean hasBeenModified() {
        if (this.originalName == null) {
            return false;
        }
        if (this.data instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)this.data;
            if (!this.originalName.equals(tag.getTagValue())) {
                return true;
            }
            String txt = tag.getTagDescription();
            if (txt != null) {
                return !this.originalDescription.equals(txt);
            }
            return false;
        }
        return false;
    }

    boolean isImageLoaded() {
        return this.thumbnail != null;
    }

    boolean isSelected() {
        return this.selectable && this.checkbox.isSelected();
    }

    boolean canUnlink() {
        if (this.unlinkButton == null) {
            return false;
        }
        return this.unlinkButton.isVisible();
    }

    void setThumbnail(String path) {
        if (path == null) {
            return;
        }
        this.thumbnail = Factory.createIcon(path, 48, 48);
        if (this.thumbnail != null) {
            this.label.setText("");
            this.label.setIcon(this.thumbnail);
            this.label.repaint();
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.firePropertyChange("removeAnnotation", null, this);
                break;
            }
            case 1: {
                this.editDescription();
                break;
            }
            case 2: {
                this.download();
            }
            case 3: {
                this.openFile();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("createNoParent".equals(name)) {
            Object text = "";
            String description = "";
            AnnotationData annotation = null;
            if (this.data instanceof TagAnnotationData || this.data instanceof TermAnnotationData || this.data instanceof XMLAnnotationData) {
                annotation = (AnnotationData)this.data;
                text = annotation.getContentAsString();
                text = EditorUtil.truncate((String)text, 10, false);
            }
            if (this.data instanceof DoubleAnnotationData) {
                annotation = (AnnotationData)this.data;
                text = "" + ((DoubleAnnotationData)this.data).getDataValue();
            }
            if (this.data instanceof LongAnnotationData) {
                annotation = (AnnotationData)this.data;
                text = "" + ((LongAnnotationData)this.data).getDataValue();
            }
            if (this.data instanceof BooleanAnnotationData) {
                annotation = (AnnotationData)this.data;
                text = "" + ((BooleanAnnotationData)this.data).getValue();
            }
            description = this.model.getAnnotationDescription(annotation);
            if (annotation == null) {
                return;
            }
            this.label.setText((String)text);
            this.label.setToolTipText(this.formatToolTip(annotation, null));
            this.originalName = text;
            this.originalDescription = description;
            this.firePropertyChange("editTag", null, this);
        } else if ("approveSelection".equals(name)) {
            File folder;
            if (this.data == null) {
                return;
            }
            FileAnnotationData fa = (FileAnnotationData)this.data;
            OriginalFile f = (OriginalFile)fa.getContent();
            Object o = evt.getNewValue();
            if (o instanceof String) {
                Object path = (String)o;
                if (!((String)path).endsWith(File.separator)) {
                    path = (String)path + File.separator;
                }
                path = (String)path + fa.getFileName();
                folder = new File((String)path);
            } else {
                File[] files = (File[])o;
                folder = files[0];
            }
            if (folder == null) {
                folder = UIUtilities.getDefaultFolder();
            }
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            IconManager icons = IconManager.getInstance();
            DownloadActivityParam activity = new DownloadActivityParam(f, folder, icons.getIcon(76));
            activity.setLegend(fa.getDescription());
            un.notifyActivity(this.model.getSecurityContext(), activity);
        }
    }
}

