/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import com.google.common.base.CharMatcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class EditableTextComponent
extends JPanel {
    public static final int DEFAULT_NUMBER_OF_CHARACTERS = 30;
    public static final String EDIT_PROPERTY = "EDIT_PROPERTY";
    private static final Border EDIT_BORDER_BLACK = BorderFactory.createLineBorder(Color.BLACK);
    private JToggleButton editButton;
    private JTextArea textPane;
    private Border defaultBorder;
    private String originalText;
    private String text;
    private int showCharacters;
    private boolean permitEmpty;
    private ItemListener buttonListener;
    private String tooltip;

    public EditableTextComponent(boolean modifiable, boolean permitEmpty, String tooltip) {
        this("", 30, modifiable, permitEmpty, tooltip);
    }

    public EditableTextComponent(String text, int showCharacters, boolean modifiable, boolean permitEmpty, String tooltip) {
        this.showCharacters = showCharacters;
        this.permitEmpty = permitEmpty;
        this.tooltip = tooltip;
        this.initComponent();
        this.buildUI(text, modifiable);
    }

    private void initComponent() {
        this.textPane = new JTextArea();
        this.textPane.setOpaque(false);
        this.textPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.textPane.setEditable(false);
        Font f = this.textPane.getFont();
        this.textPane.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (arg0.getKeyCode() == 10) {
                    EditableTextComponent.this.save();
                }
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }
        });
        this.defaultBorder = this.textPane.getBorder();
        this.textPane.setFont(f.deriveFont(1));
        IconManager icons = IconManager.getInstance();
        this.editButton = new JToggleButton(icons.getIcon(54));
        this.editButton.setOpaque(false);
        UIUtilities.unifiedButtonLookAndFeel(this.editButton);
        this.editButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        if (this.tooltip != null) {
            this.editButton.setToolTipText(this.tooltip);
        }
        this.buttonListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JToggleButton b = (JToggleButton)e.getSource();
                if (b.isSelected()) {
                    EditableTextComponent.this.editField(true);
                } else {
                    EditableTextComponent.this.save();
                    EditableTextComponent.this.editField(false);
                }
            }
        };
        this.editButton.addItemListener(this.buttonListener);
    }

    protected void buildUI(String text, boolean modifiable) {
        this.originalText = text;
        this.text = text;
        this.removeAll();
        this.editButton.setEnabled(modifiable);
        this.textPane.setEditable(modifiable);
        this.textPane.setText(UIUtilities.formatPartialName(text, this.showCharacters));
        this.textPane.setToolTipText(text);
        this.textPane.setLineWrap(false);
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        this.add((Component)this.textPane, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 13;
        this.add((Component)this.editButton, c);
        this.editField(false);
    }

    private void editField(boolean edit) {
        if (edit) {
            this.textPane.setEditable(true);
            this.textPane.setLineWrap(true);
            this.textPane.setText(this.text);
            this.textPane.setBorder(EDIT_BORDER_BLACK);
            this.textPane.setMaximumSize(this.textPane.getSize());
            this.textPane.requestFocus();
            this.textPane.select(0, 0);
            this.textPane.setCaretPosition(0);
        } else {
            this.textPane.setEditable(false);
            this.textPane.setLineWrap(false);
            this.textPane.setText(UIUtilities.formatPartialName(this.text, this.showCharacters));
            this.textPane.setBorder(this.defaultBorder);
            this.textPane.setMaximumSize(this.textPane.getSize());
            this.editButton.removeItemListener(this.buttonListener);
            this.editButton.setSelected(false);
            this.editButton.addItemListener(this.buttonListener);
        }
    }

    private void save() {
        this.text = CharMatcher.javaIsoControl().removeFrom((CharSequence)this.textPane.getText());
        if (this.text.trim().isEmpty() && !this.permitEmpty) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditableTextComponent.this.text = EditableTextComponent.this.originalText;
                    EditableTextComponent.this.editField(false);
                }
            });
            return;
        }
        this.firePropertyChange(EDIT_PROPERTY, this.originalText, this.text);
        this.originalText = this.text;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditableTextComponent.this.editField(false);
            }
        });
    }

    void setText(String text) {
        this.text = text;
        this.originalText = text;
        this.textPane.setText(UIUtilities.formatPartialName(text, this.showCharacters));
    }
}

