/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.usermodel;

import loci.poi.hssf.record.PaletteRecord;
import loci.poi.hssf.util.HSSFColor;

public class HSSFPalette {
    private PaletteRecord palette;

    protected HSSFPalette(PaletteRecord palette) {
        this.palette = palette;
    }

    public HSSFColor getColor(short index) {
        if (index == 64) {
            return HSSFColor.AUTOMATIC.getInstance();
        }
        byte[] b = this.palette.getColor(index);
        if (b != null) {
            return new CustomColor(index, b);
        }
        return null;
    }

    public HSSFColor findColor(byte red, byte green, byte blue) {
        byte[] b = this.palette.getColor((short)8);
        short i = 8;
        while (b != null) {
            if (b[0] == red && b[1] == green && b[2] == blue) {
                return new CustomColor(i, b);
            }
            i = (short)(i + 1);
            b = this.palette.getColor(i);
        }
        return null;
    }

    public HSSFColor findSimilarColor(byte red, byte green, byte blue) {
        HSSFColor result = null;
        int minColorDistance = Integer.MAX_VALUE;
        byte[] b = this.palette.getColor((short)8);
        short i = 8;
        while (b != null) {
            int colorDistance = red - b[0] + green - b[1] + blue - b[2];
            if (colorDistance < minColorDistance) {
                result = this.getColor(i);
            }
            i = (short)(i + 1);
            b = this.palette.getColor(i);
        }
        return result;
    }

    public void setColorAtIndex(short index, byte red, byte green, byte blue) {
        this.palette.setColor(index, red, green, blue);
    }

    public HSSFColor addColor(byte red, byte green, byte blue) {
        byte[] b = this.palette.getColor((short)8);
        for (short i = 8; i < 64; i = (short)(i + 1)) {
            if (b == null) {
                this.setColorAtIndex(i, red, green, blue);
                return this.getColor(i);
            }
            b = this.palette.getColor(i);
        }
        throw new RuntimeException("Could not find free color index");
    }

    private static class CustomColor
    extends HSSFColor {
        private short byteOffset;
        private byte red;
        private byte green;
        private byte blue;

        private CustomColor(short byteOffset, byte[] colors) {
            this(byteOffset, colors[0], colors[1], colors[2]);
        }

        private CustomColor(short byteOffset, byte red, byte green, byte blue) {
            this.byteOffset = byteOffset;
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        @Override
        public short getIndex() {
            return this.byteOffset;
        }

        @Override
        public short[] getTriplet() {
            return new short[]{(short)(this.red & 0xFF), (short)(this.green & 0xFF), (short)(this.blue & 0xFF)};
        }

        @Override
        public String getHexString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getGnumericPart(this.red));
            sb.append(':');
            sb.append(this.getGnumericPart(this.green));
            sb.append(':');
            sb.append(this.getGnumericPart(this.blue));
            return sb.toString();
        }

        private String getGnumericPart(byte color) {
            String s;
            if (color == 0) {
                s = "0";
            } else {
                int c = color & 0xFF;
                c = c << 8 | c;
                s = Integer.toHexString(c).toUpperCase();
                while (s.length() < 4) {
                    s = "0" + s;
                }
            }
            return s;
        }
    }
}

