/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.poifs.storage;

import java.io.IOException;
import java.io.InputStream;
import loci.poi.poifs.filesystem.OfficeXmlFileException;
import loci.poi.poifs.storage.HeaderBlockConstants;
import loci.poi.util.IOUtils;
import loci.poi.util.IntegerField;
import loci.poi.util.LittleEndian;
import loci.poi.util.LongField;

public class HeaderBlockReader
implements HeaderBlockConstants {
    private IntegerField _bat_count;
    private IntegerField _property_start;
    private IntegerField _sbat_start;
    private IntegerField _xbat_start;
    private IntegerField _xbat_count;
    private byte[] _data;
    private int batsInHeader;

    public HeaderBlockReader(InputStream stream, int blockSize) throws IOException {
        this.batsInHeader = (blockSize - 76) / 4;
        this._data = new byte[blockSize];
        int byte_count = IOUtils.readFully(stream, this._data);
        if (byte_count != blockSize) {
            if (byte_count == -1) {
                byte_count = 0;
            }
            String type = " byte" + (byte_count == 1 ? "" : "s");
            throw new IOException("Unable to read entire header; " + byte_count + type + " read; expected " + blockSize + " bytes");
        }
        LongField signature = new LongField(0, this._data);
        if (signature.get() != -2226271756974174256L) {
            if (this._data[0] == 80 && this._data[1] == 75 && this._data[2] == 3 && this._data[3] == 4) {
                throw new OfficeXmlFileException("The supplied data appears to be in the Office 2007+ XML. POI only supports OLE2 Office documents");
            }
            throw new IOException("Invalid header signature; read " + signature.get() + ", expected " + -2226271756974174256L);
        }
        this._bat_count = new IntegerField(44, this._data);
        this._property_start = new IntegerField(48, this._data);
        this._sbat_start = new IntegerField(60, this._data);
        this._xbat_start = new IntegerField(68, this._data);
        this._xbat_count = new IntegerField(72, this._data);
    }

    public int getPropertyStart() {
        return this._property_start.get();
    }

    public int getSBATStart() {
        return this._sbat_start.get();
    }

    public int getBATCount() {
        return this._bat_count.get();
    }

    public int[] getBATArray() {
        int[] result = new int[this.batsInHeader];
        int offset = 76;
        for (int j = 0; j < this.batsInHeader; ++j) {
            result[j] = LittleEndian.getInt(this._data, offset);
            offset += 4;
        }
        return result;
    }

    public int getXBATCount() {
        return this._xbat_count.get();
    }

    public int getXBATIndex() {
        return this._xbat_start.get();
    }
}

