/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PermissionData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.WellData;
import omero.gateway.model.WellSampleData;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailProvider;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class DataBrowserTranslator {
    private static final String LEFT = "[";
    private static final String RIGHT = "]";

    private static void formatToolTipFor(ImageDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node");
        }
        String toolTip = UIUtilities.formatToolTipText(node.getTitle());
        node.getTitleBar().setToolTipText(toolTip);
    }

    private static ImageDisplay getFirstElement(Set set) {
        if (set == null || set.size() == 0) {
            return null;
        }
        ImageDisplay display = null;
        Iterator i = set.iterator();
        if (i.hasNext()) {
            display = (ImageDisplay)i.next();
        }
        return display;
    }

    private static ImageNode linkImageTo(ImageData is, ImageSet parent) {
        long id = is.getId();
        String name = "";
        if (id >= 0L) {
            name = is.getName();
        }
        ThumbnailProvider provider = new ThumbnailProvider(is);
        ImageNode node = new ImageNode(name, is, provider);
        provider.setImageNode(node);
        if (parent != null) {
            parent.addChildDisplay(node);
        }
        return node;
    }

    private static ImageNode linkExperimenterTo(ExperimenterData is, ImageSet parent) {
        long id = is.getId();
        Object name = "";
        if (id >= 0L) {
            name = is.getFirstName() + " " + is.getLastName();
        }
        ThumbnailProvider provider = new ThumbnailProvider(is);
        ImageNode node = new ImageNode((String)name, is, provider);
        provider.setImageNode(node);
        if (parent != null) {
            parent.addChildDisplay(node);
        }
        return node;
    }

    private static ImageNode linkFileTo(FileData is, ImageSet parent) {
        long id = is.getId();
        String name = "";
        if (id >= 0L) {
            name = is.getName();
        }
        ThumbnailProvider provider = new ThumbnailProvider(is);
        ImageNode node = new ImageNode(name, is, provider);
        provider.setImageNode(node);
        if (parent != null) {
            parent.addChildDisplay(node);
        }
        return node;
    }

    private static void linkImagesTo(Set images, ImageSet parent) {
        if (images == null || parent == null) {
            return;
        }
        for (ImageData child : images) {
            DataBrowserTranslator.linkImageTo(child, parent);
        }
    }

    private static ImageDisplay linkImages(DataObject uo) {
        ImageSet node = null;
        if (uo instanceof DatasetData) {
            DatasetData ds = (DatasetData)uo;
            Set<ImageData> images = ds.getImages();
            Object note = "";
            if (images != null) {
                note = LEFT + images.size() + RIGHT;
            }
            node = new ImageSet(ds.getName(), (String)note, ds);
            DataBrowserTranslator.formatToolTipFor(node);
            DataBrowserTranslator.linkImagesTo(images, node);
        }
        return node;
    }

    private static Set transformProjects(Set projects) {
        if (projects == null) {
            throw new IllegalArgumentException("No projects.");
        }
        HashSet<ImageSet> results = new HashSet<ImageSet>();
        for (ProjectData ps : projects) {
            StringBuffer buffer = new StringBuffer();
            Set<DatasetData> datasets = ps.getDatasets();
            if (datasets != null) {
                buffer.append(LEFT);
                buffer.append(datasets.size());
                buffer.append(RIGHT);
            }
            ImageSet project = new ImageSet(ps.getName(), buffer.toString(), ps);
            DataBrowserTranslator.formatToolTipFor(project);
            if (datasets != null) {
                for (DataObject dataObject : datasets) {
                    project.addChildDisplay(DataBrowserTranslator.linkImages(dataObject));
                }
            }
            results.add(project);
        }
        return results;
    }

    private static ImageDisplay transformWell(WellData data) {
        if (data == null) {
            throw new IllegalArgumentException("No well.");
        }
        WellImageSet node = new WellImageSet(data);
        List<WellSampleData> samples = data.getWellSamples();
        int index = 0;
        if (samples == null || samples.size() == 0) {
            ImageData img = new ImageData();
            img.setId(-1L);
            WellSampleData wsd = new WellSampleData();
            wsd.setId(-1L);
            wsd.setImage(img);
            WellSampleNode child = DataBrowserTranslator.createWellImage(wsd, index, node);
            node.addWellSample(child);
        } else {
            for (WellSampleData wsd : samples) {
                ImageData img = wsd.getImage();
                WellSampleNode child = DataBrowserTranslator.createWellImage(wsd, index, node);
                node.addWellSample(child);
                ++index;
            }
        }
        return node;
    }

    private static WellSampleNode createWellImage(WellSampleData wsd, int index, WellImageSet parent) {
        String name = "";
        ImageData is = wsd.getImage();
        if (is != null && is.getId() >= 0L) {
            name = is.getName();
        }
        ThumbnailProvider provider = new ThumbnailProvider(is);
        WellSampleNode node = new WellSampleNode(name, wsd, provider, index, parent);
        provider.setImageNode(node);
        return node;
    }

    private static ImageDisplay transformTag(TagAnnotationData tag) {
        if (tag == null) {
            throw new IllegalArgumentException("No tag.");
        }
        ImageSet data = null;
        Set<TagAnnotationData> tags = tag.getTags();
        Set<DataObject> dataObjects = tag.getDataObjects();
        Object note = "";
        if (tags != null && tags.size() > 0) {
            note = (String)note + LEFT + tags.size() + RIGHT;
            data = new ImageSet(tag.getTagValue(), (String)note, tag);
            for (TagAnnotationData tagAnnotationData : tags) {
                data.addChildDisplay(DataBrowserTranslator.transformTag(tagAnnotationData));
            }
        }
        if (dataObjects != null && dataObjects.size() > 0) {
            note = (String)note + LEFT + dataObjects.size() + RIGHT;
            data = new ImageSet(tag.getTagValue(), (String)note, tag);
            for (DataObject dataObject : dataObjects) {
                ProjectData p;
                Set<DatasetData> datasets;
                if (dataObject instanceof ImageData) {
                    DataBrowserTranslator.linkImageTo((ImageData)dataObject, data);
                    continue;
                }
                if (dataObject instanceof DatasetData) {
                    data.addChildDisplay(DataBrowserTranslator.linkImages(dataObject));
                    continue;
                }
                if (!(dataObject instanceof ProjectData) || (datasets = (p = (ProjectData)dataObject).getDatasets()) == null) continue;
                for (DataObject dataObject2 : datasets) {
                    data.addChildDisplay(DataBrowserTranslator.linkImages(dataObject2));
                }
            }
        } else {
            data = new ImageSet(tag.getTagValue(), "", tag);
        }
        DataBrowserTranslator.formatToolTipFor(data);
        return data;
    }

    private static Set transformProject(DataObject project) {
        HashSet<DataObject> set = new HashSet<DataObject>(1);
        set.add(project);
        return DataBrowserTranslator.transformProjects(set);
    }

    private static Set transformDatasets(Set datasets) {
        if (datasets == null) {
            throw new IllegalArgumentException("No datasets.");
        }
        HashSet<ImageDisplay> results = new HashSet<ImageDisplay>();
        for (DataObject ho : datasets) {
            results.add(DataBrowserTranslator.linkImages(ho));
        }
        return results;
    }

    private static Set transformDataset(DataObject dataset) {
        HashSet<DataObject> set = new HashSet<DataObject>(1);
        set.add(dataset);
        return DataBrowserTranslator.transformDatasets(set);
    }

    public static Set transformHierarchy(Collection dataObjects) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<ImageDisplay> results = new HashSet<ImageDisplay>();
        for (DataObject ho : dataObjects) {
            ImageDisplay child;
            if (ho instanceof ProjectData) {
                results.add(DataBrowserTranslator.getFirstElement(DataBrowserTranslator.transformProject(ho)));
                continue;
            }
            if (ho instanceof DatasetData) {
                results.add(DataBrowserTranslator.getFirstElement(DataBrowserTranslator.transformDataset(ho)));
                continue;
            }
            if (ho instanceof ImageData) {
                results.add(DataBrowserTranslator.linkImageTo((ImageData)ho, null));
                continue;
            }
            if (ho instanceof TagAnnotationData) {
                child = DataBrowserTranslator.transformTag((TagAnnotationData)ho);
                if (child == null) continue;
                results.add(child);
                continue;
            }
            if (!(ho instanceof WellData) || (child = DataBrowserTranslator.transformWell((WellData)ho)) == null) continue;
            results.add(child);
        }
        return results;
    }

    public static ImageSet transformObjects(Collection dataObjects, GroupData group) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet results = new HashSet();
        Iterator i = dataObjects.iterator();
        ImageSet groupNode = new ImageSet(group.getName(), group);
        while (i.hasNext()) {
            DataObject ho = (DataObject)i.next();
            if (!(ho instanceof ImageData)) continue;
            DataBrowserTranslator.linkImageTo((ImageData)ho, groupNode);
        }
        return groupNode;
    }

    public static Set<ImageDisplay> transformObjects(Collection dataObjects) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<ImageDisplay> results = new HashSet<ImageDisplay>();
        for (DataObject ho : dataObjects) {
            if (!(ho instanceof ImageData)) continue;
            results.add(DataBrowserTranslator.linkImageTo((ImageData)ho, null));
        }
        return results;
    }

    public static Set transformImages(Collection dataObjects) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<ImageNode> results = new HashSet<ImageNode>();
        for (DataObject ho : dataObjects) {
            if (!(ho instanceof ImageData)) continue;
            results.add(DataBrowserTranslator.linkImageTo((ImageData)ho, null));
        }
        return results;
    }

    public static Set transformExperimenters(Collection dataObjects) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<ImageNode> results = new HashSet<ImageNode>();
        for (DataObject ho : dataObjects) {
            if (!(ho instanceof ExperimenterData)) continue;
            results.add(DataBrowserTranslator.linkExperimenterTo((ExperimenterData)ho, null));
        }
        return results;
    }

    public static Set transformFSFolder(Collection dataObjects) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<ImageNode> results = new HashSet<ImageNode>();
        for (DataObject ho : dataObjects) {
            if (!(ho instanceof ImageData)) continue;
            results.add(DataBrowserTranslator.linkImageTo((ImageData)ho, null));
        }
        return results;
    }

    public static Set transform(DataObject ho) {
        if (ho == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<DataObject> s = new HashSet<DataObject>(1);
        s.add(ho);
        return DataBrowserTranslator.transformHierarchy(s);
    }

    public static boolean isWritable(DataObject ho, long userID, long groupID) {
        PermissionData permissions = ho.getPermissions();
        if (userID == ho.getOwner().getId()) {
            return permissions.isUserWrite();
        }
        return permissions.isGroupWrite();
    }
}

