/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.SearchResult;
import omero.gateway.model.SearchResultCollection;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.SearchThumbnailLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailProvider;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SearchResultTable;

public class AdvancedResultSearchModel
extends DataBrowserModel {
    private static final int MAX_THUMBS = 100;
    private List<ImageDisplay> displays = new ArrayList<ImageDisplay>();
    private Map<DataObject, Thumbnail> thumbs = new HashMap<DataObject, Thumbnail>();
    private List<SearchResultTable> tables = new ArrayList<SearchResultTable>();
    private SearchResultCollection results;

    public AdvancedResultSearchModel(SearchResultCollection results) {
        super(null);
        if (results == null) {
            throw new IllegalArgumentException("No results.");
        }
        this.results = results;
        this.displays.addAll(this.createDisplays(results.getDataObjects(-1, ProjectData.class)));
        this.displays.addAll(this.createDisplays(results.getDataObjects(-1, ScreenData.class)));
        this.displays.addAll(this.createDisplays(results.getDataObjects(-1, DatasetData.class)));
        this.displays.addAll(this.createDisplays(results.getDataObjects(-1, PlateData.class)));
        this.displays.addAll(this.createDisplays(results.getDataObjects(-1, PlateAcquisitionData.class)));
        List<DataObject> imgs = results.getDataObjects(-1, ImageData.class);
        List<ImageDisplay> imgNodes = this.createDisplays(imgs);
        this.displays.addAll(imgNodes);
        this.browser = BrowserFactory.createBrowser(this.displays);
    }

    public void registerTable(SearchResultTable table) {
        this.tables.add(table);
    }

    private List<ImageDisplay> createDisplays(Collection<DataObject> dataObjs) {
        ArrayList<ImageDisplay> result = new ArrayList<ImageDisplay>();
        for (DataObject dataObj : dataObjs) {
            ImageDisplay d = null;
            if (dataObj instanceof ImageData) {
                d = new ImageNode("", dataObj, null);
            } else if (dataObj instanceof ProjectData || dataObj instanceof DatasetData || dataObj instanceof ScreenData || dataObj instanceof PlateData || dataObj instanceof PlateAcquisitionData) {
                d = new ImageSet("", dataObj);
            }
            if (d == null) continue;
            result.add(d);
        }
        return result;
    }

    @Override
    void loadData(boolean refresh, Collection ids) {
        this.loadThumbs();
    }

    private void loadThumbs() {
        int count = 0;
        HashMap<Long, ArrayList<ImageData>> map = new HashMap<Long, ArrayList<ImageData>>();
        for (ImageDisplay imageDisplay : this.displays) {
            DataObject obj = (DataObject)imageDisplay.getHierarchyObject();
            if (!(obj instanceof ImageData)) continue;
            if (count >= 100) break;
            ArrayList<ImageData> objs = (ArrayList<ImageData>)map.get(obj.getGroupId());
            if (objs == null) {
                objs = new ArrayList<ImageData>();
                map.put(obj.getGroupId(), objs);
            }
            objs.add((ImageData)obj);
            ++count;
        }
        for (Map.Entry entry : map.entrySet()) {
            List imgs = (List)entry.getValue();
            if (imgs.isEmpty()) continue;
            SearchThumbnailLoader loader = new SearchThumbnailLoader(this.component, new SecurityContext((Long)entry.getKey()), imgs, this);
            loader.load();
        }
    }

    @Override
    protected List<DataBrowserLoader> createDataLoader(boolean refresh, Collection ids) {
        return null;
    }

    @Override
    protected int getType() {
        return 3;
    }

    @Override
    protected List<ImageDisplay> getNodes() {
        return this.displays;
    }

    public void setThumbnail(long imgId, BufferedImage img) {
        for (ImageDisplay d : this.displays) {
            if (!(d.getHierarchyObject() instanceof ImageData) || ((ImageData)d.getHierarchyObject()).getId() != imgId) continue;
            ImageData refObj = (ImageData)d.getHierarchyObject();
            ThumbnailProvider thumb = new ThumbnailProvider(refObj);
            thumb.setFullScaleThumb(img);
            this.thumbs.put(refObj, thumb);
            break;
        }
    }

    public Thumbnail getThumbnail(DataObject refObj) {
        return this.thumbs.get(refObj);
    }

    public void notifyThumbsLoaded() {
        for (SearchResultTable table : this.tables) {
            table.repaint();
        }
    }

    public boolean isIdMatch(Class<? extends DataObject> type, long id) {
        for (SearchResult r : this.results) {
            if (!r.isIdMatch() || r.getObjectId() != id || !r.getType().equals(type)) continue;
            return true;
        }
        return false;
    }
}

