/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.FNode;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.ImportUserData;
import org.openmicroscopy.shoola.env.data.model.FileObject;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;

public class EditorFileBrowser
extends JTree {
    private javax.swing.filechooser.FileFilter fileFilter;

    public EditorFileBrowser(FNode rootNode) {
        super(rootNode);
        this.setRootVisible(true);
        this.setShowsRootHandles(true);
        this.getSelectionModel().setSelectionMode(1);
    }

    public void createNodes(List<ImportableFile> files, boolean holdData) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
        FNode root = (FNode)treeModel.getRoot();
        if (!holdData) {
            root.removeAllChildren();
            if (files == null) {
                return;
            }
            for (ImportableFile f : files) {
                this.addNode(root, f.getFile(), f);
                String name = "";
                if (f.getParent() instanceof ProjectData) {
                    name = f.getParent().asProject().getName().getValue();
                } else if (f.getParent() instanceof ScreenData) {
                    name = f.getParent().asScreen().getName().getValue();
                }
                String string = f.getDataset() != null ? f.getDataset().getName() : "from folder";
            }
            treeModel.reload();
        } else {
            TreePath path = this.getSelectionPath();
            FNode node = (FNode)this.getLastSelectedPathComponent();
            String dirName = node.getFile().getName();
            FNode dirNode = node;
            if (node != null && node.isLeaf()) {
                dirName = node.getFile().getParentFile().getName();
                dirNode = (FNode)node.getParent();
            }
            this.insertNodes(files, dirName, dirNode);
            this.updateUI();
            this.expandPath(path);
        }
    }

    private void addNode(FNode parent, FileObject f, ImportableFile fileObj) {
        block5: {
            ImportUserData data;
            FNode file;
            block4: {
                FNode dir = null;
                file = null;
                data = null;
                if (fileObj != null) {
                    data = new ImportUserData(fileObj.getGroup(), fileObj.getParent(), fileObj.getUser());
                }
                if (!f.isDirectory()) break block4;
                dir = new FNode(new File(f.getAbsolutePath()), data, null);
                parent.add(dir);
                File[] files = new File(f.getAbsolutePath()).listFiles((FileFilter)((Object)this.fileFilter));
                if (files == null || files.length <= 0) break block5;
                for (int i = 0; i < files.length; ++i) {
                    this.addNode(dir, new FileObject(files[i]), null);
                }
                break block5;
            }
            try {
                file = new FNode(new File(f.getAbsolutePath()), data, fileObj);
                parent.add(file);
            }
            catch (Exception e) {
                ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE]  Wrong import format \"+f.getAbsolutePath()!");
            }
        }
    }

    private void insertNodes(List<ImportableFile> files, String dirName, FNode node) {
        block3: {
            block2: {
                if (node != null && node.getFile() != null) break block2;
                node = (FNode)this.getModel().getRoot();
                Iterator<ImportableFile> j = files.iterator();
                node.removeAllChildren();
                while (j.hasNext()) {
                    ImportableFile f = j.next();
                    this.addNode(node, f.getFile(), f);
                }
                break block3;
            }
            node.removeAllChildren();
            File[] fileList = new File(node.getFile().getAbsolutePath()).listFiles((FileFilter)((Object)this.fileFilter));
            if (fileList == null || fileList.length <= 0) break block3;
            for (int i = 0; i < fileList.length; ++i) {
                this.addNode(node, new FileObject(fileList[i]), null);
            }
        }
    }

    public void setFileFilter(javax.swing.filechooser.FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public String getSelectedFilePath(FNode node) {
        String fname = "";
        if (node != null && node.isLeaf()) {
            fname = node.getAbsolutePath();
        }
        return fname;
    }

    public String getSelectedFilePath() {
        return this.getSelectedFilePath((FNode)this.getLastSelectedPathComponent());
    }
}

