/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.dicom;

import java.io.IOException;
import java.util.List;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.dicom.DicomTile;
import loci.formats.in.DicomReader;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class DicomFileInfo
implements Comparable<DicomFileInfo> {
    public CoreMetadata coreMetadata;
    public String file;
    public int concatenationIndex = 0;
    public List<DicomTile> tiles;
    public String imageType;
    public List<Double> zOffsets;
    public boolean edf = false;
    public Timestamp timestamp;
    public Length pixelSizeX;
    public Length pixelSizeY;
    public Length pixelSizeZ;
    public List<Double> positionX;
    public List<Double> positionY;
    public List<Double> positionZ;
    public List<String> channelNames;

    public DicomFileInfo() {
    }

    public DicomFileInfo(String filePath) throws FormatException, IOException {
        this.file = filePath;
        try (DicomReader reader = new DicomReader();){
            reader.setGroupFiles(false);
            reader.setId(this.file);
            this.coreMetadata = (CoreMetadata)reader.getCoreMetadataList().get(0);
            this.tiles = reader.getTiles();
            this.imageType = reader.getImageType();
            this.zOffsets = reader.getZOffsets();
            this.concatenationIndex = reader.getConcatenationIndex();
            this.edf = reader.isExtendedDepthOfField();
            this.pixelSizeX = reader.getPixelSizeX();
            this.pixelSizeY = reader.getPixelSizeY();
            this.pixelSizeZ = reader.getPixelSizeZ();
            this.positionX = reader.getPositionX();
            this.positionY = reader.getPositionY();
            this.positionZ = reader.getPositionZ();
            this.channelNames = reader.getChannelNames();
            this.timestamp = reader.getTimestamp();
        }
    }

    @Override
    public int compareTo(DicomFileInfo info) {
        if (info.edf != this.edf) {
            return this.edf ? 1 : -1;
        }
        String[] infoTypeTokens = info.imageType.split("\\\\");
        String[] thisTypeTokens = this.imageType.split("\\\\");
        int endIndex = Math.min(infoTypeTokens.length, thisTypeTokens.length) - 1;
        for (int i = 2; i < endIndex; ++i) {
            if (infoTypeTokens[i].equals(thisTypeTokens[i])) continue;
            if (i < endIndex) {
                return infoTypeTokens[i].compareTo(thisTypeTokens[i]);
            }
            return thisTypeTokens[i].compareTo(infoTypeTokens[i]);
        }
        int infoX = info.coreMetadata.sizeX;
        int infoY = info.coreMetadata.sizeY;
        int thisX = this.coreMetadata.sizeX;
        int thisY = this.coreMetadata.sizeY;
        if (infoX != thisX) {
            return infoX - thisX;
        }
        if (infoY != thisY) {
            return infoY - thisY;
        }
        if (this.zOffsets.size() > 0 && info.zOffsets.size() > 0) {
            return this.zOffsets.get(0).compareTo(info.zOffsets.get(0));
        }
        return this.concatenationIndex - info.concatenationIndex;
    }
}

