/*
 * Decompiled with CFR 0.152.
 */
package ome.services.eventlogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.meta.EventLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBacklog {
    private static final Logger logger = LoggerFactory.getLogger(EventBacklog.class);
    final Map<Long, Map<String, Set<String>>> contained = new HashMap<Long, Map<String, Set<String>>>();
    final List<EventLog> logs = new ArrayList<EventLog>();
    protected boolean adding = true;

    public synchronized boolean add(EventLog log) {
        boolean contained;
        Set<String> actions;
        if (!this.adding) {
            if (logger.isInfoEnabled()) {
                logger.info("Backlog locked:" + log.getEntityType() + ":Id_" + log.getEntityId());
            }
            return false;
        }
        if (log == null || log.getEntityType() == null || log.getEntityId() == null || log.getAction() == null) {
            throw new IllegalArgumentException("EventLog must contain entityType, entityId, and action");
        }
        Map<String, Set<String>> class2action = this.contained.get(log.getEntityId());
        if (class2action == null) {
            class2action = new HashMap<String, Set<String>>();
            this.contained.put(log.getEntityId(), class2action);
        }
        if ((actions = class2action.get(log.getEntityType())) == null) {
            actions = new HashSet<String>();
            class2action.put(log.getEntityType(), actions);
        }
        if (contained = actions.contains(log.getAction())) {
            if (logger.isInfoEnabled()) {
                logger.info("Already in backlog:" + log.getEntityType() + ":Id_" + log.getEntityId());
            }
            return false;
        }
        actions.add(log.getAction());
        this.logs.add(log);
        if (logger.isInfoEnabled()) {
            logger.info("Added to backlog:" + log.getEntityType() + ":Id_" + log.getEntityId());
        }
        return true;
    }

    public synchronized EventLog remove() {
        if (this.logs.size() == 0) {
            this.contained.clear();
            return null;
        }
        this.adding = false;
        EventLog log = this.logs.remove(0);
        Map<String, Set<String>> class2action = this.contained.get(log.getEntityId());
        Set<String> actions = class2action.get(log.getEntityType());
        assert (actions.remove(log.getAction()));
        if (actions.size() == 0) {
            class2action.remove(log.getEntityType());
            if (class2action.size() == 0) {
                this.contained.remove(log.getEntityId());
            }
        }
        return log;
    }

    public synchronized void flipState() {
        this.adding = this.logs.size() == 0;
    }

    public synchronized boolean removingOnly() {
        return !this.adding;
    }
}

