/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentListener;
import loci.common.DateTools;
import ome.model.enums.UnitsLength;
import ome.model.units.Unit;
import ome.xml.model.Experimenter;
import omero.log.LogMessage;
import org.apache.commons.lang3.BooleanUtils;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleController;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.OMEValueConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.configuration.TagNames;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.CheckComboBox;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.ExperimenterBox;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.OntologyElement;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagDataProp;

public class TagData {
    Color fillInfo = new Color(240, 240, 240);
    Color noInfo = Color.white;
    Color resetInfo = Color.white;
    private final Border normalBorder = UIManager.getBorder("TextField.border");
    private final Border errorBorder = BorderFactory.createLineBorder(new Color(255, 51, 51));
    public static final String[] DATE_FORMATS_TAGS = new String[]{"yyyy:MM:dd HH:mm:ss", "dd/MM/yyyy HH:mm:ss", "MM/dd/yyyy hh:mm:ss aa", "yyyyMMdd HH:mm:ss", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss:SSS", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd", "dd.MM.yyyy", "dd.MM.yyyy HH:mm:ss", "dd.MM.yyyy HH:mm:ss:SSS", "dd-MM-yyyy HH:mm:ss", "dd-MM-yyyy"};
    private static final Map<String, String> DATE_FORMAT_REGEXPS = new HashMap<String, String>(){
        {
            this.put("^\\d{8}$", "yyyyMMdd");
            this.put("^\\d{1,2}-\\d{1,2}-\\d{4}$", "dd-MM-yyyy");
            this.put("^\\d{1,2}.\\d{1,2}.\\d{4}$", "dd.MM.yyyy");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}$", "yyyy-MM-dd");
            this.put("^\\d{1,2}/\\d{1,2}/\\d{4}$", "MM/dd/yyyy");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}$", "yyyy/MM/dd");
            this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}$", "dd MMM yyyy");
            this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}$", "dd MMMM yyyy");
            this.put("^\\d{12}$", "yyyyMMddHHmm");
            this.put("^\\d{8}\\s\\d{4}$", "yyyyMMdd HHmm");
            this.put("^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}$", "dd-MM-yyyy HH:mm");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}$", "yyyy-MM-dd HH:mm");
            this.put("^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}$", "MM/dd/yyyy HH:mm");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}$", "yyyy/MM/dd HH:mm");
            this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}$", "dd MMM yyyy HH:mm");
            this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}$", "dd MMMM yyyy HH:mm");
            this.put("^\\d{14}$", "yyyyMMddHHmmss");
            this.put("^\\d{8}\\s\\d{6}$", "yyyyMMdd HHmmss");
            this.put("^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd-MM-yyyy HH:mm:ss");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$", "yyyy-MM-dd HH:mm:ss");
            this.put("^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "MM/dd/yyyy HH:mm:ss");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$", "yyyy/MM/dd HH:mm:ss");
            this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd MMM yyyy HH:mm:ss");
            this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd MMMM yyyy HH:mm:ss");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}:\\d{3}$", "yyyy-MM-dd HH:mm:ss:SSS");
        }
    };
    private final String datePattern = "yyyy-MM-dd HH:mm:ss";
    public static final int INACTIVE = 0;
    public static final int EMPTY = 1;
    public static final int SET = 2;
    public static final int OVERWRITE = 3;
    public static final String TEXTFIELD = "TextField";
    public static final String COMBOBOX = "ComboBox";
    public static final String CHECK_COMBOBOX_NEW = "CheckComboBox";
    public static final String CHECK_COMBOBOX = "CheckBoxComboBox";
    public static final String TEXTPANE = "TextPane";
    public static final String CHECKBOX = "CheckBox";
    public static final String ARRAYFIELDS = "ArrayField";
    public static final String TIMESTAMP = "TimeStamp";
    public static final String LIST = "List";
    public static final String TEXTAREA = "TextArea";
    private static final int SIZE_LABEL_W = 300;
    private static final int SIZE_LABEL_H = 20;
    private String tagInfo;
    private int status = 0;
    private boolean prop;
    private String type;
    private boolean visible;
    private boolean valChanged;
    private boolean valSaved;
    private String parent;
    private String name;
    private String[] value;
    private String[] defaultValue;
    private String[] unitSymbol;
    private List<OntologyElement> ontoElems;
    private ActionListener fieldActionListener;
    private DocumentListener fieldDocumentListener;
    private boolean actionListenerActiv;
    private Color backgroundColor;
    private Border fieldBorder;
    private JComponent inputField;

    public TagData(TagData orig) {
        if (orig.unitSymbol != null) {
            this.unitSymbol = (String[])orig.unitSymbol.clone();
        }
        if (orig.value != null) {
            this.value = (String[])orig.value.clone();
        }
        this.status = orig.status;
        this.prop = orig.prop;
        this.type = orig.type;
        this.visible = orig.visible;
        this.valChanged = orig.valChanged;
        this.valSaved = orig.valSaved;
        this.name = orig.name;
        this.parent = orig.parent;
        this.tagInfo = orig.tagInfo;
        this.fieldActionListener = orig.fieldActionListener;
        this.actionListenerActiv = orig.actionListenerActiv;
        this.fieldDocumentListener = orig.fieldDocumentListener;
        this.backgroundColor = orig.backgroundColor;
        this.fieldBorder = orig.fieldBorder;
        this.inputField = null;
        if (orig.defaultValue != null) {
            this.defaultValue = (String[])orig.defaultValue.clone();
        }
        if (orig.ontoElems != null) {
            this.ontoElems = orig.ontoElems.stream().collect(Collectors.toList());
        }
    }

    public TagData(String parent, String name, String[] val, boolean prop, String type) {
        this.initTagData(parent, name, val, null, null, prop, type, null);
    }

    public TagData(String parent, String name, String val, boolean prop, String type) {
        String[] value = new String[]{val};
        this.initTagData(parent, name, value, null, null, prop, type, null);
    }

    public TagData(String parent, String name, Unit unitObj, Class unitClass, boolean prop, String type) {
        String[] valArr = new String[]{""};
        String[] uSymbol = new String[1];
        if (unitObj != null) {
            valArr[0] = String.valueOf(unitObj.getValue());
            uSymbol[0] = unitObj.getUnit().getSymbol();
        }
        this.initTagData(parent, name, valArr, uSymbol, unitClass, prop, type, null);
    }

    public TagData(String parent, String name, String val, String unitSymbol, boolean prop, String type, String[] defaultVal) {
        String[] valArr = new String[]{""};
        String[] uSymbol = new String[1];
        valArr[0] = String.valueOf(val);
        uSymbol[0] = unitSymbol;
        Class unitclazz = TagNames.getUnitClassFromSymbol(unitSymbol);
        this.initTagData(parent, name, valArr, uSymbol, unitclazz, prop, type, defaultVal);
    }

    public TagData(String parent, String name, Unit[] unitObj, Class unitClass, boolean prop, String type) {
        String[] valArr = null;
        String[] uSymbols = null;
        if (unitObj != null) {
            valArr = new String[unitObj.length];
            uSymbols = new String[unitObj.length];
            for (int i = 0; i < unitObj.length; ++i) {
                valArr[i] = null;
                if (unitObj[i] == null) continue;
                valArr[i] = String.valueOf(unitObj[i].getValue());
                uSymbols[i] = unitObj[i].getUnit().getSymbol();
            }
        }
        this.initTagData(parent, name, valArr, uSymbols, unitClass, prop, type, null);
    }

    public TagData(String parent, String name, String val, boolean prop, String type, String[] defaultVal) {
        String[] valArr = new String[]{val};
        this.initTagData(parent, name, valArr, null, null, prop, type, defaultVal);
    }

    public TagData(String parent, String name, String[] val, boolean prop, String type, int size) {
        String[] def = new String[]{String.valueOf(size)};
        this.initTagData(parent, name, val, null, null, prop, type, def);
    }

    public TagData(String parent, String name, String val, boolean prop, String type, int size) {
        String[] def = new String[]{String.valueOf(size)};
        String[] valArr = new String[]{val};
        this.initTagData(parent, name, valArr, null, null, prop, type, def);
    }

    public TagData(String parent, String name, Unit[] unitObj, Class unitClass, boolean prop, String type, int size) {
        String[] def = new String[]{String.valueOf(size)};
        String[] valArr = null;
        String[] uSymbols = null;
        if (unitObj != null) {
            valArr = new String[unitObj.length];
            uSymbols = new String[unitObj.length];
            for (int i = 0; i < unitObj.length; ++i) {
                valArr[i] = null;
                if (unitObj[i] == null) continue;
                valArr[i] = String.valueOf(unitObj[i].getValue());
                uSymbols[i] = unitObj[i].getUnit().getSymbol();
            }
        }
        this.initTagData(parent, name, valArr, uSymbols, unitClass, prop, type, def);
    }

    private void initTagData(String parent, String name, String[] val, String[] unit, Class unitClass, boolean prop, String type, String[] defaultVal) {
        if (val == null) {
            val = new String[1];
        }
        this.initListener();
        this.type = type;
        this.name = name;
        this.value = val;
        this.valSaved = true;
        this.valChanged = false;
        if (unit == null) {
            this.getDefaultUnit();
        }
        this.unitSymbol = unit;
        this.defaultValue = defaultVal;
        this.parent = parent;
        this.tagInfo = "";
        this.setValueRequired(false);
        this.setVisible(true);
        this.status = 1;
        this.fieldBorder = this.normalBorder;
        this.backgroundColor = this.noInfo;
        this.actionListenerActiv = true;
    }

    private void getDefaultUnit() {
        String unitSymbol = ModuleController.getInstance().getStandardUnitSymbolByName(this.parent, this.getTagName());
        this.setTagUnit(unitSymbol);
    }

    public boolean equalContent(TagData t) {
        return t != null && t.tagToString().equals(this.tagToString());
    }

    public String tagToString() {
        String result = this.name + ": " + this.getTagWholeValue();
        return result;
    }

    public void print() {
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "TAG: " + this.parent + "::" + this.getTagName() + "\t PROP: u = " + this.getTagUnitString() + ", visible = " + this.isVisible());
    }

    public JPanel getTagLabelAndUnit() {
        JPanel labelPane = new JPanel(new BorderLayout());
        labelPane.setPreferredSize(new Dimension(300, 20));
        String labelRequired = this.isRequired() ? "*" : "";
        JTextField labelName = new JTextField(this.name + labelRequired + ": ");
        labelName.setEditable(false);
        if (this.getTagUnitString().equals("")) {
            labelPane.add((Component)labelName, "Center");
        } else {
            JComboBox units = this.createUnitCombo();
            if (units != null) {
                units.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TagData.this.setTagUnit((String)((JComboBox)e.getSource()).getSelectedItem());
                        TagData.this.repaintInputField();
                    }
                });
                labelPane.add((Component)labelName, "Center");
                labelPane.add((Component)units, "East");
            }
        }
        if (this.status == 0) {
            labelName.setEnabled(false);
        }
        return labelPane;
    }

    public JComboBox getUnitCombo() {
        return this.createUnitCombo();
    }

    private JComboBox createUnitCombo() {
        JComboBox<Object> units = new JComboBox();
        if (this.getUnitType() != null) {
            String[] unitsList = TagNames.getUnitsList(this.getUnitType());
            if (unitsList != null) {
                units = new JComboBox<String>(unitsList);
                String symbol = this.getTagUnitString();
                if (symbol.isEmpty() || symbol.equals("")) {
                    symbol = UnitsLength.REFERENCEFRAME.getSymbol();
                }
                for (int i = 0; i < units.getItemCount(); ++i) {
                    if (!units.getItemAt(i).equals(symbol)) continue;
                    units.setSelectedIndex(i);
                    break;
                }
            } else {
                ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] Unit not available :: " + this.getUnitType() + " for tag " + this.getTagName());
            }
        }
        return units;
    }

    private void repaintInputField() {
        if (this.inputField == null) {
            return;
        }
        switch (this.type) {
            case "ArrayField": {
                this.setValArrayField((JArray)this.inputField);
                break;
            }
            case "TextField": {
                this.setValTextField(this.inputField);
                break;
            }
            case "ComboBox": {
                this.setValComboBox(this.inputField);
                break;
            }
            case "CheckComboBox": 
            case "CheckBoxComboBox": {
                this.setValCheckComboBox(this.inputField);
                break;
            }
            case "TextPane": {
                this.setValTextPane(this.inputField);
                break;
            }
            case "TextArea": {
                this.setValTextArea(this.inputField);
                break;
            }
            case "CheckBox": {
                this.setValCheckbox(this.inputField);
                break;
            }
            case "TimeStamp": {
                this.setValTimestamp(this.inputField);
                break;
            }
        }
        this.inputField.revalidate();
        this.inputField.repaint();
    }

    public JComponent getInputField() {
        FocusListener listener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    TagData.this.saveTagValue((JComponent)e.getSource());
                }
                catch (Exception ex) {
                    String s = "[MDE] can't save Tag value ";
                    LogMessage msg = new LogMessage();
                    msg.print(s);
                    msg.print((Object)e);
                    ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        KeyListener listenerKey = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    TagData.this.saveTagValue((JComponent)e.getSource());
                }
                catch (Exception ex) {
                    String s = "[MDE] can't save Tag value ";
                    LogMessage msg = new LogMessage();
                    msg.print(s);
                    msg.print((Object)e);
                    ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
                }
                TagData.this.valChanged = true;
                TagData.this.valSaved = false;
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        };
        switch (this.type) {
            case "ArrayField": {
                int defaultSize = this.defaultValue != null && this.defaultValue[0] != null && !this.defaultValue[0].equals("") ? Integer.parseInt(this.defaultValue[0]) : 1;
                int size = this.value != null ? this.value.length : defaultSize;
                this.inputField = new JArray(defaultSize);
                this.setValArrayField((JArray)this.inputField);
                this.inputField.setToolTipText(this.tagInfo);
                break;
            }
            case "TextField": {
                this.inputField = new JTextField(10);
                this.setValTextField(this.inputField);
                ((JTextField)this.inputField).addActionListener(this.fieldActionListener);
                this.inputField.addFocusListener(listener);
                this.inputField.addKeyListener(listenerKey);
                this.inputField.setToolTipText(this.tagInfo);
                break;
            }
            case "ComboBox": {
                this.inputField = this.initComboBox();
                this.setValComboBox(this.inputField);
                ((JComboBox)this.inputField).addActionListener(this.fieldActionListener);
                this.inputField.addFocusListener(listener);
                this.inputField.addKeyListener(listenerKey);
                this.inputField.setToolTipText(this.tagInfo);
                break;
            }
            case "CheckComboBox": 
            case "CheckBoxComboBox": {
                this.inputField = this.initCheckComboBox();
                this.setValCheckComboBox(this.inputField);
                ((CheckComboBox)this.inputField).addActionListener(this.fieldActionListener);
                this.inputField.addFocusListener(listener);
                this.inputField.addKeyListener(listenerKey);
                this.inputField.setToolTipText(this.tagInfo);
                break;
            }
            case "TextPane": {
                this.inputField = new JTextPane();
                this.setValTextPane(this.inputField);
                this.inputField.addFocusListener(listener);
                this.inputField.addKeyListener(listenerKey);
                this.inputField.setToolTipText(this.tagInfo);
                break;
            }
            case "TextArea": {
                this.inputField = new ScrollableTextPane();
                ((ScrollableTextPane)this.inputField).setTextAreaRows(2);
                this.setValTextArea(this.inputField);
                this.inputField.addFocusListener(listener);
                this.inputField.addKeyListener(listenerKey);
                this.inputField.setToolTipText(this.tagInfo);
                break;
            }
            case "CheckBox": {
                this.inputField = new JCheckBox("", Boolean.parseBoolean(this.value[0]));
                ((JCheckBox)this.inputField).addActionListener(this.fieldActionListener);
                this.setValCheckbox(this.inputField);
                ((JCheckBox)this.inputField).addActionListener(this.fieldActionListener);
                this.inputField.addFocusListener(listener);
                this.inputField.addKeyListener(listenerKey);
                this.inputField.setToolTipText(this.tagInfo);
                break;
            }
            case "TimeStamp": {
                this.inputField = new JTextField(10);
                this.inputField.setToolTipText("Format e.g: yyyy-MM-dd HH:mm:ss or dd.MM.yyyy");
                this.setValTimestamp(this.inputField);
                ((JTextField)this.inputField).addActionListener(this.fieldActionListener);
                this.inputField.addFocusListener(listener);
                this.inputField.addKeyListener(listenerKey);
                break;
            }
            default: {
                ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] Unknown type for inputField " + this.getTagName() + "-> generate Textfield instead");
                this.inputField = new JTextField(10);
                this.setValTextField(this.inputField);
                ((JTextField)this.inputField).addActionListener(this.fieldActionListener);
                this.inputField.addFocusListener(listener);
                this.inputField.addKeyListener(listenerKey);
                this.inputField.setToolTipText(this.tagInfo);
            }
        }
        this.setTagValue(this.value);
        this.addDocumentListener(this.inputField);
        this.inputField.setBackground(this.backgroundColor);
        this.inputField.setBorder(this.fieldBorder);
        if (this.status == 0) {
            this.inputField.setEnabled(false);
        }
        if (this.name.equals("ID")) {
            this.inputField.setEnabled(false);
        }
        return this.inputField;
    }

    private JComponent initListField(List<Experimenter> expList) {
        ExperimenterBox field = new ExperimenterBox(expList);
        return field;
    }

    private JComponent initCheckComboBox() {
        CheckComboBox field = this.defaultValue != null ? new CheckComboBox(this.defaultValue) : new CheckComboBox();
        return field;
    }

    private JComponent initComboBox() {
        JComboBox<Object> field;
        if (this.defaultValue != null) {
            field = new JComboBox<String>(this.defaultValue);
            field.insertItemAt("", 0);
            field.setSelectedItem(0);
        } else {
            field = new JComboBox();
        }
        return field;
    }

    private void initListener() {
        this.fieldActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TagData.this.actionListenerActiv) {
                    TagData.this.valChanged = true;
                    TagData.this.valSaved = false;
                    if (TagData.this.fieldBorder.equals(TagData.this.errorBorder)) {
                        TagData.this.setTagInfoError("");
                    }
                }
            }
        };
    }

    public void setActionListener(ActionListener a) {
        this.fieldActionListener = a;
    }

    private void activateActionListener(boolean a) {
        this.actionListenerActiv = a;
    }

    private void addActionListener(JComponent field) {
        if (this.fieldActionListener == null) {
            return;
        }
        if (this.type == COMBOBOX) {
            ((JComboBox)field).addActionListener(this.fieldActionListener);
        }
    }

    public void setDocumentListener(DocumentListener l) {
        this.fieldDocumentListener = l;
    }

    private void addDocumentListener(JComponent field) {
        if (this.fieldDocumentListener == null) {
            return;
        }
        switch (this.type) {
            case "TextField": {
                ((JTextField)field).getDocument().addDocumentListener(this.fieldDocumentListener);
                break;
            }
            case "ComboBox": {
                break;
            }
            case "TextPane": {
                ((JTextPane)field).getDocument().addDocumentListener(this.fieldDocumentListener);
                break;
            }
            case "TextArea": {
                ((JTextArea)field).getDocument().addDocumentListener(this.fieldDocumentListener);
                break;
            }
            case "CheckBox": {
                break;
            }
            case "ArrayField": {
                break;
            }
            case "TimeStamp": {
                break;
            }
        }
    }

    public String getDefaultValuesAsString() {
        return this.arrayToString(this.defaultValue);
    }

    public String getDefaultValuesAsArrayString() {
        return Arrays.toString(this.defaultValue);
    }

    public void setDefaultValues(String[] list) {
        if (list == null) {
            return;
        }
        this.defaultValue = list;
    }

    public String getTagWholeValue() {
        if (this.unitSymbol == null) {
            return this.getTagValue();
        }
        return this.getTagValue() + " " + this.getTagUnitString();
    }

    public String getTagName() {
        return this.name;
    }

    public boolean isEmptyValue() {
        return this.value == null || this.getTagValue().equals("");
    }

    public String[] getTagValueAsArray() {
        return this.value;
    }

    public String getTagValue() {
        return this.arrayToString(this.value);
    }

    public String getTagValue(int index) {
        if (index >= this.value.length) {
            return "";
        }
        return this.value[index];
    }

    public void saveTagValue(String[] newValue) {
        if (newValue != null && this.value != null && !this.arrayToString(this.value).equals(this.arrayToString(newValue))) {
            this.dataHasChanged(true);
            this.value = newValue;
        }
    }

    private void saveTagValue(JComponent source) throws Exception {
        if (source == null) {
            return;
        }
        String[] val = null;
        switch (this.type) {
            case "ArrayField": {
                if (source instanceof JArray) {
                    try {
                        val = ((JArray)source).getValuesAsArray();
                    }
                    catch (Exception ex) {
                        String s = "[MDE] can't save Tag value ";
                        LogMessage msg = new LogMessage();
                        msg.print(s);
                        msg.print((Throwable)ex);
                        ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
                    }
                    break;
                }
                val = new String[]{((JTextField)source).getText()};
                break;
            }
            case "TimeStamp": {
                val = new String[]{this.readTimestamp(source, val[0])};
                break;
            }
            case "TextPane": {
                val = new String[]{((JTextPane)source).getText()};
                break;
            }
            case "TextArea": {
                val = new String[]{((JTextArea)source).getText()};
                break;
            }
            case "TextField": {
                val = new String[]{((JTextField)source).getText()};
                break;
            }
            case "ComboBox": {
                val = new String[]{(String)((JComboBox)source).getSelectedItem()};
                break;
            }
            case "CheckBox": {
                val = new String[]{((JCheckBox)source).isSelected() ? "true" : "false"};
                break;
            }
            case "CheckBoxComboBox": {
                val = new String[]{((CheckComboBox)source).getSelectedItemsAsString()};
                break;
            }
        }
        if (val != null && this.value != null && !this.arrayToString(this.value).equals(this.arrayToString(val))) {
            this.dataHasChanged(true);
            this.value = val;
        }
    }

    private String listToString(List<String> list) {
        Object res = "";
        if (list == null || list.isEmpty()) {
            return res;
        }
        for (String s : list) {
            if (s.equals("")) continue;
            res = (String)res + s + ",";
        }
        if (((String)res).endsWith(",")) {
            res = ((String)res).substring(0, ((String)res).length() - 1);
        }
        return res;
    }

    private String arrayToString(String[] list) {
        Object res = null;
        if (list == null) {
            return res;
        }
        res = "";
        for (String s : list) {
            if (s == null || s.equals("")) continue;
            res = (String)res + s + ",";
        }
        if (((String)res).endsWith(",")) {
            res = ((String)res).substring(0, ((String)res).length() - 1);
        }
        return res;
    }

    public String getTagUnitString() {
        if (this.unitSymbol != null && this.unitSymbol[0] != null) {
            return this.unitSymbol[0];
        }
        return ModuleController.getInstance().getStandardUnitSymbolByName(this.parent, this.getTagName());
    }

    private void setTagData(Unit[] u) {
        if (u == null || u.length == 0) {
            return;
        }
        if (this.unitSymbol.length < u.length) {
            this.unitSymbol = new String[u.length];
        }
        if (this.value.length < u.length) {
            this.value = new String[u.length];
        }
        for (int i = 0; i < u.length; ++i) {
            if (u[i] != null) {
                this.value[i] = String.valueOf(u[i].getValue());
                this.unitSymbol[i] = u[i].getUnit().getSymbol();
                continue;
            }
            this.value[i] = "";
            this.unitSymbol[i] = null;
        }
    }

    public String getUnitType() {
        if (this.getTagUnitString() != null && !this.getTagUnitString().equals("") && TagNames.getUnitClassFromSymbol(this.getTagUnitString()) != null) {
            return TagNames.getUnitClassFromSymbol(this.getTagUnitString()).getName();
        }
        return "";
    }

    public void setTagUnit(String newsymbol) {
        if (newsymbol == null || newsymbol.equals("")) {
            return;
        }
        if (this.getTagValue() == null) {
            this.unitSymbol = new String[]{newsymbol};
            return;
        }
        if (this.getTagValue().trim().equals("") && newsymbol != null) {
            if (this.unitSymbol == null && this.value != null) {
                this.unitSymbol = new String[this.value.length];
            }
            for (int i = 0; i < this.unitSymbol.length; ++i) {
                this.unitSymbol[i] = newsymbol;
            }
            return;
        }
        Unit[] newVal = null;
        if (this.value != null && this.unitSymbol != null && this.unitSymbol[0] != null && !newsymbol.equals(this.unitSymbol[0])) {
            try {
                newVal = OMEValueConverter.convert(this.value, this.unitSymbol[0], newsymbol);
            }
            catch (Exception e) {
                ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] Can't parse unit for " + this.getTagName());
            }
            if (newVal != null) {
                this.setTagData(newVal);
                return;
            }
        }
        if (newVal == null) {
            newVal = new Unit[]{TagNames.getUnit(newsymbol)};
        }
        if (this.unitSymbol == null) {
            this.unitSymbol = new String[this.value.length];
        }
        for (int i = 0; i < this.unitSymbol.length; ++i) {
            this.unitSymbol[i] = newsymbol;
        }
    }

    public void setTagValue(String val, boolean property) {
        this.setTagValue(val);
        this.setValueRequired(property);
        this.valChanged = false;
    }

    public void setTagValue(String val, int index, boolean property) {
        this.setTagValue(val, index);
        this.setValueRequired(property);
        this.valChanged = false;
    }

    public void setTagValue(Unit val, int index, boolean property) {
        if (val != null) {
            this.setTagValue(String.valueOf(val.getValue()), index);
        } else {
            this.setTagValue("", index);
        }
        this.setValueRequired(property);
        this.valChanged = false;
    }

    public void setTagValue(String[] val, boolean property) {
        this.setTagValue(val);
        this.setValueRequired(property);
        this.valChanged = false;
    }

    private void setTagValue(String val, int index) {
        if (val != null && !val.equals("")) {
            this.valSaved = false;
        }
        switch (this.type) {
            case "ArrayField": {
                if (this.value == null) {
                    this.value = new String[index + 1];
                }
                if (this.value.length <= index) {
                    ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] can't set value for " + this.getTagName() + " [TagData::setTagValue]");
                }
                this.value[index] = val;
                break;
            }
            default: {
                this.setTagValue(val);
            }
        }
        this.setTagStatus(val.equals("") ? 1 : (this.status == 1 ? 2 : 3));
    }

    private void setTagValue(String[] val) {
        this.value = val;
        this.setTagStatus(val.length == 0 ? 1 : (this.status == 1 ? 2 : 3));
    }

    public void setTagValue(String val) {
        if (val == null || val.equals("")) {
            this.backgroundColor = this.noInfo;
        } else {
            this.valSaved = false;
            this.backgroundColor = this.fillInfo;
        }
        this.value[0] = val;
        this.setTagStatus(val.equals("") ? 1 : (this.status == 1 ? 2 : 3));
        this.valChanged = false;
    }

    private String readTimestamp(JComponent inputField, String val) {
        String creationDate = ((JTextField)inputField).getText();
        try {
            String date = DateTools.formatDate((String)creationDate, (String[])DATE_FORMATS_TAGS);
            if (creationDate != null && !creationDate.equals("") && !creationDate.equals("yyyy-MM-dd HH:mm:ss") && date == null && (date = this.parseDate(creationDate)) == null) {
                Object formats = "";
                for (String s : DATE_FORMATS_TAGS) {
                    formats = (String)formats + s + "\n";
                }
                ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] unknown creation date format: " + creationDate);
            }
            val = date;
        }
        catch (Exception e) {
            ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] unknown creation date format: " + creationDate);
        }
        return val;
    }

    private String parseDate(String val) throws Exception {
        String dateformat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        String s = DateTools.formatDate((String)val, (String)dateformat);
        if (s == null) {
            dateformat = "yyyy-MM-dd'T'HH:mm:ss";
            s = DateTools.formatDate((String)val, (String)dateformat);
        }
        SimpleDateFormat df = new SimpleDateFormat(dateformat);
        try {
            Date d = df.parse(s);
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return f.format(d);
        }
        catch (NullPointerException | ParseException e1) {
            ImporterAgent.getRegistry().getLogger().error((Object)this, "[MDE] Parse error for date format " + dateformat + "\n" + e1.toString());
            return null;
        }
    }

    private void setValTimestamp(JComponent inputField) {
        String oldval = this.value[0];
        if (oldval != null && !oldval.equals("")) {
            String currentDatePattern = this.getDatePattern(oldval);
            ((JTextField)inputField).setForeground(Color.black);
            String newVal = this.convertDate(oldval, currentDatePattern, "yyyy-MM-dd HH:mm:ss");
            if (newVal == null) {
                ImporterAgent.getRegistry().getLogger().error((Object)this, "[MDE] Can't parse date " + oldval);
                this.setTagInfoError(oldval + ". Invalid Date Format!");
                ((JTextField)inputField).setText("");
            } else {
                ((JTextField)inputField).setText(newVal);
            }
        }
    }

    private String getDatePattern(String dateStr) {
        Date parsedDate = null;
        Object pattern = null;
        for (int i = 0; i < DATE_FORMATS_TAGS.length; ++i) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMATS_TAGS[i]);
            try {
                parsedDate = sdf.parse(dateStr);
                return sdf.toPattern();
            }
            catch (ParseException e) {
                continue;
            }
        }
        return null;
    }

    private String convertDate(String dateStr, String dateFormatOld, String dateFormatNew) {
        if (dateFormatNew == null || dateFormatOld == null) {
            return null;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(dateFormatOld);
            Date d = df.parse(dateStr);
            df.applyPattern(dateFormatNew);
            return df.format(d);
        }
        catch (ParseException | DateTimeParseException e) {
            ImporterAgent.getRegistry().getLogger().error((Object)this, "[MDE] Error while parsing date from " + dateFormatOld + "to " + dateFormatNew);
            return null;
        }
    }

    private void setValArrayField(JArray field) {
        if (this.value == null) {
            field.setBackground(this.noInfo, "");
        } else {
            field.setValues(this.value);
        }
    }

    private void setValCheckbox(JComponent inputField) {
        boolean bVal = BooleanUtils.toBoolean((String)this.value[0]);
        ((JCheckBox)inputField).setSelected(bVal);
    }

    private void setValTextPane(JComponent inputField) {
        ((JTextPane)inputField).setText(this.value[0]);
    }

    private void setValTextArea(JComponent inputField) {
        ((ScrollableTextPane)inputField).setText(this.value[0]);
    }

    private void setValComboBox(JComponent inputField) {
        for (int c = 0; c < ((JComboBox)inputField).getItemCount(); ++c) {
            if (!((String)((JComboBox)inputField).getItemAt(c)).equals(this.value[0])) continue;
            ((JComboBox)inputField).setSelectedIndex(c);
        }
    }

    private void setValCheckComboBox(JComponent inputField) {
        ((CheckComboBox)inputField).init_selectedValues(this.value);
    }

    private void setValTextField(JComponent inputField) {
        ((JTextField)inputField).setText(this.value == null || this.value[0] == null ? "" : this.value[0]);
    }

    public int getTagStatus() {
        return this.status;
    }

    private void setTagStatus(int status) {
        this.status = status;
    }

    public boolean isRequired() {
        return this.prop;
    }

    public void setValueRequired(boolean prop) {
        this.prop = prop;
    }

    public String getTagType() {
        return this.type;
    }

    public Class getTagTypeClass() {
        if (this.inputField == null) {
            return String.class;
        }
        return this.inputField.getClass();
    }

    public void setEnable(boolean val) {
        if (!val) {
            this.status = 0;
        }
    }

    public boolean valueHasChanged() {
        return this.valChanged;
    }

    public boolean isDataSaved() {
        return this.valSaved;
    }

    public void dataSaved(boolean b) {
        this.valSaved = b;
    }

    public void dataHasChanged(boolean b) {
        this.valChanged = b;
        if (b) {
            this.valSaved = false;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getTagInfo() {
        return this.tagInfo;
    }

    public void setTagInfoError(String tagInfo) {
        this.tagInfo = tagInfo;
        this.fieldBorder = !tagInfo.equals("") ? this.errorBorder : this.normalBorder;
    }

    public void setProperties(TagDataProp prop) {
        this.setVisible(prop.isVisible());
        this.setTagUnit(prop.getUnitSymbol());
        this.setValueRequired(prop.isRequired());
    }

    public TagDataProp getProperties() {
        return new TagDataProp(this.getTagName(), this.getTagUnitString(), this.isVisible(), this.isRequired());
    }

    public void setOntologyRef(List<OntologyElement> ontoElems) {
        this.ontoElems = ontoElems;
    }

    public boolean isOntoElement() {
        return this.ontoElems != null;
    }

    public String[] getOntologyRef(String name) {
        OntologyElement elem;
        if (this.isOntoElement() && (elem = (OntologyElement)this.ontoElems.stream().filter(n -> n.getName().equals(name)).findAny().orElse(null)) != null) {
            return new String[]{elem.getName(), elem.getId(), elem.getOntologyName(), elem.getUri()};
        }
        return null;
    }

    public OntologyElement getOntologyRefElem(String name) {
        if (this.isOntoElement()) {
            OntologyElement match = null;
            for (OntologyElement o : this.ontoElems) {
                if (!o.getName().trim().equals(name.trim())) continue;
                match = o;
            }
            if (match == null) {
                ImporterAgent.getRegistry().getLogger().debug(null, "[MDE] ATTENTION: no ontology elem matched");
            }
            return match;
        }
        return null;
    }

    class JArray
    extends JPanel {
        private JTextField[] comp;

        public JArray(int size) {
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            FocusListener flTextField = new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    try {
                        TagData.this.saveTagValue(JArray.this.getValuesAsArray());
                    }
                    catch (Exception ex) {
                        String s = "[MDE] can't save Tag value ";
                        LogMessage msg = new LogMessage();
                        msg.print(s);
                        msg.print((Throwable)ex);
                        ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            };
            KeyListener klTextField = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    try {
                        TagData.this.saveTagValue(JArray.this.getValuesAsArray());
                    }
                    catch (Exception ex) {
                        String s = "[MDE] can't save Tag value ";
                        LogMessage msg = new LogMessage();
                        msg.print(s);
                        msg.print((Throwable)ex);
                        ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
                    }
                    TagData.this.valChanged = true;
                    TagData.this.valSaved = false;
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            };
            this.comp = new JTextField[size];
            for (int i = 0; i < size; ++i) {
                JTextField txtF = new JTextField(10);
                txtF.addFocusListener(flTextField);
                txtF.addKeyListener(klTextField);
                this.comp[i] = txtF;
                this.add(txtF);
            }
        }

        public void setValue(String val, int index) {
            if (this.comp != null && this.comp.length > index && this.comp[index] != null) {
                this.comp[index].setText(val);
            }
        }

        public void setValues(String[] values) {
            if (this.comp != null) {
                for (int i = 0; i < this.comp.length; ++i) {
                    if (values.length <= i) continue;
                    if (values[i] == null || values[i].equals("")) {
                        values[i] = "";
                        this.comp[i].setBackground(TagData.this.noInfo);
                    } else {
                        this.comp[i].setBackground(TagData.this.fillInfo);
                    }
                    this.comp[i].setText(values[i]);
                }
            }
        }

        public String getValues() {
            Object res = "";
            for (JTextField s : this.comp) {
                if (s == null || s.getText().equals("")) continue;
                res = (String)res + s.getText() + ",";
            }
            if (((String)res).endsWith(",")) {
                res = ((String)res).substring(0, ((String)res).length() - 1);
            }
            return res;
        }

        public String[] getValuesAsArray() throws Exception {
            if (this.comp == null) {
                return null;
            }
            String[] res = new String[this.comp.length];
            for (int i = 0; i < this.comp.length; ++i) {
                res[i] = this.comp[i].getText();
            }
            return res;
        }

        public void setBackground(Color c, String text) {
            if (this.comp == null) {
                return;
            }
            for (JTextField t : this.comp) {
                t.setText(text);
                t.setBackground(c);
            }
        }

        @Override
        public void setBackground(Color bg) {
            if (this.comp != null) {
                for (JTextField t : this.comp) {
                    t.setBackground(bg);
                }
            }
        }

        @Override
        public void setPreferredSize(Dimension dim) {
            if (this.comp == null || this.comp.length < 2) {
                super.setPreferredSize(dim);
            } else {
                Dimension subD = new Dimension(dim.width / this.comp.length, dim.height);
                for (JTextField t : this.comp) {
                    t.setPreferredSize(subD);
                }
            }
        }
    }

    class ScrollableTextPane
    extends JScrollPane {
        JTextArea area = new JTextArea();

        public ScrollableTextPane() {
            this.area.setRows(5);
            this.area.setLineWrap(true);
            this.area.setWrapStyleWord(true);
            this.setViewportView(this.area);
        }

        public void setTextAreaRows(int r) {
            this.area.setRows(r);
        }

        public void setText(String val) {
            this.area.setText(val);
        }

        public String getText() {
            return this.area.getText();
        }

        @Override
        public void setBackground(Color bg) {
            super.setBackground(bg);
            if (this.area != null) {
                this.area.setBackground(bg);
            }
        }

        @Override
        public void addKeyListener(KeyListener l) {
            this.area.addKeyListener(l);
        }
    }
}

